/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.imu_calib.ExtGyroCalibration;
import sbgc.imu_calib.IExtRefSensorCalib;
import sbgc.imu_calib.SensorCalib;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.object.IMUDebugInfo;
import sbgc.service.SerialCommand;
import sbgc.ui.GroupView;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelBase;
import simplebgc_gui.DialogExtIMUInfo;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class TabbedPanelMavlink
extends TabbedPanelBase
implements ITabbedPanel {
    private JSpinner[] mavlinkSysId;
    private JSpinner[] mavlinkCompId;
    private JSpinner[] spinnerAlignCorr;
    private JComboBox[] mavlinkSrc;
    private JComboBox[] mavlinkCfg;
    private JCheckBox[] mavlinkDebug;
    private JCheckBox[] mavlinkRC;
    private JCheckBox[] mavlinkHeartbeat;
    private JCheckBox[] mavlinkNoTelemetry;
    private JCheckBox[] mavlinkProtocolV2;
    int imuModel = -1;
    ItemListener portSourceItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (TabbedPanelMavlink.this.mainView.isConnected() && !TabbedPanelMavlink.this.mainView.isParamsUpdated() && evt.getStateChange() == 1) {
                JComboBox obj = (JComboBox)evt.getItemSelectable();
                int new_port = ((SpravComboBoxModel)obj.getModel()).getCurrentId();
                int old_port = 0;
                BoardParams params = BoardParams.getCurParams();
                if (obj == TabbedPanelMavlink.this.jComboBoxExtIMUPort) {
                    old_port = params.extIMU.port;
                } else if (obj == TabbedPanelMavlink.this.jComboBoxMavlinkSrc1) {
                    old_port = params.mavlink_src[0];
                } else if (obj == TabbedPanelMavlink.this.jComboBoxMavlinkSrc1) {
                    old_port = params.mavlink_src[2];
                }
                if (!TabbedPanelMavlink.this.mainView.confirmMainUARTChangeFunction(old_port, new_port)) {
                    obj.removeItemListener(this);
                    ((SpravComboBoxModel)obj.getModel()).setCurrent(old_port);
                    obj.addItemListener(this);
                }
            }
        }
    };
    private ButtonGroup buttonGroupExtIMUH1;
    private ButtonGroup buttonGroupExtIMUZ1;
    private JPanel groupExtConnOptions;
    private JPanel groupExtIMU;
    private JPanel groupMavLink;
    private JButton jButtonAlignCorrAuto;
    private JButton jButtonExtImuStatus;
    private JCheckBox jCheckBoxExtIMUAsFrameIMU;
    private JCheckBox jCheckBoxExtIMUFrameUpsideDownUpdate;
    private JCheckBox jCheckBoxExtIMUGyroCalibStartup;
    private JCheckBox jCheckBoxExtIMUReplace;
    private JCheckBox jCheckBoxGyroOnlineCalib;
    private JCheckBox jCheckBoxMavLinkNoTelemetry1;
    private JCheckBox jCheckBoxMavLinkNoTelemetry2;
    private JCheckBox jCheckBoxMavLinkV2_1;
    private JCheckBox jCheckBoxMavLinkV2_2;
    private JCheckBox jCheckBoxMavlinkDebug1;
    private JCheckBox jCheckBoxMavlinkDebug2;
    private JCheckBox jCheckBoxMavlinkHeartbeat1;
    private JCheckBox jCheckBoxMavlinkHeartbeat2;
    private JCheckBox jCheckBoxMavlinkUseRC1;
    private JCheckBox jCheckBoxMavlinkUseRC2;
    private JCheckBox jCheckBoxMavlinkYawAbs;
    private JComboBox jComboBoxControlMode;
    private JComboBox jComboBoxExtIMUAxisRight;
    private JComboBox jComboBoxExtIMUAxisTop;
    private JComboBox jComboBoxExtIMUPort;
    private JComboBox jComboBoxExtIMUPos;
    private JComboBox jComboBoxExtIMUType;
    private JComboBox jComboBoxMavlinkPortCfg1;
    private JComboBox jComboBoxMavlinkPortCfg2;
    private JComboBox jComboBoxMavlinkSrc1;
    private JComboBox jComboBoxMavlinkSrc2;
    private JLabel jLabelAlignCorrection;
    private JLabel jLabelControlMode;
    private JLabel jLabelExtIMUConnection;
    private JLabel jLabelExtIMUData;
    private JLabel jLabelExtIMUHeading;
    private JLabel jLabelExtIMUOrient;
    private JLabel jLabelExtIMUPos;
    private JLabel jLabelExtIMURight;
    private JLabel jLabelExtIMURollPitch;
    private JLabel jLabelExtIMUTop;
    private JLabel jLabelExtIMUType;
    private JLabel jLabelExtImuGyroTrust;
    private JLabel jLabelMavlinkCh1;
    private JLabel jLabelMavlinkCh2;
    private JLabel jLabelMavlinkDebug;
    private JLabel jLabelMavlinkFlags;
    private JLabel jLabelMavlinkPortCfg;
    private JLabel jLabelMavlinkRC;
    private JLabel jLabelMavlinkSrc;
    private JLabel jLabelMavlinkState1;
    private JLabel jLabelMavlinkState2;
    private JLabel jLabelMavlinkStateCommon;
    private JLabel jLabelMavlinkSysId;
    private JLabel jLabelStartupDelay;
    private JRadioButton jRBExtIMUNoAttCorr;
    private JRadioButton jRadioButtonExtIMUAcc;
    private JRadioButton jRadioButtonExtIMUH1;
    private JRadioButton jRadioButtonExtIMUH1Disabled;
    private JRadioButton jRadioButtonExtIMUZ1;
    private JSpinner jSpinnerAlignCorrX;
    private JSpinner jSpinnerAlignCorrY;
    private JSpinner jSpinnerAlignCorrZ;
    private JSpinner jSpinnerExtIMUGyroTrust;
    private JSpinner jSpinnerMavlinkCompId1;
    private JSpinner jSpinnerMavlinkCompId2;
    private JSpinner jSpinnerMavlinkSysId1;
    private JSpinner jSpinnerMavlinkSysId2;
    private JSpinner jSpinnerStartupDelay;

    public TabbedPanelMavlink(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        this.mavlinkSysId = new JSpinner[]{this.jSpinnerMavlinkSysId1, this.jSpinnerMavlinkSysId2};
        this.mavlinkCompId = new JSpinner[]{this.jSpinnerMavlinkCompId1, this.jSpinnerMavlinkCompId2};
        this.mavlinkSrc = new JComboBox[]{this.jComboBoxMavlinkSrc1, this.jComboBoxMavlinkSrc2};
        this.mavlinkCfg = new JComboBox[]{this.jComboBoxMavlinkPortCfg1, this.jComboBoxMavlinkPortCfg2};
        this.mavlinkDebug = new JCheckBox[]{this.jCheckBoxMavlinkDebug1, this.jCheckBoxMavlinkDebug2};
        this.mavlinkRC = new JCheckBox[]{this.jCheckBoxMavlinkUseRC1, this.jCheckBoxMavlinkUseRC2};
        this.mavlinkHeartbeat = new JCheckBox[]{this.jCheckBoxMavlinkHeartbeat1, this.jCheckBoxMavlinkHeartbeat2};
        this.spinnerAlignCorr = new JSpinner[]{this.jSpinnerAlignCorrX, this.jSpinnerAlignCorrY, this.jSpinnerAlignCorrZ};
        this.mavlinkNoTelemetry = new JCheckBox[]{this.jCheckBoxMavLinkNoTelemetry1, this.jCheckBoxMavLinkNoTelemetry2};
        this.mavlinkProtocolV2 = new JCheckBox[]{this.jCheckBoxMavLinkV2_1, this.jCheckBoxMavLinkV2_2};
        this.jComboBoxExtIMUPort.addItemListener(this.portSourceItemListener);
        this.jComboBoxMavlinkSrc1.addItemListener(this.portSourceItemListener);
        this.jComboBoxMavlinkSrc2.addItemListener(this.portSourceItemListener);
    }

    private void initComponents() {
        this.buttonGroupExtIMUZ1 = new ButtonGroup();
        this.buttonGroupExtIMUH1 = new ButtonGroup();
        this.groupExtIMU = new JPanel();
        this.jLabelExtIMUPos = new JLabel();
        this.jComboBoxExtIMUPos = new JComboBox();
        this.jLabelExtIMUType = new JLabel();
        this.jComboBoxExtIMUType = new JComboBox();
        this.jButtonExtImuStatus = new JButton();
        this.jLabelExtIMUConnection = new JLabel();
        this.jComboBoxExtIMUPort = new JComboBox();
        this.jLabelExtIMUOrient = new JLabel();
        this.jLabelExtIMUTop = new JLabel();
        this.jComboBoxExtIMUAxisTop = new JComboBox();
        this.jLabelExtIMURight = new JLabel();
        this.jComboBoxExtIMUAxisRight = new JComboBox();
        this.jLabelExtIMURollPitch = new JLabel();
        this.jRBExtIMUNoAttCorr = new JRadioButton();
        this.jRadioButtonExtIMUAcc = new JRadioButton();
        this.jRadioButtonExtIMUZ1 = new JRadioButton();
        this.jLabelExtIMUHeading = new JLabel();
        this.jRadioButtonExtIMUH1 = new JRadioButton();
        this.jCheckBoxExtIMUFrameUpsideDownUpdate = new JCheckBox();
        this.jRadioButtonExtIMUH1Disabled = new JRadioButton();
        this.jLabelExtIMUData = new JLabel();
        this.jCheckBoxExtIMUReplace = new JCheckBox();
        this.jCheckBoxExtIMUAsFrameIMU = new JCheckBox();
        this.jCheckBoxGyroOnlineCalib = new JCheckBox();
        this.jLabelAlignCorrection = new JLabel();
        this.jSpinnerAlignCorrX = new JSpinner();
        this.jSpinnerAlignCorrY = new JSpinner();
        this.jSpinnerAlignCorrZ = new JSpinner();
        this.jButtonAlignCorrAuto = new JButton();
        this.jLabelExtImuGyroTrust = new JLabel();
        this.jSpinnerExtIMUGyroTrust = new JSpinner();
        this.jCheckBoxExtIMUGyroCalibStartup = new JCheckBox();
        this.groupExtConnOptions = new JPanel();
        this.jLabelStartupDelay = new JLabel();
        this.jSpinnerStartupDelay = new JSpinner();
        this.groupMavLink = new JPanel();
        this.jLabelMavlinkCh1 = new JLabel();
        this.jLabelMavlinkCh2 = new JLabel();
        this.jLabelMavlinkSrc = new JLabel();
        this.jComboBoxMavlinkSrc1 = new JComboBox();
        this.jComboBoxMavlinkSrc2 = new JComboBox();
        this.jLabelMavlinkSysId = new JLabel();
        this.jLabelMavlinkPortCfg = new JLabel();
        this.jSpinnerMavlinkSysId1 = new JSpinner();
        this.jSpinnerMavlinkSysId2 = new JSpinner();
        this.jSpinnerMavlinkCompId1 = new JSpinner();
        this.jSpinnerMavlinkCompId2 = new JSpinner();
        this.jComboBoxMavlinkPortCfg1 = new JComboBox();
        this.jComboBoxMavlinkPortCfg2 = new JComboBox();
        this.jLabelMavlinkFlags = new JLabel();
        this.jCheckBoxMavlinkHeartbeat1 = new JCheckBox();
        this.jCheckBoxMavlinkDebug1 = new JCheckBox();
        this.jCheckBoxMavlinkUseRC1 = new JCheckBox();
        this.jCheckBoxMavLinkNoTelemetry1 = new JCheckBox();
        this.jCheckBoxMavLinkV2_1 = new JCheckBox();
        this.jCheckBoxMavlinkHeartbeat2 = new JCheckBox();
        this.jCheckBoxMavlinkDebug2 = new JCheckBox();
        this.jCheckBoxMavlinkUseRC2 = new JCheckBox();
        this.jCheckBoxMavLinkNoTelemetry2 = new JCheckBox();
        this.jCheckBoxMavLinkV2_2 = new JCheckBox();
        this.jLabelMavlinkDebug = new JLabel();
        this.jLabelMavlinkRC = new JLabel();
        this.jLabelControlMode = new JLabel();
        this.jComboBoxControlMode = new JComboBox();
        this.jCheckBoxMavlinkYawAbs = new JCheckBox();
        this.jLabelMavlinkStateCommon = new JLabel();
        this.jLabelMavlinkState1 = new JLabel();
        this.jLabelMavlinkState2 = new JLabel();
        this.setName("Mavlink");
        this.setLayout(null);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelMavlink.class);
        this.groupExtIMU.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupExtIMU.border.title", new Object[0])));
        this.groupExtIMU.setName("groupExtIMU");
        this.groupExtIMU.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelExtIMUPos.setText(resourceMap.getString("jLabelExtIMUPos.text", new Object[0]));
        this.jLabelExtIMUPos.setName("jLabelExtIMUPos");
        this.groupExtIMU.add((Component)this.jLabelExtIMUPos, new AbsoluteConstraints(20, 90, 160, -1));
        this.jComboBoxExtIMUPos.setToolTipText(resourceMap.getString("jComboBoxExtIMUPos.toolTipText", new Object[0]));
        this.jComboBoxExtIMUPos.setName("jComboBoxExtIMUPos");
        this.groupExtIMU.add((Component)this.jComboBoxExtIMUPos, new AbsoluteConstraints(190, 90, 350, -1));
        this.jLabelExtIMUType.setText(resourceMap.getString("jLabelExtIMUType.text", new Object[0]));
        this.jLabelExtIMUType.setName("jLabelExtIMUType");
        this.groupExtIMU.add((Component)this.jLabelExtIMUType, new AbsoluteConstraints(20, 30, 160, -1));
        this.jComboBoxExtIMUType.setName("jComboBoxExtIMUType");
        this.jComboBoxExtIMUType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TabbedPanelMavlink.this.jComboBoxExtIMUTypeItemStateChanged(evt);
            }
        });
        this.groupExtIMU.add((Component)this.jComboBoxExtIMUType, new AbsoluteConstraints(190, 30, 350, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelMavlink.class, this);
        this.jButtonExtImuStatus.setAction(actionMap.get("buttonExtImuInfo"));
        this.jButtonExtImuStatus.setText(resourceMap.getString("jButtonExtImuStatus.text", new Object[0]));
        this.jButtonExtImuStatus.setName("jButtonExtImuStatus");
        this.groupExtIMU.add((Component)this.jButtonExtImuStatus, new AbsoluteConstraints(550, 30, -1, -1));
        this.jLabelExtIMUConnection.setText(resourceMap.getString("jLabelExtIMUConnection.text", new Object[0]));
        this.jLabelExtIMUConnection.setName("jLabelExtIMUConnection");
        this.groupExtIMU.add((Component)this.jLabelExtIMUConnection, new AbsoluteConstraints(20, 60, 160, -1));
        this.jComboBoxExtIMUPort.setToolTipText(resourceMap.getString("jComboBoxExtIMUPort.toolTipText", new Object[0]));
        this.jComboBoxExtIMUPort.setName("jComboBoxExtIMUPort");
        this.groupExtIMU.add((Component)this.jComboBoxExtIMUPort, new AbsoluteConstraints(190, 60, 170, -1));
        this.jLabelExtIMUOrient.setText(resourceMap.getString("jLabelExtIMUOrient.text", new Object[0]));
        this.jLabelExtIMUOrient.setName("jLabelExtIMUOrient");
        this.groupExtIMU.add((Component)this.jLabelExtIMUOrient, new AbsoluteConstraints(20, 120, 160, -1));
        this.jLabelExtIMUTop.setText(resourceMap.getString("jLabelExtIMUTop.text", new Object[0]));
        this.jLabelExtIMUTop.setName("jLabelExtIMUTop");
        this.groupExtIMU.add((Component)this.jLabelExtIMUTop, new AbsoluteConstraints(190, 120, 80, -1));
        this.jComboBoxExtIMUAxisTop.setModel(new DefaultComboBoxModel<String>(new String[]{"X", "Y", "Z", "-X", "-Y", "-Z"}));
        this.jComboBoxExtIMUAxisTop.setToolTipText(resourceMap.getString("jComboBoxExtIMUAxisTop.toolTipText", new Object[0]));
        this.jComboBoxExtIMUAxisTop.setName("jComboBoxExtIMUAxisTop");
        this.groupExtIMU.add((Component)this.jComboBoxExtIMUAxisTop, new AbsoluteConstraints(270, 120, 50, -1));
        this.jLabelExtIMURight.setText(resourceMap.getString("jLabelExtIMURight.text", new Object[0]));
        this.jLabelExtIMURight.setName("jLabelExtIMURight");
        this.groupExtIMU.add((Component)this.jLabelExtIMURight, new AbsoluteConstraints(340, 120, 70, -1));
        this.jComboBoxExtIMUAxisRight.setModel(new DefaultComboBoxModel<String>(new String[]{" X", " Y", " Z", "-X", "-Y", "-Z"}));
        this.jComboBoxExtIMUAxisRight.setToolTipText(resourceMap.getString("jComboBoxExtIMUAxisRight.toolTipText", new Object[0]));
        this.jComboBoxExtIMUAxisRight.setName("jComboBoxExtIMUAxisRight");
        this.groupExtIMU.add((Component)this.jComboBoxExtIMUAxisRight, new AbsoluteConstraints(420, 120, 50, -1));
        this.jLabelExtIMURollPitch.setText(resourceMap.getString("jLabelExtIMURollPitch.text", new Object[0]));
        this.jLabelExtIMURollPitch.setName("jLabelExtIMURollPitch");
        this.groupExtIMU.add((Component)this.jLabelExtIMURollPitch, new AbsoluteConstraints(20, 150, 160, -1));
        this.buttonGroupExtIMUZ1.add(this.jRBExtIMUNoAttCorr);
        this.jRBExtIMUNoAttCorr.setText(resourceMap.getString("jRBExtIMUNoAttCorr.text", new Object[0]));
        this.jRBExtIMUNoAttCorr.setName("jRBExtIMUNoAttCorr");
        this.groupExtIMU.add((Component)this.jRBExtIMUNoAttCorr, new AbsoluteConstraints(190, 150, -1, -1));
        this.buttonGroupExtIMUZ1.add(this.jRadioButtonExtIMUAcc);
        this.jRadioButtonExtIMUAcc.setText(resourceMap.getString("jRadioButtonExtIMUAcc.text", new Object[0]));
        this.jRadioButtonExtIMUAcc.setToolTipText(resourceMap.getString("jRadioButtonExtIMUAcc.toolTipText", new Object[0]));
        this.jRadioButtonExtIMUAcc.setName("jRadioButtonExtIMUAcc");
        this.groupExtIMU.add((Component)this.jRadioButtonExtIMUAcc, new AbsoluteConstraints(190, 170, -1, -1));
        this.buttonGroupExtIMUZ1.add(this.jRadioButtonExtIMUZ1);
        this.jRadioButtonExtIMUZ1.setText(resourceMap.getString("jRadioButtonExtIMUZ1.text", new Object[0]));
        this.jRadioButtonExtIMUZ1.setToolTipText(resourceMap.getString("jRadioButtonExtIMUZ1.toolTipText", new Object[0]));
        this.jRadioButtonExtIMUZ1.setName("jRadioButtonExtIMUZ1");
        this.groupExtIMU.add((Component)this.jRadioButtonExtIMUZ1, new AbsoluteConstraints(190, 190, -1, -1));
        this.jLabelExtIMUHeading.setText(resourceMap.getString("jLabelExtIMUHeading.text", new Object[0]));
        this.jLabelExtIMUHeading.setName("jLabelExtIMUHeading");
        this.groupExtIMU.add((Component)this.jLabelExtIMUHeading, new AbsoluteConstraints(20, 220, 160, -1));
        this.buttonGroupExtIMUH1.add(this.jRadioButtonExtIMUH1);
        this.jRadioButtonExtIMUH1.setText(resourceMap.getString("jRadioButtonExtIMUH1.text", new Object[0]));
        this.jRadioButtonExtIMUH1.setToolTipText(resourceMap.getString("jRadioButtonExtIMUH1.toolTipText", new Object[0]));
        this.jRadioButtonExtIMUH1.setName("jRadioButtonExtIMUH1");
        this.groupExtIMU.add((Component)this.jRadioButtonExtIMUH1, new AbsoluteConstraints(190, 240, -1, -1));
        this.jCheckBoxExtIMUFrameUpsideDownUpdate.setText(resourceMap.getString("jCheckBoxExtIMUFrameUpsideDownUpdate.text", new Object[0]));
        this.jCheckBoxExtIMUFrameUpsideDownUpdate.setToolTipText(resourceMap.getString("jCheckBoxExtIMUFrameUpsideDownUpdate.toolTipText", new Object[0]));
        this.jCheckBoxExtIMUFrameUpsideDownUpdate.setName("jCheckBoxExtIMUFrameUpsideDownUpdate");
        this.groupExtIMU.add((Component)this.jCheckBoxExtIMUFrameUpsideDownUpdate, new AbsoluteConstraints(190, 290, -1, -1));
        this.buttonGroupExtIMUH1.add(this.jRadioButtonExtIMUH1Disabled);
        this.jRadioButtonExtIMUH1Disabled.setText(resourceMap.getString("jRadioButtonExtIMUH1Disabled.text", new Object[0]));
        this.jRadioButtonExtIMUH1Disabled.setName("jRadioButtonExtIMUH1Disabled");
        this.groupExtIMU.add((Component)this.jRadioButtonExtIMUH1Disabled, new AbsoluteConstraints(190, 220, -1, -1));
        this.jLabelExtIMUData.setFont(this.jLabelExtIMUData.getFont().deriveFont((float)this.jLabelExtIMUData.getFont().getSize() - 1.0f));
        this.jLabelExtIMUData.setText(resourceMap.getString("jLabelExtIMUData.text", new Object[0]));
        this.jLabelExtIMUData.setName("jLabelExtIMUData");
        this.groupExtIMU.add((Component)this.jLabelExtIMUData, new AbsoluteConstraints(20, 440, 670, 140));
        this.jCheckBoxExtIMUReplace.setText(resourceMap.getString("jCheckBoxExtIMUReplace.text", new Object[0]));
        this.jCheckBoxExtIMUReplace.setToolTipText(resourceMap.getString("jCheckBoxExtIMUReplace.toolTipText", new Object[0]));
        this.jCheckBoxExtIMUReplace.setName("jCheckBoxExtIMUReplace");
        this.groupExtIMU.add((Component)this.jCheckBoxExtIMUReplace, new AbsoluteConstraints(190, 270, -1, -1));
        this.jCheckBoxExtIMUAsFrameIMU.setText(resourceMap.getString("jCheckBoxExtIMUAsFrameIMU.text", new Object[0]));
        this.jCheckBoxExtIMUAsFrameIMU.setToolTipText(resourceMap.getString("jCheckBoxExtIMUAsFrameIMU.toolTipText", new Object[0]));
        this.jCheckBoxExtIMUAsFrameIMU.setName("jCheckBoxExtIMUAsFrameIMU");
        this.groupExtIMU.add((Component)this.jCheckBoxExtIMUAsFrameIMU, new AbsoluteConstraints(190, 310, -1, -1));
        this.jCheckBoxGyroOnlineCalib.setText(resourceMap.getString("jCheckBoxGyroOnlineCalib.text", new Object[0]));
        this.jCheckBoxGyroOnlineCalib.setToolTipText(resourceMap.getString("jCheckBoxGyroOnlineCalib.toolTipText", new Object[0]));
        this.jCheckBoxGyroOnlineCalib.setName("jCheckBoxGyroOnlineCalib");
        this.groupExtIMU.add((Component)this.jCheckBoxGyroOnlineCalib, new AbsoluteConstraints(190, 330, -1, -1));
        this.jLabelAlignCorrection.setText(resourceMap.getString("jLabelAlignCorrection.text", new Object[0]));
        this.jLabelAlignCorrection.setName("jLabelAlignCorrection");
        this.groupExtIMU.add((Component)this.jLabelAlignCorrection, new AbsoluteConstraints(20, 390, -1, -1));
        this.jSpinnerAlignCorrX.setModel(new SpinnerNumberModel(0.0, -10.0, 10.0, 0.001));
        this.jSpinnerAlignCorrX.setName("jSpinnerAlignCorrX");
        this.groupExtIMU.add((Component)this.jSpinnerAlignCorrX, new AbsoluteConstraints(200, 410, 80, -1));
        this.jSpinnerAlignCorrY.setModel(new SpinnerNumberModel(0.0, -10.0, 10.0, 0.001));
        this.jSpinnerAlignCorrY.setName("jSpinnerAlignCorrY");
        this.groupExtIMU.add((Component)this.jSpinnerAlignCorrY, new AbsoluteConstraints(290, 410, 80, -1));
        this.jSpinnerAlignCorrZ.setModel(new SpinnerNumberModel(0.0, -10.0, 10.0, 0.001));
        this.jSpinnerAlignCorrZ.setName("jSpinnerAlignCorrZ");
        this.groupExtIMU.add((Component)this.jSpinnerAlignCorrZ, new AbsoluteConstraints(380, 410, 80, -1));
        this.jButtonAlignCorrAuto.setAction(actionMap.get("buttonAlignCorrAuto"));
        this.jButtonAlignCorrAuto.setText(resourceMap.getString("jButtonAlignCorrAuto.text", new Object[0]));
        this.jButtonAlignCorrAuto.setToolTipText(resourceMap.getString("jButtonAlignCorrAuto.toolTipText", new Object[0]));
        this.jButtonAlignCorrAuto.setName("jButtonAlignCorrAuto");
        this.groupExtIMU.add((Component)this.jButtonAlignCorrAuto, new AbsoluteConstraints(480, 410, -1, -1));
        this.jLabelExtImuGyroTrust.setText(resourceMap.getString("jLabelExtImuGyroTrust.text", new Object[0]));
        this.jLabelExtImuGyroTrust.setName("jLabelExtImuGyroTrust");
        this.groupExtIMU.add((Component)this.jLabelExtImuGyroTrust, new AbsoluteConstraints(220, 360, 200, -1));
        this.jSpinnerExtIMUGyroTrust.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jSpinnerExtIMUGyroTrust.setToolTipText(resourceMap.getString("jSpinnerExtIMUGyroTrust.toolTipText", new Object[0]));
        this.jSpinnerExtIMUGyroTrust.setName("jSpinnerExtIMUGyroTrust");
        this.groupExtIMU.add((Component)this.jSpinnerExtIMUGyroTrust, new AbsoluteConstraints(430, 360, 60, -1));
        this.jCheckBoxExtIMUGyroCalibStartup.setText(resourceMap.getString("jCheckBoxExtIMUGyroCalibStartup.text", new Object[0]));
        this.jCheckBoxExtIMUGyroCalibStartup.setToolTipText(resourceMap.getString("jCheckBoxExtIMUGyroCalibStartup.toolTipText", new Object[0]));
        this.jCheckBoxExtIMUGyroCalibStartup.setName("jCheckBoxExtIMUGyroCalibStartup");
        this.groupExtIMU.add((Component)this.jCheckBoxExtIMUGyroCalibStartup, new AbsoluteConstraints(500, 360, -1, -1));
        this.add(this.groupExtIMU);
        this.groupExtIMU.setBounds(0, 0, 700, 600);
        this.groupExtConnOptions.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupExtConnOptions.border.title", new Object[0])));
        this.groupExtConnOptions.setName("groupExtConnOptions");
        this.groupExtConnOptions.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelStartupDelay.setText(resourceMap.getString("jLabelStartupDelay.text", new Object[0]));
        this.jLabelStartupDelay.setToolTipText(resourceMap.getString("jSpinnerStartupDelay.toolTipText", new Object[0]));
        this.jLabelStartupDelay.setName("jLabelStartupDelay");
        this.groupExtConnOptions.add((Component)this.jLabelStartupDelay, new AbsoluteConstraints(20, 30, 220, -1));
        this.jSpinnerStartupDelay.setModel(new SpinnerNumberModel(0, 0, 12750, 50));
        this.jSpinnerStartupDelay.setToolTipText(resourceMap.getString("jSpinnerStartupDelay.toolTipText", new Object[0]));
        this.jSpinnerStartupDelay.setName("jSpinnerStartupDelay");
        this.groupExtConnOptions.add((Component)this.jSpinnerStartupDelay, new AbsoluteConstraints(250, 30, 70, -1));
        this.add(this.groupExtConnOptions);
        this.groupExtConnOptions.setBounds(0, 600, 700, 70);
        this.groupMavLink.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupMavLink.border.title", new Object[0])));
        this.groupMavLink.setName("groupMavLink");
        this.groupMavLink.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelMavlinkCh1.setText(resourceMap.getString("jLabelMavlinkCh1.text", new Object[0]));
        this.jLabelMavlinkCh1.setName("jLabelMavlinkCh1");
        this.groupMavLink.add((Component)this.jLabelMavlinkCh1, new AbsoluteConstraints(160, 10, -1, -1));
        this.jLabelMavlinkCh2.setText(resourceMap.getString("jLabelMavlinkCh2.text", new Object[0]));
        this.jLabelMavlinkCh2.setName("jLabelMavlinkCh2");
        this.groupMavLink.add((Component)this.jLabelMavlinkCh2, new AbsoluteConstraints(380, 10, -1, -1));
        this.jLabelMavlinkSrc.setText(resourceMap.getString("jLabelMavlinkSrc.text", new Object[0]));
        this.jLabelMavlinkSrc.setName("jLabelMavlinkSrc");
        this.groupMavLink.add((Component)this.jLabelMavlinkSrc, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxMavlinkSrc1.setToolTipText(resourceMap.getString("jComboBoxMavlinkSrc1.toolTipText", new Object[0]));
        this.jComboBoxMavlinkSrc1.setName("jComboBoxMavlinkSrc1");
        this.groupMavLink.add((Component)this.jComboBoxMavlinkSrc1, new AbsoluteConstraints(160, 30, 150, -1));
        this.jComboBoxMavlinkSrc2.setToolTipText(resourceMap.getString("jComboBoxMavlinkSrc1.toolTipText", new Object[0]));
        this.jComboBoxMavlinkSrc2.setName("jComboBoxMavlinkSrc2");
        this.groupMavLink.add((Component)this.jComboBoxMavlinkSrc2, new AbsoluteConstraints(380, 30, 150, -1));
        this.jLabelMavlinkSysId.setText(resourceMap.getString("jLabelMavlinkSysId.text", new Object[0]));
        this.jLabelMavlinkSysId.setName("jLabelMavlinkSysId");
        this.groupMavLink.add((Component)this.jLabelMavlinkSysId, new AbsoluteConstraints(20, 60, -1, -1));
        this.jLabelMavlinkPortCfg.setText(resourceMap.getString("jLabelMavlinkPortCfg.text", new Object[0]));
        this.jLabelMavlinkPortCfg.setName("jLabelMavlinkPortCfg");
        this.groupMavLink.add((Component)this.jLabelMavlinkPortCfg, new AbsoluteConstraints(20, 90, -1, -1));
        this.jSpinnerMavlinkSysId1.setModel(TabbedPanelMavlink.spinnerModel_255u());
        this.jSpinnerMavlinkSysId1.setName("jSpinnerMavlinkSysId1");
        this.groupMavLink.add((Component)this.jSpinnerMavlinkSysId1, new AbsoluteConstraints(160, 60, 60, -1));
        this.jSpinnerMavlinkSysId2.setModel(TabbedPanelMavlink.spinnerModel_255u());
        this.jSpinnerMavlinkSysId2.setName("jSpinnerMavlinkSysId2");
        this.groupMavLink.add((Component)this.jSpinnerMavlinkSysId2, new AbsoluteConstraints(380, 60, 60, -1));
        this.jSpinnerMavlinkCompId1.setModel(TabbedPanelMavlink.spinnerModel_255u());
        this.jSpinnerMavlinkCompId1.setName("jSpinnerMavlinkCompId1");
        this.groupMavLink.add((Component)this.jSpinnerMavlinkCompId1, new AbsoluteConstraints(240, 60, 60, -1));
        this.jSpinnerMavlinkCompId2.setModel(TabbedPanelMavlink.spinnerModel_255u());
        this.jSpinnerMavlinkCompId2.setName("jSpinnerMavlinkCompId2");
        this.groupMavLink.add((Component)this.jSpinnerMavlinkCompId2, new AbsoluteConstraints(460, 60, 60, -1));
        this.jComboBoxMavlinkPortCfg1.setName("jComboBoxMavlinkPortCfg1");
        this.groupMavLink.add((Component)this.jComboBoxMavlinkPortCfg1, new AbsoluteConstraints(160, 90, 150, -1));
        this.jComboBoxMavlinkPortCfg2.setName("jComboBoxMavlinkPortCfg2");
        this.groupMavLink.add((Component)this.jComboBoxMavlinkPortCfg2, new AbsoluteConstraints(380, 90, 150, -1));
        this.jLabelMavlinkFlags.setText(resourceMap.getString("jLabelMavlinkFlags.text", new Object[0]));
        this.jLabelMavlinkFlags.setName("jLabelMavlinkFlags");
        this.groupMavLink.add((Component)this.jLabelMavlinkFlags, new AbsoluteConstraints(20, 120, -1, -1));
        this.jCheckBoxMavlinkHeartbeat1.setText(resourceMap.getString("jCheckBoxMavlinkHeartbeat1.text", new Object[0]));
        this.jCheckBoxMavlinkHeartbeat1.setName("jCheckBoxMavlinkHeartbeat1");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkHeartbeat1, new AbsoluteConstraints(160, 120, -1, -1));
        this.jCheckBoxMavlinkDebug1.setText(resourceMap.getString("jCheckBoxMavlinkDebug1.text", new Object[0]));
        this.jCheckBoxMavlinkDebug1.setName("jCheckBoxMavlinkDebug1");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkDebug1, new AbsoluteConstraints(160, 140, -1, -1));
        this.jCheckBoxMavlinkUseRC1.setText(resourceMap.getString("jCheckBoxMavlinkUseRC1.text", new Object[0]));
        this.jCheckBoxMavlinkUseRC1.setName("jCheckBoxMavlinkUseRC1");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkUseRC1, new AbsoluteConstraints(160, 160, -1, -1));
        this.jCheckBoxMavLinkNoTelemetry1.setText(resourceMap.getString("jCheckBoxMavLinkNoTelemetry1.text", new Object[0]));
        this.jCheckBoxMavLinkNoTelemetry1.setToolTipText(resourceMap.getString("jCheckBoxMavLinkNoTelemetry1.toolTipText", new Object[0]));
        this.jCheckBoxMavLinkNoTelemetry1.setName("jCheckBoxMavLinkNoTelemetry1");
        this.groupMavLink.add((Component)this.jCheckBoxMavLinkNoTelemetry1, new AbsoluteConstraints(160, 180, -1, -1));
        this.jCheckBoxMavLinkV2_1.setText(resourceMap.getString("jCheckBoxMavLinkV2_1.text", new Object[0]));
        this.jCheckBoxMavLinkV2_1.setToolTipText(resourceMap.getString("jCheckBoxMavLinkV2_1.toolTipText", new Object[0]));
        this.jCheckBoxMavLinkV2_1.setName("jCheckBoxMavLinkV2_1");
        this.groupMavLink.add((Component)this.jCheckBoxMavLinkV2_1, new AbsoluteConstraints(160, 200, -1, -1));
        this.jCheckBoxMavlinkHeartbeat2.setText(resourceMap.getString("jCheckBoxMavlinkHeartbeat2.text", new Object[0]));
        this.jCheckBoxMavlinkHeartbeat2.setName("jCheckBoxMavlinkHeartbeat2");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkHeartbeat2, new AbsoluteConstraints(380, 120, -1, -1));
        this.jCheckBoxMavlinkDebug2.setText(resourceMap.getString("jCheckBoxMavlinkDebug2.text", new Object[0]));
        this.jCheckBoxMavlinkDebug2.setName("jCheckBoxMavlinkDebug2");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkDebug2, new AbsoluteConstraints(380, 140, -1, -1));
        this.jCheckBoxMavlinkUseRC2.setText(resourceMap.getString("jCheckBoxMavlinkUseRC2.text", new Object[0]));
        this.jCheckBoxMavlinkUseRC2.setName("jCheckBoxMavlinkUseRC2");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkUseRC2, new AbsoluteConstraints(380, 160, -1, -1));
        this.jCheckBoxMavLinkNoTelemetry2.setText(resourceMap.getString("jCheckBoxMavLinkNoTelemetry2.text", new Object[0]));
        this.jCheckBoxMavLinkNoTelemetry2.setToolTipText(resourceMap.getString("jCheckBoxMavLinkNoTelemetry1.toolTipText", new Object[0]));
        this.jCheckBoxMavLinkNoTelemetry2.setName("jCheckBoxMavLinkNoTelemetry2");
        this.groupMavLink.add((Component)this.jCheckBoxMavLinkNoTelemetry2, new AbsoluteConstraints(380, 180, -1, -1));
        this.jCheckBoxMavLinkV2_2.setText(resourceMap.getString("jCheckBoxMavLinkV2_2.text", new Object[0]));
        this.jCheckBoxMavLinkV2_2.setToolTipText(resourceMap.getString("jCheckBoxMavLinkV2_1.toolTipText", new Object[0]));
        this.jCheckBoxMavLinkV2_2.setName("jCheckBoxMavLinkV2_2");
        this.groupMavLink.add((Component)this.jCheckBoxMavLinkV2_2, new AbsoluteConstraints(380, 200, -1, -1));
        this.jLabelMavlinkDebug.setText(resourceMap.getString("jLabelMavlinkDebug.text", new Object[0]));
        this.jLabelMavlinkDebug.setName("jLabelMavlinkDebug");
        this.groupMavLink.add((Component)this.jLabelMavlinkDebug, new AbsoluteConstraints(170, 230, -1, 20));
        this.jLabelMavlinkRC.setText(resourceMap.getString("jLabelMavlinkRC.text", new Object[0]));
        this.jLabelMavlinkRC.setName("jLabelMavlinkRC");
        this.groupMavLink.add((Component)this.jLabelMavlinkRC, new AbsoluteConstraints(170, 250, -1, -1));
        this.jLabelControlMode.setText(resourceMap.getString("jLabelControlMode.text", new Object[0]));
        this.jLabelControlMode.setName("jLabelControlMode");
        this.groupMavLink.add((Component)this.jLabelControlMode, new AbsoluteConstraints(20, 280, -1, -1));
        this.jComboBoxControlMode.setName("jComboBoxControlMode");
        this.groupMavLink.add((Component)this.jComboBoxControlMode, new AbsoluteConstraints(290, 280, 350, -1));
        this.jCheckBoxMavlinkYawAbs.setText(resourceMap.getString("jCheckBoxMavlinkYawAbs.text", new Object[0]));
        this.jCheckBoxMavlinkYawAbs.setToolTipText(resourceMap.getString("jCheckBoxMavlinkYawAbs.toolTipText", new Object[0]));
        this.jCheckBoxMavlinkYawAbs.setName("jCheckBoxMavlinkYawAbs");
        this.groupMavLink.add((Component)this.jCheckBoxMavlinkYawAbs, new AbsoluteConstraints(290, 310, -1, -1));
        this.jLabelMavlinkStateCommon.setText(resourceMap.getString("jLabelMavlinkStateCommon.text", new Object[0]));
        this.jLabelMavlinkStateCommon.setName("jLabelMavlinkStateCommon");
        this.groupMavLink.add((Component)this.jLabelMavlinkStateCommon, new AbsoluteConstraints(20, 340, 680, 20));
        this.jLabelMavlinkState1.setText(resourceMap.getString("jLabelMavlinkState1.text", new Object[0]));
        this.jLabelMavlinkState1.setName("jLabelMavlinkState1");
        this.groupMavLink.add((Component)this.jLabelMavlinkState1, new AbsoluteConstraints(20, 360, 680, 20));
        this.jLabelMavlinkState2.setText(resourceMap.getString("jLabelMavlinkState2.text", new Object[0]));
        this.jLabelMavlinkState2.setName("jLabelMavlinkState2");
        this.groupMavLink.add((Component)this.jLabelMavlinkState2, new AbsoluteConstraints(20, 380, 680, 20));
        this.add(this.groupMavLink);
        this.groupMavLink.setBounds(0, 720, 710, 410);
    }

    private void jComboBoxExtIMUTypeItemStateChanged(ItemEvent evt) {
        this.imuModel = ((SpravComboBoxModel)this.jComboBoxExtIMUType.getModel()).getCurrentId();
        this.jButtonExtImuStatus.setEnabled(TabbedPanelMavlink.isExtIMUStatusSupported(this.imuModel));
    }

    public static boolean isExtIMUStatusSupported(int model) {
        return model == 5;
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
        for (int i = 0; i < 2; ++i) {
            ((SpravComboBoxModel)this.mavlinkSrc[i].getModel()).setCurrent(params.mavlink_src[i]);
            ((SpravComboBoxModel)this.mavlinkCfg[i].getModel()).setCurrent(params.mavlink_flags[i] & 0xF);
            this.mavlinkSysId[i].setValue(params.mavlink_sys_id[i]);
            this.mavlinkCompId[i].setValue(params.mavlink_comp_id[i]);
            this.mavlinkHeartbeat[i].setSelected((params.mavlink_flags[i] & 0x10) > 0);
            this.mavlinkDebug[i].setSelected((params.mavlink_flags[i] & 0x20) > 0);
            this.mavlinkRC[i].setSelected((params.mavlink_flags[i] & 0x40) > 0);
            this.mavlinkNoTelemetry[i].setSelected((params.mavlink_flags[i] & 0x80) > 0);
            this.mavlinkProtocolV2[i].setSelected((params.mavlink_flags[i] & 0x100) > 0);
        }
        ((SpravComboBoxModel)this.jComboBoxControlMode.getModel()).setCurrentOrAdd(p.mav_ctrl_mode, "mode");
        this.jCheckBoxMavlinkYawAbs.setSelected((params.general_flags3 & 8) != 0);
        if (BoardInfo.hasBoardFeature(65536L)) {
            ((SpravComboBoxModel)this.jComboBoxExtIMUType.getModel()).setCurrentOrAdd(params.extIMU.type, "type");
            ((SpravComboBoxModel)this.jComboBoxExtIMUPort.getModel()).setCurrentOrAdd(params.extIMU.port, "port");
            this.jSpinnerStartupDelay.setValue(params.extIMU.startup_delay * 50);
            if (params.extIMU.position == 0) {
                params.extIMU.position = 2;
            }
            ((SpravComboBoxModel)this.jComboBoxExtIMUPos.getModel()).setCurrentOrAdd(params.extIMU.position, "position");
            this.jComboBoxExtIMUAxisRight.setSelectedIndex(Math.min(params.extIMU.orientation >> 3 & 7, 5));
            this.jComboBoxExtIMUAxisTop.setSelectedIndex(Math.min(params.extIMU.orientation & 7, 5));
            for (int axis = 0; axis < 3; ++axis) {
                this.spinnerAlignCorr[axis].setValue((double)params.extIMU.align_corr[axis] / 1000.0);
            }
            if ((params.extIMU.flags & 2) != 0) {
                this.jRadioButtonExtIMUAcc.setSelected(true);
            } else if ((params.extIMU.flags & 8) != 0) {
                this.jRadioButtonExtIMUZ1.setSelected(true);
            } else {
                this.jRBExtIMUNoAttCorr.setSelected(true);
            }
            if ((params.extIMU.flags & 0x10) > 0) {
                this.jRadioButtonExtIMUH1.setSelected(true);
            } else {
                this.jRadioButtonExtIMUH1Disabled.setSelected(true);
            }
            this.jCheckBoxExtIMUReplace.setSelected((params.extIMU.flags & 4) > 0);
            this.jCheckBoxExtIMUFrameUpsideDownUpdate.setSelected((params.extIMU.flags & 0x20) > 0);
            this.jCheckBoxExtIMUAsFrameIMU.setSelected((params.extIMU.flags & 0x40) > 0);
            this.jCheckBoxGyroOnlineCalib.setSelected((params.extIMU.flags & 0x80) > 0);
            this.jSpinnerExtIMUGyroTrust.setValue(params.extIMU.gyro_corr_rate);
            this.jCheckBoxExtIMUGyroCalibStartup.setSelected((params.extIMU.flags & 0x100) > 0);
        }
    }

    @Override
    public void updateBoardVerUI() {
        BoardInfo info = BoardInfo.getBoardInfo();
        for (int i = 0; i < 2; ++i) {
            this.mavlinkSrc[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getMavlinkSrcList(), this.mavlinkSrc[i].getModel()));
            this.mavlinkCfg[i].setModel(new SpravComboBoxModel(ParamsUIFactory.getMavlinkCfgList(), this.mavlinkSrc[i].getModel()));
            this.mavlinkProtocolV2[i].setEnabled(BoardInfo.hasBoardFeature(0x2000000L) && GroupView.isComponentEnabled(this.mavlinkProtocolV2[i]));
        }
        this.jComboBoxControlMode.setModel(new SpravComboBoxModel(ParamsUIFactory.getMavCtrlModeList(), this.jComboBoxControlMode.getModel()));
        this.jComboBoxExtIMUPos.setModel(new SpravComboBoxModel(ParamsUIFactory.getFrameIMUPosList(), this.jComboBoxExtIMUPos.getModel()));
        this.jComboBoxExtIMUType.setModel(new SpravComboBoxModel(ParamsUIFactory.getExtIMUTypeList(), this.jComboBoxExtIMUType.getModel()));
        this.jComboBoxExtIMUPort.setModel(new SpravComboBoxModel(ParamsUIFactory.getExtIMUPortList(), this.jComboBoxExtIMUPort.getModel()));
        boolean is_feature_gyro_calib = BoardInfo.hasBoardFeature(0x100000L);
        for (JComponent c : new JComponent[]{this.jCheckBoxGyroOnlineCalib, this.jSpinnerAlignCorrX, this.jSpinnerAlignCorrY, this.jSpinnerAlignCorrZ, this.jSpinnerExtIMUGyroTrust, this.jCheckBoxExtIMUGyroCalibStartup}) {
            c.setEnabled(is_feature_gyro_calib && GroupView.isComponentEnabled(c));
        }
        boolean is_frw_268b7 = BoardInfo.checkMinPartnerFirmwareVer(2687);
        for (JComponent c : new JComponent[]{this.jSpinnerStartupDelay, this.jLabelStartupDelay}) {
            c.setEnabled(is_frw_268b7 && GroupView.isComponentEnabled(c));
        }
    }

    @Override
    public void applyBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
        for (int i = 0; i < 2; ++i) {
            params.mavlink_src[i] = ((SpravComboBoxModel)this.mavlinkSrc[i].getModel()).getCurrentId();
            if (params.mavlink_src[i] == 2) {
                p.rcVirtMode = 10;
                this.mainView.panelRCSettings.setRCVirtMode(p.rcVirtMode);
            }
            params.mavlink_flags[i] = ((SpravComboBoxModel)this.mavlinkCfg[i].getModel()).getCurrentId();
            params.mavlink_sys_id[i] = ((Number)this.mavlinkSysId[i].getValue()).intValue();
            params.mavlink_comp_id[i] = ((Number)this.mavlinkCompId[i].getValue()).intValue();
            int n = i;
            params.mavlink_flags[n] = params.mavlink_flags[n] | (this.mavlinkHeartbeat[i].isSelected() ? 16 : 0);
            int n2 = i;
            params.mavlink_flags[n2] = params.mavlink_flags[n2] | (this.mavlinkDebug[i].isSelected() ? 32 : 0);
            int n3 = i;
            params.mavlink_flags[n3] = params.mavlink_flags[n3] | (this.mavlinkRC[i].isSelected() ? 64 : 0);
            int n4 = i;
            params.mavlink_flags[n4] = params.mavlink_flags[n4] | (this.mavlinkNoTelemetry[i].isSelected() ? 128 : 0);
            int n5 = i;
            params.mavlink_flags[n5] = params.mavlink_flags[n5] | (this.mavlinkProtocolV2[i].isSelected() ? 256 : 0);
        }
        p.mav_ctrl_mode = ((SpravComboBoxModel)this.jComboBoxControlMode.getModel()).getCurrentId();
        params.general_flags3 = BoardParams.updateBit(params.general_flags3, 8, this.jCheckBoxMavlinkYawAbs.isSelected());
        if (BoardInfo.hasBoardFeature(65536L)) {
            params.extIMU.type = ((SpravComboBoxModel)this.jComboBoxExtIMUType.getModel()).getCurrentId();
            params.extIMU.port = ((SpravComboBoxModel)this.jComboBoxExtIMUPort.getModel()).getCurrentId();
            params.extIMU.startup_delay = ((Number)this.jSpinnerStartupDelay.getValue()).intValue() / 50;
            params.extIMU.position = ((SpravComboBoxModel)this.jComboBoxExtIMUPos.getModel()).getCurrentId();
            params.extIMU.orientation = (this.jComboBoxExtIMUAxisRight.getSelectedIndex() << 3) + this.jComboBoxExtIMUAxisTop.getSelectedIndex();
            for (int axis = 0; axis < 3; ++axis) {
                params.extIMU.align_corr[axis] = (int)Math.round(((Number)this.spinnerAlignCorr[axis].getValue()).doubleValue() * 1000.0);
            }
            int flags = 0;
            if (this.jRadioButtonExtIMUAcc.isSelected()) {
                flags |= 2;
            }
            if (this.jRadioButtonExtIMUZ1.isSelected()) {
                flags |= 8;
            }
            if (this.jRadioButtonExtIMUH1.isSelected()) {
                flags |= 0x10;
            }
            if (this.jCheckBoxExtIMUReplace.isSelected()) {
                flags |= 4;
            }
            if (this.jCheckBoxExtIMUFrameUpsideDownUpdate.isSelected()) {
                flags |= 0x20;
            }
            if (this.jCheckBoxExtIMUAsFrameIMU.isSelected()) {
                flags |= 0x40;
            }
            if (this.jCheckBoxGyroOnlineCalib.isSelected()) {
                flags |= 0x80;
            }
            if (this.jCheckBoxExtIMUGyroCalibStartup.isSelected()) {
                flags |= 0x100;
            }
            params.extIMU.flags = flags;
            params.extIMU.gyro_corr_rate = ((Number)this.jSpinnerExtIMUGyroTrust.getValue()).intValue();
            int fcPosAllBits = 576;
            params.general_flags2 &= ~fcPosAllBits;
            if (params.extIMU.position == 1) {
                params.general_flags2 |= 0x40;
            } else if (params.extIMU.position == 8) {
                params.general_flags2 |= 0x200;
            } else if (params.extIMU.position == 9) {
                params.general_flags2 |= fcPosAllBits;
            }
        }
    }

    public void MavlinkShowState(String common_info, String[] ch_info) {
        this.jLabelMavlinkStateCommon.setText(common_info);
        this.jLabelMavlinkState1.setText("CH1: " + ch_info[0]);
        this.jLabelMavlinkState2.setText("CH2: " + ch_info[1]);
    }

    public void parseExtIMUDebugInfo(SerialCommand cmd) throws Exception {
        BoardInfo.html_enabled = true;
        IMUDebugInfo d = new IMUDebugInfo();
        d.parseExtIMUDebugInfo(cmd);
        String info = d.formatExtIMUDebugInfo(cmd);
        this.jLabelExtIMUData.setText(info);
        this.mainView.panelHardwareSettings.setExtImuDebugInfo(info);
        this.mainView.panelHardwareSettings.setTripodModeStatus(d.isTripodMode() ? 1 : 0);
    }

    @Action
    public void buttonExtImuInfo() {
        if (TabbedPanelMavlink.isExtIMUStatusSupported(this.imuModel)) {
            DialogExtIMUInfo d = new DialogExtIMUInfo(this.mainView, this.imuModel, 2);
            d.startThread();
            d.showDialog();
        }
    }

    @Action(enabledProperty="connected")
    public void buttonAlignCorrAuto() {
        IExtRefSensorCalib extRefSensorCalibListener = new IExtRefSensorCalib(){

            @Override
            public void onExtRefSensorCalibFinished(SensorCalib c) {
                for (int axis = 0; axis < 3; ++axis) {
                    TabbedPanelMavlink.this.spinnerAlignCorr[axis].setValue((double)c.align_corr[axis] * (double)-57.29578f);
                }
                TabbedPanelMavlink.this.mainView.showInfoMessage(TabbedPanelMavlink.this.resourceMap.getString("info.message.ext_imu_align_calib_finished", new Object[0]));
            }
        };
        new ExtGyroCalibration(extRefSensorCalibListener, null, 28).start();
    }
}

