/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.object.CanDrvRealtimeData;
import sbgc.object.DebugVar;
import sbgc.object.DebugVars;
import sbgc.object.RealtimeData;
import sbgc.object.UpdateGroupImpl;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.RCDataPanel;
import sbgc.ui.TabbedPanelBase;
import sbgc.ui.chart.JRealChart;
import sbgc.ui.chart.JRealTrace;
import sbgc.utils.DataLogger;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;
import simplebgc_gui.TabWindow;

public class TabbedPanelMonitoring
extends TabbedPanelBase
implements ITabbedPanel {
    private RCDataPanel[] rcPanels = new RCDataPanel[RealtimeData.RC_DATA_NAMES.length];
    public JRealChart chart;
    private ArrayList<JToggleButton> chartToggles;
    private ArrayList<JLabel> chartLabels;
    public int curIMUset = -1;
    private int debugTraceId = -1;
    private JToggleButton[] toggleCanDrv;
    private int curCanDrvIdx = -1;
    boolean traceListChanged = false;
    private static DataLogger dataLogger = null;
    private static SimpleDateFormat logTimeFormat = new SimpleDateFormat("hh:mm:ss.SS");
    private static DecimalFormat df2 = new DecimalFormat("#.##");
    private static DecimalFormat df3 = new DecimalFormat("#.###");
    public static UpdateGroupImpl UPD_GROUP_GYRO = new UpdateGroupImpl();
    public static UpdateGroupImpl UPD_GROUP_ACC = new UpdateGroupImpl();
    public static UpdateGroupImpl UPD_GROUP_MAG = new UpdateGroupImpl();
    public static UpdateGroupImpl UPD_GROUP_DEBUG = new UpdateGroupImpl();
    boolean isZoomYUpdating = false;
    private ButtonGroup buttonGroupCanDrv;
    private ButtonGroup buttonGroupIMU;
    private JPanel groupMonitoring;
    private JButton jButtonNewWin;
    private JPanel jChart;
    private JCheckBox jCheckBoxBasicData;
    private JCheckBox jCheckBoxDebugVars;
    private JLabel jLabelIMURTData;
    private JLabel jLabelMotor;
    private JLabel jLabelRequestData;
    private JLabel jLabelSPS;
    private JLabel jLabelTimeScale;
    private JLabel jLabelYScale;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanelCanDrv;
    private JPanel jPanelChartToggle;
    private JPanel jPanelRCData;
    private JScrollPane jScrollPane1;
    private JSlider jSliderScale;
    private JSpinner jSpinnerFrameRate;
    private JSpinner jSpinnerTimeScale;
    private JToggleButton jTBCanDrv1;
    private JToggleButton jTBCanDrv2;
    private JToggleButton jTBCanDrv3;
    private JToggleButton jTBCanDrv4;
    private JToggleButton jTBCanDrv5;
    private JToggleButton jTBCanDrv6;
    private JToggleButton jTBCanDrv7;
    private JToggleButton jToggleButtonPause;
    private JToggleButton jToggleImuFrame;
    private JToggleButton jToggleImuMain;

    public TabbedPanelMonitoring(SimpleBGC_GUIView mainView) {
        super(mainView);
        this.initComponents();
        this.prepareLayout();
        this.toggleCanDrv = new JToggleButton[]{this.jTBCanDrv1, this.jTBCanDrv2, this.jTBCanDrv3, this.jTBCanDrv4, this.jTBCanDrv5, this.jTBCanDrv6, this.jTBCanDrv7};
        this.chart = new JRealChart();
        this.jChart.add(this.chart);
        this.chartToggles = new ArrayList();
        this.chartLabels = new ArrayList();
        this.addChartTrace(new JRealTrace("ACC_X", false, 1.0f, UPD_GROUP_ACC));
        this.addChartTrace(new JRealTrace("ACC_Y", false, 1.0f, UPD_GROUP_ACC));
        this.addChartTrace(new JRealTrace("ACC_Z", false, 1.0f, UPD_GROUP_ACC));
        this.addChartTrace(new JRealTrace("GYRO_X", false, 1.0f, UPD_GROUP_GYRO));
        this.addChartTrace(new JRealTrace("GYRO_Y", false, 1.0f, UPD_GROUP_GYRO));
        this.addChartTrace(new JRealTrace("GYRO_Z", false, 1.0f, UPD_GROUP_GYRO));
        this.addChartTrace(new JRealTrace("ERR_R", false, 100.0f));
        this.addChartTrace(new JRealTrace("ERR_P", false, 100.0f));
        this.addChartTrace(new JRealTrace("ERR_Y", false, 100.0f));
        this.addChartTrace(new JRealTrace("POWER_R", false));
        this.addChartTrace(new JRealTrace("POWER_P", false));
        this.addChartTrace(new JRealTrace("POWER_Y", false));
        this.addChartTrace(new JRealTrace("MAG_X", false, 1.0f, UPD_GROUP_MAG));
        this.addChartTrace(new JRealTrace("MAG_Y", false, 1.0f, UPD_GROUP_MAG));
        this.addChartTrace(new JRealTrace("MAG_Z", false, 1.0f, UPD_GROUP_MAG));
        this.addChartTrace(new JRealTrace("IMU_G_ERR", false, 10.0f));
        this.addChartTrace(new JRealTrace("IMU_H_ERR", false, 10.0f));
        this.addChartTrace(new JRealTrace("MOT_OUT_R", false));
        this.addChartTrace(new JRealTrace("MOT_OUT_P", false));
        this.addChartTrace(new JRealTrace("MOT_OUT_Y", false));
        this.addChartTrace(new JRealTrace("TARGET_A_R", false, 10.0f));
        this.addChartTrace(new JRealTrace("TARGET_A_P", false, 10.0f));
        this.addChartTrace(new JRealTrace("TARGET_A_Y", false, 10.0f));
        this.addChartTrace(new JRealTrace("STAB_A_R", false, 10.0f));
        this.addChartTrace(new JRealTrace("STAB_A_P", false, 10.0f));
        this.addChartTrace(new JRealTrace("STAB_A_Y", false, 10.0f));
        this.addChartTrace(new JRealTrace("MOT_A_R", false, 10.0f));
        this.addChartTrace(new JRealTrace("MOT_A_P", false, 10.0f));
        this.addChartTrace(new JRealTrace("MOT_A_Y", false, 10.0f));
        this.addChartTrace(new JRealTrace("CURRENT", false));
        for (int i = 0; i < this.rcPanels.length; ++i) {
            this.rcPanels[i] = new RCDataPanel(RealtimeData.RC_DATA_NAMES[i], 150, 20);
            this.jPanelRCData.add(this.rcPanels[i]);
        }
        boolean realtimeDataPaused = Settings.is("realtime.data.paused");
        this.jToggleButtonPause.setSelected(realtimeDataPaused);
        RealtimeDataThread.pause(realtimeDataPaused);
        this.jCheckBoxDebugVars.setSelected(Settings.is("realtime.debug_vars"));
        this.jSpinnerFrameRate.setValue(Integer.parseInt(Settings.get("monitoring.frame_rate", "20")));
        this.jSpinnerFrameRateStateChanged(null);
        this.jSpinnerTimeScale.setValue(Float.valueOf(Float.parseFloat(Settings.get("monitoring.time_scale", "3.0"))));
        this.jSpinnerTimeScaleStateChanged(null);
        this.jSliderScaleStateChanged(null);
        this.chart.addZoomChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedPanelMonitoring.this.isZoomYUpdating = true;
                float log_val = 500.0f + 70.0f * (float)Math.log((double)TabbedPanelMonitoring.this.chart.getZoomY() / 2.0);
                TabbedPanelMonitoring.this.jSliderScale.setValue(Math.round(log_val));
                TabbedPanelMonitoring.this.jSpinnerTimeScale.setValue(Float.valueOf((float)Math.round(TabbedPanelMonitoring.this.chart.getTimeScale() * 10.0) / 10.0f));
                TabbedPanelMonitoring.this.isZoomYUpdating = false;
            }
        });
        this.chart.setToolTipText(this.jChart.getToolTipText());
    }

    private void initComponents() {
        this.buttonGroupIMU = new ButtonGroup();
        this.buttonGroupCanDrv = new ButtonGroup();
        this.groupMonitoring = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel11 = new JPanel();
        this.jSpinnerFrameRate = new JSpinner();
        this.jLabelSPS = new JLabel();
        this.jSliderScale = new JSlider();
        this.jToggleButtonPause = new JToggleButton();
        this.jCheckBoxDebugVars = new JCheckBox();
        this.jToggleImuMain = new JToggleButton();
        this.jToggleImuFrame = new JToggleButton();
        this.jLabelIMURTData = new JLabel();
        this.jPanelCanDrv = new JPanel();
        this.jLabelMotor = new JLabel();
        this.jTBCanDrv1 = new JToggleButton();
        this.jTBCanDrv2 = new JToggleButton();
        this.jTBCanDrv3 = new JToggleButton();
        this.jTBCanDrv4 = new JToggleButton();
        this.jTBCanDrv5 = new JToggleButton();
        this.jTBCanDrv6 = new JToggleButton();
        this.jTBCanDrv7 = new JToggleButton();
        this.jCheckBoxBasicData = new JCheckBox();
        this.jLabelRequestData = new JLabel();
        this.jSpinnerTimeScale = new JSpinner();
        this.jLabelTimeScale = new JLabel();
        this.jLabelYScale = new JLabel();
        this.jPanelRCData = new JPanel();
        this.jButtonNewWin = new JButton();
        this.jChart = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelChartToggle = new JPanel();
        this.setName("Monitoring");
        this.setLayout(null);
        this.groupMonitoring.setName("groupMonitoring");
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel11.setName("jPanel11");
        this.jPanel11.setLayout((LayoutManager)new AbsoluteLayout());
        this.jSpinnerFrameRate.setModel(new SpinnerNumberModel(1, 1, 250, 1));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(TabbedPanelMonitoring.class);
        this.jSpinnerFrameRate.setToolTipText(resourceMap.getString("jSpinnerFrameRate.toolTipText", new Object[0]));
        this.jSpinnerFrameRate.setName("jSpinnerFrameRate");
        this.jSpinnerFrameRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelMonitoring.this.jSpinnerFrameRateStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jSpinnerFrameRate, new AbsoluteConstraints(50, 10, 50, -1));
        this.jLabelSPS.setText(resourceMap.getString("jLabelSPS.text", new Object[0]));
        this.jLabelSPS.setName("jLabelSPS");
        this.jPanel11.add((Component)this.jLabelSPS, new AbsoluteConstraints(10, 15, 40, -1));
        this.jSliderScale.setMaximum(500);
        this.jSliderScale.setToolTipText(resourceMap.getString("jSliderScale.toolTipText", new Object[0]));
        this.jSliderScale.setValue(400);
        this.jSliderScale.setName("jSliderScale");
        this.jSliderScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelMonitoring.this.jSliderScaleStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jSliderScale, new AbsoluteConstraints(190, 10, 190, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(TabbedPanelMonitoring.class, this);
        this.jToggleButtonPause.setAction(actionMap.get("buttonPause"));
        this.jToggleButtonPause.setIcon(resourceMap.getIcon("jToggleButtonPause.icon"));
        this.jToggleButtonPause.setText(resourceMap.getString("jToggleButtonPause.text", new Object[0]));
        this.jToggleButtonPause.setName("jToggleButtonPause");
        this.jPanel11.add((Component)this.jToggleButtonPause, new AbsoluteConstraints(290, 40, 90, -1));
        this.jCheckBoxDebugVars.setText(resourceMap.getString("jCheckBoxDebugVars.text", new Object[0]));
        this.jCheckBoxDebugVars.setToolTipText(resourceMap.getString("jCheckBoxDebugVars.toolTipText", new Object[0]));
        this.jCheckBoxDebugVars.setName("jCheckBoxDebugVars");
        this.jCheckBoxDebugVars.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelMonitoring.this.jCheckBoxDebugVarsStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jCheckBoxDebugVars, new AbsoluteConstraints(160, 40, 90, -1));
        this.jToggleImuMain.setAction(actionMap.get("buttonCameraIMU"));
        this.buttonGroupIMU.add(this.jToggleImuMain);
        this.jToggleImuMain.setSelected(true);
        this.jToggleImuMain.setText(resourceMap.getString("jToggleImuMain.text", new Object[0]));
        this.jToggleImuMain.setToolTipText(resourceMap.getString("jToggleImuMain.toolTipText", new Object[0]));
        this.jToggleImuMain.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleImuMain.setName("jToggleImuMain");
        this.jPanel11.add((Component)this.jToggleImuMain, new AbsoluteConstraints(50, 70, 30, 20));
        this.jToggleImuFrame.setAction(actionMap.get("buttonFrameIMU"));
        this.buttonGroupIMU.add(this.jToggleImuFrame);
        this.jToggleImuFrame.setText(resourceMap.getString("jToggleImuFrame.text", new Object[0]));
        this.jToggleImuFrame.setToolTipText(resourceMap.getString("jToggleImuFrame.toolTipText", new Object[0]));
        this.jToggleImuFrame.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleImuFrame.setName("jToggleImuFrame");
        this.jPanel11.add((Component)this.jToggleImuFrame, new AbsoluteConstraints(80, 70, 30, 20));
        this.jLabelIMURTData.setText(resourceMap.getString("jLabelIMURTData.text", new Object[0]));
        this.jLabelIMURTData.setName("jLabelIMURTData");
        this.jPanel11.add((Component)this.jLabelIMURTData, new AbsoluteConstraints(10, 70, -1, 20));
        this.jPanelCanDrv.setName("jPanelCanDrv");
        this.jPanelCanDrv.setLayout(new GridBagLayout());
        this.jLabelMotor.setHorizontalAlignment(0);
        this.jLabelMotor.setText(resourceMap.getString("jLabelMotor.text", new Object[0]));
        this.jLabelMotor.setName("jLabelMotor");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.weightx = 0.2;
        this.jPanelCanDrv.add((Component)this.jLabelMotor, gridBagConstraints);
        this.jTBCanDrv1.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv1);
        this.jTBCanDrv1.setText(resourceMap.getString("jTBCanDrv1.text", new Object[0]));
        this.jTBCanDrv1.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv1.setName("jTBCanDrv1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv1, gridBagConstraints);
        this.jTBCanDrv2.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv2);
        this.jTBCanDrv2.setText(resourceMap.getString("jTBCanDrv2.text", new Object[0]));
        this.jTBCanDrv2.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv2.setName("jTBCanDrv2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv2, gridBagConstraints);
        this.jTBCanDrv3.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv3);
        this.jTBCanDrv3.setText(resourceMap.getString("jTBCanDrv3.text", new Object[0]));
        this.jTBCanDrv3.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv3.setName("jTBCanDrv3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv3, gridBagConstraints);
        this.jTBCanDrv4.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv4);
        this.jTBCanDrv4.setText(resourceMap.getString("jTBCanDrv4.text", new Object[0]));
        this.jTBCanDrv4.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv4.setName("jTBCanDrv4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv4, gridBagConstraints);
        this.jTBCanDrv5.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv5);
        this.jTBCanDrv5.setText(resourceMap.getString("jTBCanDrv5.text", new Object[0]));
        this.jTBCanDrv5.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv5.setName("jTBCanDrv5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv5, gridBagConstraints);
        this.jTBCanDrv6.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv6);
        this.jTBCanDrv6.setText(resourceMap.getString("jTBCanDrv6.text", new Object[0]));
        this.jTBCanDrv6.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv6.setName("jTBCanDrv6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv6, gridBagConstraints);
        this.jTBCanDrv7.setAction(actionMap.get("toggleCanDrv"));
        this.buttonGroupCanDrv.add(this.jTBCanDrv7);
        this.jTBCanDrv7.setText(resourceMap.getString("jTBCanDrv7.text", new Object[0]));
        this.jTBCanDrv7.setMargin(new Insets(2, 2, 2, 2));
        this.jTBCanDrv7.setName("jTBCanDrv7");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.anchor = 18;
        this.jPanelCanDrv.add((Component)this.jTBCanDrv7, gridBagConstraints);
        this.jPanel11.add((Component)this.jPanelCanDrv, new AbsoluteConstraints(150, 70, 230, 20));
        this.jCheckBoxBasicData.setSelected(true);
        this.jCheckBoxBasicData.setText(resourceMap.getString("jCheckBoxBasicData.text", new Object[0]));
        this.jCheckBoxBasicData.setName("jCheckBoxBasicData");
        this.jPanel11.add((Component)this.jCheckBoxBasicData, new AbsoluteConstraints(100, 40, 70, -1));
        this.jLabelRequestData.setText(resourceMap.getString("jLabelRequestData.text", new Object[0]));
        this.jLabelRequestData.setName("jLabelRequestData");
        this.jPanel11.add((Component)this.jLabelRequestData, new AbsoluteConstraints(10, 43, 90, -1));
        this.jSpinnerTimeScale.setModel(new SpinnerNumberModel(Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(5.0f), Float.valueOf(0.1f)));
        this.jSpinnerTimeScale.setToolTipText(resourceMap.getString("jSpinnerTimeScale.toolTipText", new Object[0]));
        this.jSpinnerTimeScale.setName("jSpinnerTimeScale");
        this.jSpinnerTimeScale.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TabbedPanelMonitoring.this.jSpinnerTimeScaleStateChanged(evt);
            }
        });
        this.jPanel11.add((Component)this.jSpinnerTimeScale, new AbsoluteConstraints(130, 10, 40, -1));
        this.jLabelTimeScale.setText(resourceMap.getString("jLabelTimeScale.text", new Object[0]));
        this.jLabelTimeScale.setName("jLabelTimeScale");
        this.jPanel11.add((Component)this.jLabelTimeScale, new AbsoluteConstraints(110, 15, -1, -1));
        this.jLabelYScale.setText(resourceMap.getString("jLabelYScale.text", new Object[0]));
        this.jLabelYScale.setName("jLabelYScale");
        this.jPanel11.add((Component)this.jLabelYScale, new AbsoluteConstraints(180, 15, -1, -1));
        this.jPanel1.add((Component)this.jPanel11, new AbsoluteConstraints(0, 0, 380, 90));
        this.jPanelRCData.setName("jPanelRCData");
        this.jPanel1.add((Component)this.jPanelRCData, new AbsoluteConstraints(385, 10, 320, 80));
        this.jButtonNewWin.setAction(actionMap.get("buttonNewWin"));
        this.jButtonNewWin.setText(resourceMap.getString("jButtonNewWin.text", new Object[0]));
        this.jButtonNewWin.setName("jButtonNewWin");
        this.jPanel1.add((Component)this.jButtonNewWin, new AbsoluteConstraints(705, 10, 20, 20));
        this.jChart.setBorder(BorderFactory.createBevelBorder(1));
        this.jChart.setToolTipText(resourceMap.getString("jChart.toolTipText", new Object[0]));
        this.jChart.setMaximumSize(new Dimension(0, 0));
        this.jChart.setMinimumSize(new Dimension(0, 0));
        this.jChart.setName("jChart");
        this.jChart.setLayout(new BoxLayout(this.jChart, 2));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setName("jScrollPane1");
        this.jPanelChartToggle.setName("jPanelChartToggle");
        this.jPanelChartToggle.setPreferredSize(new Dimension(140, 400));
        this.jScrollPane1.setViewportView(this.jPanelChartToggle);
        GroupLayout groupMonitoringLayout = new GroupLayout(this.groupMonitoring);
        this.groupMonitoring.setLayout(groupMonitoringLayout);
        groupMonitoringLayout.setHorizontalGroup(groupMonitoringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupMonitoringLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 175, -2).addGap(2, 2, 2).addComponent(this.jChart, -1, 548, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        groupMonitoringLayout.setVerticalGroup(groupMonitoringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupMonitoringLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupMonitoringLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChart, -1, 242, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 242, Short.MAX_VALUE))));
        this.add(this.groupMonitoring);
        this.groupMonitoring.setBounds(0, 0, 725, 340);
    }

    private void jSpinnerFrameRateStateChanged(ChangeEvent evt) {
        int frameRate = Math.max(1, ((Number)this.jSpinnerFrameRate.getValue()).intValue());
        RealtimeDataThread.setFrameRate(frameRate);
        this.chart.setUpdateRate(frameRate);
        Settings.set("monitoring.frame_rate", Integer.toString(frameRate));
    }

    private void jSliderScaleStateChanged(ChangeEvent evt) {
        if (!this.isZoomYUpdating) {
            this.chart.setZoomY((float)(Math.exp((float)(this.jSliderScale.getValue() - 250) / 70.0f) * (2.0 / Math.exp(3.5714285714285716))));
        }
    }

    private void jCheckBoxDebugVarsStateChanged(ChangeEvent evt) {
        if (this.jCheckBoxDebugVars.isSelected()) {
            if (!Settings.is("realtime.debug_vars")) {
                DebugVars.requestDebugVarsInfo(0);
                Settings.set("realtime.debug_vars", "true");
                Settings.save();
            }
        } else {
            DebugVars.setVars(null);
            Settings.set("realtime.debug_vars", "false");
            Settings.save();
        }
    }

    private void jSpinnerTimeScaleStateChanged(ChangeEvent evt) {
        if (!this.isZoomYUpdating) {
            float val = ((Number)this.jSpinnerTimeScale.getValue()).floatValue();
            this.chart.setTimeScale(val);
            Settings.set("monitoring.time_scale", val);
        }
    }

    private int addChartTrace(final JRealTrace t) {
        t.setHint(this.resourceMap.getString("chart.hint." + t.getName(), new Object[0]));
        this.chart.addTrace(t);
        this.traceListChanged = true;
        AbstractAction chartListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton toggle = (JToggleButton)e.getSource();
                t.setEnabled(toggle.isSelected());
                TabbedPanelMonitoring.this.chart.redraw();
                if (!(t.updateGroup == null || toggle.isSelected() && t.updateGroup.hasFreshData())) {
                    ((JLabel)TabbedPanelMonitoring.this.chartLabels.get(t.id)).setText(null);
                }
            }
        };
        JToggleButton toggle = new JToggleButton(t.getName(), t.isEnabled());
        toggle.setVisible(true);
        toggle.setPreferredSize(new Dimension(90, 20));
        toggle.setMargin(new Insets(2, 2, 2, 2));
        toggle.setHorizontalAlignment(4);
        toggle.addActionListener(chartListener);
        toggle.setToolTipText(t.getHint());
        this.mainView.setToolTipListener(toggle);
        this.jPanelChartToggle.add(toggle);
        this.chartToggles.add(toggle);
        JLabel label = new JLabel("");
        label.setForeground(Color.WHITE);
        label.setBackground(t.getColor());
        label.setVisible(true);
        label.setHorizontalAlignment(4);
        label.setOpaque(true);
        label.setFont(new Font(this.jLabelSPS.getFont().getName(), 1, this.jLabelSPS.getFont().getSize()));
        label.setPreferredSize(new Dimension(50, 20));
        this.jPanelChartToggle.add(label);
        this.chartLabels.add(label);
        Dimension d = this.jPanelChartToggle.getPreferredSize();
        d.height = this.chartToggles.size() * (20 + ((FlowLayout)this.jPanelChartToggle.getLayout()).getVgap());
        this.jPanelChartToggle.setPreferredSize(d);
        return t.id;
    }

    public JRealTrace addChartTraceIfNotExists(String name) {
        JRealTrace trace = null;
        for (JRealTrace t : this.chart.traces) {
            if (!t.getName().equals(name)) continue;
            trace = t;
            break;
        }
        if (trace == null) {
            trace = new JRealTrace(name, false);
            this.addChartTrace(trace);
        }
        return trace;
    }

    public void addDebugVar(DebugVar v) {
        JRealTrace trace = this.addChartTraceIfNotExists(v.name);
        trace.setUpdateGroup(v);
        v.id = trace.id;
        v.trace = trace;
        v.color = trace.getColor();
    }

    public void setCurIMU(int type) {
        BoardParams params = BoardParams.getCurParams();
        if (params != null) {
            params.curIMU = type;
            SerialCommandProcessor.sendCommand(new SerialCommand(24, new byte[]{(byte)type}));
            this.updateCurIMU(params.curIMU);
        }
    }

    private void updateCurIMU(int curIMU) {
        if (curIMU == 1) {
            this.jToggleImuMain.setSelected(true);
        } else if (curIMU == 2) {
            this.jToggleImuFrame.setSelected(true);
        }
        this.curIMUset = curIMU;
    }

    public void setChartData(int id, float data, long time_ms) {
        if (id >= 0 && id < this.chart.traces.size() && this.chart.addData(id, data, time_ms)) {
            JRealTrace trace = this.chart.traces.get(id);
            this.chartLabels.get(id).setText(trace.formatData(data));
        }
    }

    public void setChartData(String traceName, float data, long time_ms) {
        JRealTrace trace = this.addChartTraceIfNotExists(traceName);
        this.setChartData(trace.id, data, time_ms);
    }

    public void setChartDataUnknown(int id) {
        if (id >= 0 && id < this.chart.traces.size()) {
            this.chartLabels.get(id).setText("");
        }
    }

    public void pauseRealtimeData() {
        this.jToggleButtonPause.setSelected(true);
        RealtimeDataThread.pause(true);
    }

    private void onTraceListChanged() {
        if (this.isDataLogEnabled()) {
            this.stopLogging();
            this.startLogging(true);
        }
    }

    public void updateRealtimeData(RealtimeData d) {
        int i;
        if (this.traceListChanged) {
            this.onTraceListChanged();
            this.traceListChanged = false;
        }
        if (d.regDate == null) {
            return;
        }
        for (i = 0; i < 3; ++i) {
            if (UPD_GROUP_ACC.hasFreshData()) {
                if (d.curIMU == 2 && d.frame_acc != null) {
                    this.setChartData(i, (float)d.frame_acc[i], d.fast_t2);
                } else {
                    this.setChartData(i, (float)d.acc[i], d.fast_t1);
                }
            }
            if (UPD_GROUP_GYRO.hasFreshData()) {
                if (d.curIMU == 2 && d.frame_gyro != null) {
                    this.setChartData(i + 3, (float)d.frame_gyro[i], d.fast_t2);
                } else {
                    this.setChartData(i + 3, (float)d.gyro[i], d.fast_t1);
                }
            }
            this.setChartData(i + 6, d.stab_angle[i] - d.target_angle[i], d.fast_t1);
            this.setChartData(i + 9, (float)d.power[i], d.slow_t);
            if (UPD_GROUP_MAG.hasFreshData()) {
                this.setChartData(i + 12, (float)d.magData[i], d.fast_t2);
            }
            this.setChartData(i + 17, (float)d.motor_effective_out[i], d.slow_t);
            this.setChartData(i + 20, d.target_angle[i], d.fast_t1);
            this.setChartData(i + 23, d.stab_angle[i], d.fast_t1);
            this.setChartData(i + 26, d.frameCamAngle[i], d.fast_t1);
        }
        this.setChartData(15, (float)d.IMU_G_err * 0.1f, d.slow_t);
        this.setChartData(16, (float)d.IMU_H_err * 0.1f, d.slow_t);
        if (this.debugTraceId >= 0 && UPD_GROUP_DEBUG.hasFreshData()) {
            for (i = 0; i < 4; ++i) {
                this.setChartData(this.debugTraceId + i, (float)d.debug[i], d.fast_t2);
            }
        }
        this.setChartData(29, (float)d.current, d.slow_t);
        if (BoardInfo.isDebugMode() && d.fast_dt_avg > 0.0f) {
            this.chart.fps = Math.round(1000.0f / d.fast_dt_avg);
        }
        for (i = 0; i < d.rcData.length; ++i) {
            this.rcPanels[i].setData(d.rcData[i] > -10000 ? Integer.valueOf(d.rcData[i]) : null);
        }
        if (d.curIMU != this.curIMUset) {
            this.updateCurIMU(d.curIMU);
        }
        this.logData();
    }

    @Override
    public void updateBoardParams(BoardParams params) {
        this.updateCurIMU(params.curIMU);
    }

    @Override
    public void updateBoardVerUI() {
        if (BoardInfo.isDebugMode() && this.debugTraceId < 0) {
            this.debugTraceId = this.addChartTrace(new JRealTrace("DEBUG_1", false, 1.0f, UPD_GROUP_DEBUG));
            this.addChartTrace(new JRealTrace("DEBUG_2", false, 1.0f, UPD_GROUP_DEBUG));
            this.addChartTrace(new JRealTrace("DEBUG_3", false, 1.0f, UPD_GROUP_DEBUG));
            this.addChartTrace(new JRealTrace("DEBUG_4", false, 1.0f, UPD_GROUP_DEBUG));
        }
        this.jPanelCanDrv.setVisible(BoardInfo.hasBoardFeature(1024L));
        if (BoardInfo.hasCANDrvParams()) {
            this.curCanDrvIdx = Integer.parseInt(Settings.get("realtime.can_drv", "-1"));
            if (this.curCanDrvIdx >= 0 && this.curCanDrvIdx <= this.toggleCanDrv.length) {
                this.toggleCanDrv[this.curCanDrvIdx].setSelected(true);
            }
        } else {
            this.curCanDrvIdx = -1;
        }
        this.updateCanDrvCurIdx();
        ((SpinnerNumberModel)this.jSpinnerFrameRate.getModel()).setMaximum(Integer.valueOf(BoardInfo.hasRealtimeDataCustom2() ? 250 : 60));
    }

    @Override
    public void applyBoardParams(BoardParams params) {
        BoardProfile p = params.profiles[params.curProfile];
    }

    @Action(enabledProperty="connected")
    public void buttonCameraIMU() {
        this.setCurIMU(1);
    }

    @Action(enabledProperty="connected")
    public void buttonFrameIMU() {
        this.setCurIMU(2);
    }

    @Action(enabledProperty="connected")
    public void toggleCanDrv() {
        if (BoardInfo.hasCANDrvParams()) {
            for (int i = 0; i < this.toggleCanDrv.length; ++i) {
                JToggleButton b = this.toggleCanDrv[i];
                if (!b.isSelected()) continue;
                if (this.curCanDrvIdx == i) {
                    this.buttonGroupCanDrv.clearSelection();
                    this.curCanDrvIdx = -1;
                    break;
                }
                this.curCanDrvIdx = i;
                break;
            }
            Settings.set("realtime.can_drv", Integer.toString(this.curCanDrvIdx));
            Settings.save();
            this.updateCanDrvCurIdx();
        }
    }

    private void updateCanDrvCurIdx() {
        if (BoardInfo.getBoardInfo() != null && BoardInfo.hasCANDrvParams()) {
            DebugVar[] list;
            for (DebugVar v : list = CanDrvRealtimeData.getVariables(BoardInfo.getBoardInfo().getFrwVer())) {
                if (this.curCanDrvIdx == -1) {
                    if (v.id < 0) continue;
                    this.setChartTraceSelected(v.id, false);
                    continue;
                }
                this.addDebugVar(v);
                this.setChartTraceSelected(v.id, true);
            }
        }
    }

    private void setChartTraceSelected(int id, boolean mode) {
        if (id >= 0 && id < this.chart.traces.size()) {
            this.chartToggles.get(id).setSelected(mode);
            this.chart.traces.get(id).setEnabled(mode);
        }
    }

    public int getCurCanDrvIdx() {
        return this.curCanDrvIdx;
    }

    public boolean isRequestBasicDataEnabled() {
        return this.jCheckBoxBasicData.isSelected();
    }

    @Action(enabledProperty="connected")
    public void buttonPause() {
        RealtimeDataThread.pause(this.jToggleButtonPause.isSelected());
        Settings.set("realtime.data.paused", Boolean.toString(this.jToggleButtonPause.isSelected()));
        Settings.save();
    }

    @Action
    public void buttonNewWin() {
        this.jButtonNewWin.setVisible(false);
        try {
            new TabWindow(this, this.getClass(), this.getTitle(), null, false, new Runnable(){

                @Override
                public void run() {
                    TabbedPanelMonitoring.this.jButtonNewWin.setVisible(true);
                }
            }).showDialog();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    public boolean isDataLogEnabled() {
        return dataLogger != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLogging() {
        if (dataLogger != null) {
            DataLogger dataLogger = TabbedPanelMonitoring.dataLogger;
            synchronized (dataLogger) {
                TabbedPanelMonitoring.dataLogger.finish();
                TabbedPanelMonitoring.dataLogger = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLogging(boolean rewrite) {
        if (dataLogger == null) {
            try {
                dataLogger = new DataLogger("realtime_data_log.csv", !rewrite);
                ArrayList<String> header = new ArrayList<String>();
                header.add("TIME");
                for (JRealTrace trace : this.chart.traces) {
                    header.add(trace.getName());
                }
                header.add("RC[ROLL]");
                header.add("RC[PITCH]");
                header.add("RC[YAW]");
                header.add("RC[CMD]");
                header.add("RC[FC_ROLL]");
                header.add("RC[FC_PITCH]");
                header.add("BAT_VOLTAGE");
                header.add("CURRENT");
                DataLogger dataLogger = TabbedPanelMonitoring.dataLogger;
                synchronized (dataLogger) {
                    TabbedPanelMonitoring.dataLogger.setHeader(header);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logData() {
        if (dataLogger != null) {
            ArrayList<String> row = new ArrayList<String>(dataLogger.getHeader().size());
            row.add(logTimeFormat.format(new Date()));
            for (JRealTrace trace : this.chart.traces) {
                row.add(trace.formatData(trace.getLastData()));
            }
            RealtimeData d = RealtimeData.getRealtimeData();
            for (int i = 0; i < 6; ++i) {
                if (d.rcData[i] > -10000) {
                    row.add(Integer.toString(d.rcData[i]));
                    continue;
                }
                row.add("");
            }
            row.add(df2.format((float)d.bat_val * 0.01f));
            row.add(df3.format((float)d.current * 0.001f));
            DataLogger dataLogger = TabbedPanelMonitoring.dataLogger;
            synchronized (dataLogger) {
                TabbedPanelMonitoring.dataLogger.logData(row);
            }
        }
    }

    public void doPeriodicUpdate() {
        for (JRealTrace trace : this.chart.traces) {
            if (!trace.isDataExpired()) continue;
            this.setChartDataUnknown(trace.id);
        }
    }
}

