/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;

public class Utils {
    public static int getRadioButtonSelectedIndex(JRadioButton[] list) {
        int idx = 0;
        for (JRadioButton b : list) {
            if (b.isSelected()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static int getToggleButtonSelectedBits(JToggleButton[] list) {
        int bits = 0;
        int bitCnt = 0;
        for (JToggleButton b : list) {
            if (b.isSelected()) {
                bits |= 1 << bitCnt;
            }
            ++bitCnt;
        }
        return bits;
    }

    public static <T> T[] copyArray(T[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static int[] copyArray(int[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static byte[] copyArray(byte[] array) {
        return Arrays.copyOf(array, array.length);
    }

    public static <T> T[] concatArrays2(Object[] array1, Object[] array2, Class<T> elementType) {
        Object[] result = (Object[])Array.newInstance(elementType, array1.length + array2.length);
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] concatArrays(Class<T> elementType, T[] ... arrays) {
        int totalLength = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            totalLength += array.length;
        }
        Object[] result = (Object[])Array.newInstance(elementType, totalLength);
        int currentIndex = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
        }
        return result;
    }

    public static void setToolTipListener(Component c, MouseListener toolTipMouseListener) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            if (jc.getToolTipText() != null && jc.getToolTipText().length() > 0) {
                c.addMouseListener(toolTipMouseListener);
            }
            ToolTipManager.sharedInstance().unregisterComponent(jc);
        }
        if (c instanceof Container) {
            for (Component c2 : ((Container)c).getComponents()) {
                Utils.setToolTipListener(c2, toolTipMouseListener);
            }
        }
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static <T extends Comparable<T>> T max(T a, T b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static Comparable constrainForSpinner(Comparable value, JSpinner spinner) {
        return Utils.max(((SpinnerNumberModel)spinner.getModel()).getMinimum(), Utils.min(value, ((SpinnerNumberModel)spinner.getModel()).getMaximum()));
    }
}

