/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import sbgc.ui.chart.JRealTrace;
import sbgc.ui.chart.TraceDataPoint;
import sbgc.utils.MathUtils;

public class JRealChart
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Image buf1;
    private Image buf2;
    private Image curBuf;
    private Image prevBuf;
    Image gridSideBuf;
    double updateRate = 20.0;
    private double SHIFT_STEP_PER_UPDATE = 3.0;
    private static final int GRID_X_INTERVAL_MS = 1000;
    private double x_pos_time_scale;
    public int fps = 0;
    private long prevUpdateTime = 0L;
    private long startTime = 0L;
    private long lastGridXTime = 0L;
    double x_pos = 0.0;
    double x_pos_prev = 0.0;
    double shiftErr = 0.0;
    private int centerY;
    private float offsetY;
    private float zoomY = 0.1f;
    private int width;
    private int height;
    private Color gridColor = null;
    private Stroke gridStroke = null;
    private Stroke gridStrokeZero = null;
    private Color backgroundColor = null;
    private Stroke traceStroke = null;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(255, 255, 255);
    public static final Color DEFAULT_GRID_COLOR = new Color(204, 204, 204);
    public static final Stroke DEFAULT_GRID_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_GRID_STROKE_ZERO = new BasicStroke(2.0f);
    public static final int GRID_SIDE_WIDTH = 50;
    public static final Font labelFont = new Font("Arial", 1, 9);
    public static final Color labelColor = new Color(153, 153, 153);
    public static final DecimalFormat labelFormatter = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final float MAX_VAL = 1000000.0f;
    public ArrayList<JRealTrace> traces;
    private boolean needUpdate = false;
    private int bufSize = 0;
    private Point dragStartScreen;
    private long timeOffset;
    private long startTimeOffset;
    private float startOffsetY;
    private ArrayList<ChangeListener> zoomChangeListeners = null;

    public JRealChart() {
        this.setVisible(true);
        this.backgroundColor = DEFAULT_BACKGROUND_COLOR;
        this.gridColor = DEFAULT_GRID_COLOR;
        this.gridStroke = DEFAULT_GRID_STROKE;
        this.gridStrokeZero = DEFAULT_GRID_STROKE_ZERO;
        this.traces = new ArrayList();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JRealChart.this.onResize();
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
    }

    void onResize() {
        this.bufSize = (int)((double)(this.getWidth() * 3) / this.SHIFT_STEP_PER_UPDATE);
        this.traceStroke = new BasicStroke(MathUtils.constrain((float)this.SHIFT_STEP_PER_UPDATE / 2.0f, 0.7f, 1.1f));
        for (JRealTrace trace : this.traces) {
            trace.setBufSize(this.bufSize);
        }
        this.createBuffers();
        this.redraw();
    }

    void createBuffers() {
        this.buf1 = this.createImage(this.getWidth(), this.getHeight());
        this.width = this.buf1.getWidth(this);
        this.height = this.buf1.getHeight(this);
        this.centerY = this.height / 2;
        this.curBuf = this.buf2 = this.createImage(this.getWidth(), this.getHeight());
        this.gridSideBuf = new BufferedImage(50, this.getHeight(), 2);
    }

    public void start() {
        this.startTime = System.currentTimeMillis() - this.prevUpdateTime;
        this.redraw();
    }

    void onTimeScaleChanged() {
        this.x_pos_time_scale = this.SHIFT_STEP_PER_UPDATE * Math.max(this.updateRate, 1.0) / 1000.0;
    }

    public void setUpdateRate(int updateRate) {
        this.updateRate = updateRate;
        this.onTimeScaleChanged();
    }

    public void setTimeScale(double scale) {
        this.SHIFT_STEP_PER_UPDATE = scale;
        this.onTimeScaleChanged();
        if (this.curBuf != null) {
            this.onResize();
        }
    }

    public double getTimeScale() {
        return this.SHIFT_STEP_PER_UPDATE;
    }

    public void addTrace(JRealTrace trace) {
        trace.id = this.traces.size();
        this.traces.add(trace);
        if (this.bufSize > 0) {
            trace.setBufSize(this.bufSize);
        }
    }

    float gridAutoStep(float viewScale) {
        int step;
        float[] steps = new float[]{5.0f, 2.0f};
        float v_step = (float)Math.pow(10.0, Math.floor(Math.log10(10.0f / viewScale)));
        int i = 0;
        while ((step = (int)(v_step * viewScale)) <= 10) {
            v_step *= steps[i++];
            i %= steps.length;
        }
        return v_step;
    }

    private void drawGridYLine(Graphics2D bufG, Graphics2D sideBufG, int x1, int x2) {
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        bufG.setBackground(this.backgroundColor);
        bufG.clearRect(x1, 0, this.width - x1, this.height);
        bufG.setColor(this.gridColor);
        if (sideBufG != null) {
            sideBufG.setBackground(new Color(0xFFFFFF, true));
            sideBufG.clearRect(0, 0, 50, this.height);
        }
        float valStep = this.gridAutoStep(this.zoomY);
        block0: for (int dir = -1; dir <= 1; dir += 2) {
            int i = 0;
            while (true) {
                if (i != 0 || dir != -1) {
                    bufG.setStroke(i == 0 ? this.gridStrokeZero : this.gridStroke);
                    float val = (float)(dir * i) * valStep;
                    int viewVal = Math.round(val * this.zoomY + this.offsetY);
                    int y1 = this.centerY - viewVal;
                    if (dir < 0 && y1 > this.height || dir > 0 && y1 < 0) continue block0;
                    if (!(dir > 0 && y1 > this.height || dir < 0 && y1 < 0)) {
                        bufG.drawLine(x1, y1, x2, y1);
                        if (sideBufG != null) {
                            sideBufG.setFont(labelFont);
                            sideBufG.setColor(labelColor);
                            FontMetrics fm = sideBufG.getFontMetrics();
                            String s = labelFormatter.format(val);
                            int label_h = fm.getHeight() - fm.getAscent();
                            int label_y = y1 - label_h + 1;
                            if (label_y >= -2) {
                                sideBufG.drawString(s, 1, label_y);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void drawGrid() {
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        Graphics2D sideBufG = (Graphics2D)this.gridSideBuf.getGraphics();
        this.drawGridYLine(bufG, sideBufG, 0, this.width - 1);
        if (this.startTime != 0L && this.x_pos_time_scale != 0.0) {
            int x;
            long forTime = this.prevUpdateTime - this.timeOffset;
            while (this.lastGridXTime < forTime) {
                this.lastGridXTime += 1000L;
            }
            long deltaT = forTime - this.lastGridXTime;
            do {
                int gridX = (int)((double)(deltaT - 1000L) * this.x_pos_time_scale);
                x = this.width - 1 - gridX;
                bufG.drawLine(x, 0, x, this.height);
                deltaT += 1000L;
            } while (x > 0);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.curBuf == null) {
            this.onResize();
        }
        if (this.curBuf != null) {
            g.drawImage(this.curBuf, 0, 0, this);
            g.drawImage(this.gridSideBuf, 0, 0, this);
            if (this.fps != 0) {
                g.setFont(labelFont);
                g.setColor(labelColor);
                g.drawString(Integer.toString(this.fps), this.width - 20, 10);
            }
        }
    }

    public synchronized void update() {
        if (this.curBuf == null || !this.isShowing()) {
            return;
        }
        long curTime = System.currentTimeMillis() - this.startTime;
        int deltaTime = (int)(curTime - this.prevUpdateTime);
        if (deltaTime < 15) {
            return;
        }
        this.prevUpdateTime = curTime;
        this.x_pos += (double)deltaTime * this.x_pos_time_scale;
        double shiftStep_d = this.x_pos - this.x_pos_prev + this.shiftErr;
        int shiftStep = (int)Math.round(shiftStep_d);
        this.shiftErr = shiftStep_d - (double)shiftStep;
        this.x_pos_prev = this.x_pos;
        if (this.curBuf == this.buf1) {
            this.curBuf = this.buf2;
            this.prevBuf = this.buf1;
        } else {
            this.curBuf = this.buf1;
            this.prevBuf = this.buf2;
        }
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        bufG.drawImage(this.prevBuf, -shiftStep, 0, this);
        int x1 = this.width - shiftStep;
        int x2 = this.width - 1;
        curTime -= this.timeOffset;
        this.drawGridYLine(bufG, null, x1, x2);
        while (this.lastGridXTime - 1000L > curTime) {
            this.lastGridXTime -= 1000L;
        }
        int gridX = x2 - (int)((double)(curTime - this.lastGridXTime) * this.x_pos_time_scale);
        if (gridX < this.width) {
            bufG.drawLine(gridX, 0, gridX, this.height);
            this.lastGridXTime += 1000L;
        }
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bufG.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        block1: for (JRealTrace trace : this.traces) {
            TraceDataPoint p;
            if (!trace.isEnabled()) continue;
            trace.rollbackToTime(curTime);
            while ((p = trace.displayLastData()) != null) {
                if (p.t1 > curTime) {
                    trace.rollbackDisplayedPos(1);
                    continue block1;
                }
                double xx1 = (double)x2 - (double)(curTime - p.t0) * this.x_pos_time_scale + this.shiftErr;
                double xx2 = (double)x2 - (double)(curTime - p.t1) * this.x_pos_time_scale + this.shiftErr;
                if (!(xx2 >= 0.0) || !(xx2 - xx1 < (double)((int)(this.SHIFT_STEP_PER_UPDATE * 20.0)))) continue;
                bufG.setColor(trace.getColor());
                bufG.setStroke(this.traceStroke);
                bufG.draw(new Line2D.Double(xx1, (float)this.centerY - (p.val0 * this.zoomY + this.offsetY), xx2, (float)this.centerY - (p.val1 * this.zoomY + this.offsetY)));
            }
        }
        this.needUpdate = false;
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void redraw() {
        if (this.curBuf == null) {
            return;
        }
        Graphics2D bufG = (Graphics2D)this.curBuf.getGraphics();
        this.drawGrid();
        bufG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        long fromTime = this.prevUpdateTime - this.timeOffset;
        for (JRealTrace trace : this.traces) {
            if (!trace.isEnabled()) continue;
            bufG.setColor(trace.getColor());
            bufG.setStroke(this.traceStroke);
            JRealTrace jRealTrace = trace;
            synchronized (jRealTrace) {
                for (TraceDataPoint p : trace) {
                    if (p.t0 > fromTime) continue;
                    double x1 = (double)this.width - (double)(fromTime - p.t0) * this.x_pos_time_scale + this.shiftErr;
                    double x2 = (double)this.width - (double)(fromTime - p.t1) * this.x_pos_time_scale + this.shiftErr;
                    if (x2 < 0.0) break;
                    bufG.draw(new Line2D.Double(x1, (float)this.centerY - (p.val0 * this.zoomY + this.offsetY), x2, (float)this.centerY - (p.val1 * this.zoomY + this.offsetY)));
                }
                trace.resetLastDisplayPos();
            }
        }
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Stroke getGridStroke() {
        return this.gridStroke;
    }

    public void setGridStroke(Stroke gridStroke) {
        this.gridStroke = gridStroke;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public float getZoomY() {
        return this.zoomY;
    }

    public void setZoomY(float zoomY) {
        this.zoomY = Math.max(zoomY, 0.001f);
        this.redraw();
    }

    public boolean addData(int chartId, float data, long time_ms) {
        if (this.traces.get(chartId).addData(data, time_ms - this.startTime)) {
            this.needUpdate = true;
            return true;
        }
        return false;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.dragStartScreen = e.getPoint();
            this.startTimeOffset = this.timeOffset;
            this.startOffsetY = this.offsetY;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragStartScreen != null) {
            Point current = e.getPoint();
            float dx = (float)(current.getX() - this.dragStartScreen.getX());
            float dy = (float)(current.getY() - this.dragStartScreen.getY());
            this.offsetY = this.startOffsetY - dy;
            this.timeOffset = Math.max(0L, this.startTimeOffset + (long)((double)dx / this.x_pos_time_scale));
            this.redraw();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragStartScreen = null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        float zoomFactor;
        int rotation = e.getWheelRotation();
        float mouseX = e.getX();
        float mouseY = e.getY();
        float f = zoomFactor = rotation < 0 ? 1.1f : 0.9090909f;
        if (e.isControlDown()) {
            double timeScaleNew = this.SHIFT_STEP_PER_UPDATE * (double)zoomFactor;
            this.setTimeScale(timeScaleNew);
        } else {
            float zoomYnew = this.zoomY * zoomFactor;
            this.offsetY = (mouseY - (float)(this.height / 2)) * (zoomFactor - 1.0f) + zoomFactor * this.offsetY;
            this.setZoomY(zoomYnew);
        }
        if (this.zoomChangeListeners != null) {
            for (ChangeListener listener : this.zoomChangeListeners) {
                listener.stateChanged(null);
            }
        }
    }

    public void addZoomChangeListener(ChangeListener listener) {
        if (this.zoomChangeListeners == null) {
            this.zoomChangeListeners = new ArrayList();
        }
        this.zoomChangeListeners.add(listener);
    }
}

