/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.chart;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Iterator;
import sbgc.object.IUpdateGroup;
import sbgc.ui.chart.TraceDataPoint;

public class JRealTrace
implements Iterable<TraceDataPoint> {
    private static int colorCnt = 0;
    private Color color = null;
    private float[] data;
    private long[] timeStamp;
    protected int curPos = 0;
    private String name;
    private String hint;
    private boolean enabled = true;
    private float scale;
    private DecimalFormat df;
    public IUpdateGroup updateGroup;
    private int lastDisplayedPos = 0;
    public int id = 0;
    public static final int DEFAULT_BUF_SIZE = 100;
    public static final Color[] DEFAULT_COLORS = new Color[]{new Color(77, 77, 77), new Color(247, 148, 32), new Color(236, 27, 59), new Color(92, 47, 9), new Color(6, 115, 186), new Color(43, 179, 75), new Color(252, 184, 21), new Color(243, 110, 36), new Color(162, 36, 142), new Color(16, 91, 170), new Color(25, 171, 173), new Color(165, 206, 58), new Color(127, 127, 127), new Color(165, 64, 80), new Color(84, 63, 110), new Color(81, 151, 152), new Color(88, 154, 104), new Color(219, 186, 108), new Color(192, 129, 92), new Color(126, 65, 116), new Color(51, 87, 126), new Color(173, 192, 122), new Color(255, 132, 5), new Color(255, 5, 23), new Color(120, 23, 234), new Color(5, 147, 255), new Color(5, 243, 19), new Color(27, 27, 27), new Color(201, 145, 0), new Color(201, 43, 0), new Color(201, 0, 201), new Color(0, 94, 201), new Color(0, 201, 201), new Color(108, 201, 0)};

    public JRealTrace(String name, boolean enabled) {
        this(name, enabled, 1.0f);
    }

    public JRealTrace(String name, boolean enabled, float scale) {
        this.name = name;
        this.enabled = enabled;
        this.scale = scale;
        this.df = new DecimalFormat(scale < 100.0f ? (scale < 10.0f ? "0" : "0.0") : "0.00");
        this.data = new float[100];
        this.timeStamp = new long[100];
        this.color = JRealTrace.getNextColor();
    }

    public JRealTrace(String name, boolean enabled, float scale, IUpdateGroup updateGroup) {
        this(name, enabled, scale);
        this.updateGroup = updateGroup;
    }

    public JRealTrace(String name, boolean enabled, String hint, float scale) {
        this(name, enabled, scale);
        this.hint = hint;
    }

    public static Color getNextColor() {
        return DEFAULT_COLORS[colorCnt++ % DEFAULT_COLORS.length];
    }

    public synchronized void setBufSize(int size) {
        if (this.data == null || this.data.length < size) {
            float[] prevData = this.data;
            long[] prevTimeStamp = this.timeStamp;
            this.data = new float[size];
            this.timeStamp = new long[size];
            if (prevData != null && prevTimeStamp != null) {
                int newPos;
                for (int i = newPos = Math.min(this.data.length, prevData.length) - 1; i >= 0; --i) {
                    this.data[i] = prevData[this.curPos];
                    this.timeStamp[i] = prevTimeStamp[this.curPos];
                    --this.curPos;
                    this.curPos = (this.curPos + prevData.length) % prevData.length;
                }
                this.curPos = newPos;
                this.resetLastDisplayPos();
            }
        }
    }

    public synchronized boolean addData(float x, long time) {
        if (this.timeStamp[this.curPos] == time) {
            return false;
        }
        ++this.curPos;
        this.curPos %= this.data.length;
        this.timeStamp[this.curPos] = time;
        this.data[this.curPos] = x;
        return true;
    }

    public synchronized float getLastData() {
        return this.data[this.curPos];
    }

    public String formatData(float val) {
        return this.df.format(val);
    }

    public void rollbackDisplayedPos(int offset) {
        this.lastDisplayedPos = (this.lastDisplayedPos + this.data.length - offset) % this.data.length;
    }

    public synchronized void rollbackToTime(long time) {
        while (this.lastDisplayedPos != this.curPos && this.timeStamp[this.lastDisplayedPos] > time) {
            this.lastDisplayedPos = (this.lastDisplayedPos + this.data.length - 1) % this.data.length;
        }
    }

    public synchronized TraceDataPoint displayLastData() {
        if (this.lastDisplayedPos != this.curPos) {
            ++this.lastDisplayedPos;
            this.lastDisplayedPos %= this.data.length;
            int pos1 = (this.lastDisplayedPos + this.data.length - 1) % this.data.length;
            int pos2 = this.lastDisplayedPos;
            return new TraceDataPoint(this.timeStamp[pos1], this.data[pos1] * this.scale, this.timeStamp[pos2], this.data[pos2] * this.scale);
        }
        return null;
    }

    public synchronized void resetLastDisplayPos() {
        this.lastDisplayedPos = this.curPos;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.updateGroup != null) {
            this.updateGroup.setEnabled(enabled);
        }
    }

    public boolean isDataExpired() {
        return this.updateGroup != null && !this.updateGroup.hasFreshData();
    }

    public float getScale() {
        return this.scale;
    }

    public void setUpdateGroup(IUpdateGroup group) {
        this.updateGroup = group;
    }

    @Override
    public synchronized Iterator<TraceDataPoint> iterator() {
        return new Iterator<TraceDataPoint>(){
            private int pos;
            {
                this.pos = JRealTrace.this.curPos;
            }

            @Override
            public boolean hasNext() {
                return (this.pos + JRealTrace.this.data.length - JRealTrace.this.curPos - 2) % JRealTrace.this.data.length > 0;
            }

            @Override
            public TraceDataPoint next() {
                int pos1 = (this.pos + JRealTrace.this.data.length - 1) % JRealTrace.this.data.length;
                int pos2 = this.pos;
                this.pos = this.pos > 0 ? --this.pos : JRealTrace.this.data.length - 1;
                return new TraceDataPoint(JRealTrace.this.timeStamp[pos1], JRealTrace.this.data[pos1] * JRealTrace.this.scale, JRealTrace.this.timeStamp[pos2], JRealTrace.this.data[pos2] * JRealTrace.this.scale);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

