/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.groups;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.GeometryCfg;
import sbgc.ui.groups.IGroupPanel;
import sbgc.utils.MathUtils;
import simplebgc_gui.SimpleBGC_GUIApp;

public class GroupGeometry
extends JPanel
implements IGroupPanel {
    JSpinner[][] spinnerMotorOffset;
    JSpinner[] spinnerSplitReceiverOffset;
    private JComboBox jCBSplitReceiverAxisRight;
    private JComboBox jCBSplitReceiverAxisTop;
    private JCheckBox jCBSplitReceiverMagEnable;
    private JComboBox jCBSplitReceiverMagOrigin;
    private JComboBox jCBSplitReceiverOrigin;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelGeometryIMU;
    private JLabel jLabelMotOffset1;
    private JLabel jLabelMotOffset2;
    private JLabel jLabelMotOffset3;
    private JLabel jLabelSplitReceiverMagAxisRight;
    private JLabel jLabelSplitReceiverMagAxisTop;
    private JLabel jLabelSplitReceiverMagOrigin;
    private JLabel jLabelSplitReceiverOffset;
    private JLabel jLabelSplitReceiverOrigin;
    private JLabel jLabelSplitReceiverTitle;
    private JSpinner jSpinnerMot1OffsetX;
    private JSpinner jSpinnerMot1OffsetY;
    private JSpinner jSpinnerMot1OffsetZ;
    private JSpinner jSpinnerMot2OffsetX;
    private JSpinner jSpinnerMot2OffsetY;
    private JSpinner jSpinnerMot2OffsetZ;
    private JSpinner jSpinnerMot3OffsetX;
    private JSpinner jSpinnerMot3OffsetY;
    private JSpinner jSpinnerMot3OffsetZ;
    private JSpinner jSpinnerSplitReceiverX;
    private JSpinner jSpinnerSplitReceiverY;
    private JSpinner jSpinnerSplitReceiverZ;

    public GroupGeometry() {
        this.initComponents();
        this.spinnerMotorOffset = new JSpinner[][]{{this.jSpinnerMot1OffsetX, this.jSpinnerMot1OffsetY, this.jSpinnerMot1OffsetZ}, {this.jSpinnerMot2OffsetX, this.jSpinnerMot2OffsetY, this.jSpinnerMot2OffsetZ}, {this.jSpinnerMot3OffsetX, this.jSpinnerMot3OffsetY, this.jSpinnerMot3OffsetZ}};
        this.spinnerSplitReceiverOffset = new JSpinner[]{this.jSpinnerSplitReceiverX, this.jSpinnerSplitReceiverY, this.jSpinnerSplitReceiverZ};
        this.jCBSplitReceiverMagOriginItemStateChanged(null);
    }

    private void initComponents() {
        this.jLabelGeometryIMU = new JLabel();
        this.jLabelMotOffset1 = new JLabel();
        this.jSpinnerMot1OffsetX = new JSpinner();
        this.jLabelMotOffset2 = new JLabel();
        this.jLabelMotOffset3 = new JLabel();
        this.jSpinnerMot2OffsetX = new JSpinner();
        this.jSpinnerMot3OffsetX = new JSpinner();
        this.jSpinnerMot1OffsetY = new JSpinner();
        this.jSpinnerMot2OffsetY = new JSpinner();
        this.jSpinnerMot3OffsetY = new JSpinner();
        this.jSpinnerMot1OffsetZ = new JSpinner();
        this.jSpinnerMot2OffsetZ = new JSpinner();
        this.jSpinnerMot3OffsetZ = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabelSplitReceiverTitle = new JLabel();
        this.jLabelSplitReceiverOrigin = new JLabel();
        this.jSpinnerSplitReceiverX = new JSpinner();
        this.jSpinnerSplitReceiverY = new JSpinner();
        this.jSpinnerSplitReceiverZ = new JSpinner();
        this.jLabelSplitReceiverOffset = new JLabel();
        this.jCBSplitReceiverOrigin = new JComboBox();
        this.jCBSplitReceiverMagEnable = new JCheckBox();
        this.jLabelSplitReceiverMagOrigin = new JLabel();
        this.jCBSplitReceiverMagOrigin = new JComboBox();
        this.jLabelSplitReceiverMagAxisTop = new JLabel();
        this.jCBSplitReceiverAxisTop = new JComboBox();
        this.jLabelSplitReceiverMagAxisRight = new JLabel();
        this.jCBSplitReceiverAxisRight = new JComboBox();
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(GroupGeometry.class);
        this.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupGeometry.border.title", new Object[0])));
        this.setName("groupGeometry");
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelGeometryIMU.setText(resourceMap.getString("jLabelGeometryIMU.text", new Object[0]));
        this.jLabelGeometryIMU.setName("jLabelGeometryIMU");
        this.add((Component)this.jLabelGeometryIMU, new AbsoluteConstraints(20, 30, -1, -1));
        this.jLabelMotOffset1.setText(resourceMap.getString("jLabelMotOffset1.text", new Object[0]));
        this.jLabelMotOffset1.setName("jLabelMotOffset1");
        this.add((Component)this.jLabelMotOffset1, new AbsoluteConstraints(20, 70, 90, -1));
        this.jSpinnerMot1OffsetX.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot1OffsetX.setName("jSpinnerMot1OffsetX");
        this.add((Component)this.jSpinnerMot1OffsetX, new AbsoluteConstraints(110, 70, 60, -1));
        this.jLabelMotOffset2.setText(resourceMap.getString("jLabelMotOffset2.text", new Object[0]));
        this.jLabelMotOffset2.setName("jLabelMotOffset2");
        this.add((Component)this.jLabelMotOffset2, new AbsoluteConstraints(20, 100, 90, -1));
        this.jLabelMotOffset3.setText(resourceMap.getString("jLabelMotOffset3.text", new Object[0]));
        this.jLabelMotOffset3.setName("jLabelMotOffset3");
        this.add((Component)this.jLabelMotOffset3, new AbsoluteConstraints(20, 130, 90, -1));
        this.jSpinnerMot2OffsetX.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot2OffsetX.setName("jSpinnerMot2OffsetX");
        this.add((Component)this.jSpinnerMot2OffsetX, new AbsoluteConstraints(110, 100, 60, -1));
        this.jSpinnerMot3OffsetX.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot3OffsetX.setName("jSpinnerMot3OffsetX");
        this.add((Component)this.jSpinnerMot3OffsetX, new AbsoluteConstraints(110, 130, 60, -1));
        this.jSpinnerMot1OffsetY.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot1OffsetY.setName("jSpinnerMot1OffsetY");
        this.add((Component)this.jSpinnerMot1OffsetY, new AbsoluteConstraints(180, 70, 60, -1));
        this.jSpinnerMot2OffsetY.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot2OffsetY.setName("jSpinnerMot2OffsetY");
        this.add((Component)this.jSpinnerMot2OffsetY, new AbsoluteConstraints(180, 100, 60, -1));
        this.jSpinnerMot3OffsetY.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot3OffsetY.setName("jSpinnerMot3OffsetY");
        this.add((Component)this.jSpinnerMot3OffsetY, new AbsoluteConstraints(180, 130, 60, -1));
        this.jSpinnerMot1OffsetZ.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot1OffsetZ.setName("jSpinnerMot1OffsetZ");
        this.add((Component)this.jSpinnerMot1OffsetZ, new AbsoluteConstraints(250, 70, 60, -1));
        this.jSpinnerMot2OffsetZ.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot2OffsetZ.setName("jSpinnerMot2OffsetZ");
        this.add((Component)this.jSpinnerMot2OffsetZ, new AbsoluteConstraints(250, 100, 60, -1));
        this.jSpinnerMot3OffsetZ.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerMot3OffsetZ.setName("jSpinnerMot3OffsetZ");
        this.add((Component)this.jSpinnerMot3OffsetZ, new AbsoluteConstraints(250, 130, 60, -1));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.add((Component)this.jLabel4, new AbsoluteConstraints(110, 50, 60, -1));
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.add((Component)this.jLabel5, new AbsoluteConstraints(180, 50, 60, -1));
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.add((Component)this.jLabel6, new AbsoluteConstraints(250, 50, 60, -1));
        this.jLabelSplitReceiverTitle.setFont(this.jLabelSplitReceiverTitle.getFont().deriveFont(this.jLabelSplitReceiverTitle.getFont().getStyle() | 1));
        this.jLabelSplitReceiverTitle.setText(resourceMap.getString("jLabelSplitReceiverTitle.text", new Object[0]));
        this.jLabelSplitReceiverTitle.setName("jLabelSplitReceiverTitle");
        this.add((Component)this.jLabelSplitReceiverTitle, new AbsoluteConstraints(20, 160, -1, -1));
        this.jLabelSplitReceiverOrigin.setText(resourceMap.getString("jLabelSplitReceiverOrigin.text", new Object[0]));
        this.jLabelSplitReceiverOrigin.setName("jLabelSplitReceiverOrigin");
        this.add((Component)this.jLabelSplitReceiverOrigin, new AbsoluteConstraints(40, 190, 70, -1));
        this.jSpinnerSplitReceiverX.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerSplitReceiverX.setName("jSpinnerSplitReceiverX");
        this.add((Component)this.jSpinnerSplitReceiverX, new AbsoluteConstraints(110, 220, 60, -1));
        this.jSpinnerSplitReceiverY.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerSplitReceiverY.setName("jSpinnerSplitReceiverY");
        this.add((Component)this.jSpinnerSplitReceiverY, new AbsoluteConstraints(180, 220, 60, -1));
        this.jSpinnerSplitReceiverZ.setToolTipText(resourceMap.getString("jSpinnerMot1OffsetX.toolTipText", new Object[0]));
        this.jSpinnerSplitReceiverZ.setName("jSpinnerSplitReceiverZ");
        this.add((Component)this.jSpinnerSplitReceiverZ, new AbsoluteConstraints(250, 220, 60, -1));
        this.jLabelSplitReceiverOffset.setText(resourceMap.getString("jLabelSplitReceiverOffset.text", new Object[0]));
        this.jLabelSplitReceiverOffset.setName("jLabelSplitReceiverOffset");
        this.add((Component)this.jLabelSplitReceiverOffset, new AbsoluteConstraints(40, 220, 70, -1));
        this.jCBSplitReceiverOrigin.setModel(new DefaultComboBoxModel<String>(new String[]{"IMU sensor", "Motor 1", "Motor 2", "Motor 3"}));
        this.jCBSplitReceiverOrigin.setToolTipText(resourceMap.getString("jCBSplitReceiverOrigin.toolTipText", new Object[0]));
        this.jCBSplitReceiverOrigin.setName("jCBSplitReceiverOrigin");
        this.add((Component)this.jCBSplitReceiverOrigin, new AbsoluteConstraints(110, 190, 130, -1));
        this.jCBSplitReceiverMagEnable.setText(resourceMap.getString("jCBSplitReceiverMagEnable.text", new Object[0]));
        this.jCBSplitReceiverMagEnable.setToolTipText(resourceMap.getString("jCBSplitReceiverMagEnable.toolTipText", new Object[0]));
        this.jCBSplitReceiverMagEnable.setName("jCBSplitReceiverMagEnable");
        this.add((Component)this.jCBSplitReceiverMagEnable, new AbsoluteConstraints(40, 250, -1, -1));
        this.jLabelSplitReceiverMagOrigin.setText(resourceMap.getString("jLabelSplitReceiverMagOrigin.text", new Object[0]));
        this.jLabelSplitReceiverMagOrigin.setName("jLabelSplitReceiverMagOrigin");
        this.add((Component)this.jLabelSplitReceiverMagOrigin, new AbsoluteConstraints(70, 280, 60, -1));
        this.jCBSplitReceiverMagOrigin.setModel(new DefaultComboBoxModel<String>(new String[]{"Internal - Split Receiver", "Internal - Split Sensor", "External - IMU sensor", "External - Motor 1", "External - Motor 2", "External - Motor 3"}));
        this.jCBSplitReceiverMagOrigin.setToolTipText(resourceMap.getString("jCBSplitReceiverOrigin.toolTipText", new Object[0]));
        this.jCBSplitReceiverMagOrigin.setName("jCBSplitReceiverMagOrigin");
        this.jCBSplitReceiverMagOrigin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GroupGeometry.this.jCBSplitReceiverMagOriginItemStateChanged(evt);
            }
        });
        this.add((Component)this.jCBSplitReceiverMagOrigin, new AbsoluteConstraints(130, 280, 180, -1));
        this.jLabelSplitReceiverMagAxisTop.setText(resourceMap.getString("jLabelSplitReceiverMagAxisTop.text", new Object[0]));
        this.jLabelSplitReceiverMagAxisTop.setName("jLabelSplitReceiverMagAxisTop");
        this.add((Component)this.jLabelSplitReceiverMagAxisTop, new AbsoluteConstraints(70, 310, 100, -1));
        this.jCBSplitReceiverAxisTop.setModel(new DefaultComboBoxModel<String>(new String[]{" X", " Y", " Z", "-X", "-Y", "-Z"}));
        this.jCBSplitReceiverAxisTop.setToolTipText(resourceMap.getString("jCBSplitReceiverAxisTop.toolTipText", new Object[0]));
        this.jCBSplitReceiverAxisTop.setName("jCBSplitReceiverAxisTop");
        this.add((Component)this.jCBSplitReceiverAxisTop, new AbsoluteConstraints(170, 310, 50, -1));
        this.jLabelSplitReceiverMagAxisRight.setText(resourceMap.getString("jLabelSplitReceiverMagAxisRight.text", new Object[0]));
        this.jLabelSplitReceiverMagAxisRight.setName("jLabelSplitReceiverMagAxisRight");
        this.add((Component)this.jLabelSplitReceiverMagAxisRight, new AbsoluteConstraints(70, 340, 100, -1));
        this.jCBSplitReceiverAxisRight.setModel(new DefaultComboBoxModel<String>(new String[]{" X", " Y", " Z", "-X", "-Y", "-Z"}));
        this.jCBSplitReceiverAxisRight.setToolTipText(resourceMap.getString("jCBSplitReceiverAxisTop.toolTipText", new Object[0]));
        this.jCBSplitReceiverAxisRight.setName("jCBSplitReceiverAxisRight");
        this.add((Component)this.jCBSplitReceiverAxisRight, new AbsoluteConstraints(170, 340, 50, -1));
    }

    private void jCBSplitReceiverMagOriginItemStateChanged(ItemEvent evt) {
        boolean orientationNeeded = GeometryCfg.isSplitRecOrientationNeeded(this.jCBSplitReceiverMagOrigin.getSelectedIndex());
        this.jCBSplitReceiverAxisTop.setEnabled(orientationNeeded);
        this.jCBSplitReceiverAxisRight.setEnabled(orientationNeeded);
    }

    @Override
    public void applyBoardParams(BoardParams params) throws Exception {
        if (!BoardInfo.hasBoardFeature(0x80000000L)) {
            return;
        }
        GeometryCfg cfg = params.geometry_cfg;
        for (int axis = 0; axis < 3; ++axis) {
            for (int mot = 0; mot < 3; ++mot) {
                cfg.motor_offset[mot][axis] = ((Number)this.spinnerMotorOffset[mot][axis].getValue()).intValue();
            }
            cfg.split_receiver_offset[axis] = ((Number)this.spinnerSplitReceiverOffset[axis].getValue()).intValue();
        }
        cfg.split_receiver_origin = this.jCBSplitReceiverOrigin.getSelectedIndex();
        cfg.split_receiver_mag_origin = this.jCBSplitReceiverMagOrigin.getSelectedIndex();
        cfg.split_receiver_mag_axis_top = BoardParams.axisIndexToMap(this.jCBSplitReceiverAxisTop.getSelectedIndex());
        cfg.split_receiver_mag_axis_right = BoardParams.axisIndexToMap(this.jCBSplitReceiverAxisRight.getSelectedIndex());
        cfg.flags = BoardParams.updateBit(cfg.flags, 1, this.jCBSplitReceiverMagEnable.isSelected());
        cfg.validate();
    }

    @Override
    public void updateBoardParams(BoardParams params) throws Exception {
        GeometryCfg cfg = params.geometry_cfg;
        for (int axis = 0; axis < 3; ++axis) {
            for (int mot = 0; mot < 3; ++mot) {
                this.spinnerMotorOffset[mot][axis].setValue(cfg.motor_offset[mot][axis]);
            }
            this.spinnerSplitReceiverOffset[axis].setValue(cfg.split_receiver_offset[axis]);
        }
        this.jCBSplitReceiverOrigin.setSelectedIndex(MathUtils.constrain(cfg.split_receiver_origin, 0, this.jCBSplitReceiverOrigin.getItemCount() - 1));
        this.jCBSplitReceiverMagOrigin.setSelectedIndex(MathUtils.constrain(cfg.split_receiver_mag_origin, 0, this.jCBSplitReceiverMagOrigin.getItemCount() - 1));
        this.jCBSplitReceiverAxisTop.setSelectedIndex(BoardParams.axisMapToIndex(cfg.split_receiver_mag_axis_top));
        this.jCBSplitReceiverAxisRight.setSelectedIndex(BoardParams.axisMapToIndex(cfg.split_receiver_mag_axis_right));
        this.jCBSplitReceiverMagEnable.setSelected((cfg.flags & 1) != 0);
    }

    @Override
    public void updateBoardVerUI() {
    }
}

