/*
 * Decompiled with CFR 0.152.
 */
package sbgc.ui.utils;

import sbgc.ui.utils.Colored;

public class StatusBit {
    public String name;
    public Colored colored;
    public static final String HTML_COLOR_GOOD = "#33FF99";
    public static final String HTML_COLOR_BAD = "#FF5566";

    public StatusBit(String name, Colored colored) {
        this.name = name;
        this.colored = colored;
    }

    public static void format_html(StringBuilder s, StatusBit[] bits, int val) {
        StatusBit.format(s, bits, val, true);
    }

    public static void format_plain(StringBuilder s, StatusBit[] bits, int val) {
        StatusBit.format(s, bits, val, false);
    }

    public static void format(StringBuilder s, StatusBit[] bits, int val, boolean html) {
        boolean updated = false;
        for (int bit = 0; bit < bits.length; ++bit) {
            boolean is_bad;
            boolean is_set;
            StatusBit b = bits[bit];
            if (b == null) continue;
            boolean bl = is_set = (val & 1 << bit) != 0;
            if (b.colored == Colored.SET_IS_BAD_HIDE && !is_set || b.colored == Colored.SET_IS_GOOD_HIDE && !is_set) continue;
            String color = b.colored == Colored.SET_IS_GOOD || b.colored == Colored.SET_IS_GOOD_HIDE ? (is_set ? HTML_COLOR_GOOD : null) : (b.colored == Colored.SET_IS_BAD || b.colored == Colored.SET_IS_BAD_HIDE ? (is_set ? HTML_COLOR_BAD : null) : (b.colored == Colored.NOT_SET_IS_BAD ? (!is_set ? HTML_COLOR_BAD : null) : null));
            boolean bl2 = is_bad = color != null && color.equals(HTML_COLOR_BAD);
            if (updated) {
                s.append(", ");
            }
            if (html && color != null) {
                s.append("<font color=\"" + color + "\">");
                if (is_bad) {
                    s.append("<b>");
                }
            }
            s.append(b.name + ": ");
            s.append(is_set ? "OK" : (is_bad ? "FAIL" : "0"));
            if (html && color != null) {
                if (is_bad) {
                    s.append("</b>");
                }
                s.append("</font>");
            }
            updated = true;
        }
    }
}

