/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

public class AvgFilter {
    private float res = 0.0f;
    private float inv_fact;

    public AvgFilter(float factor) {
        this.inv_fact = 1.0f / (factor + 1.0f);
    }

    public AvgFilter(float inv_factor, float data) {
        this.inv_fact = inv_factor;
        this.res = data;
    }

    public void addData(float val) {
        this.res += (val - this.res) * this.inv_fact;
    }

    public float res() {
        return this.res;
    }

    public float process(float val) {
        this.addData(val);
        return this.res;
    }

    public static float average(float val, float new_val, float freq_Hz, float sampling_time_s) {
        return val + (new_val - val) * AvgFilter.LPF_FREQ_TO_FACTOR(freq_Hz, sampling_time_s);
    }

    public static float LPF_FREQ_TO_FACTOR(float freq_Hz, float sampling_time_sec) {
        float factor = freq_Hz * 2.0f * (float)Math.PI * sampling_time_sec;
        return factor / (factor + 1.0f);
    }
}

