/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.apache.log4j.Logger;
import sbgc.utils.Settings;

public class DataLogger {
    static final Logger logger = Logger.getLogger((String)DataLogger.class.getName());
    BufferedWriter log = null;
    String logFileName = null;
    List<String> header = null;
    File file = null;
    public static final String LOG_COL_SEPARATOR = ";";

    public DataLogger(String logFileName, boolean append) throws Exception {
        this.logFileName = logFileName;
        this.file = DataLogger.logFileByName(logFileName);
        this.start(append);
    }

    public static File logFileByName(String filename) throws Exception {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(Settings.getUserDir() + File.separatorChar + "logs" + File.separatorChar + filename);
        }
        return file;
    }

    public void start(boolean append) throws Exception {
        try {
            this.log = new BufferedWriter(new FileWriter(this.file, append));
        }
        catch (Exception e) {
            throw new Exception("Can't open log file for writing: " + e.toString());
        }
    }

    public void setHeader(List<String> header) {
        this.header = header;
        if (this.isEmpty()) {
            this.logData(header);
        }
    }

    public void logData(List<String> data) {
        try {
            int i = data.size();
            for (String s : data) {
                this.log.write(s);
                if (--i <= 0) continue;
                this.log.write(LOG_COL_SEPARATOR);
            }
            this.log.newLine();
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public void logData(String row) {
        try {
            this.log.write(row);
            this.log.newLine();
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public void flush() {
        try {
            this.log.flush();
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public void finish() {
        try {
            this.log.close();
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        this.log = null;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public File getLogFile() {
        return this.file;
    }

    public List<String> getHeader() {
        return this.header;
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }
}

