/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;

public class DefaultConstructorConverter
extends ReflectionConverter {
    private BoardParams initialParams = null;
    private BoardProfile initialProfile = null;

    public DefaultConstructorConverter(Mapper mapper, ReflectionProvider reflectionProvider, BoardParams initialParams, BoardProfile initialProfile) {
        super(mapper, reflectionProvider);
        this.initialParams = initialParams;
        this.initialProfile = initialProfile;
    }

    public boolean canConvert(Class clazz) {
        return clazz == BoardParams.class || clazz == BoardProfile.class;
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            Class clazz = this.mapper.realClass(reader.getNodeName());
            if (this.initialParams != null && clazz.isInstance(this.initialParams)) {
                return this.initialParams.clone();
            }
            if (this.initialProfile != null && clazz.isInstance(this.initialProfile)) {
                return this.initialProfile.clone();
            }
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ConversionException("Could not create class instance for node " + reader.getNodeName(), (Throwable)e);
        }
    }
}

