/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import sbgc.object.BackupData;
import sbgc.object.BoardInfo;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.IBoardFileReaderWriterListener;
import sbgc.utils.intelhex.Converter;
import simplebgc_gui.SimpleBGC_GUIApp;

public class FileUtil {
    static final Logger logger = Logger.getLogger((String)SerialCommandDispatcher.class.getName());
    public static final int BUFFER_SIZE = 1024;
    private static Clip singleClip = null;
    public static final int BACKUP_DATA_EEPROM_IMAGE = 1;
    public static final int BACKUP_DATA_IMU_CALIB = 2;
    public static final int BACKUP_DATA_MOTOR_CALIB = 3;
    public static final String[] BACKUP_DATA_TYPE_NAMES = new String[]{"Undefined", "EEPROM backup", "IMU calibrations", "Motor non-linearities calibration"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(String source, String destination) throws Exception {
        try {
            File sourceFile = new File(source);
            if (!sourceFile.exists()) {
                throw new Exception("File \"" + source + "\" doesn't exist!");
            }
            byte[] tmp = new byte[1024];
            try (FileInputStream fis = new FileInputStream(sourceFile);
                 FileOutputStream fos = new FileOutputStream(destination);){
                int read = 0;
                while ((read = fis.read(tmp, 0, 1024)) > 0) {
                    fos.write(tmp, 0, read);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(MessageFormat.format("Error moving file from \"{0}\" to \"{1}\": ", source, destination));
        }
    }

    public static void save(String file, StringBuffer content) throws Exception {
        FileUtil.save(file, content.toString());
    }

    public static void save(String file, String content) throws Exception {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(new File(file)));){
            out.write(content);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error saving file!");
        }
    }

    public static void save(String file, byte[] content) throws Exception {
        try (FileOutputStream out = new FileOutputStream(new File(file));){
            out.write(content);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error saving file!");
        }
    }

    public static void save(String file, ByteArrayOutputStream content) throws Exception {
        try (FileOutputStream out = new FileOutputStream(new File(file));){
            content.writeTo(out);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage() + "\n> Error saving file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer read(String file) throws Exception {
        try {
            StringBuffer content = new StringBuffer();
            try (BufferedReader in = new BufferedReader(new FileReader(new File(file)));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (content.length() > 0) {
                        content.append("\n");
                    }
                    content.append(line);
                }
            }
            return content;
        }
        catch (Exception e) {
            throw new Exception("Error reading file '" + file + "': " + e.getMessage());
        }
    }

    public static byte[] readBytes(File f) throws Exception {
        byte[] buf = new byte[(int)f.length()];
        try (FileInputStream in = null;){
            in = new FileInputStream(f);
            if (in.read(buf) == buf.length) {
                byte[] byArray = buf;
                return byArray;
            }
            try {
                throw new Exception("Can't read " + buf.length + " bytes!");
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw e;
            }
        }
    }

    public static void saveBackupData(int dataType, File f, byte[] data) throws Exception {
        BackupData d = new BackupData();
        d.formatVer = 1;
        d.type = dataType;
        d.frwVer = BoardInfo.getBoardInfo().getFrwVer();
        d.boardVer = BoardInfo.getBoardInfo().boardVer;
        d.data = data;
        d.saveToFile(f);
    }

    public static String getDataTypeName(int type) {
        if (type > 0 && type < BACKUP_DATA_TYPE_NAMES.length) {
            return BACKUP_DATA_TYPE_NAMES[type];
        }
        return "unknown (" + type + ")";
    }

    public static BackupData readBackupData(int dataType, File f) throws Exception {
        BackupData d = BackupData.readFromFile(f);
        if (d.type != dataType) {
            throw new Exception("Selected file contains different type of data: \"" + FileUtil.getDataTypeName(d.type) + "\", required: \"" + FileUtil.getDataTypeName(dataType) + "\"");
        }
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (dataType != 1 && boardInfo != null && boardInfo.getFrwVer() != d.frwVer && JOptionPane.showConfirmDialog(SimpleBGC_GUIApp.mainView.getFrame(), SimpleBGC_GUIApp.getResourceMap().getString("confirm.restore_EEPROM.firmware_ver_mismatch", new VersionImpl(d.frwVer).toString()), SimpleBGC_GUIApp.getResourceMap().getString("messageDialog.confirm.title", new Object[0]), 0) != 0) {
            return null;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSound() {
        block6: {
            try {
                if (singleClip == null) break block6;
                Clip clip = singleClip;
                synchronized (clip) {
                    if (singleClip.isRunning()) {
                        singleClip.stop();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void playSound(final String resourceFilename, final int loopCnt) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FileUtil.stopSound();
                    singleClip = AudioSystem.getClip();
                    Clip clip = singleClip;
                    synchronized (clip) {
                        AudioInputStream inputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(SimpleBGC_GUIApp.class.getResourceAsStream("/simplebgc_gui/resources/" + resourceFilename)));
                        singleClip.open(inputStream);
                        singleClip.loop(loopCnt);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static void readFileFromBoard(final int fileId, IProgressListener _progressListener, final IBoardFileReaderWriterListener fileListener) {
        final IProgressListener progressListener = _progressListener != null ? _progressListener : SimpleBGC_GUIApp.mainView;
        new Thread(new Runnable(){

            @Override
            public void run() {
                progressListener.onProgressStart(SimpleBGC_GUIApp.getResourceMap().getString("progress.reading_file_board", new Object[0]), false);
                try {
                    byte[] data = SerialCommandProcessor.readFile(fileId, progressListener);
                    fileListener.onFileRead(fileId, data);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).error((Object)e.toString());
                    fileListener.onError(fileId, e.toString());
                }
                finally {
                    progressListener.onProgressFinish(true);
                }
            }
        }).start();
    }

    public static void writeFileToBoard(final int fileId, final byte[] data, IProgressListener _progressListener, final IBoardFileReaderWriterListener fileListener) {
        final IProgressListener progressListener = _progressListener != null ? _progressListener : SimpleBGC_GUIApp.mainView;
        new Thread(new Runnable(){

            @Override
            public void run() {
                progressListener.onProgressStart(SimpleBGC_GUIApp.getResourceMap().getString("progress.writing_file_board", new Object[0]), false);
                try {
                    SerialCommandProcessor.writeFile(fileId, data, progressListener);
                    fileListener.onFileWritten(fileId);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).error((Object)e.toString());
                    fileListener.onError(fileId, e.toString());
                }
                finally {
                    progressListener.onProgressFinish(true);
                }
            }
        }).start();
    }

    public static int crc16_sbgc32(byte[] buf, int pos, int len) {
        int crc = FileUtil.crc16_init();
        return FileUtil.crc16_update(buf, pos, len, crc);
    }

    public static int crc16_init() {
        return 0;
    }

    public static int crc16_update(byte[] buf, int pos, int len, int crc) {
        for (int idx = 0; idx < len; ++idx) {
            for (int shift_register = 1; shift_register <= 255; shift_register <<= 1) {
                int data_bit = (buf[pos + idx] & shift_register) > 0 ? 1 : 0;
                int crc_bit = crc >> 15;
                crc <<= 1;
                crc &= 0xFFFF;
                if (data_bit == crc_bit) continue;
                crc ^= 0x8005;
            }
        }
        return crc;
    }

    public static byte[] readFirmwareFromFile(File firmware, int startAddress) throws Exception {
        byte[] data;
        if (firmware == null) {
            throw new IllegalArgumentException("Firmware file parameter should not be null!");
        }
        if (firmware.getName().toLowerCase().endsWith(".hex")) {
            data = new Converter(255, startAddress).convert(firmware);
        } else if (firmware.getName().toLowerCase().endsWith(".bin")) {
            data = FileUtil.readBytes(firmware);
        } else {
            throw new IllegalArgumentException("Unsupported file format: " + firmware.getName());
        }
        return data;
    }

    public static void createDirIfNotExists(String dirPath) throws Exception {
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdir()) {
            throw new Exception("Failed to create directory " + dirPath);
        }
    }

    public static File addExtensionIfMissed(File f, String ext) {
        if (!f.getName().toLowerCase().endsWith("." + ext)) {
            f = new File(f.getAbsolutePath() + "." + ext);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Object[]> readCSV(File file, int skipLines, Class[] cls) throws Exception {
        ArrayList<Object[]> arrayList;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                if (skipLines-- > 0) continue;
                String[] lineArr = line.split(";");
                Object[] val = new Object[cls.length];
                for (int col = 0; col < cls.length; ++col) {
                    if (col < lineArr.length) {
                        String strVal = lineArr[col];
                        Class t = cls[col];
                        if (t == Integer.class) {
                            val[col] = Integer.parseInt(strVal);
                            continue;
                        }
                        if (t == Float.class) {
                            val[col] = Float.valueOf(Float.parseFloat(strVal));
                            continue;
                        }
                        if (t == Double.class) {
                            val[col] = Double.parseDouble(strVal);
                            continue;
                        }
                        throw new Exception("Field " + col + " type " + t.getSimpleName() + " isn't supported");
                    }
                    val[col] = null;
                }
                list.add(val);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new Exception("Error reading '" + file.getAbsolutePath() + "': " + e.toString());
            }
        }
        in.close();
        return arrayList;
    }
}

