/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

public class HexUtil {
    public static byte[] fromHex(String hexPairs) {
        byte[] buf = new byte[hexPairs.length() / 2];
        for (int j = 0; j < buf.length; ++j) {
            String hex = hexPairs.substring(j * 2, j * 2 + 2);
            buf[j] = (byte)Integer.parseInt(hex, 16);
        }
        return buf;
    }

    public static String toHex(byte[] data) {
        return HexUtil.toHex(data, 0, data.length, null);
    }

    public static String toHex(byte[] data, int offset, int length, String separator) {
        StringBuilder buffer = new StringBuilder();
        for (int i = offset; i < length; ++i) {
            String hex = null;
            int v = data[i] & 0xFF;
            hex = Integer.toHexString(v);
            if (hex.length() < 2) {
                buffer.append("0");
            }
            buffer.append(hex);
            if (separator == null) continue;
            buffer.append(separator);
        }
        return buffer.toString();
    }

    public static String toHex(int[] data) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            String hex = null;
            hex = Integer.toHexString(data[i]);
            if (hex.length() < 2) {
                buffer.append("0");
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
        byte[] data = HexUtil.fromHex(args[0]);
        System.out.println(args[0]);
        System.out.println("byte array length: " + data.length);
        String hex = HexUtil.toHex(data);
        System.out.println(hex);
    }

    public static int firstBitPos(long d) {
        for (int pos = 0; pos < 32; ++pos) {
            if ((d & (long)(1 << pos)) == 0L) continue;
            return pos;
        }
        return -1;
    }

    public static void reverseCopy(byte[] from, int fromIdx, byte[] to, int toIdx, int length) {
        int endIdx = fromIdx + length - 1;
        for (int i = fromIdx; i <= endIdx; ++i) {
            to[toIdx + endIdx - i] = from[i];
        }
    }

    public static byte[] reverseCopy(byte[] arr, int fromIdx, int length) {
        byte[] res = new byte[length];
        HexUtil.reverseCopy(arr, fromIdx, res, 0, length);
        return res;
    }

    public static String toBinaryString(int integer, int numberOfBits) {
        return String.format("%" + numberOfBits + "s", Integer.toBinaryString(integer)).replaceAll(" ", "0");
    }

    public static boolean isAllZero(byte[] data, int offset, int len) {
        int end = Math.min(offset + len, data.length);
        for (int i = offset; i < end; ++i) {
            if (data[i] == 0) continue;
            return false;
        }
        return true;
    }
}

