/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

public class PeakMeter {
    private float[] buf;
    private int pos = 0;
    private float min = 0.0f;
    private float max = 0.0f;

    public PeakMeter(int size) {
        this.buf = new float[size];
    }

    public void addData(float data, boolean maxOnly) {
        int i;
        ++this.pos;
        this.pos %= this.buf.length;
        this.buf[this.pos] = data;
        this.max = this.buf[0];
        for (i = 1; i < this.buf.length; ++i) {
            if (!(this.buf[i] > this.max)) continue;
            this.max = this.buf[i];
        }
        if (maxOnly) {
            this.min = 0.0f;
        } else {
            this.min = this.buf[0];
            for (i = 1; i < this.buf.length; ++i) {
                if (!(this.buf[i] < this.min)) continue;
                this.min = this.buf[i];
            }
        }
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getAbsPeak() {
        return this.max - this.min;
    }

    public float getCur() {
        return this.buf[this.pos];
    }
}

