/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils;

import java.util.Arrays;
import sbgc.utils.MathUtils;

public class Quaternion {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public float w;
    public float[] v;

    public Quaternion() {
        this.v = new float[3];
        this.w = 1.0f;
    }

    public Quaternion(Quaternion q) {
        this.v = Arrays.copyOf(q.v, 3);
        this.w = q.w;
    }

    public final void init() {
        Arrays.fill(this.v, 0.0f);
        this.w = 1.0f;
    }

    public boolean is_nan() {
        return Float.isNaN(this.w);
    }

    public void set_nan() {
        this.w = Float.NaN;
    }

    public float[] toFltArr() {
        float[] arr = new float[]{this.w, this.v[0], this.v[1], this.v[2]};
        return arr;
    }

    public void from_NED(Quaternion q) {
        this.w = -q.w;
        this.v[0] = q.v[1];
        this.v[1] = q.v[0];
        this.v[2] = q.v[2];
    }

    public void to_NED(Quaternion q) {
        q.w = -this.w;
        q.v[0] = this.v[1];
        q.v[1] = this.v[0];
        q.v[2] = this.v[2];
    }

    public float power2() {
        return this.w * this.w + MathUtils.vector_dot_product(this.v, this.v);
    }

    public void scale(float val) {
        this.w *= val;
        MathUtils.vector_mult_var(this.v, val);
    }

    public void normalize() {
        this.scale(1.0f / (float)Math.sqrt(this.power2()));
    }

    public void iterative_norm() {
        this.scale(1.5f - 0.5f * this.power2());
    }

    public void inverse() {
        MathUtils.vector_reverse(this.v);
    }

    public void mult(Quaternion q, Quaternion res) {
        MathUtils.vector_cross_product(this.v, q.v, res.v);
        MathUtils.vector_inc_mult_var(res.v, q.v, this.w);
        MathUtils.vector_inc_mult_var(res.v, this.v, q.w);
        res.w = this.w * q.w - MathUtils.vector_dot_product(this.v, q.v);
    }

    public void mult(Quaternion q) {
        Quaternion tmp = new Quaternion(this);
        tmp.mult(q, this);
    }

    public void delta(Quaternion q, Quaternion res) {
        Quaternion inv = new Quaternion(this);
        inv.inverse();
        inv.mult(q, res);
    }

    public void to_euler_rpy(float[] angles) {
        angles[0] = (float)Math.atan2(2.0f * (this.w * -this.v[1] + this.v[0] * this.v[2]), 1.0f - 2.0f * (this.v[1] * this.v[1] + this.v[0] * this.v[0]));
        float sinp = 2.0f * (this.w * -this.v[0] - this.v[2] * this.v[1]);
        angles[1] = Math.abs(sinp = -sinp) >= 1.0f ? (float)(sinp > 0.0f ? 1.5707963267948966 : -1.5707963267948966) : (float)Math.asin(sinp);
        angles[2] = (float)Math.atan2(2.0f * (this.w * -this.v[2] + this.v[0] * this.v[1]), 1.0f - 2.0f * (this.v[0] * this.v[0] + this.v[2] * this.v[2]));
    }

    public void from_euler_rpy(float[] angles) {
        float[] a_div2 = new float[3];
        MathUtils.vector_mult(angles, 0.5f, a_div2);
        double cosR_2 = Math.cos(a_div2[0]);
        double sinR_2 = Math.sin(a_div2[0]);
        double cosP_2 = Math.cos(a_div2[1]);
        double sinP_2 = -Math.sin(a_div2[1]);
        double cosY_2 = Math.cos(a_div2[2]);
        double sinY_2 = Math.sin(a_div2[2]);
        this.w = (float)(cosR_2 * cosP_2 * cosY_2 + sinR_2 * sinP_2 * sinY_2);
        this.v[1] = -((float)(sinR_2 * cosP_2 * cosY_2 - cosR_2 * sinP_2 * sinY_2));
        this.v[0] = -((float)(cosR_2 * sinP_2 * cosY_2 + sinR_2 * cosP_2 * sinY_2));
        this.v[2] = -((float)(cosR_2 * cosP_2 * sinY_2 - sinR_2 * sinP_2 * cosY_2));
    }

    public void to_DCM(float[][] DCM) {
        float sqw = this.w * this.w;
        float sqx = this.v[0] * this.v[0];
        float sqy = this.v[1] * this.v[1];
        float sqz = this.v[2] * this.v[2];
        DCM[0][0] = sqx - sqy - sqz + sqw;
        DCM[1][1] = -sqx + sqy - sqz + sqw;
        DCM[2][2] = -sqx - sqy + sqz + sqw;
        float tmp1 = this.v[0] * this.v[1];
        float tmp2 = this.v[2] * this.w;
        DCM[1][0] = 2.0f * (tmp1 + tmp2);
        DCM[0][1] = 2.0f * (tmp1 - tmp2);
        tmp1 = this.v[0] * this.v[2];
        tmp2 = this.v[1] * this.w;
        DCM[2][0] = 2.0f * (tmp1 - tmp2);
        DCM[0][2] = 2.0f * (tmp1 + tmp2);
        tmp1 = this.v[1] * this.v[2];
        tmp2 = this.v[0] * this.w;
        DCM[2][1] = 2.0f * (tmp1 + tmp2);
        DCM[1][2] = 2.0f * (tmp1 - tmp2);
    }

    public boolean from_rot_vect_small(float[] rot_v) {
        float angle = MathUtils.vector_mod(rot_v);
        if (angle > 5.0E-6f) {
            float half_angle = angle * 0.5f;
            MathUtils.vector_mult(rot_v, 0.5f, this.v);
            this.w = 1.0f - half_angle * half_angle * 0.5f;
            return true;
        }
        this.init();
        return false;
    }

    public void from_axis_angle_small(float[] axis_v, float angle) {
        float half_angle = angle * 0.5f;
        MathUtils.vector_mult(axis_v, half_angle, this.v);
        this.w = 1.0f - half_angle * half_angle * 0.5f;
    }

    public float to_axis_angle(float[] res_v) {
        float mod_v = MathUtils.vector_mod(this.v);
        float theta = (float)Math.atan2(mod_v, this.w) * 2.0f;
        MathUtils.vector_mult(this.v, 1.0f / Math.max(mod_v, 1.0E-6f), res_v);
        return theta;
    }

    public void from_DCM(float[][] m) {
        float t = m[0][0] + m[1][1] + m[2][2];
        if (t > 0.0f) {
            t = (float)Math.sqrt(1.0f + t);
            this.w = 0.5f * t;
            t = 0.5f / t;
            this.v[0] = (m[2][1] - m[1][2]) * t;
            this.v[1] = (m[0][2] - m[2][0]) * t;
            this.v[2] = (m[1][0] - m[0][1]) * t;
        } else if (m[0][0] > m[1][1] && m[0][0] > m[2][2]) {
            t = (float)Math.sqrt(1.0f + m[0][0] - m[1][1] - m[2][2]);
            this.v[0] = 0.5f * t;
            t = 0.5f / t;
            this.w = (m[2][1] - m[1][2]) * t;
            this.v[1] = (m[1][0] + m[0][1]) * t;
            this.v[2] = (m[0][2] + m[2][0]) * t;
        } else if (m[1][1] > m[2][2]) {
            t = (float)Math.sqrt(1.0f - m[0][0] + m[1][1] - m[2][2]);
            this.v[1] = 0.5f * t;
            t = 0.5f / t;
            this.w = (m[0][2] - m[2][0]) * t;
            this.v[0] = (m[1][0] + m[0][1]) * t;
            this.v[2] = (m[2][1] + m[1][2]) * t;
        } else {
            t = (float)Math.sqrt(1.0f - m[0][0] - m[1][1] + m[2][2]);
            this.v[2] = 0.5f * t;
            t = 0.5f / t;
            this.w = (m[1][0] - m[0][1]) * t;
            this.v[0] = (m[0][2] + m[2][0]) * t;
            this.v[1] = (m[2][1] + m[1][2]) * t;
        }
    }

    public void interpolate(Quaternion target, float ratio, Quaternion res) {
        res.w = this.w + (target.w - this.w) * ratio;
        MathUtils.vector_sub(target.v, this.v, res.v);
        MathUtils.vector_mult_var(res.v, ratio);
        MathUtils.vector_inc(res.v, this.v);
        res.normalize();
    }

    public void slerp(Quaternion target, float ratio, Quaternion res) {
        float cos_a = MathUtils.vector_dot_product(this.v, target.v) + this.w * target.w;
        if (cos_a >= 0.9995f) {
            this.interpolate(target, ratio, res);
        }
        float theta0 = (float)Math.acos(cos_a);
        float theta = theta0 * ratio;
        res.w = target.w - this.w * cos_a;
        MathUtils.vector_mult(this.v, -cos_a, res.v);
        MathUtils.vector_inc(res.v, target.v);
        res.normalize();
        float cos_theta = (float)Math.cos(theta);
        float sin_theta = (float)Math.sin(theta);
        res.w = res.w * sin_theta + this.w * cos_theta;
        MathUtils.vector_mult_var(res.v, sin_theta);
        MathUtils.vector_inc_mult_var(res.v, this.v, cos_theta);
    }
}

