/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.http;

import java.io.StringReader;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sbgc.common.FirmwareInfoImpl;
import sbgc.utils.DateUtil;
import sbgc.utils.Log;
import sbgc.utils.http.HttpTransportPlainImpl;
import sbgc.utils.http.IResponse;
import sbgc.utils.http.ResponseImpl;

public class ResponseFactory
implements ContentHandler,
ErrorHandler {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Log logger = new Log(Logger.getLogger((String)HttpTransportPlainImpl.class.getName()));
    public ResponseImpl response = null;
    private StringBuffer content = null;
    private Locator locator = null;
    private boolean insideError = false;
    private boolean insideResult = false;
    private boolean insideKeys = false;
    private boolean insideKey = false;
    private String temporaryKeyType = null;
    private String temporaryKeyData = null;
    private boolean insideFirmwareInfo = false;
    private boolean insideCustomerInfo = false;
    private int version = -1;
    private int gui_version = -1;
    private String gui_url = null;
    private int versionId = -1;
    private int buildNumber = 0;
    private String title = null;
    private String description = null;
    private Date regDate = null;
    private int flags = 0;
    private String dataEncoding = null;

    public ResponseFactory(ResponseImpl response) {
        this.response = response;
    }

    public static IResponse getResponse(String xml) throws Exception {
        ResponseImpl response = new ResponseImpl();
        ResponseFactory factory = new ResponseFactory(response);
        factory.parse(xml);
        return response;
    }

    public void parse(String xml) throws Exception {
        logger.trace("Parsing xml...");
        if (xml == null) {
            throw new Exception("Empty string to parse!");
        }
        logger.trace("Setting up SAX...");
        SAXParser xr = new SAXParser();
        xr.setContentHandler(this);
        xr.setErrorHandler(this);
        try {
            logger.trace("Calling SAX...");
            xr.parse(new InputSource(new StringReader(xml)));
            logger.trace("Response was parsed successfully!");
        }
        catch (Exception e) {
            logger.error("Parse exception: " + e.toString());
            throw new Exception("Server response parsing error: " + e.toString());
        }
    }

    private String locate() {
        return "[" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + "] - ";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.content = new StringBuffer();
        if ("customer_info".equals(localName)) {
            this.insideCustomerInfo = true;
        } else if ("result".equals(localName)) {
            this.insideResult = true;
        } else if (this.insideResult && "keys".equals(localName)) {
            this.insideKeys = true;
        } else if (this.insideKeys && "key".equals(localName)) {
            this.insideKey = true;
        } else if ("firmware_info".equals(localName)) {
            this.insideFirmwareInfo = true;
        } else if ("firmware".equals(localName)) {
            this.dataEncoding = atts.getValue("encoding");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.insideKey && "key".equals(localName)) {
            this.insideKey = false;
            this.temporaryKeyType = null;
            this.temporaryKeyData = null;
        }
        if (this.insideKeys && "keys".equals(localName)) {
            this.insideKeys = false;
        }
        if (this.insideResult && "result".equals(localName)) {
            this.insideResult = false;
        }
        if (this.insideCustomerInfo && "customer_info".equals(localName)) {
            this.insideCustomerInfo = false;
        }
        if (this.insideFirmwareInfo && "firmware_info".equals(localName)) {
            if (this.response != null) {
                this.response.getFirmwareInfo().add(new FirmwareInfoImpl(this.version, this.versionId, this.buildNumber, this.title, this.description, this.regDate, this.gui_version, this.gui_url, this.flags));
            }
            this.version = -1;
            this.versionId = -1;
            this.buildNumber = 0;
            this.gui_version = -1;
            this.gui_url = null;
            this.description = null;
            this.title = null;
            this.regDate = null;
            this.insideFirmwareInfo = false;
            this.flags = 0;
        }
        if (this.response != null && this.content != null && this.content.toString() != null) {
            try {
                String value = this.content.toString().trim();
                if (this.insideCustomerInfo) {
                    if ("allow_reg".equals(localName)) {
                        this.response.setAllowReg("1".equals(value));
                    } else if ("email".equals(localName)) {
                        this.response.setEmail(value);
                    } else if ("country".equals(localName)) {
                        this.response.setCountry(value);
                    }
                    if ("board_id".equals(localName)) {
                        this.response.setBoardId(value);
                    }
                } else if (this.insideResult) {
                    if ("firmware".equals(localName)) {
                        char[] chars = new char[this.content.length()];
                        this.content.getChars(0, this.content.length(), chars, 0);
                        byte[] data = new byte[chars.length];
                        for (int i = 0; i < data.length; ++i) {
                            data[i] = (byte)chars[i];
                        }
                        if (this.dataEncoding != null && this.dataEncoding.equals("base64")) {
                            data = DatatypeConverter.parseBase64Binary((String)new String(data));
                        }
                        this.response.setFirmware(data);
                    } else if (this.insideFirmwareInfo) {
                        if ("version".equals(localName)) {
                            this.version = Integer.parseInt(value);
                        } else if ("versionId".equals(localName)) {
                            this.versionId = Integer.parseInt(value);
                        } else if ("buildNumber".equals(localName)) {
                            this.buildNumber = Integer.parseInt(value);
                        } else if ("description".equals(localName)) {
                            this.description = value;
                        } else if ("title".equals(localName)) {
                            this.title = value;
                        } else if ("reg_date".equals(localName)) {
                            this.regDate = DateUtil.parse(value, DATE_FORMAT);
                        } else if ("gui_version".equals(localName)) {
                            this.gui_version = Integer.parseInt(value);
                        } else if ("gui_url".equals(localName)) {
                            this.gui_url = value;
                        } else if ("flags".equals(localName)) {
                            this.flags = Integer.parseInt(value);
                        }
                    } else if (this.insideKey) {
                        if ("type".equals(localName)) {
                            this.temporaryKeyType = value;
                        } else if ("data".equals(localName)) {
                            this.temporaryKeyData = value;
                        }
                        if (this.temporaryKeyType != null && this.temporaryKeyData != null) {
                            this.response.getKeys().put(new Integer(this.temporaryKeyType), this.temporaryKeyData);
                        }
                    } else {
                        this.response.addResultData(localName, this.content.toString());
                    }
                } else if ("error_code".equals(localName)) {
                    this.response.setErrorCode(new Integer(value));
                } else if ("error_message".equals(localName)) {
                    this.response.setErrorMessage(value);
                }
            }
            catch (Exception e) {
                throw new SAXException(e.toString());
            }
        }
        if (this.insideResult && "result".equals(localName)) {
            this.insideResult = false;
        } else if (this.insideKeys && "keys".equals(localName)) {
            this.insideKeys = false;
        } else if (this.insideKey && "key".equals(localName)) {
            this.insideKey = false;
            this.temporaryKeyData = null;
            this.temporaryKeyType = null;
        }
        this.content = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.content != null) {
            this.content.append(ch, start, length);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void warning(SAXParseException exception) {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw new SAXException(this.locate() + exception.toString());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new SAXException(this.locate() + exception.toString());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

