/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.intelhex;

public final class Memory {
    public final int BLOCK_SIZE = 262144;
    public final int MAX_ALLOWED_SIZE = 0xA00000;
    private short[] image = new short[0];
    private int size = 0;

    public void expand(int newSize, short pad) throws Exception {
        if (newSize > 0xA00000) {
            throw new IllegalArgumentException("Requested memory size (" + newSize + ") exceeds max. allowed size (" + 0xA00000 + ")");
        }
        if (newSize > this.image.length) {
            short[] image2 = new short[(newSize / 262144 + 1) * 262144];
            System.arraycopy(this.image, 0, image2, 0, this.image.length);
            for (int i = this.image.length; i < image2.length; ++i) {
                image2[i] = pad;
            }
            this.image = image2;
        }
        this.size = newSize;
    }

    public void set(int index, short value) throws IllegalArgumentException {
        if (index >= this.size) {
            throw new IllegalArgumentException("Index " + index + " exceeds max. allowed memory " + this.size);
        }
        this.image[index] = value;
    }

    public byte[] toArray() {
        byte[] target = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            target[i] = (byte)this.image[i];
        }
        return target;
    }

    public int getSize() {
        return this.size;
    }
}

