/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.intelhex;

public enum RecordType {
    DATA(0),
    END_OF_FILE(1),
    EXTENDED_SEGMENT_ADDRESS(2),
    START_SEGMENT_ADDRESS(3),
    EXTENDED_LINEAR_ADDRESS(4),
    START_LINEAR_ADDRESS(5);

    private final short code;

    private RecordType(short code) {
        this.code = code;
    }

    public static RecordType of(short code) {
        for (RecordType recordType : RecordType.values()) {
            if (recordType.getCode() != code) continue;
            return recordType;
        }
        throw new IllegalArgumentException("Record type not found for the code: " + code);
    }

    public short getCode() {
        return this.code;
    }

    public String toString() {
        return this.name() + "[" + this.code + ']';
    }
}

