/*
 * Decompiled with CFR 0.152.
 */
package sbgc.utils.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.File;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Stack;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sbgc.object.AdjVarAnalogCfg;
import sbgc.object.AdjVarTriggerCfg;
import sbgc.object.BoardParams;
import sbgc.object.BoardParamsSavedData;
import sbgc.object.BoardProfile;
import sbgc.utils.DefaultConstructorConverter;
import sbgc.utils.FileUtil;
import sbgc.utils.xml.IParseable;
import sbgc.utils.xml.ParseableProfileTemplateImpl;
import sbgc.utils.xml.XStreamArrayConverter;
import simplebgc_gui.CustomDomDriver;

public class XmlUtils
implements ContentHandler,
ErrorHandler {
    private StringBuffer content = null;
    private Locator locator = null;
    private IParseable parseable = null;

    public static void parse(byte[] data, IParseable parseable) throws Exception {
        XmlUtils.parse(new String(data), parseable);
    }

    public XmlUtils(IParseable parseable) {
        this.parseable = parseable;
    }

    public static void parse(String data, IParseable parseable) throws Exception {
        XmlUtils utils = new XmlUtils(parseable);
        SAXParser xr = new SAXParser();
        xr.setContentHandler(utils);
        xr.setErrorHandler(utils);
        xr.parse(new InputSource(new StringReader(data)));
    }

    private String locate() {
        return "[" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + "] - ";
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.content = new StringBuffer();
        try {
            this.parseable.onStartElement(localName, atts);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String contentString = this.content.toString();
            if (contentString != null && contentString.trim().length() == 0) {
                contentString = null;
            }
            this.parseable.onEndElement(localName, contentString);
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.append(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void warning(SAXParseException exception) {
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw new SAXException(this.locate() + exception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new SAXException(this.locate() + exception.getMessage());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public static XStream configureXStream(HashSet<String> allowedElements) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new CustomDomDriver("UTF-8", allowedElements)){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        if (definedIn == Object.class) {
                            return false;
                        }
                        return super.shouldSerializeMember(definedIn, fieldName);
                    }
                };
            }
        };
        xstream.processAnnotations(BoardParams.class);
        xstream.processAnnotations(BoardParamsSavedData.class);
        xstream.processAnnotations(BoardProfile.class);
        xstream.processAnnotations(AdjVarAnalogCfg.class);
        xstream.processAnnotations(AdjVarTriggerCfg.class);
        xstream.registerConverter((Converter)new XStreamArrayConverter(xstream.getMapper()), 10000);
        return xstream;
    }

    public static BoardParamsSavedData loadProfileXML(File f, BoardParams initialParams, BoardProfile initialProfile) throws Exception {
        String content = FileUtil.read(f.getPath()).toString();
        XStream xstream = XmlUtils.configureXStream(null);
        xstream.registerConverter((Converter)new DefaultConstructorConverter(xstream.getMapper(), xstream.getReflectionProvider(), initialParams, initialProfile));
        Object o = xstream.fromXML(content);
        if (o == null) {
            throw new Exception("Read object is null!");
        }
        if (o instanceof BoardParamsSavedData) {
            return (BoardParamsSavedData)o;
        }
        throw new Exception("Unknown class \"" + o.getClass().getName() + "\"!");
    }

    public static HashSet<String> parseAllowedTagsFromProfileTemplate(String profileTemplatePath) throws Exception {
        try {
            ParseableProfileTemplateImpl parseable = new ParseableProfileTemplateImpl();
            XmlUtils xmlUtils = new XmlUtils(new ParseableProfileTemplateImpl());
            XmlUtils.parse(FileUtil.readBytes(new File(profileTemplatePath)), (IParseable)parseable);
            parseable.getElements().add("saved-configuration/all-profiles");
            return parseable.getElements();
        }
        catch (Exception e) {
            throw new Exception("Error parsing allowed tags from profile template: " + e.toString());
        }
    }

    public static String getElementPathFromStack(Stack<String> elements) {
        StringBuilder builder = new StringBuilder();
        for (String element : elements) {
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(element);
        }
        return builder.toString();
    }

    public static Object convertType(Class<?> requiredType, Object item) throws ArithmeticException {
        if (requiredType == Integer.TYPE || requiredType == Integer.class) {
            if (Float.class == item.getClass()) {
                item = Math.round(((Float)item).floatValue());
            } else if (Double.class == item.getClass()) {
                item = Math.toIntExact(Math.round((Double)item));
            }
        }
        return item;
    }
}

