/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.nio.charset.Charset;
import simplebgc_gui.BTModule;
import simplebgc_gui.UartCmdSender;

class BTModuleHC04_06
implements BTModule {
    protected UartCmdSender uartCmdSender;
    static final int[] speed2baud = new int[]{8, 7, 6, 5, 4};

    BTModuleHC04_06(UartCmdSender uartCmdSender) {
        this.uartCmdSender = uartCmdSender;
    }

    @Override
    public void validateName(String name) throws Exception {
        if (name.length() > 20) {
            throw new Exception("Name should be less than 20 characters long!");
        }
    }

    @Override
    public void validatePin(String pin) throws Exception {
        if (pin.length() != 4) {
            throw new Exception("PIN should be exactly 4 digits long!");
        }
    }

    @Override
    public String getTitle() {
        return "HC-04, HC-06 (Bluetooth 2.1)";
    }

    @Override
    public void sendAtCmd(String atCmd) throws Exception {
        Thread.sleep(1000L);
        this.uartCmdSender.sendUartCmd(atCmd.getBytes(Charset.forName("ISO-8859-1")), 1, 0, 1500);
    }

    @Override
    public String[] cmdFactoryDefaults() {
        return null;
    }

    @Override
    public String[] cmdSetPin(String pin) {
        return new String[]{"AT+PIN" + pin};
    }

    @Override
    public String[] cmdSetName(String name) {
        return new String[]{"AT+NAME" + name};
    }

    @Override
    public String[] cmdSetSpeedParity(int speed, int parity) {
        int baud = speed >= 0 && speed < speed2baud.length ? speed2baud[speed] : speed2baud[0];
        return new String[]{parity == 0 ? "AT+PN" : (parity == 1 ? "AT+PE" : "AT+PO"), "AT+BAUD" + baud};
    }

    @Override
    public String[] cmdReset() {
        return null;
    }

    @Override
    public String[] cmdSetOtherParams() {
        return null;
    }

    @Override
    public boolean needReset() {
        return false;
    }
}

