/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.nio.charset.Charset;
import simplebgc_gui.BTModule;
import simplebgc_gui.UartCmdSender;

class BTModuleRN42
implements BTModule {
    static final char delimiter = '|';
    protected UartCmdSender uartCmdSender;
    static final int[] speed2baud = new int[]{11, 57, 38, 19, 96};

    BTModuleRN42(UartCmdSender uartCmdSender) {
        this.uartCmdSender = uartCmdSender;
    }

    @Override
    public void validateName(String name) throws Exception {
        if (name.length() > 20) {
            throw new Exception("Name should be less than 20 characters long!");
        }
    }

    @Override
    public void validatePin(String pin) throws Exception {
        if (pin.length() > 20) {
            throw new Exception("PIN should be less than 20 characters long!");
        }
    }

    @Override
    public String getTitle() {
        return "RN-41, RN-42 (BlueSMiRF)";
    }

    @Override
    public void sendAtCmd(String atCmd) throws Exception {
        Thread.sleep(1000L);
        this.uartCmdSender.sendUartCmd(new String("$$$").getBytes(Charset.forName("ISO-8859-1")), 0, 0, 500);
        Thread.sleep(1000L);
        atCmd = atCmd + "\n|---\n";
        this.uartCmdSender.sendUartCmd(atCmd.getBytes(Charset.forName("ISO-8859-1")), 1, 124, 500);
    }

    @Override
    public String[] cmdFactoryDefaults() {
        return new String[]{"SF,1", "R,1"};
    }

    @Override
    public String[] cmdSetPin(String pin) {
        return new String[]{"SP," + pin};
    }

    @Override
    public String[] cmdSetName(String name) {
        return new String[]{"SN," + name};
    }

    @Override
    public String[] cmdSetOtherParams() {
        return null;
    }

    @Override
    public String[] cmdSetSpeedParity(int speed, int parity) {
        int baud = speed >= 0 && speed < speed2baud.length ? speed2baud[speed] : speed2baud[0];
        return new String[]{"SU," + baud, "SL," + (parity == 0 ? "N" : (parity == 1 ? "E" : "O"))};
    }

    @Override
    public String[] cmdReset() {
        return new String[]{"R,1"};
    }

    @Override
    public boolean needReset() {
        return true;
    }
}

