/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import java.io.Writer;
import java.util.HashSet;
import java.util.Stack;
import sbgc.utils.xml.XmlUtils;
import simplebgc_gui.CustomPrettyPrintWriterFull;

public class CustomPrettyPrintWriter
extends CustomPrettyPrintWriterFull {
    Stack<String> elements = new Stack();
    HashSet<String> allowedElements = null;
    String ignoredElement = null;

    public CustomPrettyPrintWriter(Writer out, NameCoder nameCoder, HashSet<String> allowedElements) {
        super(out, nameCoder);
        this.allowedElements = allowedElements;
    }

    @Override
    public void addAttribute(String key, String value) {
        if (this.ignoredElement == null) {
            super.addAttribute(key, value);
        }
    }

    @Override
    protected void writeAttributeValue(QuickWriter writer, String text) {
        if (this.ignoredElement == null) {
            super.writeText(writer, text);
        }
    }

    @Override
    protected void writeText(QuickWriter writer, String text) {
        if (this.ignoredElement == null) {
            super.writeText(writer, text);
        }
    }

    @Override
    public void setValue(String text) {
        super.setValue(text, this.ignoredElement == null);
    }

    @Override
    public void startNode(String name) {
        this.elements.push(this.encodeNode(name).toLowerCase());
        String elementPath = XmlUtils.getElementPathFromStack(this.elements);
        if (this.ignoredElement == null && this.allowedElements != null && !this.allowedElements.contains(elementPath.toLowerCase())) {
            this.ignoredElement = elementPath;
        }
        super.startNode(name, this.ignoredElement == null);
    }

    @Override
    public void endNode() {
        String elementPath;
        super.endNode(this.ignoredElement == null);
        if (this.ignoredElement != null && (elementPath = XmlUtils.getElementPathFromStack(this.elements)).toLowerCase().equals(this.ignoredElement)) {
            this.ignoredElement = null;
        }
        this.elements.pop();
    }
}

