/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.bode_plot.BodeResult;
import sbgc.bode_plot.ControllerOptimizer;
import sbgc.object.AutoPIDCfg2;
import sbgc.object.BoardParams;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogAutoPID2
extends MyDialog {
    AutoPIDCfg2 cfg;
    boolean isGUIMode;
    JCheckBox[] checkBoxShowResponse;
    JCheckBox[] checkBoxAxes;
    JCheckBox[] checkBoxLPF;
    JCheckBox[] checkBoxPos;
    JSpinner[] spinnerEffectiveFreq;
    JSpinner[] spinnerStimulus;
    JSpinner[] spinnerProblemFreq;
    JSpinner[] spinnerProblemMargin;
    JSpinner[] spinnerPos;
    JSlider[] sliderGain;
    JComboBox[] comboBoxNotch;
    JLabel[] labelGainDb;
    ArrayList<BodeResult> G_list = null;
    private JButton jButtonCancel;
    private JButton jButtonCancelModal;
    private JButton jButtonSave;
    private JButton jButtonSetDefaults;
    private JButton jButtonStart;
    private JButton jButtonStartModal;
    private JButton jButtonStop;
    private JCheckBox jCheckBoxAllProfiles;
    private JCheckBox jCheckBoxAllowGainVariation;
    private JCheckBox jCheckBoxAutoSave;
    private JCheckBox jCheckBoxCnew;
    private JCheckBox jCheckBoxCold;
    private JCheckBox jCheckBoxGCnew;
    private JCheckBox jCheckBoxGCold;
    private JCheckBox jCheckBoxLPFPitch;
    private JCheckBox jCheckBoxLPFRoll;
    private JCheckBox jCheckBoxLPFYaw;
    private JCheckBox jCheckBoxMultipleSystems;
    private JCheckBox jCheckBoxPitch;
    private JCheckBox jCheckBoxPos1;
    private JCheckBox jCheckBoxPos2;
    private JCheckBox jCheckBoxPos3;
    private JCheckBox jCheckBoxPos4;
    private JCheckBox jCheckBoxRoll;
    private JCheckBox jCheckBoxUseStoredResp;
    private JCheckBox jCheckBoxYaw;
    private JComboBox jComboBoxGainOnly;
    private JComboBox jComboBoxInitialValues;
    private JComboBox jComboBoxNotchPitch;
    private JComboBox jComboBoxNotchRoll;
    private JComboBox jComboBoxNotchYaw;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelAxes;
    private JLabel jLabelEffectiveFreq;
    private JLabel jLabelFrequencyRange;
    private JLabel jLabelGainOnly;
    private JLabel jLabelGainP;
    private JLabel jLabelGainR;
    private JLabel jLabelGainY;
    private JLabel jLabelInitialValues;
    private JLabel jLabelLPF;
    private JLabel jLabelNotch;
    private JLabel jLabelPitch;
    private JLabel jLabelProblemFreq;
    private JLabel jLabelProblemFreqThreshold;
    private JLabel jLabelRndSeedNum;
    private JLabel jLabelRoll;
    private JLabel jLabelShowResult;
    private JLabel jLabelStimulus;
    private JLabel jLabelTarget;
    private JLabel jLabelTargetPrecision;
    private JLabel jLabelTargetStability;
    private JLabel jLabelTestPositions;
    private JLabel jLabelYaw;
    private JPanel jPanelButtonsController;
    private JPanel jPanelButtonsModal;
    private JPanel jPanelCfg;
    private JSlider jSliderGainPitch;
    private JSlider jSliderGainRoll;
    private JSlider jSliderGainYaw;
    private JSpinner jSpinnerEffectiveFreqPitch;
    private JSpinner jSpinnerEffectiveFreqRoll;
    private JSpinner jSpinnerEffectiveFreqYaw;
    private JSpinner jSpinnerFreqFrom;
    private JSpinner jSpinnerFreqTo;
    private JSpinner jSpinnerPos1;
    private JSpinner jSpinnerPos2;
    private JSpinner jSpinnerPos3;
    private JSpinner jSpinnerPos4;
    private JSpinner jSpinnerProblemFreqPitch;
    private JSpinner jSpinnerProblemFreqRoll;
    private JSpinner jSpinnerProblemFreqYaw;
    private JSpinner jSpinnerProblemMarginPitch;
    private JSpinner jSpinnerProblemMarginRoll;
    private JSpinner jSpinnerProblemMarginYaw;
    private JSpinner jSpinnerRndSeedNum;
    private JSpinner jSpinnerStimulusPitch;
    private JSpinner jSpinnerStimulusRoll;
    private JSpinner jSpinnerStimulusYaw;

    public DialogAutoPID2(Frame parent, boolean isGUIMode) {
        super(DialogAutoPID2.class, parent, SimpleBGC_GUIApp.getResourceMap(DialogAutoPID2.class).getString("Form.title", new Object[0]));
        this.initComponents();
        this.jPanelButtonsController.setVisible(false);
        this.jPanelButtonsModal.setVisible(false);
        this.isGUIMode = isGUIMode;
        this.checkBoxShowResponse = new JCheckBox[]{this.jCheckBoxGCnew, this.jCheckBoxGCold, this.jCheckBoxCnew, this.jCheckBoxCold};
        this.checkBoxAxes = new JCheckBox[]{this.jCheckBoxRoll, this.jCheckBoxPitch, this.jCheckBoxYaw};
        this.checkBoxLPF = new JCheckBox[]{this.jCheckBoxLPFRoll, this.jCheckBoxLPFPitch, this.jCheckBoxLPFYaw};
        this.spinnerEffectiveFreq = new JSpinner[]{this.jSpinnerEffectiveFreqRoll, this.jSpinnerEffectiveFreqPitch, this.jSpinnerEffectiveFreqYaw};
        this.spinnerStimulus = new JSpinner[]{this.jSpinnerStimulusRoll, this.jSpinnerStimulusPitch, this.jSpinnerStimulusYaw};
        this.spinnerProblemFreq = new JSpinner[]{this.jSpinnerProblemFreqRoll, this.jSpinnerProblemFreqPitch, this.jSpinnerProblemFreqYaw};
        this.spinnerProblemMargin = new JSpinner[]{this.jSpinnerProblemMarginRoll, this.jSpinnerProblemMarginPitch, this.jSpinnerProblemMarginYaw};
        this.sliderGain = new JSlider[]{this.jSliderGainRoll, this.jSliderGainPitch, this.jSliderGainYaw};
        this.comboBoxNotch = new JComboBox[]{this.jComboBoxNotchRoll, this.jComboBoxNotchPitch, this.jComboBoxNotchYaw};
        this.checkBoxPos = new JCheckBox[]{this.jCheckBoxPos1, this.jCheckBoxPos2, this.jCheckBoxPos3, this.jCheckBoxPos4};
        this.spinnerPos = new JSpinner[]{this.jSpinnerPos1, this.jSpinnerPos2, this.jSpinnerPos3, this.jSpinnerPos4};
        this.labelGainDb = new JLabel[]{this.jLabelGainR, this.jLabelGainP, this.jLabelGainY};
        this.cfg = new AutoPIDCfg2(isGUIMode);
        if (this.isGUIMode) {
            this.cfg.loadFromSettings();
            this.jPanelButtonsModal.setVisible(true);
            this.getRootPane().setDefaultButton(this.jButtonStartModal);
            for (int axis = 0; axis < 3; ++axis) {
                this.sliderGain[axis].setMaximum(400);
                final int for_axis = axis;
                final Color defaultTextColor = this.jLabelGainR.getForeground();
                this.sliderGain[axis].addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        float gain_dB = ControllerOptimizer.targetGain2dB(DialogAutoPID2.this.sliderGain[for_axis].getValue());
                        DialogAutoPID2.this.labelGainDb[for_axis].setText(String.format("+%.1f dB", Float.valueOf(gain_dB)).toString());
                        DialogAutoPID2.this.labelGainDb[for_axis].setForeground(gain_dB > 10.0f ? Color.YELLOW : defaultTextColor);
                    }
                });
            }
        } else {
            this.jPanelButtonsController.setVisible(true);
            this.getRootPane().setDefaultButton(this.jButtonStart);
        }
        this.jCheckBoxUseStoredResp.setVisible(SimpleBGC_GUIApp.debugMode);
        for (JSpinner s : this.spinnerPos) {
            s.setModel(new SpinnerNumberModel(0, -360, 360, 3));
        }
        this.pack();
        this.updateParams(BoardParams.getCurParams());
    }

    public AutoPIDCfg2 getCurrentConfig() {
        return this.cfg;
    }

    public void setTestData(ArrayList<BodeResult> G_list) {
        this.G_list = G_list;
    }

    public void setActiveAxis(int activeAxis) {
        for (int axis = 0; axis < 3; ++axis) {
            boolean active = axis == activeAxis;
            this.checkBoxAxes[axis].setSelected(active);
            this.checkBoxLPF[axis].setEnabled(active);
            this.spinnerEffectiveFreq[axis].setEnabled(active);
            this.spinnerStimulus[axis].setEnabled(active);
            this.spinnerProblemFreq[axis].setEnabled(active);
            this.spinnerProblemMargin[axis].setEnabled(active);
            this.sliderGain[axis].setEnabled(active);
            this.comboBoxNotch[axis].setEnabled(active);
        }
    }

    public void updateBoardParams(BoardParams params) {
        if (params != null && params.auto_pid_cfg2 != null) {
            this.cfg = params.auto_pid_cfg2.clone();
            this.updateParams(params);
        }
    }

    private void updateParams(BoardParams params) {
        try {
            int i;
            for (int axis = 0; axis < 3; ++axis) {
                this.checkBoxAxes[axis].setSelected(this.cfg.isAxisSelected(axis));
                this.checkBoxLPF[axis].setSelected((this.cfg.axis_flags[axis] & 2) > 0);
                this.spinnerEffectiveFreq[axis].setValue(this.cfg.effective_freq[axis]);
                this.spinnerStimulus[axis].setValue(this.cfg.stimulus_gain[axis]);
                this.spinnerProblemFreq[axis].setValue(this.cfg.problem_freq[axis]);
                this.spinnerProblemMargin[axis].setValue(Float.valueOf(this.cfg.problem_margin[axis]));
                this.sliderGain[axis].setValue(this.cfg.gain[axis]);
                this.comboBoxNotch[axis].setSelectedIndex(this.cfg.getNotchTunedNum(axis));
            }
            this.jComboBoxInitialValues.setSelectedIndex(this.cfg.isStartFromCurrent() ? 1 : 0);
            this.jCheckBoxAllProfiles.setSelected(this.cfg.isAllProfiles());
            this.jComboBoxGainOnly.setSelectedIndex(this.cfg.isGainOnly() ? 1 : 0);
            this.jCheckBoxAutoSave.setSelected(this.cfg.isAutoSave());
            this.jCheckBoxMultipleSystems.setSelected(this.cfg.multiple_systems);
            this.jCheckBoxAllowGainVariation.setSelected(this.cfg.allow_gain_variation);
            for (i = 0; i < this.checkBoxShowResponse.length; ++i) {
                this.checkBoxShowResponse[i].setSelected((this.cfg.show_response & 1 << i) != 0);
            }
            this.jSpinnerFreqFrom.setValue(Float.valueOf(this.cfg.freqFrom));
            this.jSpinnerFreqTo.setValue(Float.valueOf(this.cfg.freqTo));
            this.jSpinnerRndSeedNum.setValue(this.cfg.rnd_seed_num);
            if (this.isGUIMode) {
                // empty if block
            }
            this.jCheckBoxUseStoredResp.setSelected(this.cfg.isUseStoredResp());
            for (i = 0; i < this.cfg.mult_pos_angles.length; ++i) {
                this.checkBoxPos[i].setSelected((this.cfg.mult_pos_enabled & 1 << i) != 0);
                this.spinnerPos[i].setValue(this.cfg.mult_pos_angles[i] * 3);
            }
        }
        catch (Exception e) {
            this.logger.stackTrace(e);
        }
    }

    private void applyParams() {
        BoardParams params = BoardParams.getCurParams();
        for (int axis = 0; axis < 3; ++axis) {
            this.cfg.axis_flags[axis] = 0;
            this.cfg.axis_flags[axis] = BoardParams.updateBit(this.cfg.axis_flags[axis], 1, this.checkBoxAxes[axis].isSelected());
            this.cfg.axis_flags[axis] = BoardParams.updateBit(this.cfg.axis_flags[axis], 2, this.checkBoxLPF[axis].isSelected());
            this.cfg.gain[axis] = this.sliderGain[axis].getValue();
            this.cfg.stimulus_gain[axis] = ((Number)this.spinnerStimulus[axis].getValue()).intValue();
            this.cfg.effective_freq[axis] = ((Number)this.spinnerEffectiveFreq[axis].getValue()).intValue();
            this.cfg.problem_freq[axis] = ((Number)this.spinnerProblemFreq[axis].getValue()).intValue();
            this.cfg.problem_margin[axis] = ((Number)this.spinnerProblemMargin[axis].getValue()).floatValue();
            this.cfg.setNotchNum(axis, this.comboBoxNotch[axis].getSelectedIndex());
        }
        this.cfg.general_flags = 0;
        this.cfg.general_flags = BoardParams.updateBit(this.cfg.general_flags, 1, this.jComboBoxInitialValues.getSelectedIndex() == 1);
        this.cfg.general_flags = BoardParams.updateBit(this.cfg.general_flags, 2, this.jCheckBoxAllProfiles.isSelected());
        this.cfg.general_flags = BoardParams.updateBit(this.cfg.general_flags, 4, this.jComboBoxGainOnly.getSelectedIndex() == 1);
        this.cfg.general_flags = BoardParams.updateBit(this.cfg.general_flags, 16, this.jCheckBoxAutoSave.isSelected());
        this.cfg.general_flags = BoardParams.updateBit(this.cfg.general_flags, 8, this.jCheckBoxUseStoredResp.isSelected());
        this.cfg.multiple_systems = this.jCheckBoxMultipleSystems.isSelected();
        this.cfg.allow_gain_variation = this.jCheckBoxAllowGainVariation.isSelected();
        this.cfg.show_response = 0;
        for (int i = 0; i < this.checkBoxShowResponse.length; ++i) {
            if (!this.checkBoxShowResponse[i].isSelected()) continue;
            this.cfg.show_response |= 1 << i;
        }
        this.cfg.freqFrom = ((Number)this.jSpinnerFreqFrom.getValue()).floatValue();
        this.cfg.freqTo = ((Number)this.jSpinnerFreqTo.getValue()).floatValue();
        int rnd_seed_num_prev = this.cfg.rnd_seed_num;
        this.cfg.rnd_seed_num = ((Number)this.jSpinnerRndSeedNum.getValue()).intValue();
        if (this.isGUIMode) {
            this.cfg.saveToSettings();
        } else if (rnd_seed_num_prev != this.cfg.rnd_seed_num && this.jSpinnerRndSeedNum.isEnabled() && this.cfg.rnd_seed_num >= 30) {
            SimpleBGC_GUIApp.mainView.showWarningMessage(this.resourceMap.getString("warning.rnd_seed_num_too_big", this.cfg.rnd_seed_num));
        }
        this.cfg.mult_pos_enabled = 0;
        for (int i = 0; i < this.cfg.mult_pos_angles.length; ++i) {
            if (this.checkBoxPos[i].isSelected()) {
                this.cfg.mult_pos_enabled |= 1 << i;
            }
            this.cfg.mult_pos_angles[i] = ((Number)this.spinnerPos[i].getValue()).intValue() / 3;
        }
    }

    private String checkConfigErrors() {
        StringBuilder errors = new StringBuilder();
        boolean hasActiveAxis = false;
        for (int axis = 0; axis < 3; ++axis) {
            if ((this.cfg.axis_flags[axis] & 1) == 0) continue;
            hasActiveAxis = true;
        }
        if (!hasActiveAxis) {
            errors.append("Select at least one axis for tuning.\n");
        }
        if (this.cfg.freqFrom == 0.0f || this.cfg.freqFrom >= this.cfg.freqTo) {
            errors.append("Set the correct frequency range.\n");
        }
        return errors.length() > 0 ? errors.toString() : null;
    }

    @Override
    public void onCloseDialog() {
    }

    private void initComponents() {
        this.jPanelCfg = new JPanel();
        this.jLabelTarget = new JLabel();
        this.jLabelRoll = new JLabel();
        this.jSliderGainRoll = new JSlider();
        this.jLabelPitch = new JLabel();
        this.jSliderGainPitch = new JSlider();
        this.jLabelYaw = new JLabel();
        this.jSliderGainYaw = new JSlider();
        this.jLabelTargetStability = new JLabel();
        this.jLabelTargetPrecision = new JLabel();
        this.jLabelFrequencyRange = new JLabel();
        this.jSpinnerFreqFrom = new JSpinner();
        this.jSpinnerFreqTo = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabelAxes = new JLabel();
        this.jCheckBoxRoll = new JCheckBox();
        this.jCheckBoxPitch = new JCheckBox();
        this.jCheckBoxYaw = new JCheckBox();
        this.jLabelEffectiveFreq = new JLabel();
        this.jSpinnerEffectiveFreqRoll = new JSpinner();
        this.jSpinnerEffectiveFreqPitch = new JSpinner();
        this.jSpinnerEffectiveFreqYaw = new JSpinner();
        this.jLabelProblemFreq = new JLabel();
        this.jSpinnerProblemFreqRoll = new JSpinner();
        this.jSpinnerProblemFreqPitch = new JSpinner();
        this.jSpinnerProblemFreqYaw = new JSpinner();
        this.jLabelProblemFreqThreshold = new JLabel();
        this.jSpinnerProblemMarginRoll = new JSpinner();
        this.jSpinnerProblemMarginPitch = new JSpinner();
        this.jSpinnerProblemMarginYaw = new JSpinner();
        this.jLabelLPF = new JLabel();
        this.jCheckBoxLPFRoll = new JCheckBox();
        this.jCheckBoxLPFPitch = new JCheckBox();
        this.jCheckBoxLPFYaw = new JCheckBox();
        this.jLabelGainOnly = new JLabel();
        this.jComboBoxGainOnly = new JComboBox();
        this.jLabelInitialValues = new JLabel();
        this.jComboBoxInitialValues = new JComboBox();
        this.jButtonSetDefaults = new JButton();
        this.jLabelNotch = new JLabel();
        this.jComboBoxNotchRoll = new JComboBox();
        this.jComboBoxNotchYaw = new JComboBox();
        this.jComboBoxNotchPitch = new JComboBox();
        this.jLabelRndSeedNum = new JLabel();
        this.jSpinnerRndSeedNum = new JSpinner();
        this.jLabelGainY = new JLabel();
        this.jLabelGainR = new JLabel();
        this.jLabelGainP = new JLabel();
        this.jPanelButtonsController = new JPanel();
        this.jLabelStimulus = new JLabel();
        this.jSpinnerStimulusRoll = new JSpinner();
        this.jSpinnerStimulusPitch = new JSpinner();
        this.jSpinnerStimulusYaw = new JSpinner();
        this.jLabelTestPositions = new JLabel();
        this.jCheckBoxAllProfiles = new JCheckBox();
        this.jCheckBoxUseStoredResp = new JCheckBox();
        this.jButtonSave = new JButton();
        this.jCheckBoxAutoSave = new JCheckBox();
        this.jButtonStart = new JButton();
        this.jButtonStop = new JButton();
        this.jButtonCancel = new JButton();
        this.jSpinnerPos1 = new JSpinner();
        this.jCheckBoxPos1 = new JCheckBox();
        this.jCheckBoxPos2 = new JCheckBox();
        this.jSpinnerPos2 = new JSpinner();
        this.jCheckBoxPos3 = new JCheckBox();
        this.jSpinnerPos3 = new JSpinner();
        this.jCheckBoxPos4 = new JCheckBox();
        this.jSpinnerPos4 = new JSpinner();
        this.jPanelButtonsModal = new JPanel();
        this.jCheckBoxMultipleSystems = new JCheckBox();
        this.jCheckBoxAllowGainVariation = new JCheckBox();
        this.jLabelShowResult = new JLabel();
        this.jCheckBoxGCnew = new JCheckBox();
        this.jCheckBoxGCold = new JCheckBox();
        this.jCheckBoxCnew = new JCheckBox();
        this.jCheckBoxCold = new JCheckBox();
        this.jButtonStartModal = new JButton();
        this.jButtonCancelModal = new JButton();
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogAutoPID2.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(420, 280));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanelCfg.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelCfg.border.title", new Object[0])));
        this.jPanelCfg.setName("jPanelCfg");
        this.jPanelCfg.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelTarget.setText(resourceMap.getString("jLabelTarget.text", new Object[0]));
        this.jLabelTarget.setName("jLabelTarget");
        this.jPanelCfg.add((Component)this.jLabelTarget, new AbsoluteConstraints(20, 20, -1, -1));
        this.jLabelRoll.setText(resourceMap.getString("jLabelRoll.text", new Object[0]));
        this.jLabelRoll.setName("jLabelRoll");
        this.jPanelCfg.add((Component)this.jLabelRoll, new AbsoluteConstraints(40, 40, -1, -1));
        this.jSliderGainRoll.setMaximum(255);
        this.jSliderGainRoll.setValue(127);
        this.jSliderGainRoll.setName("jSliderGainRoll");
        this.jPanelCfg.add((Component)this.jSliderGainRoll, new AbsoluteConstraints(90, 40, 290, -1));
        this.jLabelPitch.setText(resourceMap.getString("jLabelPitch.text", new Object[0]));
        this.jLabelPitch.setName("jLabelPitch");
        this.jPanelCfg.add((Component)this.jLabelPitch, new AbsoluteConstraints(40, 70, -1, -1));
        this.jSliderGainPitch.setMaximum(255);
        this.jSliderGainPitch.setValue(127);
        this.jSliderGainPitch.setName("jSliderGainPitch");
        this.jPanelCfg.add((Component)this.jSliderGainPitch, new AbsoluteConstraints(90, 70, 290, -1));
        this.jLabelYaw.setText(resourceMap.getString("jLabelYaw.text", new Object[0]));
        this.jLabelYaw.setName("jLabelYaw");
        this.jPanelCfg.add((Component)this.jLabelYaw, new AbsoluteConstraints(40, 100, -1, -1));
        this.jSliderGainYaw.setMaximum(255);
        this.jSliderGainYaw.setValue(127);
        this.jSliderGainYaw.setName("jSliderGainYaw");
        this.jPanelCfg.add((Component)this.jSliderGainYaw, new AbsoluteConstraints(90, 100, 290, -1));
        this.jLabelTargetStability.setHorizontalAlignment(2);
        this.jLabelTargetStability.setText(resourceMap.getString("jLabelTargetStability.text", new Object[0]));
        this.jLabelTargetStability.setName("jLabelTargetStability");
        this.jPanelCfg.add((Component)this.jLabelTargetStability, new AbsoluteConstraints(90, 120, 150, -1));
        this.jLabelTargetPrecision.setHorizontalAlignment(4);
        this.jLabelTargetPrecision.setText(resourceMap.getString("jLabelTargetPrecision.text", new Object[0]));
        this.jLabelTargetPrecision.setName("jLabelTargetPrecision");
        this.jPanelCfg.add((Component)this.jLabelTargetPrecision, new AbsoluteConstraints(250, 120, 160, -1));
        this.jLabelFrequencyRange.setText(resourceMap.getString("jLabelFrequencyRange.text", new Object[0]));
        this.jLabelFrequencyRange.setToolTipText(resourceMap.getString("jSpinnerFreqFrom.toolTipText", new Object[0]));
        this.jLabelFrequencyRange.setName("jLabelFrequencyRange");
        this.jPanelCfg.add((Component)this.jLabelFrequencyRange, new AbsoluteConstraints(30, 150, 140, -1));
        this.jSpinnerFreqFrom.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(25.5f), Float.valueOf(0.1f)));
        this.jSpinnerFreqFrom.setToolTipText(resourceMap.getString("jSpinnerFreqFrom.toolTipText", new Object[0]));
        this.jSpinnerFreqFrom.setName("jSpinnerFreqFrom");
        this.jPanelCfg.add((Component)this.jSpinnerFreqFrom, new AbsoluteConstraints(180, 150, 60, -1));
        this.jSpinnerFreqTo.setModel(new SpinnerNumberModel(30, 30, 500, 2));
        this.jSpinnerFreqTo.setToolTipText(resourceMap.getString("jSpinnerFreqFrom.toolTipText", new Object[0]));
        this.jSpinnerFreqTo.setName("jSpinnerFreqTo");
        this.jPanelCfg.add((Component)this.jSpinnerFreqTo, new AbsoluteConstraints(270, 150, 60, -1));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jPanelCfg.add((Component)this.jLabel1, new AbsoluteConstraints(240, 150, 30, -1));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jPanelCfg.add((Component)this.jLabel2, new AbsoluteConstraints(340, 150, -1, -1));
        this.jLabelAxes.setText(resourceMap.getString("jLabelAxes.text", new Object[0]));
        this.jLabelAxes.setName("jLabelAxes");
        this.jPanelCfg.add((Component)this.jLabelAxes, new AbsoluteConstraints(30, 180, -1, -1));
        this.jCheckBoxRoll.setSelected(true);
        this.jCheckBoxRoll.setText(resourceMap.getString("labelRoll.text", new Object[0]));
        this.jCheckBoxRoll.setName("jCheckBoxRoll");
        this.jPanelCfg.add((Component)this.jCheckBoxRoll, new AbsoluteConstraints(220, 180, -1, -1));
        this.jCheckBoxPitch.setSelected(true);
        this.jCheckBoxPitch.setText(resourceMap.getString("labelPitch.text", new Object[0]));
        this.jCheckBoxPitch.setName("jCheckBoxPitch");
        this.jPanelCfg.add((Component)this.jCheckBoxPitch, new AbsoluteConstraints(300, 180, -1, -1));
        this.jCheckBoxYaw.setSelected(true);
        this.jCheckBoxYaw.setText(resourceMap.getString("labelYaw.text", new Object[0]));
        this.jCheckBoxYaw.setName("jCheckBoxYaw");
        this.jPanelCfg.add((Component)this.jCheckBoxYaw, new AbsoluteConstraints(380, 180, -1, -1));
        this.jLabelEffectiveFreq.setText(resourceMap.getString("jLabelEffectiveFreq.text", new Object[0]));
        this.jLabelEffectiveFreq.setName("jLabelEffectiveFreq");
        this.jPanelCfg.add((Component)this.jLabelEffectiveFreq, new AbsoluteConstraints(30, 210, -1, -1));
        this.jSpinnerEffectiveFreqRoll.setModel(new SpinnerNumberModel(5, 5, 50, 1));
        this.jSpinnerEffectiveFreqRoll.setName("jSpinnerEffectiveFreqRoll");
        this.jPanelCfg.add((Component)this.jSpinnerEffectiveFreqRoll, new AbsoluteConstraints(220, 210, 60, -1));
        this.jSpinnerEffectiveFreqPitch.setModel(new SpinnerNumberModel(5, 5, 50, 1));
        this.jSpinnerEffectiveFreqPitch.setName("jSpinnerEffectiveFreqPitch");
        this.jPanelCfg.add((Component)this.jSpinnerEffectiveFreqPitch, new AbsoluteConstraints(300, 210, 60, -1));
        this.jSpinnerEffectiveFreqYaw.setModel(new SpinnerNumberModel(5, 5, 50, 1));
        this.jSpinnerEffectiveFreqYaw.setName("jSpinnerEffectiveFreqYaw");
        this.jPanelCfg.add((Component)this.jSpinnerEffectiveFreqYaw, new AbsoluteConstraints(380, 210, 60, -1));
        this.jLabelProblemFreq.setText(resourceMap.getString("jLabelProblemFreq.text", new Object[0]));
        this.jLabelProblemFreq.setName("jLabelProblemFreq");
        this.jPanelCfg.add((Component)this.jLabelProblemFreq, new AbsoluteConstraints(30, 240, -1, -1));
        this.jSpinnerProblemFreqRoll.setModel(new SpinnerNumberModel(5, 5, 255, 1));
        this.jSpinnerProblemFreqRoll.setName("jSpinnerProblemFreqRoll");
        this.jPanelCfg.add((Component)this.jSpinnerProblemFreqRoll, new AbsoluteConstraints(220, 240, 60, -1));
        this.jSpinnerProblemFreqPitch.setModel(new SpinnerNumberModel(5, 5, 255, 1));
        this.jSpinnerProblemFreqPitch.setName("jSpinnerProblemFreqPitch");
        this.jPanelCfg.add((Component)this.jSpinnerProblemFreqPitch, new AbsoluteConstraints(300, 240, 60, -1));
        this.jSpinnerProblemFreqYaw.setModel(new SpinnerNumberModel(5, 5, 255, 1));
        this.jSpinnerProblemFreqYaw.setName("jSpinnerProblemFreqYaw");
        this.jPanelCfg.add((Component)this.jSpinnerProblemFreqYaw, new AbsoluteConstraints(380, 240, 60, -1));
        this.jLabelProblemFreqThreshold.setText(resourceMap.getString("jLabelProblemFreqThreshold.text", new Object[0]));
        this.jLabelProblemFreqThreshold.setName("jLabelProblemFreqThreshold");
        this.jPanelCfg.add((Component)this.jLabelProblemFreqThreshold, new AbsoluteConstraints(30, 270, -1, -1));
        this.jSpinnerProblemMarginRoll.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(25.5f), Float.valueOf(0.1f)));
        this.jSpinnerProblemMarginRoll.setName("jSpinnerProblemMarginRoll");
        this.jPanelCfg.add((Component)this.jSpinnerProblemMarginRoll, new AbsoluteConstraints(220, 270, 60, -1));
        this.jSpinnerProblemMarginPitch.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(25.5f), Float.valueOf(0.1f)));
        this.jSpinnerProblemMarginPitch.setName("jSpinnerProblemMarginPitch");
        this.jPanelCfg.add((Component)this.jSpinnerProblemMarginPitch, new AbsoluteConstraints(300, 270, 60, -1));
        this.jSpinnerProblemMarginYaw.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(25.5f), Float.valueOf(0.1f)));
        this.jSpinnerProblemMarginYaw.setName("jSpinnerProblemMarginYaw");
        this.jPanelCfg.add((Component)this.jSpinnerProblemMarginYaw, new AbsoluteConstraints(380, 270, 60, -1));
        this.jLabelLPF.setText(resourceMap.getString("jLabelLPF.text", new Object[0]));
        this.jLabelLPF.setName("jLabelLPF");
        this.jPanelCfg.add((Component)this.jLabelLPF, new AbsoluteConstraints(30, 300, -1, -1));
        this.jCheckBoxLPFRoll.setName("jCheckBoxLPFRoll");
        this.jPanelCfg.add((Component)this.jCheckBoxLPFRoll, new AbsoluteConstraints(220, 300, -1, -1));
        this.jCheckBoxLPFPitch.setName("jCheckBoxLPFPitch");
        this.jPanelCfg.add((Component)this.jCheckBoxLPFPitch, new AbsoluteConstraints(300, 300, -1, -1));
        this.jCheckBoxLPFYaw.setText(resourceMap.getString("jCheckBoxLPFYaw.text", new Object[0]));
        this.jCheckBoxLPFYaw.setName("jCheckBoxLPFYaw");
        this.jPanelCfg.add((Component)this.jCheckBoxLPFYaw, new AbsoluteConstraints(380, 300, -1, -1));
        this.jLabelGainOnly.setText(resourceMap.getString("jLabelGainOnly.text", new Object[0]));
        this.jLabelGainOnly.setName("jLabelGainOnly");
        this.jPanelCfg.add((Component)this.jLabelGainOnly, new AbsoluteConstraints(30, 360, -1, -1));
        this.jComboBoxGainOnly.setModel(new DefaultComboBoxModel<String>(new String[]{"All parameters (slower)", "Only the gain (faster)"}));
        this.jComboBoxGainOnly.setName("jComboBoxGainOnly");
        this.jPanelCfg.add((Component)this.jComboBoxGainOnly, new AbsoluteConstraints(220, 360, 230, -1));
        this.jLabelInitialValues.setText(resourceMap.getString("jLabelInitialValues.text", new Object[0]));
        this.jLabelInitialValues.setName("jLabelInitialValues");
        this.jPanelCfg.add((Component)this.jLabelInitialValues, new AbsoluteConstraints(30, 390, -1, -1));
        this.jComboBoxInitialValues.setModel(new DefaultComboBoxModel<String>(new String[]{"Start from zero (slower)", "Start from current values (faster)"}));
        this.jComboBoxInitialValues.setName("jComboBoxInitialValues");
        this.jComboBoxInitialValues.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogAutoPID2.this.jComboBoxInitialValuesItemStateChanged(evt);
            }
        });
        this.jPanelCfg.add((Component)this.jComboBoxInitialValues, new AbsoluteConstraints(220, 390, 230, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogAutoPID2.class, this);
        this.jButtonSetDefaults.setAction(actionMap.get("buttonResetToDefaults"));
        this.jButtonSetDefaults.setText(resourceMap.getString("jButtonSetDefaults.text", new Object[0]));
        this.jButtonSetDefaults.setName("jButtonSetDefaults");
        this.jPanelCfg.add((Component)this.jButtonSetDefaults, new AbsoluteConstraints(30, 450, 150, -1));
        this.jLabelNotch.setText(resourceMap.getString("jLabelNotch.text", new Object[0]));
        this.jLabelNotch.setName("jLabelNotch");
        this.jPanelCfg.add((Component)this.jLabelNotch, new AbsoluteConstraints(30, 330, -1, -1));
        this.jComboBoxNotchRoll.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "1", "2", "3"}));
        this.jComboBoxNotchRoll.setName("jComboBoxNotchRoll");
        this.jPanelCfg.add((Component)this.jComboBoxNotchRoll, new AbsoluteConstraints(220, 330, 60, -1));
        this.jComboBoxNotchYaw.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "1", "2", "3"}));
        this.jComboBoxNotchYaw.setName("jComboBoxNotchYaw");
        this.jPanelCfg.add((Component)this.jComboBoxNotchYaw, new AbsoluteConstraints(380, 330, 60, -1));
        this.jComboBoxNotchPitch.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "1", "2", "3"}));
        this.jComboBoxNotchPitch.setName("jComboBoxNotchPitch");
        this.jPanelCfg.add((Component)this.jComboBoxNotchPitch, new AbsoluteConstraints(300, 330, 60, -1));
        this.jLabelRndSeedNum.setText(resourceMap.getString("jLabelRndSeedNum.text", new Object[0]));
        this.jLabelRndSeedNum.setName("jLabelRndSeedNum");
        this.jPanelCfg.add((Component)this.jLabelRndSeedNum, new AbsoluteConstraints(30, 420, -1, -1));
        this.jSpinnerRndSeedNum.setModel(new SpinnerNumberModel(0, 0, 1000, 5));
        this.jSpinnerRndSeedNum.setToolTipText(resourceMap.getString("jSpinnerRndSeedNum.toolTipText", new Object[0]));
        this.jSpinnerRndSeedNum.setName("jSpinnerRndSeedNum");
        this.jPanelCfg.add((Component)this.jSpinnerRndSeedNum, new AbsoluteConstraints(220, 420, 60, -1));
        this.jLabelGainY.setText(resourceMap.getString("jLabelGainY.text", new Object[0]));
        this.jLabelGainY.setName("jLabelGainY");
        this.jPanelCfg.add((Component)this.jLabelGainY, new AbsoluteConstraints(390, 100, 60, -1));
        this.jLabelGainR.setText(resourceMap.getString("jLabelGainR.text", new Object[0]));
        this.jLabelGainR.setName("jLabelGainR");
        this.jPanelCfg.add((Component)this.jLabelGainR, new AbsoluteConstraints(390, 40, 60, -1));
        this.jLabelGainP.setText(resourceMap.getString("jLabelGainP.text", new Object[0]));
        this.jLabelGainP.setName("jLabelGainP");
        this.jPanelCfg.add((Component)this.jLabelGainP, new AbsoluteConstraints(390, 70, 60, -1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jPanelCfg, gridBagConstraints);
        this.jPanelButtonsController.setName("jPanelButtonsController");
        this.jPanelButtonsController.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelStimulus.setText(resourceMap.getString("jLabelStimulus.text", new Object[0]));
        this.jLabelStimulus.setName("jLabelStimulus");
        this.jPanelButtonsController.add((Component)this.jLabelStimulus, new AbsoluteConstraints(20, 20, -1, -1));
        this.jSpinnerStimulusRoll.setModel(new SpinnerNumberModel(1000, 0, 65535, 10));
        this.jSpinnerStimulusRoll.setName("jSpinnerStimulusRoll");
        this.jPanelButtonsController.add((Component)this.jSpinnerStimulusRoll, new AbsoluteConstraints(210, 20, 60, -1));
        this.jSpinnerStimulusPitch.setModel(new SpinnerNumberModel(1000, 0, 65535, 10));
        this.jSpinnerStimulusPitch.setName("jSpinnerStimulusPitch");
        this.jPanelButtonsController.add((Component)this.jSpinnerStimulusPitch, new AbsoluteConstraints(290, 20, 60, -1));
        this.jSpinnerStimulusYaw.setModel(new SpinnerNumberModel(1000, 0, 65535, 10));
        this.jSpinnerStimulusYaw.setName("jSpinnerStimulusYaw");
        this.jPanelButtonsController.add((Component)this.jSpinnerStimulusYaw, new AbsoluteConstraints(370, 20, 60, -1));
        this.jLabelTestPositions.setText(resourceMap.getString("jLabelTestPositions.text", new Object[0]));
        this.jLabelTestPositions.setName("jLabelTestPositions");
        this.jPanelButtonsController.add((Component)this.jLabelTestPositions, new AbsoluteConstraints(20, 80, -1, -1));
        this.jCheckBoxAllProfiles.setText(resourceMap.getString("jCheckBoxAllProfiles.text", new Object[0]));
        this.jCheckBoxAllProfiles.setName("jCheckBoxAllProfiles");
        this.jPanelButtonsController.add((Component)this.jCheckBoxAllProfiles, new AbsoluteConstraints(20, 130, 300, -1));
        this.jCheckBoxUseStoredResp.setText(resourceMap.getString("jCheckBoxUseStoredResp.text", new Object[0]));
        this.jCheckBoxUseStoredResp.setName("jCheckBoxUseStoredResp");
        this.jPanelButtonsController.add((Component)this.jCheckBoxUseStoredResp, new AbsoluteConstraints(320, 130, 130, -1));
        this.jButtonSave.setAction(actionMap.get("buttonSave"));
        this.jButtonSave.setText(resourceMap.getString("jButtonSave.text", new Object[0]));
        this.jButtonSave.setName("jButtonSave");
        this.jPanelButtonsController.add((Component)this.jButtonSave, new AbsoluteConstraints(20, 160, 250, -1));
        this.jCheckBoxAutoSave.setText(resourceMap.getString("jCheckBoxAutoSave.text", new Object[0]));
        this.jCheckBoxAutoSave.setName("jCheckBoxAutoSave");
        this.jPanelButtonsController.add((Component)this.jCheckBoxAutoSave, new AbsoluteConstraints(280, 160, -1, -1));
        this.jButtonStart.setAction(actionMap.get("buttonStart"));
        this.jButtonStart.setFont(this.jButtonStart.getFont().deriveFont(this.jButtonStart.getFont().getStyle() | 1));
        this.jButtonStart.setText(resourceMap.getString("jButtonStart.text", new Object[0]));
        this.jButtonStart.setName("jButtonStart");
        this.jPanelButtonsController.add((Component)this.jButtonStart, new AbsoluteConstraints(60, 190, 120, -1));
        this.jButtonStop.setAction(actionMap.get("buttonStop"));
        this.jButtonStop.setText(resourceMap.getString("jButtonStop.text", new Object[0]));
        this.jButtonStop.setName("jButtonStop");
        this.jPanelButtonsController.add((Component)this.jButtonStop, new AbsoluteConstraints(190, 190, 120, -1));
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.jPanelButtonsController.add((Component)this.jButtonCancel, new AbsoluteConstraints(320, 190, 120, -1));
        this.jSpinnerPos1.setName("jSpinnerPos1");
        this.jPanelButtonsController.add((Component)this.jSpinnerPos1, new AbsoluteConstraints(45, 100, 60, -1));
        this.jCheckBoxPos1.setName("jCheckBoxPos1");
        this.jPanelButtonsController.add((Component)this.jCheckBoxPos1, new AbsoluteConstraints(20, 100, -1, -1));
        this.jCheckBoxPos2.setName("jCheckBoxPos2");
        this.jPanelButtonsController.add((Component)this.jCheckBoxPos2, new AbsoluteConstraints(140, 100, -1, -1));
        this.jSpinnerPos2.setName("jSpinnerPos2");
        this.jPanelButtonsController.add((Component)this.jSpinnerPos2, new AbsoluteConstraints(165, 100, 60, -1));
        this.jCheckBoxPos3.setName("jCheckBoxPos3");
        this.jPanelButtonsController.add((Component)this.jCheckBoxPos3, new AbsoluteConstraints(250, 100, -1, -1));
        this.jSpinnerPos3.setName("jSpinnerPos3");
        this.jPanelButtonsController.add((Component)this.jSpinnerPos3, new AbsoluteConstraints(275, 100, 60, -1));
        this.jCheckBoxPos4.setName("jCheckBoxPos4");
        this.jPanelButtonsController.add((Component)this.jCheckBoxPos4, new AbsoluteConstraints(360, 100, -1, -1));
        this.jSpinnerPos4.setName("jSpinnerPos4");
        this.jPanelButtonsController.add((Component)this.jSpinnerPos4, new AbsoluteConstraints(385, 100, 60, -1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        this.getContentPane().add((Component)this.jPanelButtonsController, gridBagConstraints);
        this.jPanelButtonsModal.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanelButtonsModal.setName("jPanelButtonsModal");
        this.jPanelButtonsModal.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxMultipleSystems.setText(resourceMap.getString("jCheckBoxMultipleSystems.text", new Object[0]));
        this.jCheckBoxMultipleSystems.setName("jCheckBoxMultipleSystems");
        this.jPanelButtonsModal.add((Component)this.jCheckBoxMultipleSystems, new AbsoluteConstraints(20, 10, -1, -1));
        this.jCheckBoxAllowGainVariation.setText(resourceMap.getString("jCheckBoxAllowGainVariation.text", new Object[0]));
        this.jCheckBoxAllowGainVariation.setName("jCheckBoxAllowGainVariation");
        this.jPanelButtonsModal.add((Component)this.jCheckBoxAllowGainVariation, new AbsoluteConstraints(50, 30, -1, -1));
        this.jLabelShowResult.setText(resourceMap.getString("jLabelShowResult.text", new Object[0]));
        this.jLabelShowResult.setName("jLabelShowResult");
        this.jPanelButtonsModal.add((Component)this.jLabelShowResult, new AbsoluteConstraints(20, 70, -1, -1));
        this.jCheckBoxGCnew.setText(resourceMap.getString("jCheckBoxGCnew.text", new Object[0]));
        this.jCheckBoxGCnew.setName("jCheckBoxGCnew");
        this.jPanelButtonsModal.add((Component)this.jCheckBoxGCnew, new AbsoluteConstraints(140, 70, -1, -1));
        this.jCheckBoxGCold.setText(resourceMap.getString("jCheckBoxGCold.text", new Object[0]));
        this.jCheckBoxGCold.setName("jCheckBoxGCold");
        this.jPanelButtonsModal.add((Component)this.jCheckBoxGCold, new AbsoluteConstraints(140, 90, -1, -1));
        this.jCheckBoxCnew.setText(resourceMap.getString("jCheckBoxCnew.text", new Object[0]));
        this.jCheckBoxCnew.setName("jCheckBoxCnew");
        this.jPanelButtonsModal.add((Component)this.jCheckBoxCnew, new AbsoluteConstraints(140, 110, -1, -1));
        this.jCheckBoxCold.setText(resourceMap.getString("jCheckBoxCold.text", new Object[0]));
        this.jCheckBoxCold.setName("jCheckBoxCold");
        this.jPanelButtonsModal.add((Component)this.jCheckBoxCold, new AbsoluteConstraints(140, 130, -1, -1));
        this.jButtonStartModal.setAction(actionMap.get("buttonStartModal"));
        this.jButtonStartModal.setFont(this.jButtonStartModal.getFont().deriveFont(this.jButtonStartModal.getFont().getStyle() | 1));
        this.jButtonStartModal.setText(resourceMap.getString("jButtonStartModal.text", new Object[0]));
        this.jButtonStartModal.setName("jButtonStartModal");
        this.jPanelButtonsModal.add((Component)this.jButtonStartModal, new AbsoluteConstraints(140, 170, 120, -1));
        this.jButtonCancelModal.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancelModal.setText(resourceMap.getString("jButtonCancelModal.text", new Object[0]));
        this.jButtonCancelModal.setName("jButtonCancelModal");
        this.jPanelButtonsModal.add((Component)this.jButtonCancelModal, new AbsoluteConstraints(270, 170, 120, -1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.getContentPane().add((Component)this.jPanelButtonsModal, gridBagConstraints);
        this.pack();
    }

    private void jComboBoxInitialValuesItemStateChanged(ItemEvent evt) {
        boolean useRndSeed = this.jComboBoxInitialValues.getSelectedIndex() == 0;
        this.jSpinnerRndSeedNum.setEnabled(useRndSeed);
    }

    @Action
    public void buttonStart() {
        String error;
        this.applyParams();
        if (this.cfg.isAutoSave()) {
            this.saveCfgToParams();
        }
        if ((error = this.checkConfigErrors()) != null) {
            SimpleBGC_GUIApp.mainView.showErrorMessage(error);
            return;
        }
        if (this.sendCmdAutoPid2(this.cfg.isAutoSave() ? 2 : 1)) {
            SimpleBGC_GUIApp.mainView.updateStatus(this.resourceMap.getString("info.auto_pid_started", new Object[0]));
        } else {
            SimpleBGC_GUIApp.mainView.showErrorMessage(this.resourceMap.getString("error.auto_pid_not_started", new Object[0]));
        }
    }

    void saveCfgToParams() {
        if (BoardParams.getCurParams() != null) {
            try {
                BoardParams.getCurParams().auto_pid_cfg2 = this.cfg.clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Action
    public void buttonSave() {
        this.applyParams();
        this.saveCfgToParams();
        if (this.sendCmdAutoPid2(3)) {
            SimpleBGC_GUIApp.mainView.updateStatus(this.resourceMap.getString("info.auto_pid_cfg_saved", new Object[0]));
        } else {
            SimpleBGC_GUIApp.mainView.showErrorMessage(this.resourceMap.getString("error.auto_pid_cfg_not_saved", new Object[0]));
        }
    }

    private boolean sendCmdAutoPid2(int action) {
        try {
            SerialCommand cmd = new SerialCommand(108);
            cmd.writeByte(action);
            cmd.writeWord(1);
            cmd.writeEmptyArr(8);
            if (action <= 3) {
                this.cfg.write(cmd);
            }
            return CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L);
        }
        catch (Exception e) {
            this.logger.error("Failed to send CMD_AUTO_PID2: " + e.toString());
            return false;
        }
    }

    @Action
    public void buttonStop() {
        if (this.sendCmdAutoPid2(5)) {
            SimpleBGC_GUIApp.mainView.updateStatus(this.resourceMap.getString("info.auto_pid_stopped", new Object[0]));
        }
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonStartModal() {
        this.applyParams();
        this.closeDialog(1);
    }

    @Action
    public void buttonResetToDefaults() {
        this.cfg = new AutoPIDCfg2(this.isGUIMode);
        BoardParams params = BoardParams.getCurParams();
        params.auto_pid_precision = 127;
        this.updateParams(params);
    }
}

