/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.object.BoardParams;
import sbgc.object.BoardProfile;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class DialogCopyProfile
extends MyDialog {
    JCheckBox[] checkBoxProfiles;
    private JButton jButtoCancel;
    private JButton jButtonCopy;
    private JButton jButtonCopyWrite;
    private JCheckBox jCheckBoxProfile1;
    private JCheckBox jCheckBoxProfile2;
    private JCheckBox jCheckBoxProfile3;
    private JCheckBox jCheckBoxProfile4;
    private JCheckBox jCheckBoxProfile5;
    private JComboBox jComboBoxProfile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel panelButtons;
    private JPanel panelProfiles;

    private void initComponents() {
        this.panelProfiles = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxProfile = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jCheckBoxProfile1 = new JCheckBox();
        this.jCheckBoxProfile2 = new JCheckBox();
        this.jCheckBoxProfile3 = new JCheckBox();
        this.jCheckBoxProfile4 = new JCheckBox();
        this.jCheckBoxProfile5 = new JCheckBox();
        this.panelButtons = new JPanel();
        this.jButtoCancel = new JButton();
        this.jButtonCopy = new JButton();
        this.jButtonCopyWrite = new JButton();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.panelProfiles.setMinimumSize(new Dimension(127, 160));
        this.panelProfiles.setName("panelProfiles");
        this.panelProfiles.setPreferredSize(new Dimension(145, 160));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogCopyProfile.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jComboBoxProfile.setName("jComboBoxProfile");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jCheckBoxProfile1.setText(resourceMap.getString("jCheckBoxProfile1.text", new Object[0]));
        this.jCheckBoxProfile1.setName("jCheckBoxProfile1");
        this.jCheckBoxProfile2.setText(resourceMap.getString("jCheckBoxProfile2.text", new Object[0]));
        this.jCheckBoxProfile2.setName("jCheckBoxProfile2");
        this.jCheckBoxProfile3.setText(resourceMap.getString("jCheckBoxProfile3.text", new Object[0]));
        this.jCheckBoxProfile3.setName("jCheckBoxProfile3");
        this.jCheckBoxProfile4.setText(resourceMap.getString("jCheckBoxProfile4.text", new Object[0]));
        this.jCheckBoxProfile4.setName("jCheckBoxProfile4");
        this.jCheckBoxProfile5.setText(resourceMap.getString("jCheckBoxProfile5.text", new Object[0]));
        this.jCheckBoxProfile5.setName("jCheckBoxProfile5");
        GroupLayout panelProfilesLayout = new GroupLayout(this.panelProfiles);
        this.panelProfiles.setLayout(panelProfilesLayout);
        panelProfilesLayout.setHorizontalGroup(panelProfilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProfilesLayout.createSequentialGroup().addGap(26, 26, 26).addGroup(panelProfilesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelProfilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxProfile2).addComponent(this.jCheckBoxProfile5).addComponent(this.jCheckBoxProfile1).addComponent(this.jCheckBoxProfile4).addComponent(this.jCheckBoxProfile3).addComponent(this.jComboBoxProfile, -2, 271, -2)).addContainerGap(91, Short.MAX_VALUE)));
        panelProfilesLayout.setVerticalGroup(panelProfilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProfilesLayout.createSequentialGroup().addGap(28, 28, 28).addGroup(panelProfilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxProfile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelProfilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelProfilesLayout.createSequentialGroup().addComponent(this.jCheckBoxProfile1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxProfile2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxProfile3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxProfile4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxProfile5)).addComponent(this.jLabel2)).addContainerGap(50, Short.MAX_VALUE)));
        this.panelButtons.setMinimumSize(new Dimension(10, 50));
        this.panelButtons.setName("panelButtons");
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogCopyProfile.class, this);
        this.jButtoCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtoCancel.setText(resourceMap.getString("jButtoCancel.text", new Object[0]));
        this.jButtoCancel.setName("jButtoCancel");
        this.jButtonCopy.setAction(actionMap.get("buttonCopy"));
        this.jButtonCopy.setText(resourceMap.getString("jButtonCopy.text", new Object[0]));
        this.jButtonCopy.setToolTipText(resourceMap.getString("jButtonCopy.toolTipText", new Object[0]));
        this.jButtonCopy.setName("jButtonCopy");
        this.jButtonCopyWrite.setAction(actionMap.get("buttonCopyWrite"));
        this.jButtonCopyWrite.setText(resourceMap.getString("jButtonCopyWrite.text", new Object[0]));
        this.jButtonCopyWrite.setToolTipText(resourceMap.getString("jButtonCopyWrite.toolTipText", new Object[0]));
        this.jButtonCopyWrite.setName("jButtonCopyWrite");
        GroupLayout panelButtonsLayout = new GroupLayout(this.panelButtons);
        this.panelButtons.setLayout(panelButtonsLayout);
        panelButtonsLayout.setHorizontalGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelButtonsLayout.createSequentialGroup().addGap(237, 237, 237).addComponent(this.jButtoCancel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCopyWrite, -1, -1, Short.MAX_VALUE).addContainerGap()));
        panelButtonsLayout.setVerticalGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelButtonsLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(panelButtonsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCopyWrite).addComponent(this.jButtonCopy).addComponent(this.jButtoCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelButtons, -1, -1, Short.MAX_VALUE).addComponent(this.panelProfiles, -1, 552, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.panelProfiles, -1, 219, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelButtons, -2, 36, -2)));
        this.pack();
    }

    public DialogCopyProfile(Frame parent, int currentProfileIdx) {
        super(DialogCopyProfile.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_copy_profile", new Object[0]));
        this.initComponents();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogCopyProfile.this.buttonCopy();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.checkBoxProfiles = new JCheckBox[]{this.jCheckBoxProfile1, this.jCheckBoxProfile2, this.jCheckBoxProfile3, this.jCheckBoxProfile4, this.jCheckBoxProfile5};
        this.jComboBoxProfile.removeAllItems();
        for (int i = 0; i < 5; ++i) {
            String name = SimpleBGC_GUIView.getProfileName(i);
            this.jComboBoxProfile.addItem(name);
            this.checkBoxProfiles[i].setText(name);
            this.checkBoxProfiles[i].setSelected(BoardParams.getCurProfileIdx() != i);
        }
        this.jComboBoxProfile.setSelectedIndex(Math.max(0, Math.min(currentProfileIdx, this.jComboBoxProfile.getItemCount() - 1)));
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Override
    public void onCloseDialog() {
    }

    @Action
    public void buttonCopy() {
        this.copyProfiles(false);
    }

    @Action
    public void buttonCopyWrite() {
        this.copyProfiles(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void copyProfiles(boolean doWrite) {
        this.logger.info("Copying profiles..");
        try {
            BoardParams params = BoardParams.getCurParams();
            if (params == null) throw new Exception("Parameters are not loaded!");
            int fromIdx = this.jComboBoxProfile.getSelectedIndex();
            BoardProfile p_from = params.profiles[fromIdx];
            int copyCnt = 0;
            for (int i = 0; i < params.profiles.length; ++i) {
                if (i == fromIdx || !this.checkBoxProfiles[i].isSelected()) continue;
                this.logger.info("Copy profile " + fromIdx + " to " + i + "..");
                params.profiles[i] = p_from.clone();
                ++copyCnt;
            }
            if (copyCnt == 0) {
                throw new Exception("Destination profiles are not selected");
            }
            SimpleBGC_GUIApp.mainView.updateBoardParams();
            SimpleBGC_GUIApp.mainView.updateStatus("Copied " + copyCnt + " profiles.");
            if (doWrite) {
                if (!SimpleBGC_GUIApp.mainView.isConnected()) throw new Exception(this.resourceMap.getString("error.board_not_connected", new Object[0]));
                SerialCommandProcessor.writeAllParams(params, -1, new IProgressListener(){

                    @Override
                    public boolean onProgressChange(int percent) {
                        return SimpleBGC_GUIApp.mainView.onProgressChange(percent);
                    }

                    @Override
                    public void onProgressFinish(boolean isSuccess) {
                        SimpleBGC_GUIApp.mainView.onProgressFinish(isSuccess);
                        DialogCopyProfile.this.jButtonCopy.setEnabled(true);
                        DialogCopyProfile.this.jButtonCopyWrite.setEnabled(true);
                        if (isSuccess) {
                            DialogCopyProfile.this.closeDialog(1);
                        }
                    }

                    @Override
                    public void onProgressStart(String action, boolean modal) {
                        SimpleBGC_GUIApp.mainView.onProgressStart(action, modal);
                        DialogCopyProfile.this.jButtonCopy.setEnabled(false);
                        DialogCopyProfile.this.jButtonCopyWrite.setEnabled(false);
                    }
                });
                return;
            } else {
                this.closeDialog(1);
            }
            return;
        }
        catch (Exception e) {
            SimpleBGC_GUIApp.mainView.showErrorMessage("Failed to copy: " + e.getMessage());
        }
    }
}

