/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.FileNotFoundException;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.ErrorInfo;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.ui.dataview.DataViewSeries;
import sbgc.ui.dataview.LUTViewPanel;
import sbgc.utils.MathUtils;
import sbgc.utils.Settings;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.TabWindow;

public class DialogEncoderLUTCalib
extends MyDialog
implements Runnable,
IProgressListener {
    private static final int STEP_ALIGN = 0;
    private static final int STEP_SCALE = 1;
    private static final int STEP_LUT = 2;
    private static final int ITER_HOME = 0;
    private static final int CALIB_CFG_FLAG_GYRO_SCALE = 8;
    LUTViewPanel[] lutViewPanel = new LUTViewPanel[3];
    DataViewSeries[] lutSeries = new DataViewSeries[3];
    DataViewSeries[] curErrSeries = new DataViewSeries[3];
    DataViewSeries[][] alignErrSeries = new DataViewSeries[3][3];
    JPanel[] viewPanels;
    JCheckBox[] checkBoxMotors;
    JTextField[] maxErr;
    JTextField[] gyroScale;
    JTextField[][] orientCorr;
    int progress = 0;
    int prevStep;
    ActionMap actionMap;
    boolean isActive;
    private JButton jButtonCalibrate;
    private JButton jButtonDelete;
    private JButton jButtonFinish;
    private JButton jButtonLoad;
    private JButton jButtonNewWindow1;
    private JCheckBox jCheckBoxGyroScale;
    private JCheckBox jCheckBoxP;
    private JCheckBox jCheckBoxR;
    private JCheckBox jCheckBoxY;
    private JLabel jLabelGyroScale;
    private JLabel jLabelLUT;
    private JLabel jLabelMaxErr;
    private JLabel jLabelMisalignErr;
    private JLabel jLabelMotor;
    private JLabel jLabelPitch;
    private JLabel jLabelRoll;
    private JLabel jLabelStatus;
    private JLabel jLabelX;
    private JLabel jLabelX2;
    private JLabel jLabelY;
    private JLabel jLabelY2;
    private JLabel jLabelYaw;
    private JLabel jLabelZ;
    private JLabel jLabelZ2;
    private JPanel jPanelPlotContainer;
    private JPanel jPanelPlotP;
    private JPanel jPanelPlotR;
    private JPanel jPanelPlotY;
    private JPanel jPanelPlots;
    private JProgressBar jProgressBar;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldErrP;
    private JTextField jTextFieldErrR;
    private JTextField jTextFieldErrY;
    private JTextField jTextFieldGyroScaleX;
    private JTextField jTextFieldGyroScaleY;
    private JTextField jTextFieldGyroScaleZ;
    private JTextField jTextFieldPX;
    private JTextField jTextFieldPY;
    private JTextField jTextFieldPZ;
    private JTextField jTextFieldRX;
    private JTextField jTextFieldRY;
    private JTextField jTextFieldRZ;
    private JTextField jTextFieldYX;
    private JTextField jTextFieldYY;
    private JTextField jTextFieldYZ;

    public DialogEncoderLUTCalib(Frame parent, boolean modal) throws Exception {
        super(DialogEncoderLUTCalib.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_enc_lut_calibration", new Object[0]), modal);
        this.initComponents();
        this.actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogEncoderLUTCalib.class, this);
        RealtimeDataThread.suspend(true);
        this.viewPanels = new JPanel[]{this.jPanelPlotR, this.jPanelPlotP, this.jPanelPlotY};
        this.checkBoxMotors = new JCheckBox[]{this.jCheckBoxR, this.jCheckBoxP, this.jCheckBoxY};
        this.maxErr = new JTextField[]{this.jTextFieldErrR, this.jTextFieldErrP, this.jTextFieldErrY};
        this.orientCorr = new JTextField[][]{{this.jTextFieldRX, this.jTextFieldRY, this.jTextFieldRZ}, {this.jTextFieldPX, this.jTextFieldPY, this.jTextFieldPZ}, {this.jTextFieldYX, this.jTextFieldYY, this.jTextFieldYZ}};
        this.gyroScale = new JTextField[]{this.jTextFieldGyroScaleX, this.jTextFieldGyroScaleY, this.jTextFieldGyroScaleZ};
        this.jCheckBoxGyroScale.setSelected(Settings.is("encoder_lut_calib.gyro_scale", true));
        for (int i = 0; i < 3; ++i) {
            this.lutViewPanel[i] = new LUTViewPanel();
            this.viewPanels[i].add(this.lutViewPanel[i]);
            this.checkBoxMotors[i].setSelected(Settings.is("encoder_lut_calib." + i, true));
            this.lutSeries[i] = new DataViewSeries(LUTViewPanel.PRIMARY_COLORS[0], 3.0f);
            this.lutSeries[i].set_xy_range(0, -180.0f, 180.0f, true, DataViewSeries.AutoScaleType.NO, 0.0f);
            this.lutSeries[i].set_xy_range(1, -5.0f, 5.0f, true, DataViewSeries.AutoScaleType.ALL, 0.1f);
            this.lutSeries[i].set_wrap(0, -180.0f, 180.0f, true);
            this.curErrSeries[i] = new DataViewSeries(LUTViewPanel.SECONDARY_COLORS[0], 1.5f);
            this.curErrSeries[i].set_xy_range(0, -180.0f, 180.0f, true, DataViewSeries.AutoScaleType.NO, 0.0f);
            this.curErrSeries[i].set_xy_range(1, -3.0f, 3.0f, true, DataViewSeries.AutoScaleType.ALL, 0.1f);
            this.curErrSeries[i].set_wrap(0, -180.0f, 180.0f, true);
            this.curErrSeries[i].setThreshold(1.0f);
            for (int j = 0; j < 2; ++j) {
                this.alignErrSeries[i][j] = new DataViewSeries(LUTViewPanel.SECONDARY_COLORS[j + 1], 1.5f);
                this.alignErrSeries[i][j].set_xy_range(0, -180.0f, 180.0f, true, DataViewSeries.AutoScaleType.NO, 0.0f);
                this.alignErrSeries[i][j].set_xy_range(1, -3.0f, 3.0f, true, DataViewSeries.AutoScaleType.LAST, 1.0f);
                this.alignErrSeries[i][j].set_wrap(0, -180.0f, 180.0f, true);
                this.alignErrSeries[i][j].setThreshold(3.0f);
                this.lutViewPanel[i].addSeries(this.alignErrSeries[i][j]);
            }
            this.lutViewPanel[i].addSeries(this.curErrSeries[i]);
            this.lutViewPanel[i].addSeries(this.lutSeries[i]);
            this.lutViewPanel[i].setGrid(0, 90.0f, "\u00b0", false);
            this.lutViewPanel[i].setGrid(1, 1.0f, "\u00b0", true);
        }
    }

    @Override
    protected void onShowDialog() {
        this.isActive = true;
        this.setActiveState(false);
        new Thread(this).start();
    }

    private void initComponents() {
        this.jLabelLUT = new JLabel();
        this.jButtonLoad = new JButton();
        this.jButtonNewWindow1 = new JButton();
        this.jPanelPlotContainer = new JPanel();
        this.jPanelPlots = new JPanel();
        this.jPanelPlotR = new JPanel();
        this.jPanelPlotP = new JPanel();
        this.jPanelPlotY = new JPanel();
        this.jLabelMisalignErr = new JLabel();
        this.jLabelX = new JLabel();
        this.jLabelY = new JLabel();
        this.jLabelZ = new JLabel();
        this.jLabelRoll = new JLabel();
        this.jTextFieldRX = new JTextField();
        this.jTextFieldRY = new JTextField();
        this.jTextFieldRZ = new JTextField();
        this.jLabelPitch = new JLabel();
        this.jTextFieldPX = new JTextField();
        this.jTextFieldPY = new JTextField();
        this.jTextFieldPZ = new JTextField();
        this.jLabelYaw = new JLabel();
        this.jTextFieldYX = new JTextField();
        this.jTextFieldYY = new JTextField();
        this.jTextFieldYZ = new JTextField();
        this.jLabelGyroScale = new JLabel();
        this.jLabelX2 = new JLabel();
        this.jLabelY2 = new JLabel();
        this.jLabelZ2 = new JLabel();
        this.jTextFieldGyroScaleX = new JTextField();
        this.jTextFieldGyroScaleY = new JTextField();
        this.jTextFieldGyroScaleZ = new JTextField();
        this.jLabelMaxErr = new JLabel();
        this.jTextFieldErrR = new JTextField();
        this.jTextFieldErrP = new JTextField();
        this.jTextFieldErrY = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jLabelMotor = new JLabel();
        this.jCheckBoxR = new JCheckBox();
        this.jCheckBoxP = new JCheckBox();
        this.jCheckBoxY = new JCheckBox();
        this.jButtonDelete = new JButton();
        this.jButtonCalibrate = new JButton();
        this.jButtonFinish = new JButton();
        this.jProgressBar = new JProgressBar();
        this.jLabelStatus = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jCheckBoxGyroScale = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogEncoderLUTCalib.class);
        this.jLabelLUT.setText(resourceMap.getString("jLabelLUT.text", new Object[0]));
        this.jLabelLUT.setName("jLabelLUT");
        this.getContentPane().add((Component)this.jLabelLUT, new AbsoluteConstraints(10, 20, -1, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogEncoderLUTCalib.class, this);
        this.jButtonLoad.setAction(actionMap.get("buttonRead"));
        this.jButtonLoad.setText(resourceMap.getString("jButtonLoad.text", new Object[0]));
        this.jButtonLoad.setToolTipText(resourceMap.getString("jButtonLoad.toolTipText", new Object[0]));
        this.jButtonLoad.setName("jButtonLoad");
        this.getContentPane().add((Component)this.jButtonLoad, new AbsoluteConstraints(370, 10, 220, 30));
        this.jButtonNewWindow1.setAction(actionMap.get("buttonNewWin"));
        this.jButtonNewWindow1.setToolTipText(resourceMap.getString("jButtonNewWindow1.toolTipText", new Object[0]));
        this.jButtonNewWindow1.setHorizontalTextPosition(0);
        this.jButtonNewWindow1.setIconTextGap(0);
        this.jButtonNewWindow1.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonNewWindow1.setName("jButtonNewWindow1");
        this.getContentPane().add((Component)this.jButtonNewWindow1, new AbsoluteConstraints(595, 10, 30, 30));
        this.jPanelPlotContainer.setName("jPanelPlotContainer");
        this.jPanelPlotContainer.setLayout(new BoxLayout(this.jPanelPlotContainer, 2));
        this.jPanelPlots.setName("jPanelPlots");
        this.jPanelPlots.setLayout(new GridBagLayout());
        this.jPanelPlotR.setBorder(BorderFactory.createEtchedBorder(0));
        this.jPanelPlotR.setName("jPanelPlotR");
        this.jPanelPlotR.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelPlots.add((Component)this.jPanelPlotR, gridBagConstraints);
        this.jPanelPlotP.setBorder(BorderFactory.createEtchedBorder(0));
        this.jPanelPlotP.setName("jPanelPlotP");
        this.jPanelPlotP.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelPlots.add((Component)this.jPanelPlotP, gridBagConstraints);
        this.jPanelPlotY.setBorder(BorderFactory.createEtchedBorder(0));
        this.jPanelPlotY.setName("jPanelPlotY");
        this.jPanelPlotY.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelPlots.add((Component)this.jPanelPlotY, gridBagConstraints);
        this.jPanelPlotContainer.add(this.jPanelPlots);
        this.getContentPane().add((Component)this.jPanelPlotContainer, new AbsoluteConstraints(0, 50, 630, 330));
        this.jLabelMisalignErr.setText(resourceMap.getString("jLabelMisalignErr.text", new Object[0]));
        this.jLabelMisalignErr.setName("jLabelMisalignErr");
        this.getContentPane().add((Component)this.jLabelMisalignErr, new AbsoluteConstraints(10, 380, 310, 60));
        this.jLabelX.setHorizontalAlignment(0);
        this.jLabelX.setText(resourceMap.getString("jLabelX.text", new Object[0]));
        this.jLabelX.setName("jLabelX");
        this.getContentPane().add((Component)this.jLabelX, new AbsoluteConstraints(110, 440, 60, -1));
        this.jLabelY.setHorizontalAlignment(0);
        this.jLabelY.setText(resourceMap.getString("jLabelY.text", new Object[0]));
        this.jLabelY.setName("jLabelY");
        this.getContentPane().add((Component)this.jLabelY, new AbsoluteConstraints(180, 440, 60, -1));
        this.jLabelZ.setHorizontalAlignment(0);
        this.jLabelZ.setText(resourceMap.getString("jLabelZ.text", new Object[0]));
        this.jLabelZ.setName("jLabelZ");
        this.getContentPane().add((Component)this.jLabelZ, new AbsoluteConstraints(250, 440, 60, -1));
        this.jLabelRoll.setText(resourceMap.getString("jLabelRoll.text", new Object[0]));
        this.jLabelRoll.setName("jLabelRoll");
        this.getContentPane().add((Component)this.jLabelRoll, new AbsoluteConstraints(30, 460, 70, -1));
        this.jTextFieldRX.setEditable(false);
        this.jTextFieldRX.setName("jTextFieldRX");
        this.getContentPane().add((Component)this.jTextFieldRX, new AbsoluteConstraints(110, 460, 60, -1));
        this.jTextFieldRY.setEditable(false);
        this.jTextFieldRY.setName("jTextFieldRY");
        this.getContentPane().add((Component)this.jTextFieldRY, new AbsoluteConstraints(180, 460, 60, -1));
        this.jTextFieldRZ.setEditable(false);
        this.jTextFieldRZ.setName("jTextFieldRZ");
        this.getContentPane().add((Component)this.jTextFieldRZ, new AbsoluteConstraints(250, 460, 60, -1));
        this.jLabelPitch.setText(resourceMap.getString("jLabelPitch.text", new Object[0]));
        this.jLabelPitch.setName("jLabelPitch");
        this.getContentPane().add((Component)this.jLabelPitch, new AbsoluteConstraints(30, 490, 70, -1));
        this.jTextFieldPX.setEditable(false);
        this.jTextFieldPX.setName("jTextFieldPX");
        this.getContentPane().add((Component)this.jTextFieldPX, new AbsoluteConstraints(110, 490, 60, -1));
        this.jTextFieldPY.setEditable(false);
        this.jTextFieldPY.setName("jTextFieldPY");
        this.getContentPane().add((Component)this.jTextFieldPY, new AbsoluteConstraints(180, 490, 60, -1));
        this.jTextFieldPZ.setEditable(false);
        this.jTextFieldPZ.setName("jTextFieldPZ");
        this.getContentPane().add((Component)this.jTextFieldPZ, new AbsoluteConstraints(250, 490, 60, -1));
        this.jLabelYaw.setText(resourceMap.getString("jLabelYaw.text", new Object[0]));
        this.jLabelYaw.setName("jLabelYaw");
        this.getContentPane().add((Component)this.jLabelYaw, new AbsoluteConstraints(30, 520, 70, -1));
        this.jTextFieldYX.setEditable(false);
        this.jTextFieldYX.setName("jTextFieldYX");
        this.getContentPane().add((Component)this.jTextFieldYX, new AbsoluteConstraints(110, 520, 60, -1));
        this.jTextFieldYY.setEditable(false);
        this.jTextFieldYY.setName("jTextFieldYY");
        this.getContentPane().add((Component)this.jTextFieldYY, new AbsoluteConstraints(180, 520, 60, -1));
        this.jTextFieldYZ.setEditable(false);
        this.jTextFieldYZ.setName("jTextFieldYZ");
        this.getContentPane().add((Component)this.jTextFieldYZ, new AbsoluteConstraints(250, 520, 60, -1));
        this.jLabelGyroScale.setText(resourceMap.getString("jLabelGyroScale.text", new Object[0]));
        this.jLabelGyroScale.setName("jLabelGyroScale");
        this.getContentPane().add((Component)this.jLabelGyroScale, new AbsoluteConstraints(520, 440, -1, -1));
        this.jLabelX2.setText(resourceMap.getString("jLabelX2.text", new Object[0]));
        this.jLabelX2.setName("jLabelX2");
        this.getContentPane().add((Component)this.jLabelX2, new AbsoluteConstraints(490, 460, 30, -1));
        this.jLabelY2.setText(resourceMap.getString("jLabelY2.text", new Object[0]));
        this.jLabelY2.setName("jLabelY2");
        this.getContentPane().add((Component)this.jLabelY2, new AbsoluteConstraints(490, 490, 30, -1));
        this.jLabelZ2.setText(resourceMap.getString("jLabelZ2.text", new Object[0]));
        this.jLabelZ2.setName("jLabelZ2");
        this.getContentPane().add((Component)this.jLabelZ2, new AbsoluteConstraints(490, 520, 30, -1));
        this.jTextFieldGyroScaleX.setEditable(false);
        this.jTextFieldGyroScaleX.setToolTipText(resourceMap.getString("jTextFieldGyroScaleX.toolTipText", new Object[0]));
        this.jTextFieldGyroScaleX.setName("jTextFieldGyroScaleX");
        this.getContentPane().add((Component)this.jTextFieldGyroScaleX, new AbsoluteConstraints(520, 460, 60, -1));
        this.jTextFieldGyroScaleY.setEditable(false);
        this.jTextFieldGyroScaleY.setToolTipText(resourceMap.getString("jTextFieldGyroScaleX.toolTipText", new Object[0]));
        this.jTextFieldGyroScaleY.setName("jTextFieldGyroScaleY");
        this.getContentPane().add((Component)this.jTextFieldGyroScaleY, new AbsoluteConstraints(520, 490, 60, -1));
        this.jTextFieldGyroScaleZ.setEditable(false);
        this.jTextFieldGyroScaleZ.setToolTipText(resourceMap.getString("jTextFieldGyroScaleX.toolTipText", new Object[0]));
        this.jTextFieldGyroScaleZ.setName("jTextFieldGyroScaleZ");
        this.getContentPane().add((Component)this.jTextFieldGyroScaleZ, new AbsoluteConstraints(520, 520, 60, -1));
        this.jLabelMaxErr.setText(resourceMap.getString("jLabelMaxErr.text", new Object[0]));
        this.jLabelMaxErr.setName("jLabelMaxErr");
        this.getContentPane().add((Component)this.jLabelMaxErr, new AbsoluteConstraints(320, 440, -1, -1));
        this.jTextFieldErrR.setEditable(false);
        this.jTextFieldErrR.setToolTipText(resourceMap.getString("jTextFieldErrR.toolTipText", new Object[0]));
        this.jTextFieldErrR.setName("jTextFieldErrR");
        this.getContentPane().add((Component)this.jTextFieldErrR, new AbsoluteConstraints(320, 460, 60, -1));
        this.jTextFieldErrP.setEditable(false);
        this.jTextFieldErrP.setToolTipText(resourceMap.getString("jTextFieldErrR.toolTipText", new Object[0]));
        this.jTextFieldErrP.setName("jTextFieldErrP");
        this.getContentPane().add((Component)this.jTextFieldErrP, new AbsoluteConstraints(320, 490, 60, -1));
        this.jTextFieldErrY.setEditable(false);
        this.jTextFieldErrY.setToolTipText(resourceMap.getString("jTextFieldErrR.toolTipText", new Object[0]));
        this.jTextFieldErrY.setName("jTextFieldErrY");
        this.getContentPane().add((Component)this.jTextFieldErrY, new AbsoluteConstraints(320, 520, 60, -1));
        this.jSeparator2.setName("jSeparator2");
        this.getContentPane().add((Component)this.jSeparator2, new AbsoluteConstraints(10, 550, 610, 10));
        this.jLabelMotor.setText(resourceMap.getString("jLabelMotor.text", new Object[0]));
        this.jLabelMotor.setName("jLabelMotor");
        this.getContentPane().add((Component)this.jLabelMotor, new AbsoluteConstraints(20, 560, 90, -1));
        this.jCheckBoxR.setText(resourceMap.getString("jCheckBoxR.text", new Object[0]));
        this.jCheckBoxR.setName("jCheckBoxR");
        this.getContentPane().add((Component)this.jCheckBoxR, new AbsoluteConstraints(110, 560, -1, -1));
        this.jCheckBoxP.setText(resourceMap.getString("jCheckBoxP.text", new Object[0]));
        this.jCheckBoxP.setName("jCheckBoxP");
        this.getContentPane().add((Component)this.jCheckBoxP, new AbsoluteConstraints(180, 560, -1, -1));
        this.jCheckBoxY.setText(resourceMap.getString("jCheckBoxY.text", new Object[0]));
        this.jCheckBoxY.setName("jCheckBoxY");
        this.getContentPane().add((Component)this.jCheckBoxY, new AbsoluteConstraints(250, 560, -1, -1));
        this.jButtonDelete.setAction(actionMap.get("buttonDelete"));
        this.jButtonDelete.setText(resourceMap.getString("jButtonDelete.text", new Object[0]));
        this.jButtonDelete.setToolTipText(resourceMap.getString("jButtonDelete.toolTipText", new Object[0]));
        this.jButtonDelete.setName("jButtonDelete");
        this.getContentPane().add((Component)this.jButtonDelete, new AbsoluteConstraints(350, 560, 130, 30));
        this.jButtonCalibrate.setAction(actionMap.get("buttonCalibrate"));
        this.jButtonCalibrate.setText(resourceMap.getString("jButtonCalibrate.text", new Object[0]));
        this.jButtonCalibrate.setToolTipText(resourceMap.getString("jButtonCalibrate.toolTipText", new Object[0]));
        this.jButtonCalibrate.setName("jButtonCalibrate");
        this.getContentPane().add((Component)this.jButtonCalibrate, new AbsoluteConstraints(490, 560, 120, 30));
        this.jButtonFinish.setAction(actionMap.get("buttonCancel"));
        this.jButtonFinish.setText(resourceMap.getString("jButtonFinish.text", new Object[0]));
        this.jButtonFinish.setName("jButtonFinish");
        this.getContentPane().add((Component)this.jButtonFinish, new AbsoluteConstraints(490, 630, 120, 30));
        this.jProgressBar.setName("jProgressBar");
        this.jProgressBar.setStringPainted(true);
        this.getContentPane().add((Component)this.jProgressBar, new AbsoluteConstraints(30, 630, 420, 15));
        this.jLabelStatus.setVerticalAlignment(1);
        this.jLabelStatus.setName("jLabelStatus");
        this.jLabelStatus.setVerticalTextPosition(1);
        this.getContentPane().add((Component)this.jLabelStatus, new AbsoluteConstraints(20, 650, 450, 20));
        this.jSeparator3.setName("jSeparator3");
        this.getContentPane().add((Component)this.jSeparator3, new AbsoluteConstraints(10, 620, 610, 10));
        this.jCheckBoxGyroScale.setText(resourceMap.getString("jCheckBoxGyroScale.text", new Object[0]));
        this.jCheckBoxGyroScale.setToolTipText(resourceMap.getString("jCheckBoxGyroScale.toolTipText", new Object[0]));
        this.jCheckBoxGyroScale.setName("jCheckBoxGyroScale");
        this.getContentPane().add((Component)this.jCheckBoxGyroScale, new AbsoluteConstraints(20, 590, -1, -1));
        this.pack();
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.suspend(false);
        Settings.save();
    }

    public void updateStatus(final String text) {
        this.logger.info("status: " + text);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogEncoderLUTCalib.this.jLabelStatus.setText(text);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CommandResponseListener listener1 = new CommandResponseListener(117);
        CommandResponseListener listener2 = new CommandResponseListener(118);
        SerialCommandDispatcher.getInstance().addResponseListener(listener1);
        SerialCommandDispatcher.getInstance().addResponseListener(listener2);
        try {
            while (!this.isClosed()) {
                SerialCommand resp = listener2.waitShort(0L);
                if (resp == null) {
                    resp = listener1.waitShort(500L);
                }
                if (resp == null) continue;
                final SerialCommand respf = resp;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                if (respf.id == 67) {
                                    DialogEncoderLUTCalib.this.onConfirmCmd(respf);
                                    break block6;
                                }
                                if (respf.id == 255) {
                                    DialogEncoderLUTCalib.this.showErrorMessage("Operation failed with error " + ErrorInfo.formatCmdErrorInfo(respf));
                                    break block6;
                                }
                                if (respf.id == 117) {
                                    DialogEncoderLUTCalib.this.onCalibInfoCmd(respf);
                                    break block6;
                                }
                                if (respf.id == 118) {
                                    DialogEncoderLUTCalib.this.onCalibResultCmd(respf);
                                    break block6;
                                }
                                throw new Exception("Unsupported command: " + respf.id);
                            }
                            catch (Exception e) {
                                DialogEncoderLUTCalib.this.logger.error("Error parsing CMD_CALIB_ENCODER_LUT: " + e.toString());
                            }
                        }
                    }
                });
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Calibration thread interrupted");
        }
        catch (Exception e) {
            this.logger.warn("Exception in the calibration thread: " + e.toString());
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(listener1);
            SerialCommandDispatcher.getInstance().removeResponseListener(listener2);
        }
    }

    void onConfirmCmd(SerialCommand cmd) throws Exception {
        cmd.skipBytes(1);
        int action = cmd.readByte();
        this.logger.trace("Action confirmed: " + action);
        switch (action) {
            case 1: {
                this.updateStatus(this.resourceMap.getString("status.calibration_started", new Object[0]));
                this.setActiveState(true);
                break;
            }
            case 8: {
                this.updateStatus(this.resourceMap.getString("status.calibration_stopped", new Object[0]));
                this.setActiveState(false);
                break;
            }
            case 2: {
                this.updateStatus(this.resourceMap.getString("status.delete_okay", new Object[0]));
                this.readLUT(-1);
                break;
            }
            case 254: {
                this.showErrorMessage(this.resourceMap.getString("error.calibration", new Object[0]));
                this.setActiveState(false);
                break;
            }
            case 255: {
                this.updateStatus(this.resourceMap.getString("status.calibration_finished", new Object[0]));
                this.setActiveState(false);
                break;
            }
            default: {
                this.updateStatus("Unknow action confirmed: " + action);
            }
        }
    }

    void setActiveState(boolean isActive) {
        if (this.isActive != isActive) {
            if (isActive) {
                this.jButtonCalibrate.setAction(this.actionMap.get("buttonCalibrateStop"));
                this.progress = 1;
            } else {
                this.jButtonCalibrate.setAction(this.actionMap.get("buttonCalibrate"));
                this.progress = 0;
            }
            this.jProgressBar.setVisible(this.progress > 0);
            this.isActive = isActive;
        }
    }

    void onCalibInfoCmd(SerialCommand cmd) throws Exception {
        int axis = MathUtils.constrain(cmd.readByte(), 0, 2);
        int step = cmd.readByte();
        int iter = cmd.readByte();
        this.progress = cmd.readByte();
        int f_c_angle14 = (int)cmd.readDWord();
        int[] align_err = cmd.readWordArr(2);
        int enc_angle14 = cmd.readWord();
        long enc_err20 = cmd.readDWord();
        float f_c_angle = MathUtils.angle14_to_deg(f_c_angle14);
        float enc_angle360 = MathUtils.angle14_to_deg(enc_angle14);
        float err360 = (float)((double)enc_err20 * 3.4332275390625E-4);
        this.logger.trace(String.format("axis=%d, step=%d, iter=%d, progress=%d, f_c_angle=%.0f, enc_angle=%.2f, enc_err=%.4f", axis, step, iter, this.progress, Float.valueOf(f_c_angle), Float.valueOf(enc_angle360), Float.valueOf(err360)));
        if (step != this.prevStep) {
            if (this.prevStep == 0) {
                this.alignErrSeries[axis][0].clear();
                this.alignErrSeries[axis][1].clear();
            } else if (this.prevStep == 1) {
                this.curErrSeries[axis].clear();
            }
            this.prevStep = step;
        }
        if (step == 0) {
            for (int j = 0; j < 2; ++j) {
                this.alignErrSeries[axis][j].addSample(f_c_angle, (float)align_err[j] * 0.001f);
            }
        } else if ((step == 1 || step == 2) && enc_err20 != 0L) {
            this.curErrSeries[axis].addSample(this.curErrSeries[axis].unwrap(enc_angle360, 0, 0.0f, 360.0f), err360);
        }
        this.lutViewPanel[axis].onUpdate();
        this.jProgressBar.setValue(this.progress);
        this.setActiveState(true);
    }

    void onCalibResultCmd(SerialCommand cmd) throws Exception {
        int axis = MathUtils.constrain(cmd.readByte(), 0, 2);
        int step = cmd.readByte();
        int[] orient_corr = cmd.readWordArr(3);
        int gyro_ref_axis = MathUtils.constrain(cmd.readByte(), 0, 2);
        int gyro_scale = cmd.readWord();
        if (step >= 0) {
            for (int i = 0; i < 3; ++i) {
                this.orientCorr[axis][i].setText(String.format("%.3f", Float.valueOf((float)orient_corr[i] * 0.001f)));
            }
        }
        if (step >= 1) {
            this.gyroScale[gyro_ref_axis].setText(String.format("%.4f", Float.valueOf((float)gyro_scale * 1.5259255E-4f)));
        }
        if (step == 2) {
            this.readLUT(axis);
        }
    }

    @Action
    public void buttonCalibrate() {
        this.updateStatus(this.resourceMap.getString("status.starting_calibration", new Object[0]));
        for (int axis = 0; axis < 3; ++axis) {
            if (!this.checkBoxMotors[axis].isSelected()) continue;
            this.lutSeries[axis].clear();
            this.curErrSeries[axis].clear();
            this.alignErrSeries[axis][0].clear();
            this.alignErrSeries[axis][1].clear();
            this.lutViewPanel[axis].onUpdate();
            for (int i = 0; i < 3; ++i) {
                this.orientCorr[axis][i].setText(null);
            }
        }
        this.sendCalibCommand(1);
    }

    void sendCalibCommand(int action) {
        try {
            SerialCommand cmd = new SerialCommand(117);
            cmd.writeByte(action);
            int flags = 0;
            if (this.jCheckBoxGyroScale.isSelected()) {
                flags |= 8;
            }
            Settings.set("encoder_lut_calib.gyro_scale", this.jCheckBoxGyroScale.isSelected());
            for (int i = 0; i < 3; ++i) {
                if (this.checkBoxMotors[i].isSelected()) {
                    flags |= 1 << i;
                }
                Settings.set("encoder_lut_calib." + i, this.checkBoxMotors[i].isSelected());
            }
            cmd.writeWord(flags);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Action
    public void buttonDelete() {
        this.sendCalibCommand(2);
    }

    @Action
    public void buttonRead() {
        this.updateStatus(this.resourceMap.getString("status.reading_lut", new Object[0]));
        this.readLUT(-1);
    }

    public static int encoderLUTFileId(int axis) {
        return 2816 + axis;
    }

    public void readLUT(int for_axis) {
        for (int axis = 0; axis < 3; ++axis) {
            if (axis != for_axis && for_axis != -1) continue;
            this.lutSeries[axis].clear();
            this.lutViewPanel[axis].onUpdate();
            try {
                byte[] data = SerialCommandProcessor.readFile(DialogEncoderLUTCalib.encoderLUTFileId(axis), this);
                if (data == null) continue;
                this.parseEncoderLUT(data, this.lutSeries[axis]);
                this.lutViewPanel[axis].onUpdate();
                this.maxErr[axis].setText(String.format("%.3f", Float.valueOf(this.lutSeries[axis].getDataRange(1))));
                continue;
            }
            catch (FileNotFoundException data) {
                continue;
            }
            catch (Exception e) {
                this.showErrorMessage(e.toString());
            }
        }
    }

    @Action
    public void buttonCalibrateStop() {
        this.sendCalibCommand(8);
    }

    @Action
    public void buttonNewWin() {
        try {
            new TabWindow(this.jPanelPlots, this.getClass(), this.resourceMap.getString("window.title.encoder_lut", new Object[0]), this.jPanelPlotContainer, false, null).showDialog();
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
    }

    @Override
    public boolean onProgressChange(int percent) {
        this.jProgressBar.setValue(percent);
        return true;
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
        this.jProgressBar.setVisible(false);
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
        this.jProgressBar.setVisible(true);
    }

    void parseEncoderLUT(byte[] data, DataViewSeries series) throws Exception {
        SerialCommand cmd = new SerialCommand(0, data);
        int ver = cmd.readByte();
        int size = cmd.readByte();
        cmd.skipBytes(2);
        long offset = cmd.readDWord();
        long range = cmd.readDWord();
        series.clear();
        for (int i = 0; i < size; ++i) {
            int val16 = cmd.readWordUnsigned();
            float err = (float)((double)(offset + (long)val16 * range / 65535L) * 3.4332275390625E-4);
            series.addSample((float)i * 360.0f / (float)size, err);
        }
        series.addSample(series.getSample(0).getX() + 360.0f, series.getSample(0).getY());
    }
}

