/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.object.ExtDeviceInfo;
import sbgc.object.Sprav;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.ExtDeviceFirmwareUpgrader;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.utils.Colored;
import sbgc.ui.utils.StatusBit;
import sbgc.utils.Settings;
import simplebgc_gui.DialogFirmwareUpgrade;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class DialogExtIMUInfo
extends MyDialog
implements Runnable {
    public static final String[][] COLUMNS_XYZ = new String[][]{{"x", "y", "z"}};
    public static final String[][] COLUMNS_NED = new String[][]{{"N", "E", "D"}};
    public static final String[][] COLUMNS_YAW_PITCH_ROLL = new String[][]{{"yaw", "pitch", "roll"}};
    public static final String[][] COLUMNS_LLA = new String[][]{{"lat", "long", "alt"}};
    public static final String FORMAT_FLOAT4 = "%.4f";
    public static final String FORMAT_FLOAT8 = "%.8f";
    public static final String FORMAT_INT = "%d";
    public static final int DATA_TABLE_MAX_COLS = 4;
    public static final int GPS_IMU_CMD_CONFIRM = 1;
    public static final int GPS_IMU_CMD_RESET = 2;
    public static final int GPS_IMU_CMD_RESET_NOTIFY = 3;
    public static final int GPS_IMU_CMD_GET_DEVICE_INFO = 4;
    public static final int GPS_IMU_CMD_DEVICE_INFO = 5;
    public static final int GPS_IMU_CMD_GET_DATA = 6;
    public static final int GPS_IMU_CMD_DATA = 8;
    public static final int GPS_IMU_CMD_CALIBRATE = 9;
    public static final int GPS_IMU_CMD_BOOT_MODE = 10;
    public static final int GPS_IMU_CMD_ERROR = 14;
    public static final int GPS_IMU_CMD_PARAM_GET = 16;
    public static final int GPS_IMU_CMD_PARAM_SET = 17;
    public static final int GPS_IMU_CMD_MIX_DATA = 50;
    public static final String[] AHRS_QUALITY_NAMES = new String[]{"BAD", "COARSE", "GOOD", "FINE"};
    public static final int GPS_IMU_CALIB_SENS_ACC = 1;
    public static final int GPS_IMU_CALIB_SENS_GYRO = 2;
    public static final int GPS_IMU_CALIB_SENS_MAG = 3;
    public static final int GPS_IMU_CALIB_EXT_SENS_GYRO = 4;
    public static final String[] CALIB_SENSOR_NAMES = new String[]{null, "accelerometer", "gyroscope", "magnetometer", "ext.gyroscope"};
    public static final String[] CALIB_ACTION_NAMES = new String[]{"started", "finished successfully", "stage completed", "aborted"};
    public static final int GPS_IMU_CALIB_MODE_SIMPLE = 0;
    public static final int GPS_IMU_CALIB_MODE_EXT = 1;
    public static final int GPS_IMU_CALIB_MODE_ABORT = 2;
    public static final int GPS_IMU_CALIB_MODE_REF = 3;
    static final DataGrid[] DATA_GRID = new DataGrid[]{new DataGrid("TIMESTAMP_MS", "%d", new String[][]{{"ms"}}), new DataGrid("ATTITUDE_QUAT", "%.4f", new String[][]{{"w", "x", "y", "z"}}), new DataGrid("ATTITUDE_EULER", "%.2f\u00b0", COLUMNS_YAW_PITCH_ROLL), new DataGrid("EULER_U", "%.4f\u00b0", COLUMNS_YAW_PITCH_ROLL, Float.valueOf(0.002746624f)), new DataGrid("ACCEL_XYZ", "%.4f", COLUMNS_XYZ), new DataGrid("ACCEL_NED", "%.4f", COLUMNS_NED), new DataGrid("VELO_XYZ", "%.4f", COLUMNS_XYZ), new DataGrid("VELO_NED", "%.4f", COLUMNS_NED), new DataGrid("VELO_U", "%.4f", new String[][]{{"u"}}), new DataGrid("POS_NED", "%.4f", COLUMNS_NED), new DataGrid("POS_LLA", "%.8f", COLUMNS_LLA), new DataGrid("POS_U", "%.4f", new String[][]{{"u"}}), new DataGrid("MAG_XYZ", "%.4f", COLUMNS_XYZ), new DataGrid("MAG_NED", "%.4f", COLUMNS_NED), new DataGrid("GYR_XYZ", "%.4f", COLUMNS_XYZ), new DataGrid("GYR_NED", "%.4f", COLUMNS_NED), new DataGrid("ACC_XYZ", "%.4f", COLUMNS_XYZ), new DataGrid("ACC_NED", "%.4f", COLUMNS_NED), new DataGrid("GNSS_STATE", "%s", new String[][]{{"fix", "sat. num."}}), new DataGrid("GNSS_POS_LLA", "%.8f", COLUMNS_LLA), new DataGrid("GNSS_DOP", "%.4f", new String[][]{{"geometry", "position", "time", "vertical"}, {"horizontal", "northing", "easting"}}), new DataGrid("GNSS_VEL_NED", "%.4f", COLUMNS_NED), new DataGrid("GNSS_VEL_U", "%.4f", new String[][]{{"u"}}), new DataGrid("BARO_PRSR", "%.4f", new String[][]{{"kPa"}}), new DataGrid("BARO_ALT", "%.4f", new String[][]{{"m"}}), new DataGrid("TEMP_BOARD", "%.4f", new String[][]{{"IMU", "Baro", "MCU"}}), new DataGrid("PORT_STAT_CUR", "%d", new String[][]{{"TX_CNT", "TX_ERR_CNT", "RX_CNT", "RX_ERR_CNT"}}), new DataGrid("PORT_STAT_ALL", "%d", new String[][]{{"TX_CNT", "TX_ERR_CNT", "RX_CNT", "RX_ERR_CNT"}}), new DataGrid("UTC_DATE", "%d", new String[][]{{"YEAR", "MONTH", "DAY"}}), new DataGrid("UTC_TIME", "%d", new String[][]{{"HOUR", "MINUTE", "SECOND"}})};
    static final HashMap<String, DataGrid> dataGridByName;
    static final DataBitField[] DATA_BIT_FIELDS;
    static StatusBit[] HW_STATUS_BITS;
    static StatusBit[] AHRS_STATUS_BITS;
    public static final String[] GNSS_STATE_FIX;
    public static final int ROLE_MAIN_IMU = 0;
    public static final int ROLE_FRAME_IMU = 1;
    public static final int ROLE_EXT_IMU = 2;
    public static final String[] ROLE_NAMES;
    public static final int EXT_IMU_MODEL_GPS_IMU_UART = 5;
    SimpleBGC_GUIView mainView = null;
    boolean isConnected = false;
    int ahrs_status = -1;
    int hw_status = -1;
    int[] sensor_fusion_qlt = null;
    long ext_sens_status;
    int curSensCalib = 0;
    ExtDeviceInfo extDeviceInfo = null;
    DialogFirmwareUpgrade dialogFirmwareUpgrade = null;
    final int role;
    final int model;
    final int wrapCmdId;
    ArrayList<Integer> paramsRead = null;
    final Component[] debugControls;
    final JSpinner[] spinnerExtGyroScale;
    final JSpinner[] spinnerWeight;
    static final String[] SENSORS_FUSION_LIST;
    private JPanel groupCalib;
    private JPanel groupFilterMode;
    private JButton jButtonAccExt;
    private JButton jButtonCalibACC;
    private JButton jButtonCalibAccAlign;
    private JButton jButtonCalibExtGyroAlign;
    private JButton jButtonCalibExtGyroBias;
    private JButton jButtonCalibGyro;
    private JButton jButtonCalibMag;
    private JButton jButtonFirmwareUpdateFile;
    private JButton jButtonRead;
    private JButton jButtonReset;
    private JButton jButtonSNCopy;
    private JButton jButtonStopCalib;
    private JButton jButtonWrite;
    private JCheckBox jCBDontUpdGyroBiasX;
    private JCheckBox jCBDontUpdGyroBiasY;
    private JCheckBox jCBDontUpdGyroBiasZ;
    private JCheckBox jCBUseMotionDet;
    private JCheckBox jCheckBoxDisableMag;
    private JCheckBox jCheckBoxEuler312;
    private JCheckBox jCheckBoxExtGyroDisable;
    private JCheckBox jCheckBoxGNSSHeading;
    private JCheckBox jCheckBoxSaveSD;
    private JCheckBox jCheckBoxTestMixData;
    private JCheckBox jCheckBoxVH_SAPI;
    private JCheckBox jCheckBoxVH_SBGC;
    private JComboBox jComboBoxDynamicModel;
    private JComboBox jComboBoxGNSSMode;
    private JComboBox jComboBoxMagAutoCalib;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JLabel jLabelACCWeight;
    private JLabel jLabelCalibInfo;
    private JLabel jLabelCalibStatus;
    private JLabel jLabelCalibTooltip;
    private JLabel jLabelCalibrate;
    private JLabel jLabelDeviceSN;
    private JLabel jLabelDontUpdateGyroBias;
    private JLabel jLabelDynamicModel;
    private JLabel jLabelGNSSWeight;
    private JLabel jLabelMagWeight;
    private JLabel jLabelMotDetThreshold;
    private JLabel jLabelStatus;
    private JLabel jLabelTestVeloU;
    private JPanel jPanelControl;
    private JProgressBar jProgressBarCalibProgress;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerAccWeight;
    private JSpinner jSpinnerExtGyroScaleX;
    private JSpinner jSpinnerExtGyroScaleY;
    private JSpinner jSpinnerExtGyroScaleZ;
    private JSpinner jSpinnerGNSSWeight;
    private JSpinner jSpinnerMagWeight;
    private JSpinner jSpinnerMotDetThreshold;
    private JSpinner jSpinnerTestVeloU;
    private JPanel jTabPanelCalib;
    private JPanel jTabPanelConfig;
    private JPanel jTabPanelStatus;
    private JTabbedPane jTabbedPane;
    private JTable jTableData;
    private JTextField jTextFieldDeviceSN;
    static StatusBit[] EXT_SENS_STATUS_BITS;
    public static final int EXT_SENS_GYRO_ENABLED_BIT = 1;
    public static final int PARAM_ID_FILTER_MODE_FLAGS = 1;
    public static final int PARAM_ID_MAG_AUTO_CALIB2 = 2;
    public static final int PARAM_ID_EXT_GYR_SCALE_X = 3;
    public static final int PARAM_ID_EXT_GYR_SCALE_Y = 4;
    public static final int PARAM_ID_EXT_GYR_SCALE_Z = 5;
    public static final int PARAM_ID_ACC_WEIGHT = 6;
    public static final int PARAM_ID_GNSS_WEIGHT = 7;
    public static final int PARAM_ID_MAG_WEIGHT = 8;
    public static final int PARAM_ID_MAG_DECL_FORCE = 9;
    public static final int PARAM_ID_DYNAMIC_MODEL = 10;
    public static final int PARAM_ID_MOT_DET_THRESHOLD = 11;
    public static final long FM_FLAG_VH_SBGC = 1L;
    public static final long FM_FLAG_VH_SAPI = 2L;
    public static final long FM_FLAG_DISABLE_MAG = 4L;
    public static final long FM_FLAG_GNSS_HEADING = 64L;
    public static final long FM_FLAG_DONT_UPD_GYRO_BIAS_X = 128L;
    public static final long FM_FLAG_DONT_UPD_GYRO_BIAS_Y = 256L;
    public static final long FM_FLAG_DONT_UPD_GYRO_BIAS_Z = 512L;
    public static final long FM_FLAG_EXT_GYRO_DISABLE = 1024L;
    public static final long FM_FLAG_EULER_312 = 2048L;
    public static final long FM_FLAG_DISABLE_MOTION_DET = 4096L;
    boolean calibACCExtStarted = false;

    public static String getCalibSensorName(int sens_id) {
        return sens_id < CALIB_SENSOR_NAMES.length ? CALIB_SENSOR_NAMES[sens_id] : "sensor <" + sens_id + ">";
    }

    public static String getCalibActionName(int action) {
        return action < CALIB_ACTION_NAMES.length ? CALIB_ACTION_NAMES[action] : "action <" + action + ">";
    }

    public DialogExtIMUInfo(SimpleBGC_GUIView mainView, int model, int role) {
        super(DialogExtIMUInfo.class, mainView.getFrame(), SimpleBGC_GUIApp.getResourceMap(DialogExtIMUInfo.class).getString("Form.title", new Object[0]), false);
        this.RestoreSizePos("ext_imu_info");
        this.mainView = mainView;
        this.model = model;
        this.role = role;
        this.wrapCmdId = this.role == 2 ? 110 : 150;
        this.initComponents();
        this.spinnerExtGyroScale = new JSpinner[]{this.jSpinnerExtGyroScaleX, this.jSpinnerExtGyroScaleY, this.jSpinnerExtGyroScaleZ};
        this.spinnerWeight = new JSpinner[]{this.jSpinnerAccWeight, this.jSpinnerGNSSWeight, this.jSpinnerMagWeight};
        this.setTitle(this.resourceMap.getString("Form.title", DialogExtIMUInfo.getIMUFullName(role, model)));
        DefaultTableModel table = (DefaultTableModel)this.jTableData.getModel();
        Object[] row = new Object[9];
        int rowCnt = 0;
        for (DataGrid dg : DATA_GRID) {
            for (int subRow = 0; subRow < dg.columns.length; ++subRow) {
                for (int i = 0; i < 4; ++i) {
                    row[i * 2 + 1] = i < dg.columns[subRow].length ? dg.columns[subRow][i] : null;
                    row[i * 2 + 2] = null;
                }
                if (subRow == 0) {
                    row[0] = dg.name;
                    dg.row = rowCnt;
                } else {
                    row[0] = null;
                }
                table.addRow(row);
                ++rowCnt;
            }
        }
        DefaultTableCellRenderer r = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 0) {
                    c.setFont(c.getFont().deriveFont(1));
                    this.setForeground(Color.WHITE);
                } else if (column % 2 == 1) {
                    this.setForeground(Color.GRAY);
                } else {
                    this.setForeground(Color.WHITE);
                }
                return c;
            }
        };
        this.jTableData.setDefaultRenderer(String.class, r);
        this.setTooltipViewer(this.jLabelCalibTooltip, this.jTabPanelCalib);
        if (role == 0) {
            this.jButtonReset.setVisible(false);
        }
        for (Component c : this.debugControls = new Component[]{this.jCheckBoxTestMixData, this.jButtonAccExt, this.jLabelTestVeloU, this.jSpinnerTestVeloU}) {
            c.setVisible(false);
        }
        for (int i = 0; i < 3; ++i) {
            this.spinnerExtGyroScale[i].setEditor(new JSpinner.NumberEditor(this.spinnerExtGyroScale[i], "0.######"));
        }
        this.jComboBoxGNSSMode.setModel(new SpravComboBoxModel(new ArrayList<Sprav>(Arrays.asList(new Sprav(0, "Enable GNSS"), new Sprav(1, "Disable GNSS"), new Sprav(2, "Disable GNSS on poor signal quality"), new Sprav(3, "Disable GNSS in static conditions")))));
        this.jComboBoxMagAutoCalib.setModel(new SpravComboBoxModel(new ArrayList<Sprav>(Arrays.asList(new Sprav(0, "Disabled"), new Sprav(1, "On rotations"), new Sprav(2, "On rotations & external magnetic disturbances")))));
        this.jComboBoxDynamicModel.setModel(new SpravComboBoxModel(new ArrayList<Sprav>(Arrays.asList(new Sprav(0, "PORTABLE"), new Sprav(2, "STATIONARY"), new Sprav(3, "PEDESTRIAN"), new Sprav(4, "AUTOMOTIVE"), new Sprav(5, "SEA"), new Sprav(6, "AIRBORNE_1G"), new Sprav(7, "AIRBORNE_2G"), new Sprav(8, "AIRBORNE_4G")))));
        this.beforeReadParams();
    }

    public void startThread() {
        new Thread(this).start();
    }

    @Override
    public void onCloseDialog() {
    }

    void setData(DataBitField f, Number[] data) {
        Object[] show_data = data;
        if (data != null) {
            if (f.name.equals("GNSS_STATE")) {
                int fix = data[0].intValue();
                show_data = new String[]{fix >= 0 && fix < GNSS_STATE_FIX.length ? GNSS_STATE_FIX[fix] : "unknown", data[1].toString()};
            } else if (f.name.equals("CALIB_STATUS")) {
                this.curSensCalib = data[0].intValue();
                int progress = data[1].intValue();
                boolean inProgress = false;
                if (this.curSensCalib > 0) {
                    inProgress = true;
                    String sens_name = DialogExtIMUInfo.getCalibSensorName(this.curSensCalib);
                    String state_name = "collecting data";
                    if (progress > 100) {
                        state_name = progress == 101 ? "idle" : (progress == 102 ? "prepearing" : (progress == 103 ? "collecting data" : (progress == 104 ? "finishing" : (progress == 105 ? "waiting user action" : "unknown <" + progress + ">"))));
                        progress = 0;
                    }
                    this.jLabelCalibStatus.setText("Calibrating " + sens_name + ": " + state_name);
                } else {
                    progress = 0;
                }
                this.jProgressBarCalibProgress.setValue(progress);
                this.jProgressBarCalibProgress.setEnabled(inProgress);
                this.jButtonStopCalib.setEnabled(inProgress);
                this.jLabelCalibStatus.setEnabled(inProgress);
            }
        } else {
            show_data = new String[f.length];
            Arrays.fill(show_data, "x");
        }
        DataGrid dg = dataGridByName.get(f.name);
        if (dg != null) {
            int col = 0;
            int subRow = 0;
            for (int data_idx = 0; data_idx < show_data.length; ++data_idx) {
                this.jTableData.setValueAt(String.format(dg.format, dg.scale != null && show_data[data_idx] instanceof Number ? Float.valueOf(((Number)show_data[data_idx]).floatValue() * dg.scale.floatValue()) : show_data[data_idx]), dg.row + subRow, col * 2 + 2);
                if (++col < dg.columns[subRow].length) continue;
                col = 0;
                if (++subRow > dg.columns.length) break;
            }
        }
    }

    void updateStatusInfo() {
        StringBuilder s = new StringBuilder("<html>");
        if (this.extDeviceInfo != null) {
            s.append("VERSION: ");
            s.append(this.extDeviceInfo.versionStr);
            s.append("<br>");
            if (!this.jTextFieldDeviceSN.getText().equals(this.extDeviceInfo.device_id)) {
                this.jTextFieldDeviceSN.setText(this.extDeviceInfo.device_id);
            }
        }
        s.append("HW STATUS: ");
        StatusBit.format_html(s, HW_STATUS_BITS, this.hw_status);
        s.append("<br>AHRS STATUS: ");
        StatusBit.format_html(s, AHRS_STATUS_BITS, this.ahrs_status);
        if (this.ext_sens_status != 0L) {
            s.append("<br>EXT.SENS STATUS: " + DialogExtIMUInfo.formatExtSensStatus(this.ext_sens_status));
        }
        boolean ext_gyro_enabled = (this.ext_sens_status & 1L) != 0L;
        this.jButtonCalibExtGyroBias.setEnabled(ext_gyro_enabled);
        this.jButtonCalibExtGyroAlign.setEnabled(ext_gyro_enabled);
        s.append("<br>SOLUTION QUALITY: ");
        int quality = this.ahrs_status >> 4 & 3;
        String color = quality > 1 ? "#33FF99" : "#FF5566";
        s.append("<font color=\"" + color + "\">");
        if (color.equals("#FF5566")) {
            s.append("<b>");
        }
        s.append(AHRS_QUALITY_NAMES[quality]);
        if (color.equals("#FF5566")) {
            s.append("</b>");
        }
        s.append("</font>");
        if (this.sensor_fusion_qlt != null) {
            s.append(", SENS.FUSION QUALITY: ");
            for (int i = 0; i < SENSORS_FUSION_LIST.length; ++i) {
                if (i >= this.sensor_fusion_qlt.length) continue;
                if (i > 0) {
                    s.append(", ");
                }
                s.append(SENSORS_FUSION_LIST[i] + ": " + Integer.toString(this.sensor_fusion_qlt[i] * 100 / 255) + "%");
            }
        }
        s.append("<br>");
        s.append("</html>");
        this.jLabelStatus.setText(s.toString());
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jTabPanelStatus = new JPanel();
        this.jLabelStatus = new JLabel();
        this.jPanelControl = new JPanel();
        this.jButtonFirmwareUpdateFile = new JButton();
        this.jButtonReset = new JButton();
        this.jLabelDeviceSN = new JLabel();
        this.jTextFieldDeviceSN = new JTextField();
        this.jButtonSNCopy = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableData = new JTable();
        this.jTabPanelConfig = new JPanel();
        this.jButtonRead = new JButton();
        this.jButtonWrite = new JButton();
        this.jCheckBoxSaveSD = new JCheckBox();
        this.groupFilterMode = new JPanel();
        this.jCheckBoxVH_SBGC = new JCheckBox();
        this.jCheckBoxVH_SAPI = new JCheckBox();
        this.jCheckBoxDisableMag = new JCheckBox();
        this.jComboBoxGNSSMode = new JComboBox();
        this.jCheckBoxGNSSHeading = new JCheckBox();
        this.jLabelDynamicModel = new JLabel();
        this.jComboBoxDynamicModel = new JComboBox();
        this.jLabelACCWeight = new JLabel();
        this.jSpinnerAccWeight = new JSpinner();
        this.jLabelGNSSWeight = new JLabel();
        this.jSpinnerGNSSWeight = new JSpinner();
        this.jLabelMagWeight = new JLabel();
        this.jSpinnerMagWeight = new JSpinner();
        this.jLabelDontUpdateGyroBias = new JLabel();
        this.jCBDontUpdGyroBiasY = new JCheckBox();
        this.jCBDontUpdGyroBiasZ = new JCheckBox();
        this.jCBDontUpdGyroBiasX = new JCheckBox();
        this.jCheckBoxExtGyroDisable = new JCheckBox();
        this.jCheckBoxEuler312 = new JCheckBox();
        this.jCBUseMotionDet = new JCheckBox();
        this.jSpinnerMotDetThreshold = new JSpinner();
        this.jLabelMotDetThreshold = new JLabel();
        this.groupCalib = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxMagAutoCalib = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jSpinnerExtGyroScaleX = new JSpinner();
        this.jSpinnerExtGyroScaleY = new JSpinner();
        this.jSpinnerExtGyroScaleZ = new JSpinner();
        this.jCheckBoxTestMixData = new JCheckBox();
        this.jLabelTestVeloU = new JLabel();
        this.jSpinnerTestVeloU = new JSpinner();
        this.jTabPanelCalib = new JPanel();
        this.jLabelCalibrate = new JLabel();
        this.jButtonCalibACC = new JButton();
        this.jButtonCalibGyro = new JButton();
        this.jButtonCalibMag = new JButton();
        this.jButtonCalibExtGyroBias = new JButton();
        this.jButtonCalibExtGyroAlign = new JButton();
        this.jProgressBarCalibProgress = new JProgressBar();
        this.jButtonStopCalib = new JButton();
        this.jLabelCalibStatus = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabelCalibTooltip = new JLabel();
        this.jButtonCalibAccAlign = new JButton();
        this.jLabelCalibInfo = new JLabel();
        this.jButtonAccExt = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogExtIMUInfo.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(700, 500));
        this.setModal(true);
        this.setName("Form");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTabbedPane.setName("jTabbedPane");
        this.jTabPanelStatus.setName("jTabPanelStatus");
        this.jTabPanelStatus.setLayout(new GridBagLayout());
        this.jLabelStatus.setText(resourceMap.getString("jLabelStatus.text", new Object[0]));
        this.jLabelStatus.setName("jLabelStatus");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jTabPanelStatus.add((Component)this.jLabelStatus, gridBagConstraints);
        this.jPanelControl.setName("jPanelControl");
        this.jPanelControl.setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogExtIMUInfo.class, this);
        this.jButtonFirmwareUpdateFile.setAction(actionMap.get("buttonFirmwareUpdateFile"));
        this.jButtonFirmwareUpdateFile.setText(resourceMap.getString("jButtonFirmwareUpdateFile.text", new Object[0]));
        this.jButtonFirmwareUpdateFile.setName("jButtonFirmwareUpdateFile");
        this.jPanelControl.add((Component)this.jButtonFirmwareUpdateFile, new AbsoluteConstraints(360, 10, 160, 25));
        this.jButtonReset.setAction(actionMap.get("buttonReset"));
        this.jButtonReset.setToolTipText(resourceMap.getString("jButtonReset.toolTipText", new Object[0]));
        this.jButtonReset.setName("jButtonReset");
        this.jPanelControl.add((Component)this.jButtonReset, new AbsoluteConstraints(330, 10, 25, 25));
        this.jLabelDeviceSN.setText(resourceMap.getString("jLabelDeviceSN.text", new Object[0]));
        this.jLabelDeviceSN.setName("jLabelDeviceSN");
        this.jPanelControl.add((Component)this.jLabelDeviceSN, new AbsoluteConstraints(10, 10, 90, -1));
        this.jTextFieldDeviceSN.setEditable(false);
        this.jTextFieldDeviceSN.setName("jTextFieldDeviceSN");
        this.jPanelControl.add((Component)this.jTextFieldDeviceSN, new AbsoluteConstraints(110, 10, 150, -1));
        this.jButtonSNCopy.setAction(actionMap.get("buttonDeviceSNCopyClipboard"));
        this.jButtonSNCopy.setToolTipText(resourceMap.getString("jButtonSNCopy.toolTipText", new Object[0]));
        this.jButtonSNCopy.setName("jButtonSNCopy");
        this.jPanelControl.add((Component)this.jButtonSNCopy, new AbsoluteConstraints(270, 10, 25, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.jTabPanelStatus.add((Component)this.jPanelControl, gridBagConstraints);
        this.jScrollPane1.setName("jScrollPane1");
        this.jScrollPane1.setPreferredSize(new Dimension(800, 402));
        this.jTableData.setModel(new DefaultTableModel(new Object[0][], new String[]{"variable", "", "", "", "", "", "", "", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableData.setMinimumSize(new Dimension(500, 0));
        this.jTableData.setName("jTableData");
        this.jScrollPane1.setViewportView(this.jTableData);
        this.jTableData.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.jTableData.getColumnModel().getColumn(1).setPreferredWidth(5);
        this.jTableData.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("jTableData.columnModel.title1", new Object[0]));
        this.jTableData.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.jTableData.getColumnModel().getColumn(2).setHeaderValue(resourceMap.getString("jTableData.columnModel.title2", new Object[0]));
        this.jTableData.getColumnModel().getColumn(3).setPreferredWidth(5);
        this.jTableData.getColumnModel().getColumn(3).setHeaderValue(resourceMap.getString("jTableData.columnModel.title3", new Object[0]));
        this.jTableData.getColumnModel().getColumn(4).setPreferredWidth(50);
        this.jTableData.getColumnModel().getColumn(4).setHeaderValue(resourceMap.getString("jTableData.columnModel.title4", new Object[0]));
        this.jTableData.getColumnModel().getColumn(5).setPreferredWidth(5);
        this.jTableData.getColumnModel().getColumn(5).setHeaderValue(resourceMap.getString("jTableData.columnModel.title5", new Object[0]));
        this.jTableData.getColumnModel().getColumn(6).setPreferredWidth(50);
        this.jTableData.getColumnModel().getColumn(6).setHeaderValue(resourceMap.getString("jTableData.columnModel.title6", new Object[0]));
        this.jTableData.getColumnModel().getColumn(7).setPreferredWidth(5);
        this.jTableData.getColumnModel().getColumn(7).setHeaderValue(resourceMap.getString("jTableData.columnModel.title7", new Object[0]));
        this.jTableData.getColumnModel().getColumn(8).setPreferredWidth(50);
        this.jTableData.getColumnModel().getColumn(8).setHeaderValue(resourceMap.getString("jTableData.columnModel.title8", new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jTabPanelStatus.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jTabbedPane.addTab(resourceMap.getString("jTabPanelStatus.TabConstraints.tabTitle", new Object[0]), this.jTabPanelStatus);
        this.jTabPanelConfig.setName("jTabPanelConfig");
        this.jTabPanelConfig.setLayout((LayoutManager)new AbsoluteLayout());
        this.jButtonRead.setAction(actionMap.get("buttonRead"));
        this.jButtonRead.setText(resourceMap.getString("jButtonRead.text", new Object[0]));
        this.jButtonRead.setName("jButtonRead");
        this.jTabPanelConfig.add((Component)this.jButtonRead, new AbsoluteConstraints(380, 20, 130, 30));
        this.jButtonWrite.setAction(actionMap.get("buttonWrite"));
        this.jButtonWrite.setText(resourceMap.getString("jButtonWrite.text", new Object[0]));
        this.jButtonWrite.setName("jButtonWrite");
        this.jTabPanelConfig.add((Component)this.jButtonWrite, new AbsoluteConstraints(380, 60, 130, 30));
        this.jCheckBoxSaveSD.setText(resourceMap.getString("jCheckBoxSaveSD.text", new Object[0]));
        this.jCheckBoxSaveSD.setName("jCheckBoxSaveSD");
        this.jTabPanelConfig.add((Component)this.jCheckBoxSaveSD, new AbsoluteConstraints(390, 100, -1, -1));
        this.groupFilterMode.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupFilterMode.border.title", new Object[0])));
        this.groupFilterMode.setName("groupFilterMode");
        this.groupFilterMode.setLayout((LayoutManager)new AbsoluteLayout());
        this.jCheckBoxVH_SBGC.setText(resourceMap.getString("jCheckBoxVH_SBGC.text", new Object[0]));
        this.jCheckBoxVH_SBGC.setName("jCheckBoxVH_SBGC");
        this.groupFilterMode.add((Component)this.jCheckBoxVH_SBGC, new AbsoluteConstraints(20, 20, -1, -1));
        this.jCheckBoxVH_SAPI.setText(resourceMap.getString("jCheckBoxVH_SAPI.text", new Object[0]));
        this.jCheckBoxVH_SAPI.setName("jCheckBoxVH_SAPI");
        this.groupFilterMode.add((Component)this.jCheckBoxVH_SAPI, new AbsoluteConstraints(20, 40, -1, -1));
        this.jCheckBoxDisableMag.setText(resourceMap.getString("jCheckBoxDisableMag.text", new Object[0]));
        this.jCheckBoxDisableMag.setName("jCheckBoxDisableMag");
        this.groupFilterMode.add((Component)this.jCheckBoxDisableMag, new AbsoluteConstraints(20, 60, -1, -1));
        this.jComboBoxGNSSMode.setName("jComboBoxGNSSMode");
        this.groupFilterMode.add((Component)this.jComboBoxGNSSMode, new AbsoluteConstraints(20, 90, 310, -1));
        this.jCheckBoxGNSSHeading.setText(resourceMap.getString("jCheckBoxGNSSHeading.text", new Object[0]));
        this.jCheckBoxGNSSHeading.setToolTipText(resourceMap.getString("jCheckBoxGNSSHeading.toolTipText", new Object[0]));
        this.jCheckBoxGNSSHeading.setName("jCheckBoxGNSSHeading");
        this.groupFilterMode.add((Component)this.jCheckBoxGNSSHeading, new AbsoluteConstraints(40, 120, -1, -1));
        this.jLabelDynamicModel.setText(resourceMap.getString("jLabelDynamicModel.text", new Object[0]));
        this.jLabelDynamicModel.setToolTipText(resourceMap.getString("jLabelDynamicModel.toolTipText", new Object[0]));
        this.jLabelDynamicModel.setName("jLabelDynamicModel");
        this.groupFilterMode.add((Component)this.jLabelDynamicModel, new AbsoluteConstraints(50, 150, 160, -1));
        this.jComboBoxDynamicModel.setName("jComboBoxDynamicModel");
        this.groupFilterMode.add((Component)this.jComboBoxDynamicModel, new AbsoluteConstraints(220, 150, 120, -1));
        this.jLabelACCWeight.setText(resourceMap.getString("jLabelACCWeight.text", new Object[0]));
        this.jLabelACCWeight.setName("jLabelACCWeight");
        this.groupFilterMode.add((Component)this.jLabelACCWeight, new AbsoluteConstraints(20, 180, 230, -1));
        this.jSpinnerAccWeight.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.001f), Float.valueOf(1000.0f), Float.valueOf(0.01f)));
        this.jSpinnerAccWeight.setToolTipText(resourceMap.getString("jSpinnerAccWeight.toolTipText", new Object[0]));
        this.jSpinnerAccWeight.setName("jSpinnerAccWeight");
        this.groupFilterMode.add((Component)this.jSpinnerAccWeight, new AbsoluteConstraints(270, 180, 70, -1));
        this.jLabelGNSSWeight.setText(resourceMap.getString("jLabelGNSSWeight.text", new Object[0]));
        this.jLabelGNSSWeight.setName("jLabelGNSSWeight");
        this.groupFilterMode.add((Component)this.jLabelGNSSWeight, new AbsoluteConstraints(20, 210, 230, -1));
        this.jSpinnerGNSSWeight.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.01f), Float.valueOf(100.0f), Float.valueOf(0.01f)));
        this.jSpinnerGNSSWeight.setName("jSpinnerGNSSWeight");
        this.groupFilterMode.add((Component)this.jSpinnerGNSSWeight, new AbsoluteConstraints(270, 210, 70, -1));
        this.jLabelMagWeight.setText(resourceMap.getString("jLabelMagWeight.text", new Object[0]));
        this.jLabelMagWeight.setName("jLabelMagWeight");
        this.groupFilterMode.add((Component)this.jLabelMagWeight, new AbsoluteConstraints(20, 240, 230, -1));
        this.jSpinnerMagWeight.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.001f), Float.valueOf(1000.0f), Float.valueOf(0.01f)));
        this.jSpinnerMagWeight.setName("jSpinnerMagWeight");
        this.groupFilterMode.add((Component)this.jSpinnerMagWeight, new AbsoluteConstraints(270, 240, 70, -1));
        this.jLabelDontUpdateGyroBias.setText(resourceMap.getString("jLabelDontUpdateGyroBias.text", new Object[0]));
        this.jLabelDontUpdateGyroBias.setName("jLabelDontUpdateGyroBias");
        this.groupFilterMode.add((Component)this.jLabelDontUpdateGyroBias, new AbsoluteConstraints(20, 270, -1, -1));
        this.jCBDontUpdGyroBiasY.setText(resourceMap.getString("jCBDontUpdGyroBiasY.text", new Object[0]));
        this.jCBDontUpdGyroBiasY.setToolTipText(resourceMap.getString("jCBDontUpdGyroBiasX.toolTipText", new Object[0]));
        this.jCBDontUpdGyroBiasY.setName("jCBDontUpdGyroBiasY");
        this.groupFilterMode.add((Component)this.jCBDontUpdGyroBiasY, new AbsoluteConstraints(260, 270, -1, -1));
        this.jCBDontUpdGyroBiasZ.setText(resourceMap.getString("jCBDontUpdGyroBiasZ.text", new Object[0]));
        this.jCBDontUpdGyroBiasZ.setToolTipText(resourceMap.getString("jCBDontUpdGyroBiasX.toolTipText", new Object[0]));
        this.jCBDontUpdGyroBiasZ.setName("jCBDontUpdGyroBiasZ");
        this.groupFilterMode.add((Component)this.jCBDontUpdGyroBiasZ, new AbsoluteConstraints(300, 270, -1, -1));
        this.jCBDontUpdGyroBiasX.setText(resourceMap.getString("jCBDontUpdGyroBiasX.text", new Object[0]));
        this.jCBDontUpdGyroBiasX.setToolTipText(resourceMap.getString("jCBDontUpdGyroBiasX.toolTipText", new Object[0]));
        this.jCBDontUpdGyroBiasX.setName("jCBDontUpdGyroBiasX");
        this.groupFilterMode.add((Component)this.jCBDontUpdGyroBiasX, new AbsoluteConstraints(220, 270, -1, -1));
        this.jCheckBoxExtGyroDisable.setText(resourceMap.getString("jCheckBoxExtGyroDisable.text", new Object[0]));
        this.jCheckBoxExtGyroDisable.setToolTipText(resourceMap.getString("jCheckBoxExtGyroDisable.toolTipText", new Object[0]));
        this.jCheckBoxExtGyroDisable.setName("jCheckBoxExtGyroDisable");
        this.groupFilterMode.add((Component)this.jCheckBoxExtGyroDisable, new AbsoluteConstraints(20, 290, -1, -1));
        this.jCheckBoxEuler312.setText(resourceMap.getString("jCheckBoxEuler312.text", new Object[0]));
        this.jCheckBoxEuler312.setToolTipText(resourceMap.getString("jCheckBoxEuler312.toolTipText", new Object[0]));
        this.jCheckBoxEuler312.setName("jCheckBoxEuler312");
        this.groupFilterMode.add((Component)this.jCheckBoxEuler312, new AbsoluteConstraints(20, 310, -1, -1));
        this.jCBUseMotionDet.setText(resourceMap.getString("jCBUseMotionDet.text", new Object[0]));
        this.jCBUseMotionDet.setToolTipText(resourceMap.getString("jCBUseMotionDet.toolTipText", new Object[0]));
        this.jCBUseMotionDet.setName("jCBUseMotionDet");
        this.groupFilterMode.add((Component)this.jCBUseMotionDet, new AbsoluteConstraints(20, 330, -1, -1));
        this.jSpinnerMotDetThreshold.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), null, null, Float.valueOf(10.0f)));
        this.jSpinnerMotDetThreshold.setToolTipText(resourceMap.getString("jSpinnerMotDetThreshold.toolTipText", new Object[0]));
        this.jSpinnerMotDetThreshold.setName("jSpinnerMotDetThreshold");
        this.groupFilterMode.add((Component)this.jSpinnerMotDetThreshold, new AbsoluteConstraints(270, 360, 70, -1));
        this.jLabelMotDetThreshold.setText(resourceMap.getString("jLabelMotDetThreshold.text", new Object[0]));
        this.jLabelMotDetThreshold.setName("jLabelMotDetThreshold");
        this.groupFilterMode.add((Component)this.jLabelMotDetThreshold, new AbsoluteConstraints(60, 360, 210, -1));
        this.jTabPanelConfig.add((Component)this.groupFilterMode, new AbsoluteConstraints(10, 10, 360, 400));
        this.groupCalib.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupCalib.border.title", new Object[0])));
        this.groupCalib.setName("groupCalib");
        this.groupCalib.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.groupCalib.add((Component)this.jLabel2, new AbsoluteConstraints(20, 30, -1, -1));
        this.jComboBoxMagAutoCalib.setName("jComboBoxMagAutoCalib");
        this.groupCalib.add((Component)this.jComboBoxMagAutoCalib, new AbsoluteConstraints(20, 50, 310, -1));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.groupCalib.add((Component)this.jLabel3, new AbsoluteConstraints(20, 90, -1, -1));
        this.jSpinnerExtGyroScaleX.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        this.jSpinnerExtGyroScaleX.setName("jSpinnerExtGyroScaleX");
        this.groupCalib.add((Component)this.jSpinnerExtGyroScaleX, new AbsoluteConstraints(20, 110, 90, -1));
        this.jSpinnerExtGyroScaleY.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        this.jSpinnerExtGyroScaleY.setName("jSpinnerExtGyroScaleY");
        this.groupCalib.add((Component)this.jSpinnerExtGyroScaleY, new AbsoluteConstraints(130, 110, 90, -1));
        this.jSpinnerExtGyroScaleZ.setModel(new SpinnerNumberModel((Number)0.0, null, null, (Number)1.0));
        this.jSpinnerExtGyroScaleZ.setName("jSpinnerExtGyroScaleZ");
        this.groupCalib.add((Component)this.jSpinnerExtGyroScaleZ, new AbsoluteConstraints(240, 110, 90, -1));
        this.jTabPanelConfig.add((Component)this.groupCalib, new AbsoluteConstraints(10, 410, 360, 160));
        this.jCheckBoxTestMixData.setText(resourceMap.getString("jCheckBoxTestMixData.text", new Object[0]));
        this.jCheckBoxTestMixData.setToolTipText(resourceMap.getString("jCheckBoxTestMixData.toolTipText", new Object[0]));
        this.jCheckBoxTestMixData.setName("jCheckBoxTestMixData");
        this.jTabPanelConfig.add((Component)this.jCheckBoxTestMixData, new AbsoluteConstraints(390, 170, -1, -1));
        this.jLabelTestVeloU.setText(resourceMap.getString("jLabelTestVeloU.text", new Object[0]));
        this.jLabelTestVeloU.setName("jLabelTestVeloU");
        this.jTabPanelConfig.add((Component)this.jLabelTestVeloU, new AbsoluteConstraints(390, 200, -1, -1));
        this.jSpinnerTestVeloU.setModel(new SpinnerNumberModel(Float.valueOf(0.3f), Float.valueOf(0.0f), Float.valueOf(6.5f), Float.valueOf(0.01f)));
        this.jSpinnerTestVeloU.setName("jSpinnerTestVeloU");
        this.jTabPanelConfig.add((Component)this.jSpinnerTestVeloU, new AbsoluteConstraints(440, 200, 60, -1));
        this.jTabbedPane.addTab(resourceMap.getString("jTabPanelConfig.TabConstraints.tabTitle", new Object[0]), this.jTabPanelConfig);
        this.jTabPanelCalib.setName("jTabPanelCalib");
        this.jTabPanelCalib.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelCalibrate.setText(resourceMap.getString("jLabelCalibrate.text", new Object[0]));
        this.jLabelCalibrate.setName("jLabelCalibrate");
        this.jTabPanelCalib.add((Component)this.jLabelCalibrate, new AbsoluteConstraints(10, 20, 120, -1));
        this.jButtonCalibACC.setAction(actionMap.get("buttonCalibACC"));
        this.jButtonCalibACC.setText(resourceMap.getString("jButtonCalibACC.text", new Object[0]));
        this.jButtonCalibACC.setToolTipText(resourceMap.getString("jButtonCalibACC.toolTipText", new Object[0]));
        this.jButtonCalibACC.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCalibACC.setName("jButtonCalibACC");
        this.jTabPanelCalib.add((Component)this.jButtonCalibACC, new AbsoluteConstraints(130, 20, 110, 25));
        this.jButtonCalibGyro.setAction(actionMap.get("buttonCalibGyro"));
        this.jButtonCalibGyro.setText(resourceMap.getString("jButtonCalibGyro.text", new Object[0]));
        this.jButtonCalibGyro.setToolTipText(resourceMap.getString("jButtonCalibGyro.toolTipText", new Object[0]));
        this.jButtonCalibGyro.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCalibGyro.setName("jButtonCalibGyro");
        this.jTabPanelCalib.add((Component)this.jButtonCalibGyro, new AbsoluteConstraints(250, 20, 110, 25));
        this.jButtonCalibMag.setAction(actionMap.get("buttonCalibMag"));
        this.jButtonCalibMag.setText(resourceMap.getString("jButtonCalibMag.text", new Object[0]));
        this.jButtonCalibMag.setToolTipText(resourceMap.getString("jButtonCalibMag.toolTipText", new Object[0]));
        this.jButtonCalibMag.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCalibMag.setName("jButtonCalibMag");
        this.jTabPanelCalib.add((Component)this.jButtonCalibMag, new AbsoluteConstraints(370, 20, 120, 25));
        this.jButtonCalibExtGyroBias.setAction(actionMap.get("buttonCalibExtGyro"));
        this.jButtonCalibExtGyroBias.setText(resourceMap.getString("jButtonCalibExtGyroBias.text", new Object[0]));
        this.jButtonCalibExtGyroBias.setToolTipText(resourceMap.getString("jButtonCalibExtGyroBias.toolTipText", new Object[0]));
        this.jButtonCalibExtGyroBias.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCalibExtGyroBias.setName("jButtonCalibExtGyroBias");
        this.jTabPanelCalib.add((Component)this.jButtonCalibExtGyroBias, new AbsoluteConstraints(130, 60, 110, 25));
        this.jButtonCalibExtGyroAlign.setAction(actionMap.get("buttonCalibExtGyroAlign"));
        this.jButtonCalibExtGyroAlign.setText(resourceMap.getString("jButtonCalibExtGyroAlign.text", new Object[0]));
        this.jButtonCalibExtGyroAlign.setToolTipText(resourceMap.getString("jButtonCalibExtGyroAlign.toolTipText", new Object[0]));
        this.jButtonCalibExtGyroAlign.setMargin(new Insets(2, 5, 2, 5));
        this.jButtonCalibExtGyroAlign.setName("jButtonCalibExtGyroAlign");
        this.jTabPanelCalib.add((Component)this.jButtonCalibExtGyroAlign, new AbsoluteConstraints(250, 60, 110, 25));
        this.jProgressBarCalibProgress.setName("jProgressBarCalibProgress");
        this.jTabPanelCalib.add((Component)this.jProgressBarCalibProgress, new AbsoluteConstraints(140, 100, 190, 20));
        this.jButtonStopCalib.setAction(actionMap.get("buttonStopCalib"));
        this.jButtonStopCalib.setToolTipText(resourceMap.getString("jButtonStopCalib.toolTipText", new Object[0]));
        this.jButtonStopCalib.setHorizontalTextPosition(0);
        this.jButtonStopCalib.setIconTextGap(0);
        this.jButtonStopCalib.setName("jButtonStopCalib");
        this.jTabPanelCalib.add((Component)this.jButtonStopCalib, new AbsoluteConstraints(340, 100, 25, 25));
        this.jLabelCalibStatus.setText(resourceMap.getString("jLabelCalibStatus.text", new Object[0]));
        this.jLabelCalibStatus.setName("jLabelCalibStatus");
        this.jTabPanelCalib.add((Component)this.jLabelCalibStatus, new AbsoluteConstraints(140, 130, -1, 20));
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jTabPanelCalib.add((Component)this.jLabel7, new AbsoluteConstraints(10, 60, -1, -1));
        this.jLabelCalibTooltip.setFont(this.jLabelCalibTooltip.getFont().deriveFont((float)this.jLabelCalibTooltip.getFont().getSize() + 1.0f));
        this.jLabelCalibTooltip.setVerticalAlignment(1);
        this.jLabelCalibTooltip.setName("jLabelCalibTooltip");
        this.jTabPanelCalib.add((Component)this.jLabelCalibTooltip, new AbsoluteConstraints(10, 190, 630, 240));
        this.jButtonCalibAccAlign.setAction(actionMap.get("buttonACCAlign"));
        this.jButtonCalibAccAlign.setText(resourceMap.getString("jButtonCalibAccAlign.text", new Object[0]));
        this.jButtonCalibAccAlign.setToolTipText(resourceMap.getString("jButtonCalibAccAlign.toolTipText", new Object[0]));
        this.jButtonCalibAccAlign.setName("jButtonCalibAccAlign");
        this.jTabPanelCalib.add((Component)this.jButtonCalibAccAlign, new AbsoluteConstraints(500, 20, 110, 25));
        this.jLabelCalibInfo.setText(resourceMap.getString("jLabelCalibInfo.text", new Object[0]));
        this.jLabelCalibInfo.setName("jLabelCalibInfo");
        this.jTabPanelCalib.add((Component)this.jLabelCalibInfo, new AbsoluteConstraints(380, 100, -1, -1));
        this.jButtonAccExt.setAction(actionMap.get("buttonACCExt"));
        this.jButtonAccExt.setText(resourceMap.getString("jButtonAccExt.text", new Object[0]));
        this.jButtonAccExt.setName("jButtonAccExt");
        this.jTabPanelCalib.add((Component)this.jButtonAccExt, new AbsoluteConstraints(500, 60, 110, -1));
        this.jTabbedPane.addTab(resourceMap.getString("jTabPanelCalib.TabConstraints.tabTitle", new Object[0]), this.jTabPanelCalib);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane, gridBagConstraints);
        this.pack();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isFwUpdateAllowed() {
        return this.isConnected && this.role == 2 && this.model == 5;
    }

    void parse_CMD_DEVICE_INFO(SerialCommand resp) {
        try {
            int cmd_id = resp.readByte();
            if (cmd_id == 5) {
                this.extDeviceInfo = ExtDeviceInfo.parse_GPS_IMU_CMD_DEVICE_INFO(resp);
                this.updateStatusInfo();
                boolean debugMode = this.extDeviceInfo.isDebugMode();
                for (Component c : this.debugControls) {
                    c.setVisible(debugMode);
                }
            }
        }
        catch (Exception e) {
            this.logger.stackTrace(e);
        }
    }

    void parse_CMD_DATA(SerialCommand resp) {
        block14: {
            try {
                int cmd_id = resp.readByte();
                if (cmd_id == 1) {
                    int for_cmd_id = resp.readByte();
                    if (for_cmd_id == 9) {
                        int sens_id = resp.readByte();
                        int action = resp.readByte();
                        String action_name = DialogExtIMUInfo.getCalibActionName(action);
                        this.jLabelCalibInfo.setText(action_name);
                    }
                    break block14;
                }
                if (cmd_id != 8) break block14;
                long flags = resp.readDWordUnsigned();
                long flags2 = 0L;
                if ((flags & 0x80000000L) > 0L) {
                    flags2 = resp.readDWordUnsigned();
                }
                block10: for (int bit = 0; bit < 64; ++bit) {
                    if ((bit >= 31 || (flags & (long)(1 << bit)) == 0L) && (bit < 32 || (flags2 & (long)(1 << bit - 32)) == 0L)) continue;
                    switch (bit) {
                        case 1: {
                            this.ahrs_status = resp.readWordUnsigned();
                            continue block10;
                        }
                        case 2: {
                            this.hw_status = resp.readWordUnsigned();
                            continue block10;
                        }
                        case 3: {
                            this.sensor_fusion_qlt = resp.readByteArr(5);
                            continue block10;
                        }
                        case 38: {
                            this.ext_sens_status = resp.getBytesAvailable() >= 4 ? resp.readDWordUnsigned() : 0L;
                            continue block10;
                        }
                        default: {
                            DataBitField f;
                            if (bit >= DATA_BIT_FIELDS.length || (f = DATA_BIT_FIELDS[bit]) == null) continue block10;
                            Number[] data = null;
                            try {
                                data = f.readData(resp);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.setData(f, data);
                        }
                    }
                }
                this.updateStatusInfo();
            }
            catch (Exception e) {
                this.logger.stackTrace(e);
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName("ExtIMUInfo");
        RealtimeDataThread.suspend(true);
        CommandResponseListener cmdDataListener = new CommandResponseListener(this.wrapCmdId);
        SerialCommandDispatcher.getInstance().addResponseListener(cmdDataListener);
        try {
            ArrayList<SerialCommand> get_data_cmds = new ArrayList<SerialCommand>();
            int cmd_size = 0;
            long flags = 0L;
            for (int bit = 0; bit < DATA_BIT_FIELDS.length; ++bit) {
                DataBitField fld = DATA_BIT_FIELDS[bit];
                int fld_size = 0;
                long fld_flag = 0L;
                if (fld != null) {
                    fld_size = fld.getSizeBytes();
                    fld_flag = 1L << bit;
                }
                if (bit == DATA_BIT_FIELDS.length - 1) {
                    flags |= fld_flag;
                    fld_size = 1000;
                }
                if (cmd_size + fld_size > 200) {
                    SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(this.wrapCmdId, 6, false);
                    if ((flags & 0xFFFFFFFF00000000L) != 0L) {
                        cmd.writeDWord(flags & 0xFFFFFFFFL | 0x80000000L);
                        cmd.writeDWord(flags >> 32);
                    } else {
                        cmd.writeDWord(flags);
                    }
                    cmd.writeEmptyArr(4);
                    get_data_cmds.add(cmd);
                    cmd_size = fld_size;
                    flags = fld_flag;
                    continue;
                }
                cmd_size += fld_size;
                flags |= fld_flag;
            }
            for (int tryCnt = 0; tryCnt < 5 && this.extDeviceInfo == null; ++tryCnt) {
                SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(this.wrapCmdId, 4, true);
                SerialCommandProcessor.sendCommand(cmd);
                final SerialCommand resp = cmdDataListener.waitShort(1000L);
                if (resp == null || resp.getId() != this.wrapCmdId) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DialogExtIMUInfo.this.parse_CMD_DEVICE_INFO(resp);
                    }
                });
            }
            if (this.extDeviceInfo == null) {
                throw new Exception("Device version information is not received.");
            }
            this.isConnected = true;
            this.firePropertyChange("connected", false, this.isConnected());
            this.firePropertyChange("fwUpdateAllowed", false, this.isFwUpdateAllowed());
            int dataset_idx = 0;
            while (!this.isClosed()) {
                if (!this.mainView.isConnected()) {
                    Thread.sleep(1000L);
                    continue;
                }
                SerialCommandProcessor.sendCommand((SerialCommand)get_data_cmds.get(dataset_idx));
                final SerialCommand resp = cmdDataListener.waitShort(500L);
                if (resp != null && resp.getId() == this.wrapCmdId) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogExtIMUInfo.this.parse_CMD_DATA(resp);
                        }
                    });
                } else {
                    this.logger.warn("No response received on CMD_EXT_IMU_CMD(CMD_GET_DATA)!");
                }
                dataset_idx = (dataset_idx + 1) % get_data_cmds.size();
                if (this.extDeviceInfo.isDebugMode() && this.jCheckBoxTestMixData.isSelected()) {
                    SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(this.wrapCmdId, 50, false);
                    int[] values = this.mainView.panelJoystick.getValues();
                    for (int i = 0; i < 2; ++i) {
                        cmd.writeWord((int)((float)values[1 - i] * 0.30517578f));
                    }
                    cmd.writeWord(0);
                    cmd.writeWord(values[2] * 90 / 16384);
                    cmd.writeWord((int)(((Number)this.jSpinnerTestVeloU.getValue()).floatValue() * 1000.0f));
                    SerialCommandProcessor.sendCommand(cmd);
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException get_data_cmds) {
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            this.jLabelStatus.setText("<html>ERROR: " + e.getMessage() + "</html>");
        }
        SerialCommandDispatcher.getInstance().removeResponseListener(cmdDataListener);
        RealtimeDataThread.suspend(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialCommand sendCommandAndWaitConfirm(SerialCommand cmd, int confirmCmdId, long timeout) throws Exception {
        CommandResponseListener listener = new CommandResponseListener(this.wrapCmdId);
        SerialCommandDispatcher.getInstance().addResponseListener(listener);
        SerialCommand resp = null;
        int cmdConfirmId = 1;
        if (confirmCmdId == 2 || confirmCmdId == 10) {
            cmdConfirmId = 3;
        }
        try {
            SerialCommandProcessor.sendCommand(cmd);
            long outTime = System.currentTimeMillis() + timeout;
            do {
                CommandResponseListener commandResponseListener = listener;
                synchronized (commandResponseListener) {
                    SerialCommand r = listener.waitShort(100L);
                    if (r != null) {
                        SerialCommand copy = new SerialCommand(r);
                        int gps_imu_cmd_id = copy.readByte();
                        if (gps_imu_cmd_id == cmdConfirmId && copy.readByte() == confirmCmdId || gps_imu_cmd_id == confirmCmdId) {
                            resp = copy;
                            resp.startReading();
                        } else if (gps_imu_cmd_id == 14 && copy.readByte() == confirmCmdId) {
                            int err_code = copy.readByte();
                            throw new Exception("CMD_ERROR(" + err_code + ") is received in response");
                        }
                    }
                }
            } while (resp == null && System.currentTimeMillis() < outTime);
        }
        finally {
            SerialCommandDispatcher.getInstance().removeResponseListener(listener);
        }
        return resp;
    }

    public void send_CMD_CALIBRATE(int type, int mode) {
        this.send_CMD_CALIBRATE(type, mode, 0);
    }

    public void send_CMD_CALIBRATE(final int type, final int mode, final int value) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(DialogExtIMUInfo.this.wrapCmdId, 9, true);
                    cmd.writeByte(type);
                    cmd.writeByte(mode);
                    cmd.writeWord(value);
                    cmd.writeEmptyArr(7);
                    SerialCommand resp = DialogExtIMUInfo.this.sendCommandAndWaitConfirm(cmd, 9, 3000L);
                    if (resp == null) {
                        DialogExtIMUInfo.this.showErrorMessage("Timeout waiting confirmation of the start of calibration.");
                    }
                }
                catch (InterruptedException cmd) {
                }
                catch (Exception e) {
                    DialogExtIMUInfo.this.logger.stackTrace(e);
                    DialogExtIMUInfo.this.showErrorMessage(e.toString());
                }
            }
        }).start();
    }

    @Action(enabledProperty="connected")
    public void buttonCalibACC() {
        this.send_CMD_CALIBRATE(1, 0);
    }

    @Action(enabledProperty="connected")
    public void buttonCalibGyro() {
        this.send_CMD_CALIBRATE(2, 0);
    }

    @Action(enabledProperty="connected")
    public void buttonCalibMag() {
        this.send_CMD_CALIBRATE(3, 0);
    }

    @Action(enabledProperty="fwUpdateAllowed")
    public void buttonFirmwareUpdateFile() {
        if (!this.isFwUpdateAllowed()) {
            return;
        }
        try {
            JFileChooser fileChooser = new JFileChooser();
            String lastUsedFirmwareDirectory = Settings.get("last_used_ext_device_firmware_dir");
            if (lastUsedFirmwareDirectory != null) {
                fileChooser.setCurrentDirectory(new File(lastUsedFirmwareDirectory));
            } else {
                fileChooser.setCurrentDirectory(new File(Settings.getUserDir()));
            }
            fileChooser.setFileFilter(new FileNameExtensionFilter(this.resourceMap.getString("messageDialog.firmware_hex_file.title", new Object[0]), "hex", "bin"));
            if (fileChooser.showOpenDialog(this.mainView.getFrame()) == 0) {
                Settings.set("last_used_ext_device_firmware_dir", fileChooser.getCurrentDirectory().getPath());
                Settings.save();
                File firmwareFile = fileChooser.getSelectedFile();
                this.dialogFirmwareUpgrade = new DialogFirmwareUpgrade(this.mainView);
                ExtDeviceFirmwareUpgrader firmwareUpgrader = new ExtDeviceFirmwareUpgrader(this, this.extDeviceInfo, firmwareFile, this.dialogFirmwareUpgrade, this.dialogFirmwareUpgrade, this.dialogFirmwareUpgrade);
                super.closeDialog(1);
                this.dialogFirmwareUpgrade.start(new Thread(firmwareUpgrader));
            }
        }
        catch (Exception e) {
            this.mainView.showErrorMessage(e.toString());
        }
    }

    @Action(enabledProperty="connected")
    public void buttonReset() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(DialogExtIMUInfo.this.wrapCmdId, 2, true);
                    cmd.writeByte(1);
                    cmd.writeWord(500);
                    SerialCommand resp = DialogExtIMUInfo.this.sendCommandAndWaitConfirm(cmd, 2, 3000L);
                    if (resp == null) {
                        DialogExtIMUInfo.this.showErrorMessage("Timeout waiting confirmation");
                    }
                }
                catch (InterruptedException cmd) {
                }
                catch (Exception e) {
                    DialogExtIMUInfo.this.logger.stackTrace(e);
                    DialogExtIMUInfo.this.showErrorMessage(e.toString());
                }
            }
        }).start();
    }

    public static String getIMURoleName(int role) {
        if (role >= 0 && role < ROLE_NAMES.length) {
            return ROLE_NAMES[role];
        }
        return "Unknown role";
    }

    public static String getIMUModelName(int role, int model) {
        if (role == 2) {
            return ParamsUIFactory.getExtIMUModelName(model);
        }
        if (role == 1 || role == 0) {
            return BoardInfo.getMainIMUModelName(model);
        }
        return "unknown model " + role + "." + model;
    }

    public static String getIMUFullName(int role, int model) {
        return DialogExtIMUInfo.getIMURoleName(role) + "(" + DialogExtIMUInfo.getIMUModelName(role, model) + ")";
    }

    @Action
    public void buttonStopCalib() {
        if (this.curSensCalib > 0) {
            this.send_CMD_CALIBRATE(this.curSensCalib, 2);
        }
    }

    @Action(enabledProperty="connected")
    public void buttonDeviceSNCopyClipboard() {
        StringSelection stringSelection = new StringSelection(this.jTextFieldDeviceSN.getText());
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    public static String formatExtSensStatus(long ext_sens_status) {
        StringBuilder s = new StringBuilder();
        StatusBit.format_html(s, EXT_SENS_STATUS_BITS, (int)(ext_sens_status & 0xFFL));
        s.append(String.format(", Missed frames count: %d, Overflow count: %d", ext_sens_status >> 8 & 0xFFL, ext_sens_status >> 16 & 0xFFL));
        return s.toString();
    }

    @Action
    public void buttonCalibExtGyro() {
        this.send_CMD_CALIBRATE(4, 0);
    }

    @Action
    public void buttonCalibExtGyroAlign() {
        this.send_CMD_CALIBRATE(4, 3);
    }

    @Action
    public void buttonACCAlign() {
        this.send_CMD_CALIBRATE(1, 3);
    }

    void beforeReadParams() {
        for (Component component : Arrays.asList(this.jCheckBoxVH_SBGC, this.jCheckBoxVH_SAPI, this.jCheckBoxDisableMag, this.jCheckBoxGNSSHeading, this.jComboBoxGNSSMode, this.jComboBoxMagAutoCalib, this.jSpinnerAccWeight, this.jSpinnerMagWeight, this.jSpinnerGNSSWeight, this.jSpinnerExtGyroScaleX, this.jSpinnerExtGyroScaleY, this.jSpinnerExtGyroScaleZ, this.jCBDontUpdGyroBiasX, this.jCBDontUpdGyroBiasY, this.jCBDontUpdGyroBiasZ, this.jComboBoxDynamicModel)) {
            component.setEnabled(false);
        }
        this.jButtonWrite.setEnabled(false);
        this.paramsRead = null;
    }

    @Action(enabledProperty="connected")
    public void buttonRead() {
        this.beforeReadParams();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(DialogExtIMUInfo.this.wrapCmdId, 16, true);
                    cmd.writeByte(1);
                    cmd.writeByte(2);
                    for (int i = 0; i < 3; ++i) {
                        cmd.writeByte(3 + i);
                        cmd.writeByte(6 + i);
                    }
                    cmd.writeByte(10);
                    cmd.writeByte(11);
                    final SerialCommand resp = DialogExtIMUInfo.this.sendCommandAndWaitConfirm(cmd, 16, 5000L);
                    if (resp != null && resp.readByte() == 16) {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    DialogExtIMUInfo.this.paramsRead = new ArrayList();
                                    int num = resp.readByte();
                                    block10: while (num-- > 0) {
                                        int param_id = resp.readByte();
                                        DialogExtIMUInfo.this.paramsRead.add(param_id);
                                        switch (param_id) {
                                            case 1: {
                                                long flags = resp.readDWordUnsigned();
                                                DialogExtIMUInfo.this.jCheckBoxVH_SBGC.setSelected((flags & 1L) != 0L);
                                                DialogExtIMUInfo.this.jCheckBoxVH_SAPI.setSelected((flags & 2L) != 0L);
                                                DialogExtIMUInfo.this.jCheckBoxDisableMag.setSelected((flags & 4L) != 0L);
                                                DialogExtIMUInfo.this.jCheckBoxGNSSHeading.setSelected((flags & 0x40L) != 0L);
                                                DialogExtIMUInfo.this.jCheckBoxExtGyroDisable.setSelected((flags & 0x400L) != 0L);
                                                DialogExtIMUInfo.this.jCheckBoxEuler312.setSelected((flags & 0x800L) != 0L);
                                                DialogExtIMUInfo.this.jCBUseMotionDet.setSelected((flags & 0x1000L) == 0L);
                                                int gnss_mode = (int)(flags >> 3 & 7L);
                                                ((SpravComboBoxModel)DialogExtIMUInfo.this.jComboBoxGNSSMode.getModel()).setCurrentOrAdd(gnss_mode);
                                                int i = 0;
                                                for (JCheckBox jCheckBox : Arrays.asList(DialogExtIMUInfo.this.jCBDontUpdGyroBiasX, DialogExtIMUInfo.this.jCBDontUpdGyroBiasY, DialogExtIMUInfo.this.jCBDontUpdGyroBiasZ)) {
                                                    jCheckBox.setSelected((flags & 128L << i) != 0L);
                                                    ++i;
                                                }
                                                for (Component component : Arrays.asList(DialogExtIMUInfo.this.jCheckBoxVH_SBGC, DialogExtIMUInfo.this.jCheckBoxVH_SAPI, DialogExtIMUInfo.this.jCheckBoxDisableMag, DialogExtIMUInfo.this.jCheckBoxGNSSHeading, DialogExtIMUInfo.this.jComboBoxGNSSMode, DialogExtIMUInfo.this.jCBDontUpdGyroBiasX, DialogExtIMUInfo.this.jCBDontUpdGyroBiasY, DialogExtIMUInfo.this.jCBDontUpdGyroBiasZ, DialogExtIMUInfo.this.jCheckBoxExtGyroDisable, DialogExtIMUInfo.this.jCheckBoxEuler312, DialogExtIMUInfo.this.jCBUseMotionDet)) {
                                                    component.setEnabled(true);
                                                }
                                                continue block10;
                                            }
                                            case 2: {
                                                int mag_calib_mode = resp.readByte();
                                                ((SpravComboBoxModel)DialogExtIMUInfo.this.jComboBoxMagAutoCalib.getModel()).setCurrentOrAdd(mag_calib_mode);
                                                DialogExtIMUInfo.this.jComboBoxMagAutoCalib.setEnabled(true);
                                                break;
                                            }
                                            case 3: 
                                            case 4: 
                                            case 5: {
                                                int axis = param_id - 3;
                                                float val = resp.readFloat();
                                                DialogExtIMUInfo.this.spinnerExtGyroScale[axis].setValue(Float.valueOf(val));
                                                DialogExtIMUInfo.this.spinnerExtGyroScale[axis].setEnabled(true);
                                                break;
                                            }
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                int idx = param_id - 6;
                                                float val = resp.readFloat();
                                                DialogExtIMUInfo.this.spinnerWeight[idx].setValue(Float.valueOf(val));
                                                DialogExtIMUInfo.this.spinnerWeight[idx].setEnabled(true);
                                                break;
                                            }
                                            case 10: {
                                                int val = resp.readByte();
                                                ((SpravComboBoxModel)DialogExtIMUInfo.this.jComboBoxDynamicModel.getModel()).setCurrentOrAdd(val);
                                                DialogExtIMUInfo.this.jComboBoxDynamicModel.setEnabled(true);
                                                break;
                                            }
                                            case 11: {
                                                float val = resp.readFloat();
                                                DialogExtIMUInfo.this.jSpinnerMotDetThreshold.setValue(Float.valueOf(val));
                                                DialogExtIMUInfo.this.jSpinnerMotDetThreshold.setEnabled(true);
                                                break;
                                            }
                                            default: {
                                                throw new Exception("Wrong data format");
                                            }
                                        }
                                    }
                                    DialogExtIMUInfo.this.mainView.updateStatus("Parameters are read successfully");
                                    DialogExtIMUInfo.this.jButtonWrite.setEnabled(true);
                                }
                                catch (Exception e) {
                                    DialogExtIMUInfo.this.showErrorMessage("Error parsing data: " + e.getMessage());
                                }
                            }
                        });
                    } else {
                        DialogExtIMUInfo.this.showErrorMessage("Timeout waiting response.");
                    }
                }
                catch (InterruptedException cmd) {
                }
                catch (Exception e) {
                    DialogExtIMUInfo.this.logger.stackTrace(e);
                    DialogExtIMUInfo.this.showErrorMessage(e.toString());
                }
            }
        }).start();
    }

    @Action
    public void buttonWrite() {
        if (this.paramsRead == null || this.paramsRead.size() == 0) {
            return;
        }
        this.jButtonWrite.setEnabled(false);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SerialCommand cmd = SerialCommandProcessor.extImuWrapCmd(DialogExtIMUInfo.this.wrapCmdId, 17, true);
                    cmd.writeByte(DialogExtIMUInfo.this.paramsRead.size());
                    int cmd_flags = DialogExtIMUInfo.this.jCheckBoxSaveSD.isSelected() ? 1 : 0;
                    cmd.writeByte(cmd_flags);
                    block14: for (Integer param_id : DialogExtIMUInfo.this.paramsRead) {
                        cmd.writeByte(param_id);
                        switch (param_id) {
                            case 1: {
                                long flags = (DialogExtIMUInfo.this.jCheckBoxVH_SBGC.isSelected() ? 1L : 0L) | (DialogExtIMUInfo.this.jCheckBoxVH_SAPI.isSelected() ? 2L : 0L) | (DialogExtIMUInfo.this.jCheckBoxDisableMag.isSelected() ? 4L : 0L) | (DialogExtIMUInfo.this.jCheckBoxGNSSHeading.isSelected() ? 64L : 0L) | (DialogExtIMUInfo.this.jCheckBoxExtGyroDisable.isSelected() ? 1024L : 0L) | (DialogExtIMUInfo.this.jCheckBoxEuler312.isSelected() ? 2048L : 0L) | (DialogExtIMUInfo.this.jCBUseMotionDet.isSelected() ? 0L : 4096L);
                                int i = 0;
                                for (JCheckBox cb : Arrays.asList(DialogExtIMUInfo.this.jCBDontUpdGyroBiasX, DialogExtIMUInfo.this.jCBDontUpdGyroBiasY, DialogExtIMUInfo.this.jCBDontUpdGyroBiasZ)) {
                                    if (cb.isSelected()) {
                                        flags |= 128L << i;
                                    }
                                    ++i;
                                }
                                int gnss_mode = ((SpravComboBoxModel)DialogExtIMUInfo.this.jComboBoxGNSSMode.getModel()).getCurrentId();
                                cmd.writeDWord(flags |= (long)(gnss_mode << 3));
                                continue block14;
                            }
                            case 2: {
                                int mag_calib_mode = ((SpravComboBoxModel)DialogExtIMUInfo.this.jComboBoxMagAutoCalib.getModel()).getCurrentId();
                                cmd.writeByte(mag_calib_mode);
                                continue block14;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                int axis = param_id - 3;
                                float val = ((Number)DialogExtIMUInfo.this.spinnerExtGyroScale[axis].getValue()).floatValue();
                                cmd.writeFloat(val);
                                continue block14;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                int idx = param_id - 6;
                                float val = ((Number)DialogExtIMUInfo.this.spinnerWeight[idx].getValue()).floatValue();
                                cmd.writeFloat(val);
                                continue block14;
                            }
                            case 10: {
                                int mode = ((SpravComboBoxModel)DialogExtIMUInfo.this.jComboBoxDynamicModel.getModel()).getCurrentId();
                                cmd.writeByte(mode);
                                continue block14;
                            }
                            case 11: {
                                float val = ((Number)DialogExtIMUInfo.this.jSpinnerMotDetThreshold.getValue()).floatValue();
                                cmd.writeFloat(val);
                                continue block14;
                            }
                        }
                        throw new Exception("Unknown param_id=" + param_id);
                    }
                    SerialCommand resp = DialogExtIMUInfo.this.sendCommandAndWaitConfirm(cmd, 17, 5000L);
                    if (resp != null) {
                        DialogExtIMUInfo.this.mainView.updateStatus("Parameters are written successfully");
                    } else {
                        DialogExtIMUInfo.this.showErrorMessage("Timeout waiting response.");
                    }
                }
                catch (InterruptedException cmd) {
                }
                catch (Exception e) {
                    DialogExtIMUInfo.this.logger.stackTrace(e);
                    DialogExtIMUInfo.this.showErrorMessage(e.toString());
                }
                finally {
                    DialogExtIMUInfo.this.jButtonWrite.setEnabled(true);
                }
            }
        }).start();
    }

    @Action(enabledProperty="connected")
    public void buttonACCExt() {
        this.send_CMD_CALIBRATE(1, 1, this.calibACCExtStarted ? 980 : 0);
        this.calibACCExtStarted = !this.calibACCExtStarted;
    }

    static {
        DATA_BIT_FIELDS = new DataBitField[]{new DataBitField(0, "TIMESTAMP_MS", 3, 1), new DataBitField(1, "AHRS_STATUS", 2, 1), new DataBitField(2, "HARDWARE_STATUS", 2, 1), new DataBitField(3, "SENSOR_FUSION_QLT", 1, 5), null, new DataBitField(5, "ATTITUDE_QUAT", 4, 4), new DataBitField(6, "ATTITUDE_EULER", 4, 3), new DataBitField(7, "ACCEL_XYZ", 4, 3), new DataBitField(8, "ACCEL_NED", 4, 3), new DataBitField(9, "VELO_XYZ", 4, 3), new DataBitField(10, "VELO_NED", 4, 3), new DataBitField(11, "VELO_U", 4, 1), new DataBitField(12, "POS_NED", 4, 3), new DataBitField(13, "POS_LLA", 5, 3), new DataBitField(14, "POS_U", 4, 1), new DataBitField(15, "MAG_XYZ", 4, 3), new DataBitField(16, "MAG_NED", 4, 3), new DataBitField(17, "GYR_XYZ", 4, 3), new DataBitField(18, "GYR_NED", 4, 3), new DataBitField(19, "ACC_XYZ", 4, 3), new DataBitField(20, "ACC_NED", 4, 3), new DataBitField(21, "GNSS_STATE", 1, 2), new DataBitField(22, "GNSS_POS_LLA", 5, 3), new DataBitField(23, "GNSS_DOP", 4, 7), new DataBitField(24, "GNSS_VEL_NED", 4, 3), new DataBitField(25, "GNSS_VEL_U", 4, 1), new DataBitField(26, "BARO_PRSR", 4, 1), new DataBitField(27, "BARO_ALT", 4, 1), new DataBitField(28, "TEMP_BOARD", 4, 3), null, new DataBitField(30, "CALIB_STATUS", 1, 3), null, new DataBitField(32, "PORT_STAT_CUR", new int[]{3, 2, 3, 2}, 4), new DataBitField(33, "PORT_STAT_ALL", new int[]{3, 2, 3, 2}, 4), new DataBitField(34, "UTC_DATE", 1, 3), new DataBitField(35, "UTC_TIME", 1, 3), null, null, new DataBitField(38, "EXT_SENS_STATUS", 3, 1), new DataBitField(39, "EULER_U", 2, 3)};
        HW_STATUS_BITS = new StatusBit[]{new StatusBit("THERMOSTAT", Colored.SET_IS_GOOD), new StatusBit("RTC_BAT", Colored.NOT_SET_IS_BAD), new StatusBit("SD_CARD", Colored.NOT_SET_IS_BAD), new StatusBit("GNSS_ERR", Colored.SET_IS_BAD_HIDE), new StatusBit("MAG_ERR", Colored.SET_IS_BAD_HIDE), new StatusBit("IMU_ERR", Colored.SET_IS_BAD_HIDE), new StatusBit("CALIB_VALID", Colored.NOT_SET_IS_BAD), new StatusBit("LICENSE_VALID", Colored.NOT_SET_IS_BAD), new StatusBit("EXT_SENS_ERR", Colored.SET_IS_BAD_HIDE), new StatusBit("STACK_OVERFLOW", Colored.SET_IS_BAD_HIDE), new StatusBit("MALLOC_FAILED", Colored.SET_IS_BAD_HIDE), new StatusBit("SD_LOG", Colored.SET_IS_GOOD_HIDE)};
        AHRS_STATUS_BITS = new StatusBit[]{new StatusBit("ATTITUDE_INIT", Colored.SET_IS_GOOD), new StatusBit("HEADING_INIT", Colored.SET_IS_GOOD), new StatusBit("HEAD_REF_EN", Colored.SET_IS_GOOD), new StatusBit("GNSS_REF_EN", Colored.SET_IS_GOOD), null, null, new StatusBit("VIRT_HEAD_SBGC", Colored.SET_IS_GOOD), new StatusBit("VIRT_HEAD_API", Colored.SET_IS_GOOD), new StatusBit("HEAD_EXT_REF_EN", Colored.SET_IS_GOOD_HIDE), new StatusBit("VIRT_HEAD_EXT_REF_EN", Colored.SET_IS_GOOD_HIDE)};
        GNSS_STATE_FIX = new String[]{"no fix", "dead reck. only", "2D-fix", "3D-fix"};
        dataGridByName = new HashMap(DATA_GRID.length);
        for (DataGrid dg : DATA_GRID) {
            dataGridByName.put(dg.name, dg);
        }
        ROLE_NAMES = new String[]{"Main IMU", "Frame IMU", "External IMU"};
        SENSORS_FUSION_LIST = new String[]{"ATTITUDE", "MAG", "GNSS", "BARO", "HEADING"};
        EXT_SENS_STATUS_BITS = new StatusBit[]{new StatusBit("GYRO_ENABLED", Colored.SET_IS_GOOD)};
    }

    static class DataBitField {
        public final int bit;
        public final String name;
        public final int type;
        public final int length;
        public final int[] mixedType;
        public static final int TYPE_1u = 1;
        public static final int TYPE_2u = 2;
        public static final int TYPE_4u = 3;
        public static final int TYPE_4f = 4;
        public static final int TYPE_8d = 5;

        public DataBitField(int bit, String name, int type, int length) {
            this.bit = bit;
            this.name = name;
            this.type = type;
            this.mixedType = null;
            this.length = length;
        }

        public DataBitField(int bit, String name, int[] mixedType, int length) {
            if (length != mixedType.length) {
                throw new IllegalArgumentException("Parameter 'length' does not match mixedType.length");
            }
            this.bit = bit;
            this.name = name;
            this.type = 0;
            this.mixedType = mixedType;
            this.length = length;
        }

        public Number[] readData(SerialCommand cmd) throws Exception {
            Number[] data = new Number[this.length];
            block7: for (int i = 0; i < this.length; ++i) {
                switch (this.mixedType != null ? this.mixedType[i] : this.type) {
                    case 1: {
                        data[i] = new Integer(cmd.readByte());
                        continue block7;
                    }
                    case 2: {
                        data[i] = new Integer(cmd.readWordUnsigned());
                        continue block7;
                    }
                    case 3: {
                        data[i] = new Long(cmd.readDWordUnsigned());
                        continue block7;
                    }
                    case 4: {
                        data[i] = new Float(cmd.readFloat());
                        continue block7;
                    }
                    case 5: {
                        data[i] = new Double(cmd.readDouble());
                    }
                }
            }
            return data;
        }

        int getSizeBytes() throws InternalError {
            int size = 0;
            block6: for (int i = 0; i < this.length; ++i) {
                int _type = this.mixedType != null ? this.mixedType[i] : this.type;
                switch (_type) {
                    case 1: {
                        ++size;
                        continue block6;
                    }
                    case 2: {
                        size += 2;
                        continue block6;
                    }
                    case 3: 
                    case 4: {
                        size += 4;
                        continue block6;
                    }
                    case 5: {
                        size += 8;
                        continue block6;
                    }
                    default: {
                        throw new InternalError("Unsupported variable type: " + _type);
                    }
                }
            }
            return size;
        }
    }

    static class DataGrid {
        public String name;
        public String format;
        public String[][] columns;
        public Number scale = null;
        public int row;

        public DataGrid(String name, String format, String[][] columns) {
            this.name = name;
            this.format = format;
            this.columns = columns;
        }

        public DataGrid(String name, String format, String[][] columns, Number scale) {
            this(name, format, columns);
            this.scale = scale;
        }
    }
}

