/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.common.IFirmwareInfo;
import sbgc.service.upgrade.IFirmwareUpgradeListener;
import sbgc.service.upgrade.IStatusListener;
import sbgc.service.upgrade.VersionImpl;
import sbgc.utils.ILogListener;
import sbgc.utils.Log;
import simplebgc_gui.SimpleBGC_GUIApp;
import simplebgc_gui.SimpleBGC_GUIView;

public class DialogFirmwareUpgrade
extends JDialog
implements ILogListener,
IFirmwareUpgradeListener,
IStatusListener {
    protected static final Log logger = new Log(Logger.getLogger((String)DialogFirmwareUpgrade.class.getName()));
    private SimpleBGC_GUIView parent = null;
    private boolean canClose = false;
    private static ResourceMap resourceMap = null;
    Thread executer = null;
    boolean alive;
    private JButton buttonCancel;
    private JLabel labelFirmwareUpgrade;
    private JPanel panelButtonDetail;
    private JPanel panelButtons;
    private JPanel panelDetail;
    private JPanel panelScrollPane;
    private JPanel panelTitleAndProgress;
    private JProgressBar progressBarFirmwareUpgrade;
    private JScrollPane scrollPaneDetails;
    private JTextArea textAreaDetails;
    private JToggleButton toggleButtonDetails;

    public DialogFirmwareUpgrade(SimpleBGC_GUIView parent) {
        super((Frame)parent.getFrame(), true);
        this.parent = parent;
        resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogFirmwareUpgrade.class);
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (DialogFirmwareUpgrade.this.canClose) {
                    DialogFirmwareUpgrade.this.buttonClose();
                }
            }
        });
        this.panelScrollPane.setVisible(false);
        this.pack();
    }

    public void start(Thread executer) {
        this.alive = true;
        this.executer = executer;
        executer.start();
        this.setLocationRelativeTo(this.parent.getFrame());
        this.setVisible(true);
    }

    @Override
    public void trace(final String message) {
        logger.trace(message);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogFirmwareUpgrade.this.textAreaDetails.append(message);
                DialogFirmwareUpgrade.this.textAreaDetails.append("\n");
            }
        });
    }

    @Override
    public void append(final String part) {
        logger.trace(part);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogFirmwareUpgrade.this.textAreaDetails.append(part);
            }
        });
    }

    @Override
    public void debug(String message) {
        this.trace(message);
    }

    @Override
    public void info(String message) {
        this.trace(message);
    }

    @Override
    public void warn(String message) {
        this.trace(message);
    }

    @Override
    public void error(String message) {
        this.trace(message);
    }

    @Override
    public void onProgressStart(String action, boolean modal) {
    }

    @Override
    public boolean onProgressChange(final int val) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogFirmwareUpgrade.this.progressBarFirmwareUpgrade.setValue(DialogFirmwareUpgrade.this.progressBarFirmwareUpgrade.getMaximum() * val / 100);
            }
        });
        return true;
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
        if (canClose) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogFirmwareUpgrade.this.buttonCancel.setEnabled(true);
                    DialogFirmwareUpgrade.this.buttonCancel.setText(resourceMap.getString("buttonCancel.close.text", new Object[0]));
                    DialogFirmwareUpgrade.this.labelFirmwareUpgrade.setText(resourceMap.getString("labelFirmwareUpgrade.finished.text", new Object[0]));
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogFirmwareUpgrade.this.buttonCancel.setEnabled(false);
                }
            });
        }
    }

    @Override
    public synchronized void onFirmwareSaved(File saveFile) {
        this.dispose();
        if (this.parent != null) {
            this.parent.showInfoMessage(resourceMap.getString("messageDialog.firmware_saved.text", saveFile.getAbsolutePath()));
        }
    }

    @Override
    public synchronized void onFirmwareUpgradeEnd(final Throwable e, final IFirmwareInfo firmwareInfo) {
        this.notifyAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogFirmwareUpgrade.this.onFirmwareUpgradeEndUpdateUI(e, firmwareInfo);
            }
        });
    }

    private void onFirmwareUpgradeEndUpdateUI(Throwable e, IFirmwareInfo firmwareInfo) {
        this.setCanClose(true);
        this.alive = false;
        if (e != null) {
            if (e.getMessage() == null) {
                logger.stackTrace(e);
            }
            this.error(resourceMap.getString("error.upgrading_firmware", e.getMessage()));
            JOptionPane.showMessageDialog(null, resourceMap.getString("error.failed_to_upload", e.getMessage()), resourceMap.getString("error.title", new Object[0]), 0);
        } else {
            this.dispose();
            if (firmwareInfo != null && firmwareInfo.getGUIVersion() > SimpleBGC_GUIApp.version.getComparableVersion() && firmwareInfo.getGUIUrl() != null && firmwareInfo.getGUIUrl().length() > 0) {
                VersionImpl gui_ver = new VersionImpl(firmwareInfo.getGUIVersion());
                if (JOptionPane.showConfirmDialog(null, resourceMap.getString("messageDialog.firmware_uploaded_gui_download.text", gui_ver.toString()), resourceMap.getString("messageDialog.info.title", new Object[0]), 0) == 0) {
                    logger.info("Redirecting to GUI url: " + firmwareInfo.getGUIUrl());
                    SimpleBGC_GUIView.browseURI(firmwareInfo.getGUIUrl());
                }
            } else {
                JOptionPane.showMessageDialog(null, resourceMap.getString("messageDialog.firmware_uploaded.text", new Object[0]), resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
            }
        }
    }

    @Action
    public void showDetails() {
        this.panelScrollPane.setVisible(this.toggleButtonDetails.isSelected());
        if (!this.panelScrollPane.isVisible()) {
            this.setSize(new Dimension((int)this.getSize().getWidth(), (int)(this.getSize().getHeight() - 300.0)));
            this.setResizable(false);
            this.setLocationRelativeTo(this.parent.getFrame());
        } else {
            this.setSize(new Dimension((int)this.getSize().getWidth(), (int)(this.getSize().getHeight() + 300.0)));
            this.setResizable(true);
            this.setLocationRelativeTo(this.parent.getFrame());
        }
    }

    @Override
    public void onStatusChange(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogFirmwareUpgrade.this.labelFirmwareUpgrade.setText(status);
                DialogFirmwareUpgrade.this.textAreaDetails.append(status + "\n");
            }
        });
    }

    private void initComponents() {
        this.panelTitleAndProgress = new JPanel();
        this.labelFirmwareUpgrade = new JLabel();
        this.progressBarFirmwareUpgrade = new JProgressBar();
        this.panelButtons = new JPanel();
        this.buttonCancel = new JButton();
        this.panelDetail = new JPanel();
        this.panelButtonDetail = new JPanel();
        this.toggleButtonDetails = new JToggleButton();
        this.panelScrollPane = new JPanel();
        this.scrollPaneDetails = new JScrollPane();
        this.textAreaDetails = new JTextArea();
        this.setDefaultCloseOperation(0);
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogFirmwareUpgrade.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setMinimumSize(new Dimension(800, 180));
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.panelTitleAndProgress.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelTitleAndProgress.setName("panelTitleAndProgress");
        this.panelTitleAndProgress.setLayout(new BorderLayout(5, 5));
        this.labelFirmwareUpgrade.setText(resourceMap.getString("labelFirmwareUpgrade.text", new Object[0]));
        this.labelFirmwareUpgrade.setName("labelFirmwareUpgrade");
        this.panelTitleAndProgress.add((Component)this.labelFirmwareUpgrade, "North");
        this.progressBarFirmwareUpgrade.setMaximum(1000);
        this.progressBarFirmwareUpgrade.setName("progressBarFirmwareUpgrade");
        this.panelTitleAndProgress.add((Component)this.progressBarFirmwareUpgrade, "South");
        this.getContentPane().add((Component)this.panelTitleAndProgress, "North");
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new FlowLayout(2));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogFirmwareUpgrade.class, this);
        this.buttonCancel.setAction(actionMap.get("buttonClose"));
        this.buttonCancel.setText(resourceMap.getString("buttonCancel.text", new Object[0]));
        this.buttonCancel.setName("buttonCancel");
        this.panelButtons.add(this.buttonCancel);
        this.getContentPane().add((Component)this.panelButtons, "South");
        this.panelDetail.setName("panelDetail");
        this.panelDetail.setRequestFocusEnabled(false);
        this.panelDetail.setLayout(new BorderLayout());
        this.panelButtonDetail.setName("panelButtonDetail");
        this.panelButtonDetail.setLayout(new FlowLayout(0));
        this.toggleButtonDetails.setAction(actionMap.get("showDetails"));
        this.toggleButtonDetails.setText(resourceMap.getString("toggleButtonDetails.text", new Object[0]));
        this.toggleButtonDetails.setName("toggleButtonDetails");
        this.panelButtonDetail.add(this.toggleButtonDetails);
        this.panelDetail.add((Component)this.panelButtonDetail, "North");
        this.panelScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelScrollPane.setName("panelScrollPane");
        this.panelScrollPane.setLayout(new BorderLayout());
        this.scrollPaneDetails.setMinimumSize(null);
        this.scrollPaneDetails.setName("scrollPaneDetails");
        this.textAreaDetails.setBackground(resourceMap.getColor("textAreaDetails.background"));
        this.textAreaDetails.setColumns(20);
        this.textAreaDetails.setForeground(resourceMap.getColor("textAreaDetails.foreground"));
        this.textAreaDetails.setRows(5);
        this.textAreaDetails.setMinimumSize(null);
        this.textAreaDetails.setName("textAreaDetails");
        this.textAreaDetails.setPreferredSize(null);
        this.scrollPaneDetails.setViewportView(this.textAreaDetails);
        this.panelScrollPane.add((Component)this.scrollPaneDetails, "Center");
        this.panelDetail.add((Component)this.panelScrollPane, "Center");
        this.getContentPane().add((Component)this.panelDetail, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    @Action
    public synchronized void buttonClose() {
        this.error("Cancelled by user!");
        this.alive = false;
        if (this.executer != null) {
            this.executer.interrupt();
        }
        this.notifyAll();
        this.dispose();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void onFlashStart() {
        this.buttonCancel.setEnabled(false);
    }
}

