/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultCaret;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardInfo;
import sbgc.service.ICommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.ui.SpravComboBoxModel;
import simplebgc_gui.EmptyIcon;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogMultilink
extends MyDialog
implements ICommandResponseListener {
    private JButton jButtoCancel;
    private JButton jButton1;
    private JButton jButtonDefaults;
    private JButton jButtonRead;
    private JButton jButtonRestart;
    private JButton jButtonSend;
    private JButton jButtonWrite;
    private JCheckBox jCheckBoxBLE;
    private JCheckBox jCheckBoxBluetoothClassic;
    private JCheckBox jCheckBoxEthernet;
    private JCheckBox jCheckBoxWiFi;
    private JComboBox jComboBoxButtonFn;
    private JComboBox jComboBoxCurParity;
    private JComboBox jComboBoxCurSpeed;
    private JComboBox jComboBoxNewParity;
    private JComboBox jComboBoxNewSpeed;
    private JComboBox jComboBoxPort;
    private JComboBox jComboBoxWiFiMode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelAT;
    private JLabel jLabelBFN;
    private JLabel jLabelCurBaud;
    private JLabel jLabelIPPort;
    private JLabel jLabelName;
    private JLabel jLabelNewBaud;
    private JLabel jLabelPIN;
    private JLabel jLabelSerialPort;
    private JMenuItem jMenuItemClear;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPopupMenu jPopupMenuDebug;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator3;
    private JSpinner jSpinnerIPPort;
    private JTextArea jTextAreaDebugCmd;
    private JTextArea jTextAreaInfo;
    private JTextField jTextFieldAPName;
    private JTextField jTextFieldAPPass;
    private JTextField jTextFieldAT;
    private JTextField jTextFieldBluetoothName;
    private JTextField jTextFieldBluetoothPIN;
    private JTextField jTextFieldIPAddress;
    private JTextField jTextFieldSTAName;
    private JTextField jTextFieldSTAPass;
    public static final int[] SERIAL_BAUD_RATES = new int[]{115200, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 230400, 256000};
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int MULTI_PART_TIMEOUT = 600;
    JComboBox[] speedBox;
    boolean rtPauseState;
    ArrayList<SerialCommand> response = null;
    String responseStr = null;
    int portIdx;
    int curSpeed;
    int curParity;
    boolean isReady = false;
    boolean isReadyWrite = false;
    private static final Pattern LINE_PATTERN = Pattern.compile("^\\(([^)]+)\\)[^:]*:\\s*(.*?)\\s*$");
    private static final Pattern VALUE_CLEAN_PATTERN = Pattern.compile("\\s*\\([^)]*\\)\\s*$");

    private void initComponents() {
        this.jPopupMenuDebug = new JPopupMenu();
        this.jMenuItemClear = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jLabelSerialPort = new JLabel();
        this.jComboBoxPort = new JComboBox();
        this.jLabelCurBaud = new JLabel();
        this.jComboBoxCurSpeed = new JComboBox();
        this.jComboBoxCurParity = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jLabelNewBaud = new JLabel();
        this.jComboBoxNewSpeed = new JComboBox();
        this.jComboBoxNewParity = new JComboBox();
        this.jLabelName = new JLabel();
        this.jTextFieldBluetoothName = new JTextField();
        this.jTextFieldBluetoothPIN = new JTextField();
        this.jLabelPIN = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldAPName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxWiFiMode = new JComboBox();
        this.jLabelIPPort = new JLabel();
        this.jSpinnerIPPort = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jTextFieldAPPass = new JTextField();
        this.jTextFieldSTAName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldSTAPass = new JTextField();
        this.jLabel6 = new JLabel();
        this.jCheckBoxBLE = new JCheckBox();
        this.jCheckBoxBluetoothClassic = new JCheckBox();
        this.jCheckBoxWiFi = new JCheckBox();
        this.jCheckBoxEthernet = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jTextFieldIPAddress = new JTextField();
        this.jButton1 = new JButton();
        this.jLabelBFN = new JLabel();
        this.jComboBoxButtonFn = new JComboBox();
        this.jButtonDefaults = new JButton();
        this.jButtonRestart = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonWrite = new JButton();
        this.jButtoCancel = new JButton();
        this.jSeparator3 = new JSeparator();
        this.jLabelAT = new JLabel();
        this.jTextFieldAT = new JTextField();
        this.jButtonSend = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaDebugCmd = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTextAreaInfo = new JTextArea();
        this.jPopupMenuDebug.setName("jPopupMenuDebug");
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogMultilink.class, this);
        this.jMenuItemClear.setAction(actionMap.get("menuDebugClear"));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogMultilink.class);
        this.jMenuItemClear.setText(resourceMap.getString("jMenuItemClear.text", new Object[0]));
        this.jMenuItemClear.setName("jMenuItemClear");
        this.jPopupMenuDebug.add(this.jMenuItemClear);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelSerialPort.setText(resourceMap.getString("jLabelSerialPort.text", new Object[0]));
        this.jLabelSerialPort.setName("jLabelSerialPort");
        this.jPanel1.add((Component)this.jLabelSerialPort, new AbsoluteConstraints(30, 20, -1, -1));
        this.jComboBoxPort.setModel(new DefaultComboBoxModel<String>(new String[]{"UART1", "RC_SERIAL", "UART2"}));
        this.jComboBoxPort.setName("jComboBoxPort");
        this.jPanel1.add((Component)this.jComboBoxPort, new AbsoluteConstraints(240, 20, -1, -1));
        this.jLabelCurBaud.setText(resourceMap.getString("jLabelCurBaud.text", new Object[0]));
        this.jLabelCurBaud.setName("jLabelCurBaud");
        this.jPanel1.add((Component)this.jLabelCurBaud, new AbsoluteConstraints(30, 50, -1, -1));
        this.jComboBoxCurSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxCurSpeed.setToolTipText(resourceMap.getString("jComboBoxCurSpeed.toolTipText", new Object[0]));
        this.jComboBoxCurSpeed.setName("jComboBoxCurSpeed");
        this.jPanel1.add((Component)this.jComboBoxCurSpeed, new AbsoluteConstraints(240, 50, 190, -1));
        this.jComboBoxCurParity.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Even", "Odd"}));
        this.jComboBoxCurParity.setName("jComboBoxCurParity");
        this.jPanel1.add((Component)this.jComboBoxCurParity, new AbsoluteConstraints(440, 50, -1, -1));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 10, 580, 90));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel2.border.title", new Object[0])));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelNewBaud.setText(resourceMap.getString("jLabelNewBaud.text", new Object[0]));
        this.jLabelNewBaud.setName("jLabelNewBaud");
        this.jPanel2.add((Component)this.jLabelNewBaud, new AbsoluteConstraints(30, 20, 140, -1));
        this.jComboBoxNewSpeed.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxNewSpeed.setToolTipText(resourceMap.getString("jComboBoxNewSpeed.toolTipText", new Object[0]));
        this.jComboBoxNewSpeed.setName("jComboBoxNewSpeed");
        this.jPanel2.add((Component)this.jComboBoxNewSpeed, new AbsoluteConstraints(170, 20, 140, -1));
        this.jComboBoxNewParity.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Odd", "Even"}));
        this.jComboBoxNewParity.setName("jComboBoxNewParity");
        this.jPanel2.add((Component)this.jComboBoxNewParity, new AbsoluteConstraints(320, 20, -1, -1));
        this.jLabelName.setText(resourceMap.getString("jLabelName.text", new Object[0]));
        this.jLabelName.setName("jLabelName");
        this.jPanel2.add((Component)this.jLabelName, new AbsoluteConstraints(30, 50, 140, -1));
        this.jTextFieldBluetoothName.setText(resourceMap.getString("jTextFieldBluetoothName.text", new Object[0]));
        this.jTextFieldBluetoothName.setName("jTextFieldBluetoothName");
        this.jPanel2.add((Component)this.jTextFieldBluetoothName, new AbsoluteConstraints(170, 50, 140, -1));
        this.jTextFieldBluetoothPIN.setText(resourceMap.getString("jTextFieldBluetoothPIN.text", new Object[0]));
        this.jTextFieldBluetoothPIN.setName("jTextFieldBluetoothPIN");
        this.jPanel2.add((Component)this.jTextFieldBluetoothPIN, new AbsoluteConstraints(430, 50, 120, -1));
        this.jLabelPIN.setText(resourceMap.getString("jLabelPIN.text", new Object[0]));
        this.jLabelPIN.setName("jLabelPIN");
        this.jPanel2.add((Component)this.jLabelPIN, new AbsoluteConstraints(330, 50, 100, -1));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jPanel2.add((Component)this.jLabel1, new AbsoluteConstraints(30, 110, 140, -1));
        this.jTextFieldAPName.setText(resourceMap.getString("jTextFieldAPName.text", new Object[0]));
        this.jTextFieldAPName.setName("jTextFieldAPName");
        this.jPanel2.add((Component)this.jTextFieldAPName, new AbsoluteConstraints(170, 110, 140, -1));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jPanel2.add((Component)this.jLabel2, new AbsoluteConstraints(30, 80, 140, -1));
        this.jComboBoxWiFiMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Access Point", "Connect to station"}));
        this.jComboBoxWiFiMode.setName("jComboBoxWiFiMode");
        this.jPanel2.add((Component)this.jComboBoxWiFiMode, new AbsoluteConstraints(170, 80, 140, -1));
        this.jLabelIPPort.setText(resourceMap.getString("jLabelIPPort.text", new Object[0]));
        this.jLabelIPPort.setName("jLabelIPPort");
        this.jPanel2.add((Component)this.jLabelIPPort, new AbsoluteConstraints(330, 80, 100, -1));
        this.jSpinnerIPPort.setModel(new SpinnerNumberModel(0, 0, 65535, 1));
        this.jSpinnerIPPort.setName("jSpinnerIPPort");
        this.jPanel2.add((Component)this.jSpinnerIPPort, new AbsoluteConstraints(430, 80, 60, -1));
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jPanel2.add((Component)this.jLabel3, new AbsoluteConstraints(330, 110, 100, -1));
        this.jTextFieldAPPass.setText(resourceMap.getString("jTextFieldAPPass.text", new Object[0]));
        this.jTextFieldAPPass.setName("jTextFieldAPPass");
        this.jPanel2.add((Component)this.jTextFieldAPPass, new AbsoluteConstraints(430, 110, 120, -1));
        this.jTextFieldSTAName.setText(resourceMap.getString("jTextFieldSTAName.text", new Object[0]));
        this.jTextFieldSTAName.setName("jTextFieldSTAName");
        this.jPanel2.add((Component)this.jTextFieldSTAName, new AbsoluteConstraints(170, 140, 140, -1));
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jPanel2.add((Component)this.jLabel4, new AbsoluteConstraints(30, 140, 140, -1));
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jPanel2.add((Component)this.jLabel5, new AbsoluteConstraints(330, 140, 100, -1));
        this.jTextFieldSTAPass.setText(resourceMap.getString("jTextFieldSTAPass.text", new Object[0]));
        this.jTextFieldSTAPass.setName("jTextFieldSTAPass");
        this.jPanel2.add((Component)this.jTextFieldSTAPass, new AbsoluteConstraints(430, 140, 120, -1));
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jPanel2.add((Component)this.jLabel6, new AbsoluteConstraints(30, 170, 140, -1));
        this.jCheckBoxBLE.setText(resourceMap.getString("jCheckBoxBLE.text", new Object[0]));
        this.jCheckBoxBLE.setName("jCheckBoxBLE");
        this.jPanel2.add((Component)this.jCheckBoxBLE, new AbsoluteConstraints(170, 170, -1, -1));
        this.jCheckBoxBluetoothClassic.setText(resourceMap.getString("jCheckBoxBluetoothClassic.text", new Object[0]));
        this.jCheckBoxBluetoothClassic.setName("jCheckBoxBluetoothClassic");
        this.jPanel2.add((Component)this.jCheckBoxBluetoothClassic, new AbsoluteConstraints(170, 190, -1, -1));
        this.jCheckBoxWiFi.setText(resourceMap.getString("jCheckBoxWiFi.text", new Object[0]));
        this.jCheckBoxWiFi.setName("jCheckBoxWiFi");
        this.jPanel2.add((Component)this.jCheckBoxWiFi, new AbsoluteConstraints(420, 170, -1, -1));
        this.jCheckBoxEthernet.setText(resourceMap.getString("jCheckBoxEthernet.text", new Object[0]));
        this.jCheckBoxEthernet.setName("jCheckBoxEthernet");
        this.jPanel2.add((Component)this.jCheckBoxEthernet, new AbsoluteConstraints(420, 190, -1, -1));
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jPanel2.add((Component)this.jLabel7, new AbsoluteConstraints(30, 250, 140, -1));
        this.jTextFieldIPAddress.setEditable(false);
        this.jTextFieldIPAddress.setText(resourceMap.getString("jTextFieldIPAddress.text", new Object[0]));
        this.jTextFieldIPAddress.setName("jTextFieldIPAddress");
        this.jPanel2.add((Component)this.jTextFieldIPAddress, new AbsoluteConstraints(170, 250, 150, -1));
        this.jButton1.setAction(actionMap.get("buttonCopyIP"));
        this.jButton1.setName("jButton1");
        this.jPanel2.add((Component)this.jButton1, new AbsoluteConstraints(330, 250, 30, -1));
        this.jLabelBFN.setText(resourceMap.getString("jLabelBFN.text", new Object[0]));
        this.jLabelBFN.setName("jLabelBFN");
        this.jPanel2.add((Component)this.jLabelBFN, new AbsoluteConstraints(30, 220, 140, -1));
        this.jComboBoxButtonFn.setName("jComboBoxButtonFn");
        this.jPanel2.add((Component)this.jComboBoxButtonFn, new AbsoluteConstraints(170, 220, 250, -1));
        this.getContentPane().add((Component)this.jPanel2, new AbsoluteConstraints(10, 100, 580, 290));
        this.jButtonDefaults.setAction(actionMap.get("buttonResetDefaults"));
        this.jButtonDefaults.setText(resourceMap.getString("jButtonDefaults.text", new Object[0]));
        this.jButtonDefaults.setToolTipText(resourceMap.getString("jButtonDefaults.toolTipText", new Object[0]));
        this.jButtonDefaults.setName("jButtonDefaults");
        this.getContentPane().add((Component)this.jButtonDefaults, new AbsoluteConstraints(20, 480, 180, 30));
        this.jButtonRestart.setAction(actionMap.get("restartModule"));
        this.jButtonRestart.setToolTipText(resourceMap.getString("jButtonRestart.toolTipText", new Object[0]));
        this.jButtonRestart.setName("jButtonRestart");
        this.getContentPane().add((Component)this.jButtonRestart, new AbsoluteConstraints(200, 480, 30, 30));
        this.jButtonRead.setAction(actionMap.get("buttonRead"));
        this.jButtonRead.setText(resourceMap.getString("jButtonRead.text", new Object[0]));
        this.jButtonRead.setToolTipText(resourceMap.getString("jButtonRead.toolTipText", new Object[0]));
        this.jButtonRead.setName("jButtonRead");
        this.getContentPane().add((Component)this.jButtonRead, new AbsoluteConstraints(240, 480, 110, 30));
        this.jButtonWrite.setAction(actionMap.get("buttonWrite"));
        this.jButtonWrite.setText(resourceMap.getString("jButtonWrite.text", new Object[0]));
        this.jButtonWrite.setToolTipText(resourceMap.getString("jButtonWrite.toolTipText", new Object[0]));
        this.jButtonWrite.setName("jButtonWrite");
        this.getContentPane().add((Component)this.jButtonWrite, new AbsoluteConstraints(360, 480, 110, 30));
        this.jButtoCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtoCancel.setText(resourceMap.getString("jButtoCancel.text", new Object[0]));
        this.jButtoCancel.setName("jButtoCancel");
        this.getContentPane().add((Component)this.jButtoCancel, new AbsoluteConstraints(480, 480, 110, 30));
        this.jSeparator3.setName("jSeparator3");
        this.getContentPane().add((Component)this.jSeparator3, new AbsoluteConstraints(0, 520, 600, 10));
        this.jLabelAT.setText(resourceMap.getString("jLabelAT.text", new Object[0]));
        this.jLabelAT.setName("jLabelAT");
        this.getContentPane().add((Component)this.jLabelAT, new AbsoluteConstraints(10, 530, -1, -1));
        this.jTextFieldAT.setText(resourceMap.getString("jTextFieldAT.text", new Object[0]));
        this.jTextFieldAT.setName("jTextFieldAT");
        this.getContentPane().add((Component)this.jTextFieldAT, new AbsoluteConstraints(210, 530, 310, -1));
        this.jButtonSend.setAction(actionMap.get("buttonSend"));
        this.jButtonSend.setText(resourceMap.getString("jButtonSend.text", new Object[0]));
        this.jButtonSend.setName("jButtonSend");
        this.getContentPane().add((Component)this.jButtonSend, new AbsoluteConstraints(530, 530, -1, -1));
        this.jScrollPane2.setName("jScrollPane2");
        this.jTextAreaDebugCmd.setColumns(20);
        this.jTextAreaDebugCmd.setEditable(false);
        this.jTextAreaDebugCmd.setRows(5);
        this.jTextAreaDebugCmd.setComponentPopupMenu(this.jPopupMenuDebug);
        this.jTextAreaDebugCmd.setName("jTextAreaDebugCmd");
        this.jScrollPane2.setViewportView(this.jTextAreaDebugCmd);
        this.getContentPane().add((Component)this.jScrollPane2, new AbsoluteConstraints(10, 560, 580, 110));
        this.jScrollPane3.setFocusable(false);
        this.jScrollPane3.setName("jScrollPane3");
        this.jTextAreaInfo.setColumns(20);
        this.jTextAreaInfo.setEditable(false);
        this.jTextAreaInfo.setRows(4);
        this.jTextAreaInfo.setBorder(null);
        this.jTextAreaInfo.setName("jTextAreaInfo");
        this.jScrollPane3.setViewportView(this.jTextAreaInfo);
        this.getContentPane().add((Component)this.jScrollPane3, new AbsoluteConstraints(10, 390, 580, 80));
        this.pack();
    }

    public DialogMultilink(Frame parent) throws Exception {
        super(DialogMultilink.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_multilink", new Object[0]));
        if (!BoardInfo.checkMinPartnerFirmwareVer(2553)) {
            throw new Exception("Firmware version 2.55b3 or greater is required!");
        }
        this.initComponents();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogMultilink.this.buttonSend();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        for (JComboBox b : this.speedBox = new JComboBox[]{this.jComboBoxCurSpeed, this.jComboBoxNewSpeed}) {
            int i;
            DefaultComboBoxModel tmp = (DefaultComboBoxModel)b.getModel();
            tmp.removeAllElements();
            if (b.equals(this.jComboBoxCurSpeed)) {
                for (i = 0; i < SerialPortService.SERIAL_BAUD_RATES_EXTENDED.length; ++i) {
                    String rate = Integer.toString(SerialPortService.SERIAL_BAUD_RATES_EXTENDED[i]);
                    if (i == 0) {
                        rate = rate + " (default)";
                    }
                    tmp.addElement(rate);
                }
                b.setSelectedIndex(0);
                continue;
            }
            for (i = 0; i < SERIAL_BAUD_RATES.length; ++i) {
                tmp.addElement(SERIAL_BAUD_RATES[i]);
            }
        }
        this.jComboBoxButtonFn.setModel(new SpravComboBoxModel(SpravComboBoxModel.elementsFromArray(new String[]{"None", "Restart", "Temporary WiFi AP password off", "Connect to WiFi station", "Restore default settings"}, 0)));
        DefaultCaret caret = (DefaultCaret)this.jTextAreaDebugCmd.getCaret();
        caret.setUpdatePolicy(2);
        EmptyIcon.setTo(this.jMenuItemClear);
        SerialCommandDispatcher.getInstance().addResponseListener(this);
        this.rtPauseState = RealtimeDataThread.pause(true);
        this.setReady(true);
    }

    void applyConnectionParams() throws Exception {
        this.portIdx = this.jComboBoxPort.getSelectedIndex();
        this.curSpeed = this.jComboBoxCurSpeed.getSelectedIndex();
        this.curParity = this.jComboBoxCurParity.getSelectedIndex();
    }

    @Action(enabledProperty="ready")
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action(enabledProperty="readyWrite")
    public void buttonWrite() {
        try {
            final int newSpeed = this.jComboBoxNewSpeed.getSelectedIndex();
            final int newParity = this.jComboBoxNewParity.getSelectedIndex();
            final String bt_name = this.jTextFieldBluetoothName.getText();
            final String bt_pin = this.jTextFieldBluetoothPIN.getText();
            final int wifi_mode = this.jComboBoxWiFiMode.getSelectedIndex();
            final String wifi_ap_name = this.jTextFieldAPName.getText();
            final String wifi_ap_pass = this.jTextFieldAPPass.getText();
            final int ip_port = ((Number)this.jSpinnerIPPort.getValue()).intValue();
            final String wifi_sta_name = this.jTextFieldSTAName.getText();
            final String wifi_sta_pass = this.jTextFieldSTAPass.getText();
            final int bfn = ((SpravComboBoxModel)this.jComboBoxButtonFn.getModel()).getCurrentId();
            String modules = "";
            if (this.jCheckBoxEthernet.isSelected()) {
                modules = modules + "E";
            }
            if (this.jCheckBoxWiFi.isSelected()) {
                modules = modules + "W";
            }
            if (this.jCheckBoxBLE.isSelected()) {
                modules = modules + "L";
            }
            if (this.jCheckBoxBluetoothClassic.isSelected()) {
                modules = modules + "C";
            }
            final String modules_f = modules;
            new Thread(){

                @Override
                public void run() {
                    try {
                        DialogMultilink.this.enterCommandMode();
                        if (DialogMultilink.this.sendATCmdAndWaitResponse("ML#SERVICE", 3000)) {
                            if (DialogMultilink.this.sendATCmdAndWaitResponse("ML-EN-" + modules_f, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-WFM-" + wifi_mode, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-APN-" + wifi_ap_name, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-APP-" + wifi_ap_pass, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-SN-" + wifi_sta_name, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-SP-" + wifi_sta_pass, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-BTN-" + bt_name, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-BTP-" + bt_pin, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-SPS-" + newSpeed, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-SPP-" + newParity, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-BFN-" + bfn, 3000) && DialogMultilink.this.sendATCmdAndWaitResponse("ML-PRT-" + ip_port, 3000)) {
                                DialogMultilink.this.logMessage("Module was configured successfuly.");
                                DialogMultilink.this.sendATCmdAndWaitResponse("ML#RS", 3000);
                                DialogMultilink.this.logMessage("Module was restarted.");
                            } else {
                                DialogMultilink.this.logErrorMessage("Failed to configure module.");
                            }
                        } else {
                            DialogMultilink.this.logErrorMessage(DialogMultilink.this.resourceMap.getString("error.enter_service", new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        DialogMultilink.this.logErrorMessage(e.toString());
                    }
                    DialogMultilink.this.setReady(true);
                }
            }.start();
        }
        catch (Exception e) {
            this.logErrorMessage(e.toString());
            SimpleBGC_GUIApp.mainView.showErrorMessage(e.getMessage());
        }
    }

    @Override
    public void onCloseDialog() {
        SerialCommandDispatcher.getInstance().removeResponseListener(this);
        RealtimeDataThread.pause(this.rtPauseState);
    }

    @Action(enabledProperty="ready")
    public void buttonSend() {
        try {
            this.enterCommandMode();
            this.sendATCmdAndWaitResponse(this.jTextFieldAT.getText(), 3000);
            this.setReady(true);
        }
        catch (Exception e) {
            this.logErrorMessage(e.toString());
        }
    }

    @Action(enabledProperty="ready")
    public void buttonResetDefaults() {
        if (!SimpleBGC_GUIApp.mainView.showConfirmDialog(this.resourceMap.getString("confirm.bt_reset_to_defaults", new Object[0]))) {
            return;
        }
        try {
            new Thread(){

                @Override
                public void run() {
                    try {
                        DialogMultilink.this.enterCommandMode();
                        if (DialogMultilink.this.sendATCmdAndWaitResponse("ML#SERVICE", 3000)) {
                            if (DialogMultilink.this.sendATCmdAndWaitResponse("ML#DP", 3000)) {
                                DialogMultilink.this.logMessage("Module was reset to factory defaults.");
                                DialogMultilink.this.setReadyWrite(false);
                                Thread.sleep(500L);
                                DialogMultilink.this._readParams();
                            }
                        } else {
                            DialogMultilink.this.logErrorMessage(DialogMultilink.this.resourceMap.getString("error.enter_service", new Object[0]));
                        }
                    }
                    catch (Exception e) {
                        DialogMultilink.this.logErrorMessage(e.toString());
                    }
                    DialogMultilink.this.setReady(true);
                }
            }.start();
        }
        catch (Exception e) {
            this.logErrorMessage(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommandReceived(SerialCommand cmd) {
        DialogMultilink dialogMultilink = this;
        synchronized (dialogMultilink) {
            if (this.response == null) {
                this.response = new ArrayList();
            }
            this.response.add(cmd);
            try {
                String resp_str = new String(cmd.readBytes(cmd.getBytesAvailable()), Charset.forName("ISO-8859-1"));
                cmd.startReading();
                this.logMessage("<" + resp_str);
            }
            catch (Exception e) {
                this.logErrorMessage(e.toString());
            }
            this.notify();
        }
    }

    @Override
    public int getCommandId() {
        return 60;
    }

    public void sendUartCmd(byte[] data, int needResponse, int delimiter, int waitTimeout) throws Exception {
        SerialCommand cmd = new SerialCommand(60);
        cmd.writeByte(this.portIdx);
        cmd.writeByte(this.curSpeed);
        cmd.writeByte(this.curParity);
        cmd.writeByte(needResponse);
        cmd.writeByte(delimiter);
        cmd.writeWord(waitTimeout);
        cmd.writeEmptyArr(12);
        cmd.write(data);
        SerialCommandProcessor.sendCommand(cmd);
    }

    synchronized boolean sendATCmdAndWaitResponse(String atCmd, int timeout) throws Exception {
        return this.sendATCmdAndWaitResponse(atCmd, timeout, false);
    }

    synchronized boolean sendATCmdAndWaitResponse(String atCmd, int timeout, boolean multipartExpected) throws Exception {
        this.logMessage(">" + atCmd);
        this.response = null;
        atCmd = atCmd + "\r\n";
        this.sendUartCmd(atCmd.getBytes(Charset.forName("ISO-8859-1")), 1, 0, timeout);
        this.logger.trace("Waiting for the answer (" + timeout + ")..");
        this.wait(timeout);
        if (multipartExpected) {
            this.logger.trace("Waiting for multi-part answer (600)..");
            this.wait(600L);
        }
        if (this.response != null) {
            try {
                StringBuilder buf = new StringBuilder();
                for (SerialCommand cmd : this.response) {
                    buf.append(new String(cmd.readBytes(cmd.getBytesAvailable()), Charset.forName("ISO-8859-1")));
                }
                this.responseStr = buf.toString();
                if (this.responseStr.length() > 0) {
                    if (this.responseStr.startsWith("OK:")) {
                        return true;
                    }
                    if (this.responseStr.startsWith("ERROR:")) {
                        this.logErrorMessage(this.responseStr.substring(6));
                        return false;
                    }
                    this.logErrorMessage("Unexpected answer: " + this.responseStr);
                    return false;
                }
                this.logErrorMessage("Empty response");
            }
            catch (Exception e) {
                this.logErrorMessage(e.toString());
            }
        } else {
            this.logErrorMessage("No response");
        }
        return false;
    }

    String strip_OK_ERR(String resp) {
        return resp.replaceFirst("^(OK:|ERROR:)\\s*", "");
    }

    public void logErrorMessage(String msg) {
        this.jTextAreaDebugCmd.append("ERR: " + msg + "\n");
    }

    public void logMessage(String msg) {
        this.jTextAreaDebugCmd.append(msg + "\n");
    }

    public void enterCommandMode() throws Exception {
        this.applyConnectionParams();
        this.setReady(false);
    }

    public void setReady(boolean state) {
        boolean oldReady = this.isReady();
        boolean oldReadyWrite = this.isReadyWrite();
        this.isReady = state;
        this.firePropertyChange("ready", oldReady, this.isReady());
        this.firePropertyChange("readyWrite", oldReadyWrite, this.isReadyWrite());
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void setReadyWrite(boolean busy) {
        boolean oldReadyWrite = this.isReadyWrite();
        this.isReadyWrite = busy;
        this.firePropertyChange("readyWrite", oldReadyWrite, this.isReadyWrite());
    }

    public boolean isReadyWrite() {
        return this.isReady && this.isReadyWrite;
    }

    @Action(enabledProperty="ready")
    public void restartModule() {
        new Thread(){

            @Override
            public void run() {
                try {
                    DialogMultilink.this.enterCommandMode();
                    if (DialogMultilink.this.sendATCmdAndWaitResponse("ML#SERVICE", 3000)) {
                        if (DialogMultilink.this.sendATCmdAndWaitResponse("ML#RS", 3000)) {
                            DialogMultilink.this.logMessage("Module is restarted.");
                        } else {
                            DialogMultilink.this.logErrorMessage("Failed to restart module");
                        }
                    } else {
                        DialogMultilink.this.logErrorMessage(DialogMultilink.this.resourceMap.getString("error.enter_service", new Object[0]));
                    }
                }
                catch (Exception e) {
                    DialogMultilink.this.logErrorMessage(e.toString());
                }
                DialogMultilink.this.setReady(true);
            }
        }.start();
    }

    @Action(enabledProperty="ready")
    public void buttonRead() {
        new Thread(){

            @Override
            public void run() {
                try {
                    DialogMultilink.this.enterCommandMode();
                    DialogMultilink.this._readParams();
                }
                catch (Exception e) {
                    DialogMultilink.this.logErrorMessage(e.toString());
                }
                DialogMultilink.this.setReady(true);
            }
        }.start();
    }

    void _readParams() throws Exception {
        this.jTextAreaInfo.setText(null);
        if (this.sendATCmdAndWaitResponse("ML#SERVICE", 3000)) {
            if (this.sendATCmdAndWaitResponse("ML+INFO", 3000, true) && this.responseStr != null) {
                this.responseStr = this.strip_OK_ERR(this.responseStr);
                Map<String, String> info = DialogMultilink.parseNameValue(this.responseStr);
                if (info.containsKey("IPA")) {
                    this.jTextFieldIPAddress.setText(info.get("IPA"));
                }
                this.jTextAreaInfo.setText(this.responseStr);
            }
            if (this.sendATCmdAndWaitResponse("ML+LIST", 3000, true)) {
                if (this.responseStr != null) {
                    final Map<String, String> list = DialogMultilink.parseNameValue(this.responseStr);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ArrayList<String> missedNames = new ArrayList<String>();
                                if (list.containsKey("SPS")) {
                                    int baud = Integer.parseInt((String)list.get("SPS"));
                                    for (int i = 0; i < SERIAL_BAUD_RATES.length; ++i) {
                                        if (SERIAL_BAUD_RATES[i] != baud) continue;
                                        DialogMultilink.this.jComboBoxNewSpeed.setSelectedIndex(i);
                                        break;
                                    }
                                } else {
                                    missedNames.add("SPS");
                                }
                                if (list.containsKey("SPP")) {
                                    DialogMultilink.this.jComboBoxNewParity.setSelectedIndex(Integer.parseInt((String)list.get("SPP")));
                                } else {
                                    missedNames.add("SPP");
                                }
                                if (list.containsKey("WFM")) {
                                    DialogMultilink.this.jComboBoxWiFiMode.setSelectedIndex(Integer.parseInt((String)list.get("WFM")));
                                } else {
                                    missedNames.add("WFM");
                                }
                                if (list.containsKey("APN")) {
                                    DialogMultilink.this.jTextFieldAPName.setText((String)list.get("APN"));
                                } else {
                                    missedNames.add("APN");
                                }
                                if (list.containsKey("APP")) {
                                    DialogMultilink.this.jTextFieldAPPass.setText((String)list.get("APP"));
                                } else {
                                    missedNames.add("APP");
                                }
                                if (list.containsKey("EN")) {
                                    String modules = (String)list.get("EN");
                                    DialogMultilink.this.jCheckBoxEthernet.setSelected(modules.contains("E"));
                                    DialogMultilink.this.jCheckBoxWiFi.setSelected(modules.contains("W"));
                                    DialogMultilink.this.jCheckBoxBluetoothClassic.setSelected(modules.contains("C"));
                                    DialogMultilink.this.jCheckBoxBLE.setSelected(modules.contains("L"));
                                } else {
                                    missedNames.add("EN");
                                }
                                if (list.containsKey("SN")) {
                                    DialogMultilink.this.jTextFieldSTAName.setText((String)list.get("SN"));
                                } else {
                                    missedNames.add("SN");
                                }
                                if (list.containsKey("SP")) {
                                    DialogMultilink.this.jTextFieldSTAPass.setText((String)list.get("SP"));
                                } else {
                                    missedNames.add("SP");
                                }
                                if (list.containsKey("BTN")) {
                                    DialogMultilink.this.jTextFieldBluetoothName.setText((String)list.get("BTN"));
                                } else {
                                    missedNames.add("BTN");
                                }
                                if (list.containsKey("BTP")) {
                                    DialogMultilink.this.jTextFieldBluetoothPIN.setText((String)list.get("BTP"));
                                } else {
                                    missedNames.add("BTP");
                                }
                                if (list.containsKey("BFN")) {
                                    ((SpravComboBoxModel)DialogMultilink.this.jComboBoxButtonFn.getModel()).setCurrentOrAdd(Integer.parseInt((String)list.get("BFN")), "function");
                                } else {
                                    missedNames.add("BFN");
                                }
                                if (list.containsKey("PRT")) {
                                    DialogMultilink.this.jSpinnerIPPort.setValue(Integer.parseInt((String)list.get("PRT")));
                                } else {
                                    missedNames.add("PRT");
                                }
                                if (!missedNames.isEmpty()) {
                                    DialogMultilink.this.logErrorMessage("Missed parameters: " + String.join((CharSequence)",", missedNames));
                                }
                            }
                            catch (Exception e) {
                                DialogMultilink.this.logErrorMessage("Error parsing parameters: " + e.toString());
                            }
                        }
                    });
                } else {
                    this.logErrorMessage("Unexpected list format");
                }
                this.setReadyWrite(true);
            }
        } else {
            this.logErrorMessage(this.resourceMap.getString("error.enter_service", new Object[0]));
        }
    }

    public static Map<String, String> parseNameValue(String text) {
        String[] lines;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String line : lines = text.split("\\R")) {
            Matcher matcher = LINE_PATTERN.matcher(line.trim());
            if (!matcher.matches()) continue;
            String name = matcher.group(1).trim();
            String value = matcher.group(2).trim();
            value = VALUE_CLEAN_PATTERN.matcher(value).replaceFirst("");
            result.put(name, value);
        }
        return result;
    }

    @Action
    public void buttonCopyIP() {
        StringSelection stringSelection = new StringSelection(this.jTextFieldIPAddress.getText());
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    @Action
    public void menuDebugClear() {
        this.jTextAreaDebugCmd.setText(null);
    }
}

