/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.object.BoardParams;
import sbgc.object.RealtimeData;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.ui.TabbedPanelMonitoring;
import sbgc.utils.FileUtil;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogSensorPosition
extends MyDialog
implements Runnable {
    private JButton jButtonCancel;
    private JButton jButtonNext;
    private JButton jButtonSave;
    private JLabel jLabelHelp;
    private JLabel jLabelResult;
    private JLabel jLabelRight;
    private JLabel jLabelRightLabel;
    private JLabel jLabelTop;
    private JLabel jLabelTopLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    public final int STATE_DISABLED = 0;
    public final int STATE_ACTIVE = 1;
    StepImage[] stepImages = null;
    JComponent[] imgContainers = null;
    int sensorType;
    int curStep = -1;
    int axisTop = 0;
    int axisRight = 0;
    int oldAxisTop = 0;
    int oldAxisRight = 0;
    BoardParams params = null;
    boolean oldRtDataState;
    static final int[] T_ACC0 = new int[]{-1, -2, 3};
    int[] T_ACC = new int[]{0, 0, 0};

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabelTopLabel = new JLabel();
        this.jLabelRightLabel = new JLabel();
        this.jLabelTop = new JLabel();
        this.jLabelRight = new JLabel();
        this.jLabelResult = new JLabel();
        this.jButtonNext = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelHelp = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setPreferredSize(new Dimension(120, 120));
        this.jPanel1.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(10, 11, -1, -1));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setPreferredSize(new Dimension(120, 120));
        this.jPanel2.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel2, new AbsoluteConstraints(136, 11, -1, -1));
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setPreferredSize(new Dimension(120, 120));
        this.jPanel3.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel3, new AbsoluteConstraints(262, 11, -1, -1));
        this.jPanel5.setName("jPanel5");
        this.jPanel5.setPreferredSize(new Dimension(120, 120));
        this.jPanel5.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelTopLabel.setFont(this.jLabelTopLabel.getFont().deriveFont((float)this.jLabelTopLabel.getFont().getSize() + 7.0f));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogSensorPosition.class);
        this.jLabelTopLabel.setText(resourceMap.getString("jLabelTopLabel.text", new Object[0]));
        this.jLabelTopLabel.setName("jLabelTopLabel");
        this.jPanel5.add((Component)this.jLabelTopLabel, new AbsoluteConstraints(10, 50, 70, -1));
        this.jLabelRightLabel.setFont(this.jLabelRightLabel.getFont().deriveFont((float)this.jLabelRightLabel.getFont().getSize() + 7.0f));
        this.jLabelRightLabel.setText(resourceMap.getString("jLabelRightLabel.text", new Object[0]));
        this.jLabelRightLabel.setName("jLabelRightLabel");
        this.jPanel5.add((Component)this.jLabelRightLabel, new AbsoluteConstraints(10, 80, 70, -1));
        this.jLabelTop.setFont(this.jLabelTop.getFont().deriveFont(this.jLabelTop.getFont().getStyle() | 1, this.jLabelTop.getFont().getSize() + 7));
        this.jLabelTop.setText(resourceMap.getString("jLabelTop.text", new Object[0]));
        this.jLabelTop.setName("jLabelTop");
        this.jPanel5.add((Component)this.jLabelTop, new AbsoluteConstraints(90, 50, -1, -1));
        this.jLabelRight.setFont(this.jLabelRight.getFont().deriveFont(this.jLabelRight.getFont().getStyle() | 1, this.jLabelRight.getFont().getSize() + 7));
        this.jLabelRight.setText(resourceMap.getString("jLabelRight.text", new Object[0]));
        this.jLabelRight.setName("jLabelRight");
        this.jPanel5.add((Component)this.jLabelRight, new AbsoluteConstraints(90, 80, -1, -1));
        this.jLabelResult.setText(resourceMap.getString("jLabelResult.text", new Object[0]));
        this.jLabelResult.setName("jLabelResult");
        this.jPanel5.add((Component)this.jLabelResult, new AbsoluteConstraints(10, 10, 70, -1));
        this.getContentPane().add((Component)this.jPanel5, new AbsoluteConstraints(390, 10, -1, -1));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogSensorPosition.class, this);
        this.jButtonNext.setAction(actionMap.get("buttonStart"));
        this.jButtonNext.setText(resourceMap.getString("jButtonNext.text", new Object[0]));
        this.jButtonNext.setName("jButtonNext");
        this.getContentPane().add((Component)this.jButtonNext, new AbsoluteConstraints(10, 200, 120, 30));
        this.jButtonSave.setAction(actionMap.get("buttonSave"));
        this.jButtonSave.setText(resourceMap.getString("jButtonSave.text", new Object[0]));
        this.jButtonSave.setName("jButtonSave");
        this.getContentPane().add((Component)this.jButtonSave, new AbsoluteConstraints(390, 200, 120, 30));
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.getContentPane().add((Component)this.jButtonCancel, new AbsoluteConstraints(260, 200, 120, 30));
        this.jLabelHelp.setText(resourceMap.getString("jLabelHelp.text", new Object[0]));
        this.jLabelHelp.setVerticalAlignment(1);
        this.jLabelHelp.setName("jLabelHelp");
        this.getContentPane().add((Component)this.jLabelHelp, new AbsoluteConstraints(10, 140, 500, 50));
        this.pack();
    }

    public DialogSensorPosition(Frame parent, int sensorType) {
        super(DialogSensorPosition.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_sensor_position", new Object[0]));
        this.initComponents();
        this.sensorType = sensorType;
        this.imgContainers = new JComponent[]{this.jPanel1, this.jPanel2, this.jPanel3};
        try {
            this.stepImages = new StepImage[]{new StepImage(sensorType, "level"), new StepImage(sensorType, "right"), new StepImage(sensorType, "done")};
        }
        catch (Exception e) {
            this.showError(e.toString());
            return;
        }
        for (int step = 0; step < this.stepImages.length; ++step) {
            JLabel imageLabel = new JLabel();
            this.imgContainers[step].add((Component)imageLabel, "Center");
            this.setStepImage(step, 0);
        }
        this.params = BoardParams.getCurParams();
        if (this.params != null) {
            if (sensorType == 1) {
                this.oldAxisTop = this.params.axisTop;
                this.oldAxisRight = this.params.axisRight;
            } else if (sensorType == 2) {
                this.oldAxisTop = this.params.frameAxisTop;
                this.oldAxisRight = this.params.frameAxisRight;
            }
        }
        if (this.oldAxisTop != 0 && this.oldAxisRight != 0) {
            this.initAxisMap(this.oldAxisTop, this.oldAxisRight);
            this.oldRtDataState = RealtimeDataThread.pause(false);
            TabbedPanelMonitoring.UPD_GROUP_ACC.setEnabled(true);
            this.setStep(0);
            new Thread(this).start();
        } else {
            this.showError(this.resourceMap.getString("error.start", new Object[0]));
        }
    }

    final void setStep(int step) {
        if (this.curStep >= 0) {
            this.setStepImage(this.curStep, 0);
        }
        this.curStep = step;
        this.setStepImage(this.curStep, 1);
        this.jLabelHelp.setText("<html>" + this.resourceMap.getString("step." + (step + 1), new Object[0]) + "</html>");
        this.showResult();
    }

    private void showResult() {
        this.jLabelTop.setText(BoardParams.axisMapToString(this.axisTop));
        this.jLabelRight.setText(BoardParams.axisMapToString(this.axisRight));
    }

    final void setStepImage(int step, int state) {
        ((JLabel)this.imgContainers[step].getComponent(0)).setIcon(this.stepImages[step].stateIcons[state]);
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonStart() {
        this.setStep(1);
        this.jButtonNext.setEnabled(false);
    }

    @Action
    public void buttonSave() {
        if (this.params != null && this.axisRight != 0 && this.axisTop != 0 && Math.abs(this.axisRight) != Math.abs(this.axisTop)) {
            this.logger.debug("Saving new sensor configuration..");
            if (this.sensorType == 1) {
                this.params.axisRight = this.axisRight;
                this.params.axisTop = this.axisTop;
            } else if (this.sensorType == 2) {
                this.params.frameAxisRight = this.axisRight;
                this.params.frameAxisTop = this.axisTop;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIApp.mainView.updateBoardParams();
                }
            });
            SerialCommandProcessor.writeAllParams(this.params, this.params.curProfile, SimpleBGC_GUIApp.mainView);
        }
        this.closeDialog(1);
    }

    @Override
    public void onCloseDialog() {
        RealtimeDataThread.pause(this.oldRtDataState);
    }

    public void showError(String error) {
        this.jLabelHelp.setText("<html><b>ERROR:</b> " + error + "</html>");
    }

    @Override
    public void run() {
        int[] accData = new int[3];
        long startTime = 0L;
        while (!this.isClosed()) {
            RealtimeData rtData = RealtimeData.getRealtimeData();
            if (rtData != null) {
                if (rtData.curIMU == this.sensorType) {
                    this.mapAxisBack(rtData.curIMU == 2 && rtData.frame_acc != null ? rtData.frame_acc : rtData.acc, accData, this.T_ACC);
                    if (this.curStep == 0) {
                        int top = this.getAxisTop(accData);
                        if (top != this.axisTop) {
                            this.axisTop = top;
                            this.showResult();
                            this.jButtonNext.setEnabled(top != 0);
                        }
                    } else if (this.curStep == 1) {
                        int right = -this.getAxisTop(accData);
                        if (right != this.axisRight && Math.abs(right) != Math.abs(this.axisTop)) {
                            this.axisRight = right;
                            this.showResult();
                            startTime = System.currentTimeMillis();
                        }
                        if (this.axisRight != 0 && System.currentTimeMillis() - startTime > 1000L) {
                            this.jButtonSave.setEnabled(true);
                            this.setStep(2);
                            FileUtil.playSound("switch.wav", 1);
                        }
                    } else if (this.curStep == 2) {
                        break;
                    }
                } else {
                    SerialCommandProcessor.sendCommand(new SerialCommand(24, new byte[]{(byte)this.sensorType}));
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                this.logger.debug("Monitoring thread interrupted");
                return;
            }
        }
        this.logger.debug("Monitoring thread finished normally.");
    }

    private int getAxisTop(int[] accData) {
        int axis = this.findMaxVectorIdx(accData);
        if (axis >= 0) {
            return accData[axis] > 0 ? axis + 1 : -(axis + 1);
        }
        return 0;
    }

    private int findMaxVectorIdx(int[] v) {
        for (int idx = 0; idx < 3; ++idx) {
            int abs2 = Math.abs(v[idx]) / 2;
            if (abs2 <= Math.abs(v[(idx + 1) % 3]) || abs2 <= Math.abs(v[(idx + 2) % 3])) continue;
            return idx;
        }
        return -1;
    }

    private void initAxisMap(int axisTop, int axisRight) {
        int i;
        int[][] R = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
        for (i = 0; i < 3; ++i) {
            if (axisRight == i + 1) {
                R[0][i] = 1;
            } else if (-axisRight == i + 1) {
                R[0][i] = -1;
            }
            if (axisTop == i + 1) {
                R[2][i] = 1;
                continue;
            }
            if (-axisTop != i + 1) continue;
            R[2][i] = -1;
        }
        this.vectorCrossProduct(R[2], R[0], R[1]);
        for (i = 0; i < 3; ++i) {
            this.T_ACC[i] = 0;
            int acc_index = T_ACC0[i];
            for (int j = 0; j < 3; ++j) {
                int n = i;
                this.T_ACC[n] = this.T_ACC[n] + (j + 1) * R[Math.abs(acc_index) - 1][j] * (acc_index > 0 ? 1 : -1);
            }
        }
    }

    void vectorCrossProduct(int[] a, int[] b, int[] res) {
        res[0] = a[1] * b[2] - a[2] * b[1];
        res[1] = a[2] * b[0] - a[0] * b[2];
        res[2] = a[0] * b[1] - a[1] * b[0];
    }

    void mapAxis(int[] from, int[] to, int[] map) {
        for (int i = 0; i < 3; ++i) {
            to[i] = map[i] > 0 ? from[map[i] - 1] : -from[-map[i] - 1];
        }
    }

    void mapAxisBack(int[] from, int[] to, int[] map) {
        for (int i = 0; i < 3; ++i) {
            if (map[i] > 0) {
                to[map[i] - 1] = from[i];
                continue;
            }
            to[-map[i] - 1] = -from[i];
        }
    }

    class StepImage {
        public ImageIcon[] stateIcons = null;

        StepImage(int sensorType, String step) {
            String sType = sensorType == 2 ? "frame" : "cam";
            this.stateIcons = new ImageIcon[]{new ImageIcon(DialogSensorPosition.class.getResource("/simplebgc_gui/resources/sens_pos/" + sType + "_" + step + "_dis.gif")), new ImageIcon(DialogSensorPosition.class.getResource("/simplebgc_gui/resources/sens_pos/" + sType + "_" + step + ".gif"))};
        }
    }
}

