/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import sbgc.common.IProfileTemplate;
import sbgc.common.ProfileTemplateFactory;
import sbgc.object.Sprav;
import sbgc.service.SerialPortService;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.utils.ListModelProfileTemplatesImpl;
import sbgc.utils.BGCJFileLoader;
import sbgc.utils.Settings;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogSettings
extends MyDialog {
    private LinkedHashSet<IProfileTemplate> profileTemplates = new LinkedHashSet();
    private JButton btnProfileTemplateAdd;
    private JButton btnProfileTemplateDelete;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler fillerProfileTemplateButtons;
    private JButton jButtoCancel;
    private JButton jButtonSave;
    private JCheckBox jCheckBoxLogRTData;
    private JCheckBox jCheckBoxLogRTDataRewrite;
    private JCheckBox jCheckBoxSerialBaudAuto;
    private JComboBox jComboBoxProtocolVer;
    private JComboBox jComboBoxSerialBaud;
    private JComboBox jComboBoxSerialParity;
    private JComboBox jComboBoxTunnelType;
    private JLabel jLabelMavLinkTunnelCompId;
    private JLabel jLabelPassword;
    private JLabel jLabelProtocolVer;
    private JLabel jLabelRemoteNote;
    private JLabel jLabelSerialBaud;
    private JLabel jLabelSerialParity;
    private JLabel jLabelUDPHost;
    private JLabel jLabelUDPHost1;
    private JLabel jLabelUDPLocalPort;
    private JPanel jPanel1;
    private JPanel jPanelMavLinkTunnel;
    private JPanel jPanelProtection;
    private JPanel jPanelSerial;
    private JPanel jPanelTCP;
    private JPanel jPanelUDP;
    private JSpinner jSpinnerMavLinkTunnelCompId;
    private JSpinner jSpinnerTCPPort;
    private JSpinner jSpinnerUDPLocalPort;
    private JSpinner jSpinnerUDPRemotePort;
    private JTextField jTextFieldPassword;
    private JTextField jTextFieldTCPHost;
    private JTextField jTextFieldUDPHost;
    private JList listProfileTemplates;
    private JPanel panelButtons;
    private JPanel panelProfileTemplatesButtons;
    private JPanel panelProfiles;
    private JScrollPane scrollpaneProfileTemplates;

    private void initComponents() {
        this.jPanelSerial = new JPanel();
        this.jLabelSerialBaud = new JLabel();
        this.jComboBoxSerialBaud = new JComboBox();
        this.jLabelSerialParity = new JLabel();
        this.jComboBoxSerialParity = new JComboBox();
        this.jCheckBoxSerialBaudAuto = new JCheckBox();
        this.jLabelProtocolVer = new JLabel();
        this.jComboBoxProtocolVer = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jCheckBoxLogRTData = new JCheckBox();
        this.jCheckBoxLogRTDataRewrite = new JCheckBox();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanelUDP = new JPanel();
        this.jLabelUDPHost = new JLabel();
        this.jTextFieldUDPHost = new JTextField();
        this.jSpinnerUDPRemotePort = new JSpinner();
        this.jLabelUDPLocalPort = new JLabel();
        this.jSpinnerUDPLocalPort = new JSpinner();
        this.jLabelRemoteNote = new JLabel();
        this.jPanelTCP = new JPanel();
        this.jLabelUDPHost1 = new JLabel();
        this.jTextFieldTCPHost = new JTextField();
        this.jSpinnerTCPPort = new JSpinner();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanelMavLinkTunnel = new JPanel();
        this.jLabelMavLinkTunnelCompId = new JLabel();
        this.jSpinnerMavLinkTunnelCompId = new JSpinner();
        this.jComboBoxTunnelType = new JComboBox();
        this.jPanelProtection = new JPanel();
        this.jLabelPassword = new JLabel();
        this.jTextFieldPassword = new JTextField();
        this.panelProfiles = new JPanel();
        this.panelProfileTemplatesButtons = new JPanel();
        this.btnProfileTemplateAdd = new JButton();
        this.btnProfileTemplateDelete = new JButton();
        this.fillerProfileTemplateButtons = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.scrollpaneProfileTemplates = new JScrollPane();
        this.listProfileTemplates = new JList();
        this.panelButtons = new JPanel();
        this.jButtoCancel = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setName("Form");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogSettings.class);
        this.jPanelSerial.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelSerial.border.title", new Object[0])));
        this.jPanelSerial.setName("jPanelSerial");
        this.jPanelSerial.setLayout(new GridBagLayout());
        this.jLabelSerialBaud.setText(resourceMap.getString("jLabelSerialBaud.text", new Object[0]));
        this.jLabelSerialBaud.setName("jLabelSerialBaud");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelSerial.add((Component)this.jLabelSerialBaud, gridBagConstraints);
        this.jComboBoxSerialBaud.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSerialBaud.setName("jComboBoxSerialBaud");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelSerial.add((Component)this.jComboBoxSerialBaud, gridBagConstraints);
        this.jLabelSerialParity.setText(resourceMap.getString("jLabelSerialParity.text", new Object[0]));
        this.jLabelSerialParity.setName("jLabelSerialParity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelSerial.add((Component)this.jLabelSerialParity, gridBagConstraints);
        this.jComboBoxSerialParity.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Odd", "Even"}));
        this.jComboBoxSerialParity.setName("jComboBoxSerialParity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelSerial.add((Component)this.jComboBoxSerialParity, gridBagConstraints);
        this.jCheckBoxSerialBaudAuto.setText(resourceMap.getString("jCheckBoxSerialBaudAuto.text", new Object[0]));
        this.jCheckBoxSerialBaudAuto.setName("jCheckBoxSerialBaudAuto");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelSerial.add((Component)this.jCheckBoxSerialBaudAuto, gridBagConstraints);
        this.jLabelProtocolVer.setText(resourceMap.getString("jLabelProtocolVer.text", new Object[0]));
        this.jLabelProtocolVer.setName("jLabelProtocolVer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelSerial.add((Component)this.jLabelProtocolVer, gridBagConstraints);
        this.jComboBoxProtocolVer.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto-select", "Ver.1", "Ver.2"}));
        this.jComboBoxProtocolVer.setName("jComboBoxProtocolVer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanelSerial.add((Component)this.jComboBoxProtocolVer, gridBagConstraints);
        this.getContentPane().add(this.jPanelSerial);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setPreferredSize(new Dimension(100, 50));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jCheckBoxLogRTData.setText(resourceMap.getString("jCheckBoxLogRTData.text", new Object[0]));
        this.jCheckBoxLogRTData.setName("jCheckBoxLogRTData");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jCheckBoxLogRTData, gridBagConstraints);
        this.jCheckBoxLogRTDataRewrite.setText(resourceMap.getString("jCheckBoxLogRTDataRewrite.text", new Object[0]));
        this.jCheckBoxLogRTDataRewrite.setName("jCheckBoxLogRTDataRewrite");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jCheckBoxLogRTDataRewrite, gridBagConstraints);
        this.filler2.setName("filler2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 2.0;
        this.jPanel1.add((Component)this.filler2, gridBagConstraints);
        this.getContentPane().add(this.jPanel1);
        this.jPanelUDP.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelUDP.border.title", new Object[0])));
        this.jPanelUDP.setName("jPanelUDP");
        this.jPanelUDP.setPreferredSize(new Dimension(505, 100));
        this.jPanelUDP.setLayout(new GridBagLayout());
        this.jLabelUDPHost.setText(resourceMap.getString("jLabelUDPHost.text", new Object[0]));
        this.jLabelUDPHost.setName("jLabelUDPHost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelUDP.add((Component)this.jLabelUDPHost, gridBagConstraints);
        this.jTextFieldUDPHost.setName("jTextFieldUDPHost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 306;
        gridBagConstraints.anchor = 21;
        this.jPanelUDP.add((Component)this.jTextFieldUDPHost, gridBagConstraints);
        this.jSpinnerUDPRemotePort.setModel(new SpinnerNumberModel());
        this.jSpinnerUDPRemotePort.setEditor(new JSpinner.NumberEditor(this.jSpinnerUDPRemotePort, "#"));
        this.jSpinnerUDPRemotePort.setName("jSpinnerUDPRemotePort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 33;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.jPanelUDP.add((Component)this.jSpinnerUDPRemotePort, gridBagConstraints);
        this.jLabelUDPLocalPort.setText(resourceMap.getString("jLabelUDPLocalPort.text", new Object[0]));
        this.jLabelUDPLocalPort.setName("jLabelUDPLocalPort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelUDP.add((Component)this.jLabelUDPLocalPort, gridBagConstraints);
        this.jSpinnerUDPLocalPort.setModel(new SpinnerNumberModel());
        this.jSpinnerUDPLocalPort.setEditor(new JSpinner.NumberEditor(this.jSpinnerUDPLocalPort, "#"));
        this.jSpinnerUDPLocalPort.setName("jSpinnerUDPLocalPort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 33;
        gridBagConstraints.anchor = 23;
        this.jPanelUDP.add((Component)this.jSpinnerUDPLocalPort, gridBagConstraints);
        this.jLabelRemoteNote.setText(resourceMap.getString("jLabelRemoteNote.text", new Object[0]));
        this.jLabelRemoteNote.setName("jLabelRemoteNote");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        this.jPanelUDP.add((Component)this.jLabelRemoteNote, gridBagConstraints);
        this.getContentPane().add(this.jPanelUDP);
        this.jPanelTCP.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelTCP.border.title", new Object[0])));
        this.jPanelTCP.setName("jPanelTCP");
        this.jPanelTCP.setPreferredSize(new Dimension(505, 60));
        this.jPanelTCP.setLayout(new GridBagLayout());
        this.jLabelUDPHost1.setText(resourceMap.getString("jLabelUDPHost1.text", new Object[0]));
        this.jLabelUDPHost1.setName("jLabelUDPHost1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelTCP.add((Component)this.jLabelUDPHost1, gridBagConstraints);
        this.jTextFieldTCPHost.setName("jTextFieldTCPHost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 306;
        gridBagConstraints.anchor = 512;
        this.jPanelTCP.add((Component)this.jTextFieldTCPHost, gridBagConstraints);
        this.jSpinnerTCPPort.setModel(new SpinnerNumberModel());
        this.jSpinnerTCPPort.setEditor(new JSpinner.NumberEditor(this.jSpinnerTCPPort, "#"));
        this.jSpinnerTCPPort.setName("jSpinnerTCPPort");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipadx = 33;
        gridBagConstraints.anchor = 21;
        this.jPanelTCP.add((Component)this.jSpinnerTCPPort, gridBagConstraints);
        this.filler1.setName("filler1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelTCP.add((Component)this.filler1, gridBagConstraints);
        this.getContentPane().add(this.jPanelTCP);
        this.jPanelMavLinkTunnel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelMavLinkTunnel.border.title", new Object[0])));
        this.jPanelMavLinkTunnel.setToolTipText(resourceMap.getString("jPanelMavLinkTunnel.toolTipText", new Object[0]));
        this.jPanelMavLinkTunnel.setName("jPanelMavLinkTunnel");
        this.jPanelMavLinkTunnel.setLayout(new GridBagLayout());
        this.jLabelMavLinkTunnelCompId.setText(resourceMap.getString("jLabelMavLinkTunnelCompId.text", new Object[0]));
        this.jLabelMavLinkTunnelCompId.setName("jLabelMavLinkTunnelCompId");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelMavLinkTunnel.add((Component)this.jLabelMavLinkTunnelCompId, gridBagConstraints);
        this.jSpinnerMavLinkTunnelCompId.setModel(new SpinnerNumberModel(1, 1, 255, 1));
        this.jSpinnerMavLinkTunnelCompId.setToolTipText(resourceMap.getString("jSpinnerMavLinkTunnelCompId.toolTipText", new Object[0]));
        this.jSpinnerMavLinkTunnelCompId.setName("jSpinnerMavLinkTunnelCompId");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelMavLinkTunnel.add((Component)this.jSpinnerMavLinkTunnelCompId, gridBagConstraints);
        this.jComboBoxTunnelType.setName("jComboBoxTunnelType");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanelMavLinkTunnel.add((Component)this.jComboBoxTunnelType, gridBagConstraints);
        this.getContentPane().add(this.jPanelMavLinkTunnel);
        this.jPanelProtection.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanelProtection.border.title", new Object[0])));
        this.jPanelProtection.setName("jPanelProtection");
        this.jPanelProtection.setLayout(new GridBagLayout());
        this.jLabelPassword.setText(resourceMap.getString("jLabelPassword.text", new Object[0]));
        this.jLabelPassword.setName("jLabelPassword");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelProtection.add((Component)this.jLabelPassword, gridBagConstraints);
        this.jTextFieldPassword.setText(resourceMap.getString("jTextFieldPassword.text", new Object[0]));
        this.jTextFieldPassword.setName("jTextFieldPassword");
        this.jTextFieldPassword.setPreferredSize(new Dimension(200, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelProtection.add((Component)this.jTextFieldPassword, gridBagConstraints);
        this.getContentPane().add(this.jPanelProtection);
        this.panelProfiles.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("panelProfiles.border.title", new Object[0])));
        this.panelProfiles.setName("panelProfiles");
        this.panelProfiles.setPreferredSize(new Dimension(145, 200));
        this.panelProfiles.setLayout(new BorderLayout());
        this.panelProfileTemplatesButtons.setName("panelProfileTemplatesButtons");
        this.panelProfileTemplatesButtons.setLayout(new GridBagLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogSettings.class, this);
        this.btnProfileTemplateAdd.setAction(actionMap.get("buttonProfileTemplateAdd"));
        this.btnProfileTemplateAdd.setText(resourceMap.getString("btnProfileTemplateAdd.text", new Object[0]));
        this.btnProfileTemplateAdd.setToolTipText(resourceMap.getString("btnProfileTemplateAdd.toolTipText", new Object[0]));
        this.btnProfileTemplateAdd.setMaximumSize(new Dimension(84, 29));
        this.btnProfileTemplateAdd.setMinimumSize(new Dimension(84, 29));
        this.btnProfileTemplateAdd.setName("btnProfileTemplateAdd");
        this.btnProfileTemplateAdd.setPreferredSize(new Dimension(84, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelProfileTemplatesButtons.add((Component)this.btnProfileTemplateAdd, gridBagConstraints);
        this.btnProfileTemplateDelete.setAction(actionMap.get("buttonProfileTemplateDelete"));
        this.btnProfileTemplateDelete.setText(resourceMap.getString("btnProfileTemplateDelete.text", new Object[0]));
        this.btnProfileTemplateDelete.setToolTipText(resourceMap.getString("btnProfileTemplateDelete.toolTipText", new Object[0]));
        this.btnProfileTemplateDelete.setName("btnProfileTemplateDelete");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelProfileTemplatesButtons.add((Component)this.btnProfileTemplateDelete, gridBagConstraints);
        this.fillerProfileTemplateButtons.setName("fillerProfileTemplateButtons");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelProfileTemplatesButtons.add((Component)this.fillerProfileTemplateButtons, gridBagConstraints);
        this.panelProfiles.add((Component)this.panelProfileTemplatesButtons, "East");
        this.scrollpaneProfileTemplates.setBorder(BorderFactory.createBevelBorder(1));
        this.scrollpaneProfileTemplates.setName("scrollpaneProfileTemplates");
        this.listProfileTemplates.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        this.listProfileTemplates.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.listProfileTemplates.setName("listProfileTemplates");
        this.scrollpaneProfileTemplates.setViewportView(this.listProfileTemplates);
        this.panelProfiles.add((Component)this.scrollpaneProfileTemplates, "Center");
        this.getContentPane().add(this.panelProfiles);
        this.panelButtons.setMinimumSize(new Dimension(10, 50));
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new FlowLayout(2));
        this.jButtoCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtoCancel.setText(resourceMap.getString("jButtoCancel.text", new Object[0]));
        this.jButtoCancel.setName("jButtoCancel");
        this.panelButtons.add(this.jButtoCancel);
        this.jButtonSave.setAction(actionMap.get("buttonSave"));
        this.jButtonSave.setText(resourceMap.getString("jButtonSave.text", new Object[0]));
        this.jButtonSave.setName("jButtonSave");
        this.panelButtons.add(this.jButtonSave);
        this.getContentPane().add(this.panelButtons);
        this.pack();
    }

    public DialogSettings(Frame parent) {
        super(DialogSettings.class, parent, SimpleBGC_GUIApp.getResourceMap().getString("title.dialog_settings", new Object[0]));
        this.initComponents();
        this.profileTemplates = SimpleBGC_GUIApp.getProfileTemplates();
        this.rebuildProfileTemplatesList();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSettings.this.buttonSave();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.jTextFieldUDPHost.setText(Settings.get("udp.remote_host", ""));
        this.jTextFieldTCPHost.setText(Settings.get("tcp.remote_host", "192.168.4.1"));
        try {
            this.jSpinnerUDPRemotePort.setValue(Integer.parseInt(Settings.get("udp.remote_port", "0")));
            this.jSpinnerUDPLocalPort.setValue(Integer.parseInt(Settings.get("udp.local_port", "4416")));
            this.jSpinnerTCPPort.setValue(Integer.parseInt(Settings.get("tcp.remote_port", "23")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultComboBoxModel tmp = (DefaultComboBoxModel)this.jComboBoxSerialBaud.getModel();
        tmp.removeAllElements();
        int[] baudRates = SerialPortService.SERIAL_BAUD_RATES_EXTENDED;
        for (int i = 0; i < baudRates.length; ++i) {
            tmp.addElement(baudRates[i]);
        }
        int curBaud = Integer.parseInt(Settings.get("latest.serial.baud", "0"));
        this.jComboBoxSerialBaud.setSelectedIndex(curBaud < tmp.getSize() ? curBaud : 0);
        this.jComboBoxSerialParity.setSelectedIndex(Integer.parseInt(Settings.get("latest.serial.parity", "0")));
        this.jCheckBoxSerialBaudAuto.setSelected(Settings.is("serial.baud.auto", true));
        this.jComboBoxProtocolVer.setSelectedIndex(Integer.parseInt(Settings.get("serial.protocol_ver", "0")));
        this.jCheckBoxLogRTData.setSelected(Settings.is("realtime.log_to_file"));
        this.jCheckBoxLogRTDataRewrite.setSelected(Settings.is("realtime.log_rewrite", true));
        int tunnelType = Settings.getInt("tunnel.type", 0);
        ArrayList<Sprav> types = new ArrayList<Sprav>();
        types.add(new Sprav(0, "disabled"));
        types.add(new Sprav(1, this.resourceMap.getString("tunnel.mavlink.v2_extension", new Object[0])));
        types.add(new Sprav(10, this.resourceMap.getString("tunnel.mavlink.tunnel", new Object[0])));
        this.jComboBoxTunnelType.setModel(new SpravComboBoxModel(types, tunnelType));
        this.jSpinnerMavLinkTunnelCompId.setValue(Integer.parseInt(Settings.get("tunnel.mavlink.comp_id", "154")));
        this.jTextFieldPassword.setText(Settings.get("board_password.default"));
    }

    @Action
    public void buttonCancel() {
        this.cancelDialog();
    }

    @Action
    public void buttonSave() {
        Settings.set("udp.remote_host", this.jTextFieldUDPHost.getText());
        Settings.set("udp.remote_port", ((Number)this.jSpinnerUDPRemotePort.getValue()).toString());
        Settings.set("udp.local_port", ((Number)this.jSpinnerUDPLocalPort.getValue()).toString());
        Settings.set("tcp.remote_host", this.jTextFieldTCPHost.getText());
        Settings.set("tcp.remote_port", ((Number)this.jSpinnerTCPPort.getValue()).toString());
        Settings.set("latest.serial.baud", Integer.toString(this.jComboBoxSerialBaud.getSelectedIndex()));
        Settings.set("latest.serial.parity", Integer.toString(this.jComboBoxSerialParity.getSelectedIndex()));
        Settings.set("serial.baud.auto", this.jCheckBoxSerialBaudAuto.isSelected());
        Settings.set("serial.protocol_ver", Integer.toString(this.jComboBoxProtocolVer.getSelectedIndex()));
        Settings.set("realtime.log_to_file", this.jCheckBoxLogRTData.isSelected());
        Settings.set("realtime.log_rewrite", this.jCheckBoxLogRTDataRewrite.isSelected());
        Settings.set("tunnel.type", ((SpravComboBoxModel)this.jComboBoxTunnelType.getModel()).getCurrentId());
        Settings.set("tunnel.mavlink.comp_id", ((Number)this.jSpinnerMavLinkTunnelCompId.getValue()).toString());
        if (this.jTextFieldPassword.getText().length() > 20) {
            SimpleBGC_GUIApp.mainView.showErrorMessage("Password length should not exceed 20 characters.");
            return;
        }
        Settings.set("board_password.default", this.jTextFieldPassword.getText());
        SimpleBGC_GUIApp.setProfileTemplates(this.profileTemplates);
        Settings.save();
        SimpleBGC_GUIApp.mainView.applySettings();
        this.closeDialog(1);
    }

    @Override
    public void onCloseDialog() {
    }

    @Action
    public void buttonProfileTemplateAdd() {
        String selectedProfileTemplateFile = null;
        selectedProfileTemplateFile = BGCJFileLoader.getFilePath(this, new String[]{"profile"}, this.resourceMap.getString("profileTemplateChooserFileTypeDescription", new Object[0]), "last_used_profiles_directory", this.resourceMap.getString("addProfileTemplateDialogApproveButtonText", new Object[0]));
        if (selectedProfileTemplateFile != null) {
            IProfileTemplate item = ProfileTemplateFactory.get(selectedProfileTemplateFile);
            this.profileTemplates.add(item);
            this.rebuildProfileTemplatesList();
        }
    }

    @Action
    public void buttonProfileTemplateDelete() {
        IProfileTemplate selectedProfileTemplate = null;
        int selectedIndex = -1;
        selectedIndex = this.listProfileTemplates.getSelectedIndex();
        if (selectedIndex > -1) {
            selectedProfileTemplate = (IProfileTemplate)((ListModelProfileTemplatesImpl)this.listProfileTemplates.getModel()).getElementAt(selectedIndex);
        }
        Object[] options = new Object[]{SimpleBGC_GUIApp.getResourceMap().getString("option.yes", new Object[0]), SimpleBGC_GUIApp.getResourceMap().getString("option.no", new Object[0])};
        if (selectedProfileTemplate != null && JOptionPane.showOptionDialog(this, this.resourceMap.getString("confirm.deleteProfileTemplate", new Object[0]), SimpleBGC_GUIApp.getResourceMap().getString("messageDialog.confirm.title", new Object[0]), 0, 3, null, options, options[1]) == 0) {
            this.profileTemplates.remove(selectedProfileTemplate);
            this.rebuildProfileTemplatesList();
        }
    }

    private void rebuildProfileTemplatesList() {
        ArrayList<IProfileTemplate> profileTemplatesList = new ArrayList<IProfileTemplate>();
        for (IProfileTemplate item : this.profileTemplates) {
            profileTemplatesList.add(item);
        }
        this.btnProfileTemplateDelete.setEnabled(profileTemplatesList.size() > 0);
        this.listProfileTemplates.setModel(new ListModelProfileTemplatesImpl(profileTemplatesList));
    }
}

