/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.bode_plot.BodeResult;
import sbgc.utils.Settings;
import simplebgc_gui.MyDialog;
import simplebgc_gui.SimpleBGC_GUIApp;

public class DialogShowController
extends MyDialog {
    public static final String SHOW_CONTROLLER_SETTING = "show_ctr_dlg.show_controller";
    public static final String AXIS_SETTING = "show_ctr_dlg.axis";
    List<BodeResult> bodeDataList = null;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JCheckBox jCheckBoxShowController;
    private JComboBox jComboBoxAxis;
    private JLabel jLabelApplyto;
    private JLabel jLabelAxis;
    private JList jListPlant;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogShowController(Frame parent, boolean modal, List<BodeResult> bodeDataList) {
        super(DialogShowController.class, parent, SimpleBGC_GUIApp.getResourceMap(DialogShowController.class).getString("Form.title", new Object[0]));
        this.bodeDataList = bodeDataList;
        this.initComponents();
        this.jCheckBoxShowController.setSelected(Settings.is(SHOW_CONTROLLER_SETTING));
        this.jComboBoxAxis.setSelectedIndex(Settings.getInt(AXIS_SETTING, 0));
        this.jComboBoxAxisItemStateChanged(null);
    }

    private void initComponents() {
        this.jLabelAxis = new JLabel();
        this.jComboBoxAxis = new JComboBox();
        this.jCheckBoxShowController = new JCheckBox();
        this.jLabelApplyto = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListPlant = new JList();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(DialogShowController.class);
        this.jLabelAxis.setText(resourceMap.getString("jLabelAxis.text", new Object[0]));
        this.jLabelAxis.setName("jLabelAxis");
        this.getContentPane().add((Component)this.jLabelAxis, new AbsoluteConstraints(10, 20, 50, -1));
        this.jComboBoxAxis.setModel(new DefaultComboBoxModel<String>(new String[]{"ROLL", "PITCH", "YAW"}));
        this.jComboBoxAxis.setName("jComboBoxAxis");
        this.jComboBoxAxis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogShowController.this.jComboBoxAxisItemStateChanged(evt);
            }
        });
        this.getContentPane().add((Component)this.jComboBoxAxis, new AbsoluteConstraints(70, 20, 80, -1));
        this.jCheckBoxShowController.setText(resourceMap.getString("jCheckBoxShowController.text", new Object[0]));
        this.jCheckBoxShowController.setName("jCheckBoxShowController");
        this.getContentPane().add((Component)this.jCheckBoxShowController, new AbsoluteConstraints(160, 20, 310, -1));
        this.jLabelApplyto.setText(resourceMap.getString("jLabelApplyto.text", new Object[0]));
        this.jLabelApplyto.setName("jLabelApplyto");
        this.getContentPane().add((Component)this.jLabelApplyto, new AbsoluteConstraints(10, 50, 460, 40));
        this.jScrollPane1.setName("jScrollPane1");
        this.jListPlant.setName("jListPlant");
        this.jScrollPane1.setViewportView(this.jListPlant);
        this.getContentPane().add((Component)this.jScrollPane1, new AbsoluteConstraints(10, 100, 460, 80));
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(DialogShowController.class, this);
        this.jButtonOk.setAction(actionMap.get("buttonOk"));
        this.jButtonOk.setText(resourceMap.getString("jButtonOk.text", new Object[0]));
        this.jButtonOk.setName("jButtonOk");
        this.getContentPane().add((Component)this.jButtonOk, new AbsoluteConstraints(380, 190, 90, -1));
        this.jButtonCancel.setAction(actionMap.get("buttonCancel"));
        this.jButtonCancel.setText(resourceMap.getString("jButtonCancel.text", new Object[0]));
        this.jButtonCancel.setName("jButtonCancel");
        this.getContentPane().add((Component)this.jButtonCancel, new AbsoluteConstraints(280, 190, 90, -1));
        this.pack();
    }

    private void jComboBoxAxisItemStateChanged(ItemEvent evt) {
        DefaultListModel<BodeResult> m = new DefaultListModel<BodeResult>();
        this.jListPlant.setModel(m);
        if (this.bodeDataList != null) {
            int axis = this.jComboBoxAxis.getSelectedIndex();
            for (BodeResult b : this.bodeDataList) {
                if (b.axis != axis || !b.isPlant()) continue;
                m.addElement(b);
            }
            this.jListPlant.setSelectionInterval(0, m.getSize() - 1);
        }
    }

    @Override
    public void onCloseDialog() {
    }

    @Action
    public void buttonCancel() {
        this.closeDialog(-1);
    }

    @Action
    public void buttonOk() {
        this.closeDialog(1);
        Settings.set(SHOW_CONTROLLER_SETTING, this.isShowController());
        Settings.set(AXIS_SETTING, this.getAxis());
        Settings.save();
    }

    public List<BodeResult> getSelectedResponse() {
        ArrayList<BodeResult> list = new ArrayList<BodeResult>();
        for (Object b : this.jListPlant.getSelectedValuesList()) {
            if (!BodeResult.class.isInstance(b)) continue;
            list.add((BodeResult)b);
        }
        return list;
    }

    public int getAxis() {
        return this.jComboBoxAxis.getSelectedIndex();
    }

    public boolean isShowController() {
        return this.jCheckBoxShowController.isSelected();
    }
}

