/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import sbgc.utils.PeakMeter;

class PeakMeterPanel
extends JPanel {
    private static final Color[] limitColors = new Color[]{new Color(0, 187, 0), new Color(204, 204, 0), new Color(221, 0, 0)};
    private static final Color shadeColor = new Color(0, 0, 0, 153);
    private static final Color peakColor = new Color(255, 255, 255);
    private static final Color labelColor = new Color(255, 255, 255);
    private static final Font labelFont = new Font("Verdana", 1, 10);
    private int width;
    private int height;
    private int x0;
    private int y0;
    private float data = 0.0f;
    private PeakMeter peakMeter = null;
    private final float[] limits;
    private final float MAX_VAL;
    private String labelTemplate = null;

    PeakMeterPanel(float[] _limits, int length, String labelTemplate) {
        this.limits = _limits;
        this.labelTemplate = labelTemplate;
        this.MAX_VAL = this.limits[this.limits.length - 1];
        if (length > 0) {
            this.peakMeter = new PeakMeter(length);
        }
        this.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.x0 = this.getInsets().left;
        this.y0 = this.getInsets().top;
        this.width = this.getWidth() - this.getInsets().left - this.getInsets().right;
        this.height = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        for (int i = 0; i < this.limits.length; ++i) {
            g2d.setPaint(limitColors[i]);
            int y1 = this.valToScreenY(i == 0 ? 0.0f : this.limits[i - 1]);
            int y2 = this.valToScreenY(this.limits[i]);
            g2d.fillRect(this.x0, y2, this.width, y1 - y2);
        }
        g2d.setPaint(shadeColor);
        g2d.fillRect(this.x0, this.y0, this.width, this.valToScreenY(this.data) - this.y0);
        if (this.peakMeter != null) {
            g2d.setPaint(peakColor);
            g2d.fillRect(this.x0, Math.max(this.valToScreenY(this.peakMeter.getMax()) - 2, this.y0), this.width, 2);
        }
        if (this.labelTemplate != null) {
            String label = String.format(this.labelTemplate, Float.valueOf(this.data));
            g2d.setFont(labelFont);
            FontMetrics fm = g2d.getFontMetrics();
            g2d.setColor(labelColor);
            g2d.setPaint(labelColor);
            g2d.drawString(label, this.x0 + (this.width - fm.stringWidth(label)) / 2, this.y0 + fm.getHeight() + 5);
        }
    }

    int valToScreenY(float val) {
        return this.y0 + Math.round((float)this.height * (this.MAX_VAL - val) / this.MAX_VAL);
    }

    public void addData(float data) {
        this.data = Math.min(data, this.MAX_VAL);
        this.peakMeter.addData(data, false);
        this.repaint();
    }
}

