/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import java.awt.Font;
import java.awt.Window;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import sbgc.common.IProfileTemplate;
import sbgc.common.ProfileTemplateFactory;
import sbgc.service.upgrade.VersionImpl;
import sbgc.ui.IProfileTemplatesListener;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIView;

public class SimpleBGC_GUIApp
extends SingleFrameApplication {
    public static String PROJECT_URI;
    public static String PROJECT_URI_TITLE;
    public static String BUG_REPORT_URI;
    public static String SCRIPTING_REFERENCE_URI;
    public static String GUI_DOWNLOAD_URI;
    public static final int VERSION = 2743;
    public static SimpleBGC_GUIView mainView;
    protected static final Log logger;
    public static VersionImpl version;
    private static String theme;
    public static boolean debugMode;
    public static boolean serialDebug;
    private static LinkedHashSet<IProfileTemplate> profileTemplates;
    private static final HashSet<IProfileTemplatesListener> profileTemplatesListeners;

    @Override
    protected void initialize(String[] args) {
        ResourceMap resourceMap = SimpleBGC_GUIApp.getResourceMap();
        for (String arg : args) {
            if (arg.equals("DEBUG_MODE")) {
                debugMode = true;
            }
            if (!arg.equals("SERIAL_DEBUG")) continue;
            serialDebug = true;
        }
        if (System.getenv("DEBUG_MODE") != null) {
            debugMode = true;
        }
        if (System.getenv("SERIAL_DEBUG") != null) {
            serialDebug = true;
        }
        version = new VersionImpl(2743, Integer.parseInt(ResourceBundle.getBundle("simplebgc_gui.resources.version").getString("BUILD")));
        Thread.currentThread().setName("EDT");
        PROJECT_URI = resourceMap.getString("PROJECT_URI", new Object[0]);
        PROJECT_URI_TITLE = resourceMap.getString("PROJECT_URI_TITLE", new Object[0]);
        BUG_REPORT_URI = resourceMap.getString("BUG_REPORT_URI", new Object[0]);
        SCRIPTING_REFERENCE_URI = resourceMap.getString("SCRIPTING_REFERENCE_URI", new Object[0]);
        GUI_DOWNLOAD_URI = resourceMap.getString("GUI_DOWNLOAD_URI", new Object[0]);
        Settings.load();
        Locale current = Settings.getLocale();
        logger.debug("Current locale: " + current.toString());
        Locale.setDefault(current);
        SimpleBGC_GUIApp.reloadProfileTemplates(profileTemplates);
    }

    private static void reloadProfileTemplates(LinkedHashSet<IProfileTemplate> items) {
        try {
            items.clear();
            int i = 0;
            String value = null;
            while ((value = Settings.get("profile.template." + i++)) != null) {
                items.add(ProfileTemplateFactory.get(value));
            }
            logger.trace("Profile templates loaded: " + items.size());
        }
        catch (Exception e) {
            logger.error("Error loading profile templates: " + e.getMessage());
        }
    }

    private static void saveProfileTemplates(LinkedHashSet<IProfileTemplate> items) {
        int i;
        int previousProfileTemplatesCount = Integer.parseInt(Settings.get("profile.templates.count", "0"));
        Settings.set("profile.templates.count", Integer.toString(items.size()));
        for (i = items.size(); i < previousProfileTemplatesCount; ++i) {
            Settings.remove("profile.template." + Integer.toString(i));
        }
        i = 0;
        for (IProfileTemplate item : items) {
            Settings.set("profile.template." + Integer.toString(i++), item.getPath());
        }
        Settings.save();
    }

    public static void addProfileTemplate(String profileTemplateFilePath) {
        IProfileTemplate item = ProfileTemplateFactory.get(profileTemplateFilePath);
        profileTemplates.add(item);
        SimpleBGC_GUIApp.saveProfileTemplates(profileTemplates);
        for (IProfileTemplatesListener listener : profileTemplatesListeners) {
            listener.onProfileTemplatesChange(profileTemplates);
        }
    }

    public static void removeProfileTemplate(IProfileTemplate item) {
        profileTemplates.remove(item);
        SimpleBGC_GUIApp.saveProfileTemplates(profileTemplates);
        for (IProfileTemplatesListener listener : profileTemplatesListeners) {
            listener.onProfileTemplatesChange(profileTemplates);
        }
    }

    public static void setProfileTemplates(LinkedHashSet<IProfileTemplate> p) {
        profileTemplates = p;
        SimpleBGC_GUIApp.saveProfileTemplates(profileTemplates);
        for (IProfileTemplatesListener listener : profileTemplatesListeners) {
            listener.onProfileTemplatesChange(profileTemplates);
        }
    }

    public static void addProfileTemplatesListener(IProfileTemplatesListener listener) {
        profileTemplatesListeners.add(listener);
    }

    public static void removeProfileTemplatesListener(IProfileTemplatesListener listener) {
        profileTemplatesListeners.remove(listener);
    }

    public static LinkedHashSet<IProfileTemplate> getProfileTemplates() {
        return (LinkedHashSet)profileTemplates.clone();
    }

    @Override
    protected void startup() {
        SimpleBGC_GUIApp.setTheme(Settings.get("view.theme", "Classic"), false);
        mainView = new SimpleBGC_GUIView(this);
        SimpleBGC_GUIApp.addProfileTemplatesListener(mainView);
        this.show(mainView);
        mainView.onAfterShow();
    }

    @Override
    protected void configureWindow(Window root) {
    }

    public static SimpleBGC_GUIApp getApplication() {
        return Application.getInstance(SimpleBGC_GUIApp.class);
    }

    public static void main(String[] args) {
        SimpleBGC_GUIApp.launch(SimpleBGC_GUIApp.class, args);
    }

    public static ResourceMap getResourceMap(Class cls) {
        return Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(cls);
    }

    public static ResourceMap getResourceMap() {
        return Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(SimpleBGC_GUIApp.class);
    }

    public static String getTheme() {
        return theme;
    }

    public static void setTheme(String _theme, boolean save) {
        if (!_theme.equals(theme)) {
            theme = _theme;
            try {
                NimRODLookAndFeel lookAndFeel = new NimRODLookAndFeel();
                NimRODTheme nt = new NimRODTheme(SimpleBGC_GUIApp.class.getResource("/simplebgc_gui/resources/" + theme + ".theme"));
                NimRODLookAndFeel.setCurrentTheme(nt);
                UIManager.setLookAndFeel(lookAndFeel);
                String ln = Locale.getDefault().getLanguage();
                if (ln.equals("ja") || ln.equals("zh")) {
                    Font bFont = UIManager.getFont("Button.font");
                    Font newFont = new Font(bFont.getName(), bFont.getStyle(), bFont.getSize() + 2);
                    UIManager.put("Button.font", newFont);
                    UIManager.put("ToggleButton.font", newFont);
                }
                UIManager.put("ComboBox.background", nt.getPrimaryControlHighlight());
                UIManager.put("Spinner.background", nt.getPrimaryControlHighlight());
                if (mainView != null) {
                    mainView.applyTheme();
                }
                if (save) {
                    Settings.set("view.theme", theme);
                    Settings.save();
                }
            }
            catch (Exception e) {
                logger.error("Failed to set theme " + theme + ": " + e.getMessage());
            }
        }
    }

    public static Log getLogger() {
        return logger;
    }

    static {
        logger = new Log(Logger.getLogger((String)SimpleBGC_GUIApp.class.getName()));
        theme = "";
        profileTemplates = new LinkedHashSet();
        profileTemplatesListeners = new HashSet();
    }
}

