/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import sbgc.object.BoardParams;
import sbgc.object.BoardParamsSavedData;
import sbgc.object.BoardProfile;
import sbgc.service.ConnectThread;
import sbgc.service.ParamsWriterThread;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.utils.Log;
import sbgc.utils.xml.XmlUtils;
import simplebgc_gui.Action;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SimpleBGC_GUICmdApp
extends SimpleBGC_GUIApp {
    private static final Log logger = new Log(Logger.getLogger((String)SimpleBGC_GUICmdApp.class.getName()));
    public static final String APP_CMD = "sbgc_cmd";
    public static final SerialCommandProcessor.ProtocolVersion PROTOCOL_VER_DEFAULT = SerialCommandProcessor.ProtocolVersion.V2;
    public static final String ACTION_WRITE_RPOFILE = "write_profile";
    public static final String ACTION_SEND_CMD = "send_cmd";
    public static final String ACTION_SEND_STR = "send_str";
    private static final HashMap<String, Action> actions = new HashMap();
    private static final HashMap<String, String> params = new HashMap();

    public static void main(String[] args) {
        SimpleBGC_GUICmdApp app = new SimpleBGC_GUICmdApp();
        app.initialize(args);
        System.out.println("**********************************************");
        System.out.println("SimpleBGC GUI is started in command line mode");
        System.out.println("**********************************************");
        try {
            ArrayList<String> command = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '-') {
                    String pname = args[i].substring(1);
                    if (i + 1 >= args.length) {
                        throw new Exception("Parameter '" + pname + "' has no value");
                    }
                    params.put(pname, args[i + 1]);
                    ++i;
                    continue;
                }
                command.add(args[i]);
            }
            if (command.size() > 0) {
                String action = (String)command.get(0);
                List tmp = command.subList(1, command.size());
                args = tmp.toArray(new String[tmp.size()]);
                if (action.equals(ACTION_WRITE_RPOFILE)) {
                    app.action_write_profile(args);
                } else if (action.equals(ACTION_SEND_CMD)) {
                    app.action_send_cmd(args);
                } else if (action.equals(ACTION_SEND_STR)) {
                    app.action_send_str(args);
                } else {
                    app.print_error("Unknown action '" + action + "'.", null);
                }
            } else {
                app.print_usage(null);
            }
        }
        catch (Exception e) {
            logger.error("Error: " + e.getMessage());
        }
    }

    private void print_usage(String actionName) {
        String port_params = "-port <port_name> -baud <baud> -api <1|2> ";
        Action a = actionName != null ? actions.get(actionName) : null;
        System.out.println("Usage:");
        if (a != null) {
            System.out.println(">sbgc_cmd " + port_params + actionName + " " + a.paramsStr);
            System.out.println(a.info);
            System.out.println("\t" + a.paramsInfo);
            System.out.println("\t-port - port name, for example COM1");
            System.out.println("\t-baud - baud rate (optional, default 115200)");
            System.out.println("\t-api - Serial API V1 or V2 (optional, default V2)");
        } else {
            System.out.println("sbgc_cmd <parameters> <action> <args>");
            System.out.println("Parameters:");
            System.out.println("\t" + port_params);
            System.out.println("Action:");
            for (String name : actions.keySet()) {
                System.out.println("\t" + name + ": " + SimpleBGC_GUICmdApp.actions.get((Object)name).info);
            }
            System.out.println("Type <action> without arguments for more details.");
        }
    }

    private void print_error(String error, String actionName) {
        System.out.println(actionName + ": " + error);
        this.print_usage(actionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void action_write_profile(String[] args) throws Exception {
        if (args.length == 2) {
            String filename = args[0];
            int profile_idx = Integer.parseInt(args[1]);
            if (profile_idx < -1 || profile_idx >= 5) {
                throw new Exception("Invalid profile index. Use 0..5 or -1.");
            }
            try {
                BoardParams curParams = BoardParams.getCurParams();
                File f = new File(filename);
                logger.debug("Loading profile from file " + f.getAbsolutePath() + " ...");
                BoardParamsSavedData data = XmlUtils.loadProfileXML(f, curParams, curParams.profiles[Math.max(profile_idx, 0)]);
                this.connect(false);
                if (data.profiles != null) {
                    data.params.profiles = data.profiles;
                } else {
                    if (data.profile == null) throw new Exception("File contains no profile data!");
                    if (profile_idx < 0) throw new Exception("File contains only one profile. You have to specify slot to write it.");
                    data.params.profiles = new BoardProfile[5];
                    data.params.profiles[profile_idx] = data.profile;
                }
                ParamsWriterThread writerThread = SerialCommandProcessor.writeAllParams(data.params, profile_idx, null);
                try {
                    writerThread.join();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            finally {
                this.disconnect();
            }
        } else {
            this.print_error("Invalid number of arguments.", ACTION_WRITE_RPOFILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action_send_cmd(String[] args) throws Exception {
        if (args.length >= 2) {
            int cmd_id = Integer.parseInt(args[0]);
            String payload = String.join((CharSequence)"", Arrays.copyOfRange(args, 1, args.length));
            byte[] data = DatatypeConverter.parseHexBinary((String)payload);
            try {
                this.connect(false);
                SerialCommand cmd = new SerialCommand(cmd_id, data);
                SerialCommandProcessor.sendCommand(cmd);
                this.wait_serial_send();
            }
            finally {
                this.disconnect();
            }
        } else {
            this.print_error("Invalid number of arguments.", ACTION_SEND_CMD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action_send_str(String[] args) throws Exception {
        if (args.length > 0) {
            String str = String.join((CharSequence)"\r\n", args) + "\r\n";
            byte[] data = str.getBytes("US-ASCII");
            try {
                this.connect(false);
                SerialCommandProcessor.getDataPort().sendData(data, 0, data.length);
                this.wait_serial_send();
            }
            finally {
                this.disconnect();
            }
        } else {
            this.print_usage(ACTION_SEND_STR);
        }
    }

    public void connect(boolean getBoardInfo) throws Exception {
        String port = params.get("port");
        String baud_str = params.get("baud");
        String prot_str = params.get("api");
        if (port == null) {
            throw new Exception("Parameter -port is not specified");
        }
        int baud = baud_str != null ? Integer.parseInt(baud_str) : 115200;
        int baud_idx = SerialPortService.getBaudIndexByValue(baud);
        if (baud_idx < 0) {
            throw new Exception("Baud rate " + baud + " is not supported.");
        }
        SerialCommandProcessor.ProtocolVersion prot_ver = PROTOCOL_VER_DEFAULT;
        if (prot_str != null) {
            prot_ver = SerialCommandProcessor.protocolVerFromInt(Integer.parseInt(prot_str));
            if (prot_ver == SerialCommandProcessor.ProtocolVersion.AUTO) {
                prot_ver = PROTOCOL_VER_DEFAULT;
            }
            SerialCommandProcessor.setProtocolVerOut(prot_ver);
            SerialCommandProcessor.setProtocolVerIn(SerialCommandProcessor.ProtocolVersion.AUTO);
        }
        logger.info("Connecting to the board..");
        SerialPortService.connect(port, false, 0);
        SerialPortService.setBaudIndex(baud_idx);
        SerialPortService.setParity(0);
        SerialCommandProcessor.setCommandListener(SerialCommandDispatcher.getInstance());
        if (getBoardInfo) {
            ConnectThread.initConnection();
            try {
                ConnectThread.getThread().join(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!ConnectThread.isConnected) {
                throw new Exception("No response from the board.");
            }
        }
    }

    public void disconnect() throws Exception {
        logger.info("Closing connection..");
        ConnectThread.stopConnection();
        RealtimeDataThread.stop();
        SerialCommandProcessor.stopSerialCommunication();
        SerialPortService.disconnect();
    }

    public void wait_serial_send() {
        long delta = SerialCommandProcessor.getDataPort().getLastSendTime() - System.currentTimeMillis() + 10L;
        if (delta > 0L) {
            logger.debug("Waiting " + delta + " ms to finish sending data..");
            try {
                Thread.sleep(delta);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        actions.put(ACTION_WRITE_RPOFILE, new Action("Writes profile file to the board to specidied slot", "<path-to-profile> <profile-slot-to-write>", "you can set slot=-1 to write all profiles stored in the XML file."));
        actions.put(ACTION_SEND_CMD, new Action("Sends Serial API command to the board", "<cmd_id> <payload> [<payload> ..]", "<cmd_id> command Id in decimal, <payload> a sequence of two-digit hex."));
        actions.put(ACTION_SEND_STR, new Action("Sends ASCII string(s) to COM port", "<string> [<string> ..]", "<string> is in US-ASCII encoding, \\r\\n is appended to each string. Use \"...\" to protect strings if it contains spaces."));
    }
}

