/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui;

import com.thoughtworks.xstream.XStream;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;
import sbgc.common.IProfileTemplate;
import sbgc.object.BoardInfo;
import sbgc.object.BoardParams;
import sbgc.object.BoardParamsSavedData;
import sbgc.object.DebugVar;
import sbgc.object.DebugVars;
import sbgc.object.ErrorInfo;
import sbgc.object.RealtimeData;
import sbgc.object.Sprav;
import sbgc.service.BackupIMUCalibThread;
import sbgc.service.ConnectThread;
import sbgc.service.RealtimeDataThread;
import sbgc.service.RestoreIMUCalibThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.SerialPortService;
import sbgc.service.upgrade.IProgressListener;
import sbgc.service.upgrade.VersionImpl;
import sbgc.ui.AnglePanel;
import sbgc.ui.GroupView;
import sbgc.ui.IProfileTemplatesListener;
import sbgc.ui.ITabbedPanel;
import sbgc.ui.JPanelAdjVars;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.RCDataPanel;
import sbgc.ui.SpravComboBoxModel;
import sbgc.ui.TabbedPanelAnalyze;
import sbgc.ui.TabbedPanelCAN;
import sbgc.ui.TabbedPanelDebug;
import sbgc.ui.TabbedPanelEncoders;
import sbgc.ui.TabbedPanelExtraMotors;
import sbgc.ui.TabbedPanelFirmwareUpdate;
import sbgc.ui.TabbedPanelFollow;
import sbgc.ui.TabbedPanelHardwareSettings;
import sbgc.ui.TabbedPanelJoystick;
import sbgc.ui.TabbedPanelMavlink;
import sbgc.ui.TabbedPanelMonitoring;
import sbgc.ui.TabbedPanelRCSettings;
import sbgc.ui.TabbedPanelScripting;
import sbgc.ui.TabbedPanelService;
import sbgc.ui.TabbedPanelStabilizationSettings;
import sbgc.ui.Utils;
import sbgc.utils.BGCJFileSaver;
import sbgc.utils.FileUtil;
import sbgc.utils.HexUtil;
import sbgc.utils.Log;
import sbgc.utils.Settings;
import sbgc.utils.xml.XmlUtils;
import simplebgc_gui.DialogBackupManager;
import simplebgc_gui.DialogBluetooth;
import simplebgc_gui.DialogCopyProfile;
import simplebgc_gui.DialogMultilink;
import simplebgc_gui.DialogProgress;
import simplebgc_gui.DialogSettings;
import simplebgc_gui.MenuItemProfileTemplate;
import simplebgc_gui.SimpleBGC_GUIAboutBox;
import simplebgc_gui.SimpleBGC_GUIApp;

public class SimpleBGC_GUIView
extends FrameView
implements IProgressListener,
IProfileTemplatesListener {
    private final ResourceMap resourceMap;
    public final ActionMap actionMap;
    private static final Log logger = new Log(Logger.getLogger((String)SimpleBGC_GUIView.class.getName()));
    private int oldProfile = 0;
    DialogProgress progressDialog = null;
    private Dimension initSize = null;
    private AnglePanel[] anglePanels = new AnglePanel[3];
    private RCDataPanel batPanel;
    private JToggleButton[] buttonProfiles;
    private boolean inProgress = false;
    private MouseListener toolTipMouseListener = null;
    private ITabbedPanel[] tabPanels;
    public final TabbedPanelStabilizationSettings panelStabilizationSettings;
    public final TabbedPanelHardwareSettings panelHardwareSettings;
    public final JPanelAdjVars panelAdjVars;
    public final TabbedPanelFirmwareUpdate panelFirmwareUpdate;
    public final TabbedPanelRCSettings panelRCSettings;
    public final TabbedPanelService panelService;
    public final TabbedPanelFollow panelFollow;
    public final TabbedPanelEncoders panelEncoders;
    public final TabbedPanelMavlink panelMavlink;
    public final TabbedPanelScripting panelScripting;
    public final TabbedPanelAnalyze panelAnalyze;
    public final TabbedPanelDebug panelDebug;
    public final TabbedPanelMonitoring panelMonitoring;
    public final TabbedPanelCAN panelCAN;
    public final TabbedPanelExtraMotors panelExtraMotors;
    public final TabbedPanelJoystick panelJoystick;
    private JDialog aboutBox;
    private boolean isPortConnected = false;
    private boolean isConnected = false;
    private boolean serialCommunicationActive = false;
    private static String latestPortName = null;
    private static GroupView.VIEW maxViewLevel = GroupView.VIEW.DEVELOPER;
    private int activeProfile = -1;
    private long lastRTUpdateTime;
    boolean is_write_from_old_GUI_confirmed;
    boolean paramsUpdated = false;
    int calibMode;
    String calibModeInfo;
    String curStatusInfo;
    private JMenu boardMenu;
    private JMenuItem bugReportMenuItem;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroupLang;
    private ButtonGroup buttonGroupProfile;
    private ButtonGroup buttonGroupView;
    private ButtonGroup buttonGroupViewLevel;
    private JButton jButton1;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButtonConnect;
    private JButton jButtonCopy;
    private JButton jButtonRead;
    private JButton jButtonRenameProfile;
    private JButton jButtonWrite;
    private JComboBox jCBPortList;
    private JCheckBox jCheckBoxConnectBLE;
    private JComboBox jComboBoxProfile;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelConnState;
    private JLabel jLabelCurrentSens;
    private JLabel jLabelCycleTime;
    private JLabel jLabelErrorDescr;
    private JLabel jLabelErrorTitle;
    private JLabel jLabelI2CErrors;
    private JLabel jLabelStatus;
    private JLabel jLabelURL;
    private JMenuItem jMenuItem1;
    private JPanel jPanel4;
    private JPanel jPanelAngles;
    private JPanel jPanelBat;
    private JPanel jPanelConnection;
    private JPanel jPanelMain;
    private JPanel jPanelPitchAngle;
    private JPanel jPanelProfile;
    private JPanel jPanelRollAngle;
    private JPanel jPanelYawAngle;
    private JProgressBar jProgressBarMain;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator9;
    private JToggleButton jToggleButtonMotors;
    private JToggleButton jToggleButtonProfile1;
    private JToggleButton jToggleButtonProfile2;
    private JToggleButton jToggleButtonProfile3;
    private JToggleButton jToggleButtonProfile4;
    private JToggleButton jToggleButtonProfile5;
    private JLabel labelFirmwareVersionValue;
    private JMenu languageMenu;
    private JPanel mainPanel;
    private JMenuItem menuBackupFrameIMUCalib;
    private JMenu menuBackupIMUCalib;
    private JMenuItem menuBackupMainIMUCalib;
    private JMenuItem menuBackupManager;
    private JMenuBar menuBar;
    private JMenuItem menuCalibAcc;
    private JMenuItem menuCalibAccTemp;
    private JMenuItem menuCalibGyroTemp;
    private JMenuItem menuCalibrateGyro;
    private JMenuItem menuCalibrateHelper;
    private JMenuItem menuConfigureBluetooth;
    private JMenuItem menuConfigureBluetooth1;
    private JMenuItem menuCopyProfile;
    private JMenuItem menuEraseEEPROM;
    private JMenu menuExecuteAction;
    private JMenuItem menuLoadProfile;
    private JMenuItem menuManageProfileTemplates;
    private JMenuItem menuReadParams;
    private JMenuItem menuRestoreFrameIMUCalib;
    private JMenu menuRestoreIMUCalib;
    private JMenuItem menuRestoreMainIMUCalib;
    private JMenuItem menuSaveAllProfiles;
    private JMenu menuSaveAllProfilesUsingTemplate;
    private JMenuItem menuSaveProfile;
    private JMenu menuSaveProfileUsingTemplate;
    private JMenuItem menuSettings;
    private JMenu menuViewLevel;
    private JRadioButtonMenuItem menuViewLevelADVANCED;
    private JRadioButtonMenuItem menuViewLevelBASIC;
    private JRadioButtonMenuItem menuViewLevelDEVELOPER;
    private JRadioButtonMenuItem menuViewLevelEXPERT;
    private JMenuItem menuWriteParams;
    private JMenuItem menuWriteParamsAll;
    private JMenu sensorMenu;
    private JPanel statusPanel;
    private JTabbedPane tabbedPaneMain;
    private JMenu viewMenu;
    private static String errorTitle = "";
    private static String errorDescr = "";
    private boolean inFullScreen = false;
    private static final Class[] paramsChartClasses = new Class[]{JSpinner.class, JTextField.class, JComboBox.class, JCheckBox.class, JRadioButton.class};

    public SimpleBGC_GUIView(SingleFrameApplication app) {
        super(app);
        int i;
        JRadioButtonMenuItem item2;
        JFrame frame = this.getFrame();
        frame.setResizable(false);
        frame.setTitle(SimpleBGC_GUIApp.getResourceMap().getString("Application.title", new Object[0]) + " v" + SimpleBGC_GUIApp.version.toString());
        frame.setIconImage(new ImageIcon(this.getClass().getResource("/simplebgc_gui/resources/app-icon.png")).getImage());
        frame.addWindowListener(new CloseWindowAdapter());
        this.initComponents();
        this.rebuildProfileTemplatesMenu();
        SerialCommandProcessor.setCommandListener(SerialCommandDispatcher.getInstance());
        this.resourceMap = this.getResourceMap();
        this.actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(SimpleBGC_GUIView.class, this);
        try {
            GroupView.VIEW curView;
            String maxViewStr = Settings.get("view.level.max");
            if (maxViewStr != null) {
                maxViewLevel = GroupView.VIEW.valueOf(maxViewStr);
            }
            GroupView.setCurViewLevel((curView = GroupView.VIEW.valueOf(Settings.get("view.level", "BASIC"))).compareTo(maxViewLevel) <= 0 ? curView : maxViewLevel);
            for (Component menuItem : this.menuViewLevel.getMenuComponents()) {
                try {
                    item2 = (JRadioButtonMenuItem)menuItem;
                    GroupView.VIEW v = GroupView.VIEW.valueOf(item2.getName().substring(13));
                    item2.setEnabled(v.compareTo(maxViewLevel) <= 0);
                }
                catch (Exception item2) {
                    // empty catch block
                }
            }
        }
        catch (Exception maxViewStr) {
            // empty catch block
        }
        this.panelStabilizationSettings = new TabbedPanelStabilizationSettings(this);
        this.panelHardwareSettings = new TabbedPanelHardwareSettings(this);
        this.panelAdjVars = new JPanelAdjVars(this);
        this.panelFirmwareUpdate = new TabbedPanelFirmwareUpdate(this);
        this.panelRCSettings = new TabbedPanelRCSettings(this);
        this.panelService = new TabbedPanelService(this);
        this.panelFollow = new TabbedPanelFollow(this);
        this.panelEncoders = new TabbedPanelEncoders(this);
        this.panelMavlink = new TabbedPanelMavlink(this);
        this.panelScripting = new TabbedPanelScripting(this);
        this.panelAnalyze = new TabbedPanelAnalyze(this);
        this.panelDebug = new TabbedPanelDebug(this);
        this.panelMonitoring = new TabbedPanelMonitoring(this);
        this.panelCAN = new TabbedPanelCAN(this);
        this.panelExtraMotors = new TabbedPanelExtraMotors(this);
        this.panelJoystick = new TabbedPanelJoystick(this);
        this.tabPanels = new ITabbedPanel[]{this.panelStabilizationSettings, this.panelRCSettings, this.panelJoystick, this.panelFollow, this.panelHardwareSettings, this.panelService, this.panelAdjVars, this.panelFirmwareUpdate, this.panelEncoders, this.panelMavlink, this.panelScripting, this.panelAnalyze, this.panelDebug, this.panelMonitoring, this.panelCAN, this.panelExtraMotors};
        this.buttonProfiles = new JToggleButton[]{this.jToggleButtonProfile1, this.jToggleButtonProfile2, this.jToggleButtonProfile3, this.jToggleButtonProfile4, this.jToggleButtonProfile5};
        for (i = 1; i < 30; ++i) {
            String[] lang;
            String s = this.resourceMap.getString("lang." + i, new Object[0]);
            if (s == null || (lang = s.split(":")).length < 3) continue;
            JRadioButtonMenuItem item3 = new JRadioButtonMenuItem(lang[2]);
            item3.setName(GroupView.MENU_NAME_PREFIX + lang[0]);
            item3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleBGC_GUIView.this.changeLocale(lang[0], lang[1]);
                }
            });
            this.buttonGroupLang.add(item3);
            this.languageMenu.add(item3);
        }
        if (this.languageMenu.getMenuComponentCount() <= 1) {
            this.menuBar.remove(this.languageMenu);
        }
        this.changeLocaleMenuSelection();
        for (i = 0; i < this.menuBar.getMenuCount(); ++i) {
            if (!this.menuBar.getMenu(i).getText().isEmpty()) continue;
            this.menuBar.remove(i);
            --i;
        }
        String themes = this.resourceMap.getString("view.themes", new Object[0]);
        if (themes == null || themes.isEmpty()) {
            themes = "Classic,HighContrastDark,HighContrastLight";
        }
        int pos = 2;
        for (final String theme : themes.split("\\s*,\\s*")) {
            item2 = new JRadioButtonMenuItem(theme);
            item2.setName(GroupView.MENU_NAME_PREFIX + theme);
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleBGC_GUIApp.setTheme(theme, true);
                }
            });
            this.buttonGroupView.add(item2);
            this.viewMenu.insert(item2, pos++);
        }
        this.changeViewMenuSelection();
        this.changeViewLevelMenuSelection();
        this.isPortConnected = false;
        this.jButtonConnect.setText(this.resourceMap.getString("jButtonConnect.connect.text", new Object[0]));
        try {
            SerialPortService.initSerialPortService();
            this.setPortList();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        SimpleBGC_GUIView.setProjectLink(this.jLabelURL, null);
        this.toolTipMouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SimpleBGC_GUIView.this.jLabelErrorDescr.setText("<html>" + ((JComponent)e.getSource()).getToolTipText() + "</html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SimpleBGC_GUIView.this.jLabelErrorDescr.setText(errorDescr);
            }
        };
        Utils.setToolTipListener(this.mainPanel, this.toolTipMouseListener);
        Utils.setToolTipListener(this.menuBar, this.toolTipMouseListener);
        for (ITabbedPanel p : this.tabPanels) {
            for (Component g : p.getGroups()) {
                if (!(g instanceof Container)) continue;
                Utils.setToolTipListener((Container)g, this.toolTipMouseListener);
            }
        }
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        GroupView.updateComponentViewLevelsPropertiesFile(this.tabPanels);
        this.updateBoardVerUI();
        try {
            this.anglePanels[0] = new AnglePanel(this.getClass().getResource("/simplebgc_gui/resources/roll.png"), this.getClass().getResource("/simplebgc_gui/resources/circle_bg3.png"));
            this.anglePanels[1] = new AnglePanel(this.getClass().getResource("/simplebgc_gui/resources/pitch.png"), this.getClass().getResource("/simplebgc_gui/resources/circle_bg3.png"));
            this.anglePanels[2] = new AnglePanel(this.getClass().getResource("/simplebgc_gui/resources/compass_arrow.png"), this.getClass().getResource("/simplebgc_gui/resources/compass_bg3.png"));
            this.jPanelRollAngle.add(this.anglePanels[0]);
            this.jPanelPitchAngle.add(this.anglePanels[1]);
            this.jPanelYawAngle.add(this.anglePanels[2]);
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
        this.batPanel = new RCDataPanel("BAT", "%.1f");
        this.jPanelBat.add(this.batPanel);
        this.updateError();
        this.updateStatus("");
        this.setConnected(false);
        this.jProgressBarMain.setVisible(false);
        this.jCheckBoxConnectBLE.setSelected(Settings.is("connect.BLE"));
        this.updateCustomColors();
        this.setupKeyboardShortcuts();
    }

    private void setupKeyboardShortcuts() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                javax.swing.Action a = SimpleBGC_GUIView.this.actionMap.get(KeyStroke.getKeyStrokeForEvent(e));
                if (a != null) {
                    a.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null));
                    return true;
                }
                return false;
            }
        });
        for (final ITabbedPanel p : this.tabPanels) {
            String actionName = "shortcuts.tabs." + p.getName();
            KeyStroke keyStroke = Settings.getShortcutKey(actionName, 512);
            if (keyStroke == null) continue;
            this.actionMap.put(keyStroke, new AbstractAction(actionName){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimpleBGC_GUIView.this.tabbedPaneMain.setSelectedComponent((Component)((Object)p));
                }
            });
        }
    }

    public void onAfterShow() {
        JFrame frame = this.getFrame();
        frame.pack();
        this.initSize = this.getFrame().getSize();
    }

    public String getSelectedPort(boolean warnIfNotSelected) {
        if (this.jCBPortList.getSelectedIndex() != -1) {
            Sprav p = ((SpravComboBoxModel)this.jCBPortList.getModel()).getCurrent();
            String name = (String)p.getProp("port");
            if (name == null) {
                name = p.getName();
            }
            return name;
        }
        JOptionPane.showMessageDialog(null, this.resourceMap.getString("error.select_port", new Object[0]), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
        return null;
    }

    public boolean isPortConnected() {
        return this.isPortConnected;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isSerialCommunicationActive() {
        return this.serialCommunicationActive;
    }

    public boolean isSerialCommunicationActiveAndNotPaused() {
        return this.serialCommunicationActive && !RealtimeDataThread.isPaused();
    }

    public void setSelectedTab(Component tab) {
        this.tabbedPaneMain.setSelectedComponent(tab);
    }

    public void updateDeviceSN() {
        String port;
        if (!this.isConnected && (port = this.getSelectedPort(true)) != null) {
            this.connect(port, true);
            if (ConnectThread.getThread() != null) {
                try {
                    ConnectThread.getThread().join(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.isConnected) {
                this.disconnect();
                JOptionPane.showMessageDialog(null, this.resourceMap.getString("error.serial_connect", "Timeout!"), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 2);
                return;
            }
        }
        if (this.isConnected) {
            this.panelFirmwareUpdate.setDeviceSN();
            SerialCommandProcessor.sendCommand(SerialCommandProcessor.getCmdBoardInfo(null));
        }
    }

    private void changeLocale(String language, String country) {
        Locale locale = new Locale(language, country);
        Settings.set("locale.language", language);
        Settings.set("locale.country", country);
        Settings.save();
        this.changeLocaleMenuSelection();
        Object[] options = new Object[]{"Exit", "Later"};
        int res = JOptionPane.showOptionDialog(null, "Application should be restarted to reflect changes.", this.resourceMap.getString("messageDialog.question.title", new Object[0]), 0, 3, null, options, options[1]);
        if (res == 0) {
            this.getApplication().quit(null);
        }
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = SimpleBGC_GUIApp.getApplication().getMainFrame();
            this.aboutBox = new SimpleBGC_GUIAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        SimpleBGC_GUIApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void renameProfile() {
        try {
            Object returned;
            int profileId = this.jComboBoxProfile.getSelectedIndex();
            String previousProfileName = (String)this.jComboBoxProfile.getItemAt(profileId);
            if (profileId >= 0 && profileId < 5 && (returned = JOptionPane.showInputDialog(this.getFrame(), this.resourceMap.getString("input.profile_name", new Object[0]), this.resourceMap.getString("input.profile_name.title", new Object[0]), -1, null, null, (String)this.jComboBoxProfile.getItemAt(profileId))) != null && ((String)returned).trim().length() > 0 && !((String)returned).trim().equals(previousProfileName)) {
                BoardParams params;
                BoardInfo boardInfo = BoardInfo.getBoardInfo();
                if (boardInfo != null && boardInfo.canSaveProfileNames()) {
                    boardInfo.setProfileName(profileId, (String)returned);
                    if (this.isConnected) {
                        SerialCommandProcessor.sendCommand(boardInfo.formatProfileNamesCmd());
                    }
                }
                if ((params = BoardParams.getCurParams()) != null) {
                    params.setProfileName(profileId, (String)returned);
                }
                this.updateBoardVerUI();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.getFrame(), "Error renaming profile: " + e.getMessage(), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanelMain = new JPanel();
        this.jLabelURL = new JLabel();
        this.jPanelConnection = new JPanel();
        this.jButtonConnect = new JButton();
        this.jCBPortList = new JComboBox();
        this.jLabelConnState = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.labelFirmwareVersionValue = new JLabel();
        this.jCheckBoxConnectBLE = new JCheckBox();
        this.jPanelProfile = new JPanel();
        this.jComboBoxProfile = new JComboBox();
        this.jButtonRenameProfile = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButtonCopy = new JButton();
        this.jToggleButtonProfile1 = new JToggleButton();
        this.jToggleButtonProfile2 = new JToggleButton();
        this.jToggleButtonProfile3 = new JToggleButton();
        this.jToggleButtonProfile4 = new JToggleButton();
        this.jToggleButtonProfile5 = new JToggleButton();
        this.jLabel3 = new JLabel();
        this.tabbedPaneMain = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jLabelErrorTitle = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabelErrorDescr = new JLabel();
        this.jLabelI2CErrors = new JLabel();
        this.jLabelCycleTime = new JLabel();
        this.jLabel13 = new JLabel();
        this.jPanelAngles = new JPanel();
        this.jPanelYawAngle = new JPanel();
        this.jPanelRollAngle = new JPanel();
        this.jPanelPitchAngle = new JPanel();
        this.jButtonRead = new JButton();
        this.jButtonWrite = new JButton();
        this.jToggleButtonMotors = new JToggleButton();
        this.jProgressBarMain = new JProgressBar();
        this.jButton1 = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.menuLoadProfile = new JMenuItem();
        this.menuSaveProfile = new JMenuItem();
        this.menuSaveProfileUsingTemplate = new JMenu();
        this.menuManageProfileTemplates = new JMenuItem();
        this.menuSaveAllProfiles = new JMenuItem();
        this.menuSaveAllProfilesUsingTemplate = new JMenu();
        this.menuCopyProfile = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.menuSettings = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        JMenuItem exitMenuItem = new JMenuItem();
        this.boardMenu = new JMenu();
        this.menuReadParams = new JMenuItem();
        this.menuWriteParams = new JMenuItem();
        this.menuWriteParamsAll = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.menuExecuteAction = new JMenu();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.sensorMenu = new JMenu();
        this.menuCalibAcc = new JMenuItem();
        this.menuCalibrateGyro = new JMenuItem();
        this.menuCalibAccTemp = new JMenuItem();
        this.menuCalibGyroTemp = new JMenuItem();
        this.menuCalibrateHelper = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.menuConfigureBluetooth = new JMenuItem();
        this.menuConfigureBluetooth1 = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.menuEraseEEPROM = new JMenuItem();
        this.menuBackupManager = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.menuBackupIMUCalib = new JMenu();
        this.menuBackupMainIMUCalib = new JMenuItem();
        this.menuBackupFrameIMUCalib = new JMenuItem();
        this.menuRestoreIMUCalib = new JMenu();
        this.menuRestoreMainIMUCalib = new JMenuItem();
        this.menuRestoreFrameIMUCalib = new JMenuItem();
        this.languageMenu = new JMenu();
        this.viewMenu = new JMenu();
        this.menuViewLevel = new JMenu();
        this.menuViewLevelBASIC = new JRadioButtonMenuItem();
        this.menuViewLevelADVANCED = new JRadioButtonMenuItem();
        this.menuViewLevelEXPERT = new JRadioButtonMenuItem();
        this.menuViewLevelDEVELOPER = new JRadioButtonMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem1 = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.bugReportMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.jLabelStatus = new JLabel();
        this.jPanelBat = new JPanel();
        this.jLabelCurrentSens = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroupLang = new ButtonGroup();
        this.buttonGroupView = new ButtonGroup();
        this.buttonGroupViewLevel = new ButtonGroup();
        this.buttonGroupProfile = new ButtonGroup();
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setLayout(new GridBagLayout());
        this.jPanelMain.setName("jPanelMain");
        this.jPanelMain.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelURL.setHorizontalAlignment(0);
        this.jLabelURL.setName("jLabelURL");
        this.jPanelMain.add((Component)this.jLabelURL, new AbsoluteConstraints(740, 90, 190, 20));
        ResourceMap resourceMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getResourceMap(SimpleBGC_GUIView.class);
        this.jPanelConnection.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupConnection.border.title", new Object[0])));
        this.jPanelConnection.setName("groupConnection");
        this.jPanelConnection.setLayout((LayoutManager)new AbsoluteLayout());
        ApplicationActionMap actionMap = Application.getInstance(SimpleBGC_GUIApp.class).getContext().getActionMap(SimpleBGC_GUIView.class, this);
        this.jButtonConnect.setAction(actionMap.get("connectDisconnect"));
        this.jButtonConnect.setText(resourceMap.getString("buttonConnect.text", new Object[0]));
        this.jButtonConnect.setName("buttonConnect");
        this.jPanelConnection.add((Component)this.jButtonConnect, new AbsoluteConstraints(270, 20, 150, 30));
        this.jCBPortList.setName("comboBoxPortList");
        this.jCBPortList.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                SimpleBGC_GUIView.this.jCBPortListPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jPanelConnection.add((Component)this.jCBPortList, new AbsoluteConstraints(10, 20, 200, -1));
        this.jLabelConnState.setText(resourceMap.getString("labelConnectionState.text", new Object[0]));
        this.jLabelConnState.setName("labelConnectionState");
        this.jPanelConnection.add((Component)this.jLabelConnState, new AbsoluteConstraints(60, 60, 160, -1));
        this.jLabel2.setText(resourceMap.getString("labelFirmware.text", new Object[0]));
        this.jLabel2.setName("labelFirmware");
        this.jPanelConnection.add((Component)this.jLabel2, new AbsoluteConstraints(230, 60, 70, -1));
        this.jLabel1.setText(resourceMap.getString("labelBoard.text", new Object[0]));
        this.jLabel1.setName("labelBoard");
        this.jPanelConnection.add((Component)this.jLabel1, new AbsoluteConstraints(10, 60, 50, -1));
        this.labelFirmwareVersionValue.setText(resourceMap.getString("labelFirmwareVersion.text", new Object[0]));
        this.labelFirmwareVersionValue.setName("labelFirmwareVersion");
        this.jPanelConnection.add((Component)this.labelFirmwareVersionValue, new AbsoluteConstraints(300, 60, 130, -1));
        this.jCheckBoxConnectBLE.setText(resourceMap.getString("jCheckBoxConnectBLE.text", new Object[0]));
        this.jCheckBoxConnectBLE.setToolTipText(resourceMap.getString("jCheckBoxConnectBLE.toolTipText", new Object[0]));
        this.jCheckBoxConnectBLE.setName("jCheckBoxConnectBLE");
        this.jPanelConnection.add((Component)this.jCheckBoxConnectBLE, new AbsoluteConstraints(210, 20, -1, -1));
        this.jPanelMain.add((Component)this.jPanelConnection, new AbsoluteConstraints(0, 0, 430, 90));
        this.jPanelProfile.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("groupProfile.border.title", new Object[0])));
        this.jPanelProfile.setName("groupProfile");
        this.jPanelProfile.setLayout((LayoutManager)new AbsoluteLayout());
        this.jComboBoxProfile.setToolTipText(resourceMap.getString("comboBoxProfile.toolTipText", new Object[0]));
        this.jComboBoxProfile.setName("comboBoxProfile");
        this.jComboBoxProfile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SimpleBGC_GUIView.this.jComboBoxProfileItemStateChanged(evt);
            }
        });
        this.jPanelProfile.add((Component)this.jComboBoxProfile, new AbsoluteConstraints(10, 20, 270, -1));
        this.jButtonRenameProfile.setAction(actionMap.get("renameProfile"));
        this.jButtonRenameProfile.setIcon(resourceMap.getIcon("buttonProfileRename.icon"));
        this.jButtonRenameProfile.setText(resourceMap.getString("buttonProfileRename.text", new Object[0]));
        this.jButtonRenameProfile.setToolTipText(resourceMap.getString("buttonProfileRename.toolTipText", new Object[0]));
        this.jButtonRenameProfile.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonRenameProfile.setName("buttonProfileRename");
        this.jPanelProfile.add((Component)this.jButtonRenameProfile, new AbsoluteConstraints(290, 20, 100, 30));
        this.jButton5.setAction(actionMap.get("loadProfile"));
        this.jButton5.setText(resourceMap.getString("buttonProfileLoad.text", new Object[0]));
        this.jButton5.setToolTipText(resourceMap.getString("buttonProfileLoad.toolTipText", new Object[0]));
        this.jButton5.setName("buttonProfileLoad");
        this.jPanelProfile.add((Component)this.jButton5, new AbsoluteConstraints(10, 50, 120, 30));
        this.jButton6.setAction(actionMap.get("saveProfile"));
        this.jButton6.setText(resourceMap.getString("buttonProfileSave.text", new Object[0]));
        this.jButton6.setToolTipText(resourceMap.getString("buttonProfileSave.toolTipText", new Object[0]));
        this.jButton6.setName("buttonProfileSave");
        this.jPanelProfile.add((Component)this.jButton6, new AbsoluteConstraints(130, 50, 120, 30));
        this.jButtonCopy.setAction(actionMap.get("copyProfile"));
        this.jButtonCopy.setText(resourceMap.getString("jButtonCopy.text", new Object[0]));
        this.jButtonCopy.setToolTipText(resourceMap.getString("jButtonCopy.toolTipText", new Object[0]));
        this.jButtonCopy.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCopy.setName("jButtonCopy");
        this.jPanelProfile.add((Component)this.jButtonCopy, new AbsoluteConstraints(390, 20, 100, 30));
        this.jToggleButtonProfile1.setAction(actionMap.get("buttonActivateProfile"));
        this.buttonGroupProfile.add(this.jToggleButtonProfile1);
        this.jToggleButtonProfile1.setText(resourceMap.getString("jToggleButtonProfile1.text", new Object[0]));
        this.jToggleButtonProfile1.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonProfile1.setName("jToggleButtonProfile1");
        this.jPanelProfile.add((Component)this.jToggleButtonProfile1, new AbsoluteConstraints(340, 50, 30, 30));
        this.jToggleButtonProfile2.setAction(actionMap.get("buttonActivateProfile"));
        this.buttonGroupProfile.add(this.jToggleButtonProfile2);
        this.jToggleButtonProfile2.setText(resourceMap.getString("jToggleButtonProfile2.text", new Object[0]));
        this.jToggleButtonProfile2.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonProfile2.setName("jToggleButtonProfile2");
        this.jPanelProfile.add((Component)this.jToggleButtonProfile2, new AbsoluteConstraints(370, 50, 30, 30));
        this.jToggleButtonProfile3.setAction(actionMap.get("buttonActivateProfile"));
        this.buttonGroupProfile.add(this.jToggleButtonProfile3);
        this.jToggleButtonProfile3.setText(resourceMap.getString("jToggleButtonProfile3.text", new Object[0]));
        this.jToggleButtonProfile3.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonProfile3.setName("jToggleButtonProfile3");
        this.jPanelProfile.add((Component)this.jToggleButtonProfile3, new AbsoluteConstraints(400, 50, 30, 30));
        this.jToggleButtonProfile4.setAction(actionMap.get("buttonActivateProfile"));
        this.buttonGroupProfile.add(this.jToggleButtonProfile4);
        this.jToggleButtonProfile4.setText(resourceMap.getString("jToggleButtonProfile4.text", new Object[0]));
        this.jToggleButtonProfile4.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonProfile4.setName("jToggleButtonProfile4");
        this.jPanelProfile.add((Component)this.jToggleButtonProfile4, new AbsoluteConstraints(430, 50, 30, 30));
        this.jToggleButtonProfile5.setAction(actionMap.get("buttonActivateProfile"));
        this.buttonGroupProfile.add(this.jToggleButtonProfile5);
        this.jToggleButtonProfile5.setText(resourceMap.getString("jToggleButtonProfile5.text", new Object[0]));
        this.jToggleButtonProfile5.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButtonProfile5.setName("jToggleButtonProfile5");
        this.jPanelProfile.add((Component)this.jToggleButtonProfile5, new AbsoluteConstraints(460, 50, 30, 30));
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jPanelProfile.add((Component)this.jLabel3, new AbsoluteConstraints(250, 60, 80, -1));
        this.jPanelMain.add((Component)this.jPanelProfile, new AbsoluteConstraints(430, 0, 500, 90));
        this.tabbedPaneMain.setName("tabbedPane");
        this.tabbedPaneMain.setPreferredSize(new Dimension(500, 459));
        this.tabbedPaneMain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SimpleBGC_GUIView.this.tabbedPaneMainStateChanged(evt);
            }
        });
        this.jPanelMain.add((Component)this.tabbedPaneMain, new AbsoluteConstraints(0, 90, 740, 410));
        this.jPanel4.setBackground(resourceMap.getColor("JPanelInfo.background"));
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel4.setName("JPanelInfo");
        this.jPanel4.setLayout((LayoutManager)new AbsoluteLayout());
        this.jLabelErrorTitle.setFont(this.jLabelErrorTitle.getFont().deriveFont(this.jLabelErrorTitle.getFont().getStyle() | 1));
        this.jLabelErrorTitle.setForeground(resourceMap.getColor("labelErrorTitle.foreground"));
        this.jLabelErrorTitle.setText(resourceMap.getString("labelErrorTitle.text", new Object[0]));
        this.jLabelErrorTitle.setVerticalAlignment(1);
        this.jLabelErrorTitle.setName("labelErrorTitle");
        this.jPanel4.add((Component)this.jLabelErrorTitle, new AbsoluteConstraints(11, 1, 487, 30));
        this.jLabel14.setForeground(resourceMap.getColor("labelErrorsCount.foreground"));
        this.jLabel14.setText(resourceMap.getString("labelErrorsCount.text", new Object[0]));
        this.jLabel14.setName("labelErrorsCount");
        this.jPanel4.add((Component)this.jLabel14, new AbsoluteConstraints(630, 1, -1, -1));
        this.jLabelErrorDescr.setForeground(resourceMap.getColor("labelErrorDescr.foreground"));
        this.jLabelErrorDescr.setText(resourceMap.getString("labelErrorDescr.text", new Object[0]));
        this.jLabelErrorDescr.setName("labelErrorDescr");
        this.jPanel4.add((Component)this.jLabelErrorDescr, new AbsoluteConstraints(11, 20, 690, 79));
        this.jLabelI2CErrors.setText(resourceMap.getString("jLabelI2CErrors.text", new Object[0]));
        this.jLabelI2CErrors.setName("jLabelI2CErrors");
        this.jPanel4.add((Component)this.jLabelI2CErrors, new AbsoluteConstraints(693, 1, 46, -1));
        this.jLabelCycleTime.setText(resourceMap.getString("jLabelCycleTime.text", new Object[0]));
        this.jLabelCycleTime.setName("jLabelCycleTime");
        this.jPanel4.add((Component)this.jLabelCycleTime, new AbsoluteConstraints(589, 1, 35, -1));
        this.jLabel13.setForeground(resourceMap.getColor("jLabel13.foreground"));
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.jPanel4.add((Component)this.jLabel13, new AbsoluteConstraints(504, 1, -1, -1));
        this.jPanelMain.add((Component)this.jPanel4, new AbsoluteConstraints(0, 550, 740, 100));
        this.jPanelAngles.setName("jPanelAngles");
        this.jPanelAngles.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanelYawAngle.setName("jPanelYawAngle");
        this.jPanelYawAngle.setPreferredSize(new Dimension(171, 171));
        this.jPanelYawAngle.setLayout(new BoxLayout(this.jPanelYawAngle, 2));
        this.jPanelAngles.add((Component)this.jPanelYawAngle, new AbsoluteConstraints(0, 10, -1, -1));
        this.jPanelRollAngle.setName("jPanelRollAngle");
        this.jPanelRollAngle.setPreferredSize(new Dimension(171, 171));
        this.jPanelRollAngle.setLayout(new BoxLayout(this.jPanelRollAngle, 2));
        this.jPanelAngles.add((Component)this.jPanelRollAngle, new AbsoluteConstraints(0, 185, -1, -1));
        this.jPanelPitchAngle.setName("jPanelPitchAngle");
        this.jPanelPitchAngle.setPreferredSize(new Dimension(171, 171));
        this.jPanelPitchAngle.setLayout(new BoxLayout(this.jPanelPitchAngle, 2));
        this.jPanelAngles.add((Component)this.jPanelPitchAngle, new AbsoluteConstraints(0, 360, -1, -1));
        this.jPanelMain.add((Component)this.jPanelAngles, new AbsoluteConstraints(750, 100, -1, -1));
        this.jButtonRead.setAction(actionMap.get("buttonReadParams"));
        this.jButtonRead.setText(resourceMap.getString("buttonRead.text", new Object[0]));
        this.jButtonRead.setToolTipText(resourceMap.getString("buttonRead.toolTipText", new Object[0]));
        this.jButtonRead.setName("buttonRead");
        this.jPanelMain.add((Component)this.jButtonRead, new AbsoluteConstraints(450, 510, 140, 30));
        this.jButtonWrite.setAction(actionMap.get("buttonWriteParams"));
        this.jButtonWrite.setText(resourceMap.getString("buttonWrite.text", new Object[0]));
        this.jButtonWrite.setToolTipText(resourceMap.getString("buttonWrite.toolTipText", new Object[0]));
        this.jButtonWrite.setName("buttonWrite");
        this.jPanelMain.add((Component)this.jButtonWrite, new AbsoluteConstraints(600, 510, 140, 30));
        this.jToggleButtonMotors.setAction(actionMap.get("buttonMotorsOn"));
        this.jToggleButtonMotors.setText(resourceMap.getString("jToggleButtonMotors.text", new Object[0]));
        this.jToggleButtonMotors.setName("jToggleButtonMotors");
        this.jPanelMain.add((Component)this.jToggleButtonMotors, new AbsoluteConstraints(10, 510, 180, 30));
        this.jProgressBarMain.setName("jProgressBarMain");
        this.jProgressBarMain.setStringPainted(true);
        this.jPanelMain.add((Component)this.jProgressBarMain, new AbsoluteConstraints(240, 520, 200, 20));
        this.jButton1.setAction(actionMap.get("buttonReset"));
        this.jButton1.setToolTipText(resourceMap.getString("jButton1.toolTipText", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jPanelMain.add((Component)this.jButton1, new AbsoluteConstraints(190, 510, 30, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.jPanelMain, gridBagConstraints);
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("menuFile.text", new Object[0]));
        fileMenu.setName("menuFile");
        this.menuLoadProfile.setAction(actionMap.get("loadProfile"));
        this.menuLoadProfile.setText(resourceMap.getString("menuLoadProfile.text", new Object[0]));
        this.menuLoadProfile.setName("menuLoadProfile");
        fileMenu.add(this.menuLoadProfile);
        this.menuSaveProfile.setAction(actionMap.get("saveProfile"));
        this.menuSaveProfile.setText(resourceMap.getString("menuSaveProfile.text", new Object[0]));
        this.menuSaveProfile.setName("menuSaveProfile");
        fileMenu.add(this.menuSaveProfile);
        this.menuSaveProfileUsingTemplate.setText(resourceMap.getString("menuSaveProfileUsingTemplate.text", new Object[0]));
        this.menuSaveProfileUsingTemplate.setName("menuSaveProfileUsingTemplate");
        this.menuManageProfileTemplates.setAction(actionMap.get("menuSettings"));
        this.menuManageProfileTemplates.setText(resourceMap.getString("menuManageProfileTemplates.text", new Object[0]));
        this.menuManageProfileTemplates.setName("menuManageProfileTemplates");
        this.menuSaveProfileUsingTemplate.add(this.menuManageProfileTemplates);
        fileMenu.add(this.menuSaveProfileUsingTemplate);
        this.menuSaveAllProfiles.setAction(actionMap.get("saveAllProfiles"));
        this.menuSaveAllProfiles.setText(resourceMap.getString("menuSaveAllProfiles.text", new Object[0]));
        this.menuSaveAllProfiles.setName("menuSaveAllProfiles");
        fileMenu.add(this.menuSaveAllProfiles);
        this.menuSaveAllProfilesUsingTemplate.setText(resourceMap.getString("menuSaveAllProfilesUsingTemplate.text", new Object[0]));
        this.menuSaveAllProfilesUsingTemplate.setName("menuSaveAllProfilesUsingTemplate");
        fileMenu.add(this.menuSaveAllProfilesUsingTemplate);
        this.menuCopyProfile.setAction(actionMap.get("copyProfile"));
        this.menuCopyProfile.setText(resourceMap.getString("menuCopyProfile.text", new Object[0]));
        this.menuCopyProfile.setName("menuCopyProfile");
        fileMenu.add(this.menuCopyProfile);
        this.jSeparator9.setName("jSeparator9");
        fileMenu.add(this.jSeparator9);
        this.menuSettings.setAction(actionMap.get("menuSettings"));
        this.menuSettings.setText(resourceMap.getString("menuSettings.text", new Object[0]));
        this.menuSettings.setName("menuSettings");
        fileMenu.add(this.menuSettings);
        this.jSeparator5.setName("jSeparator5");
        fileMenu.add(this.jSeparator5);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setText(resourceMap.getString("menuItemExit.text", new Object[0]));
        exitMenuItem.setName("menuItemExit");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.boardMenu.setText(resourceMap.getString("boardMenu.text", new Object[0]));
        this.boardMenu.setName("boardMenu");
        this.menuReadParams.setAction(actionMap.get("buttonReadParams"));
        this.menuReadParams.setText(resourceMap.getString("menuReadParams.text", new Object[0]));
        this.menuReadParams.setName("menuReadParams");
        this.boardMenu.add(this.menuReadParams);
        this.menuWriteParams.setAction(actionMap.get("buttonWriteParams"));
        this.menuWriteParams.setText(resourceMap.getString("menuWriteParams.text", new Object[0]));
        this.menuWriteParams.setName("menuWriteParams");
        this.boardMenu.add(this.menuWriteParams);
        this.menuWriteParamsAll.setAction(actionMap.get("buttonWriteAllProfiles"));
        this.menuWriteParamsAll.setText(resourceMap.getString("menuWriteParamsAll.text", new Object[0]));
        this.menuWriteParamsAll.setName("menuWriteParamsAll");
        this.boardMenu.add(this.menuWriteParamsAll);
        this.jSeparator10.setName("jSeparator10");
        this.boardMenu.add(this.jSeparator10);
        this.menuExecuteAction.setAction(actionMap.get("executeActionAction"));
        this.menuExecuteAction.setText(resourceMap.getString("menuExecuteAction.text", new Object[0]));
        this.menuExecuteAction.setName("menuExecuteAction");
        this.boardMenu.add(this.menuExecuteAction);
        this.jSeparator4.setName("jSeparator4");
        this.boardMenu.add(this.jSeparator4);
        this.sensorMenu.setText(resourceMap.getString("sensorMenu.text", new Object[0]));
        this.sensorMenu.setName("sensorMenu");
        this.menuCalibAcc.setAction(actionMap.get("buttonCalibACCAction"));
        this.menuCalibAcc.setText(resourceMap.getString("menuCalibAcc.text", new Object[0]));
        this.menuCalibAcc.setName("menuCalibAcc");
        this.sensorMenu.add(this.menuCalibAcc);
        this.menuCalibrateGyro.setAction(actionMap.get("buttonCalibGyroAction"));
        this.menuCalibrateGyro.setText(resourceMap.getString("menuCalibrateGyro.text", new Object[0]));
        this.menuCalibrateGyro.setName("menuCalibrateGyro");
        this.sensorMenu.add(this.menuCalibrateGyro);
        this.menuCalibAccTemp.setAction(actionMap.get("menuCalibAccTemp"));
        this.menuCalibAccTemp.setText(resourceMap.getString("menuCalibAccTemp.text", new Object[0]));
        this.menuCalibAccTemp.setName("menuCalibAccTemp");
        this.sensorMenu.add(this.menuCalibAccTemp);
        this.menuCalibGyroTemp.setAction(actionMap.get("buttonCalibGyroTemp"));
        this.menuCalibGyroTemp.setText(resourceMap.getString("menuCalibGyroTemp.text", new Object[0]));
        this.menuCalibGyroTemp.setName("menuCalibGyroTemp");
        this.sensorMenu.add(this.menuCalibGyroTemp);
        this.menuCalibrateHelper.setAction(actionMap.get("buttonCalibHelper"));
        this.menuCalibrateHelper.setText(resourceMap.getString("menuCalibrateHelper.text", new Object[0]));
        this.menuCalibrateHelper.setName("menuCalibrateHelper");
        this.sensorMenu.add(this.menuCalibrateHelper);
        this.boardMenu.add(this.sensorMenu);
        this.jSeparator3.setName("jSeparator3");
        this.boardMenu.add(this.jSeparator3);
        this.menuConfigureBluetooth.setAction(actionMap.get("menuConfigureBluetooth"));
        this.menuConfigureBluetooth.setText(resourceMap.getString("menuConfigureBluetooth.text", new Object[0]));
        this.menuConfigureBluetooth.setName("menuConfigureBluetooth");
        this.boardMenu.add(this.menuConfigureBluetooth);
        this.menuConfigureBluetooth1.setAction(actionMap.get("menuConfigureMultiLink"));
        this.menuConfigureBluetooth1.setText(resourceMap.getString("menuConfigureBluetooth1.text", new Object[0]));
        this.menuConfigureBluetooth1.setName("menuConfigureBluetooth1");
        this.boardMenu.add(this.menuConfigureBluetooth1);
        this.jSeparator11.setName("jSeparator11");
        this.boardMenu.add(this.jSeparator11);
        this.menuEraseEEPROM.setAction(actionMap.get("eraseEEPROM"));
        this.menuEraseEEPROM.setText(resourceMap.getString("menuEraseEEPROM.text", new Object[0]));
        this.menuEraseEEPROM.setName("menuEraseEEPROM");
        this.boardMenu.add(this.menuEraseEEPROM);
        this.menuBackupManager.setAction(actionMap.get("menuBackupManager"));
        this.menuBackupManager.setText(resourceMap.getString("menuBackupManager.text", new Object[0]));
        this.menuBackupManager.setName("menuBackupManager");
        this.boardMenu.add(this.menuBackupManager);
        this.jSeparator12.setName("jSeparator12");
        this.boardMenu.add(this.jSeparator12);
        this.menuBackupIMUCalib.setText(resourceMap.getString("menuBackupIMUCalib.text", new Object[0]));
        this.menuBackupIMUCalib.setName("menuBackupIMUCalib");
        this.menuBackupMainIMUCalib.setAction(actionMap.get("actionBackupMainIMUCalib"));
        this.menuBackupMainIMUCalib.setText(resourceMap.getString("menuBackupMainIMUCalib.text", new Object[0]));
        this.menuBackupMainIMUCalib.setName("menuBackupMainIMUCalib");
        this.menuBackupIMUCalib.add(this.menuBackupMainIMUCalib);
        this.menuBackupFrameIMUCalib.setAction(actionMap.get("actionBackupFrameIMUCalib"));
        this.menuBackupFrameIMUCalib.setText(resourceMap.getString("menuBackupFrameIMUCalib.text", new Object[0]));
        this.menuBackupFrameIMUCalib.setName("menuBackupFrameIMUCalib");
        this.menuBackupIMUCalib.add(this.menuBackupFrameIMUCalib);
        this.boardMenu.add(this.menuBackupIMUCalib);
        this.menuRestoreIMUCalib.setText(resourceMap.getString("menuRestoreIMUCalib.text", new Object[0]));
        this.menuRestoreIMUCalib.setName("menuRestoreIMUCalib");
        this.menuRestoreMainIMUCalib.setAction(actionMap.get("actionRestoreMainIMUCalib"));
        this.menuRestoreMainIMUCalib.setText(resourceMap.getString("menuRestoreMainIMUCalib.text", new Object[0]));
        this.menuRestoreMainIMUCalib.setName("menuRestoreMainIMUCalib");
        this.menuRestoreIMUCalib.add(this.menuRestoreMainIMUCalib);
        this.menuRestoreFrameIMUCalib.setAction(actionMap.get("actionRestoreFrameIMUCalib"));
        this.menuRestoreFrameIMUCalib.setText(resourceMap.getString("menuRestoreFrameIMUCalib.text", new Object[0]));
        this.menuRestoreFrameIMUCalib.setName("menuRestoreFrameIMUCalib");
        this.menuRestoreIMUCalib.add(this.menuRestoreFrameIMUCalib);
        this.boardMenu.add(this.menuRestoreIMUCalib);
        this.menuBar.add(this.boardMenu);
        this.languageMenu.setText("Language");
        this.languageMenu.setName("menuLanguage");
        this.menuBar.add(this.languageMenu);
        this.viewMenu.setText(resourceMap.getString("viewMenu.text", new Object[0]));
        this.viewMenu.setName("viewMenu");
        this.menuViewLevel.setText(resourceMap.getString("menuViewLevel.text", new Object[0]));
        this.menuViewLevel.setName("menuViewLevel");
        this.menuViewLevelBASIC.setAction(actionMap.get("menuSetViewLevel"));
        this.buttonGroupViewLevel.add(this.menuViewLevelBASIC);
        this.menuViewLevelBASIC.setText(resourceMap.getString("menuViewLevelBASIC.text", new Object[0]));
        this.menuViewLevelBASIC.setName("menuViewLevelBASIC");
        this.menuViewLevel.add(this.menuViewLevelBASIC);
        this.menuViewLevelADVANCED.setAction(actionMap.get("menuSetViewLevel"));
        this.buttonGroupViewLevel.add(this.menuViewLevelADVANCED);
        this.menuViewLevelADVANCED.setText(resourceMap.getString("menuViewLevelADVANCED.text", new Object[0]));
        this.menuViewLevelADVANCED.setName("menuViewLevelADVANCED");
        this.menuViewLevel.add(this.menuViewLevelADVANCED);
        this.menuViewLevelEXPERT.setAction(actionMap.get("menuSetViewLevel"));
        this.buttonGroupViewLevel.add(this.menuViewLevelEXPERT);
        this.menuViewLevelEXPERT.setText(resourceMap.getString("menuViewLevelEXPERT.text", new Object[0]));
        this.menuViewLevelEXPERT.setName("menuViewLevelEXPERT");
        this.menuViewLevel.add(this.menuViewLevelEXPERT);
        this.menuViewLevelDEVELOPER.setAction(actionMap.get("menuSetViewLevel"));
        this.buttonGroupViewLevel.add(this.menuViewLevelDEVELOPER);
        this.menuViewLevelDEVELOPER.setText(resourceMap.getString("menuViewLevelDEVELOPER.text", new Object[0]));
        this.menuViewLevelDEVELOPER.setName("menuViewLevelDEVELOPER");
        this.menuViewLevel.add(this.menuViewLevelDEVELOPER);
        this.viewMenu.add(this.menuViewLevel);
        this.jSeparator13.setName("jSeparator13");
        this.viewMenu.add(this.jSeparator13);
        this.jSeparator2.setName("jSeparator2");
        this.viewMenu.add(this.jSeparator2);
        this.jMenuItem1.setAction(actionMap.get("fullScreen"));
        this.jMenuItem1.setText(resourceMap.getString("jMenuItem1.text", new Object[0]));
        this.jMenuItem1.setName("jMenuItem1");
        this.viewMenu.add(this.jMenuItem1);
        this.menuBar.add(this.viewMenu);
        helpMenu.setText(resourceMap.getString("menuHelp.text", new Object[0]));
        helpMenu.setName("menuHelp");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("menuItemAbout");
        helpMenu.add(aboutMenuItem);
        this.jSeparator1.setName("jSeparator1");
        helpMenu.add(this.jSeparator1);
        this.bugReportMenuItem.setAction(actionMap.get("actionBugReport"));
        this.bugReportMenuItem.setText(resourceMap.getString("bugReportMenuItem.text", new Object[0]));
        this.bugReportMenuItem.setName("bugReportMenuItem");
        helpMenu.add(this.bugReportMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        this.statusPanel.setPreferredSize(new Dimension(944, 30));
        statusPanelSeparator.setName("statusPanelSeparator");
        this.jLabelStatus.setName("jLabelStatus");
        this.jPanelBat.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("jPanelBat.border.lineColor")));
        this.jPanelBat.setName("jPanelBat");
        this.jPanelBat.setLayout(new BoxLayout(this.jPanelBat, 2));
        this.jLabelCurrentSens.setFont(this.jLabelCurrentSens.getFont().deriveFont(this.jLabelCurrentSens.getFont().getStyle() | 1, this.jLabelCurrentSens.getFont().getSize() + 3));
        this.jLabelCurrentSens.setName("jLabelCurrentSens");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelStatus, -1, 656, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCurrentSens, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelBat, -2, 176, -2).addContainerGap()).addComponent(statusPanelSeparator, GroupLayout.Alignment.TRAILING, -1, 944, Short.MAX_VALUE));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jPanelBat, -2, 17, -2)).addGroup(statusPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelStatus, -2, 20, -2).addComponent(this.jLabelCurrentSens, -2, 20, -2)))).addGap(123, 123, 123)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void jCBPortListPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.setPortList();
    }

    private void jComboBoxProfileItemStateChanged(ItemEvent evt) {
        int profile;
        if (evt.getStateChange() == 1 && (profile = this.jComboBoxProfile.getSelectedIndex()) != this.oldProfile) {
            logger.info("New profile selected: " + profile);
            BoardParams params = BoardParams.getCurParams();
            if (params != null) {
                if (!this.applyBoardParams(params)) {
                    return;
                }
                params.curProfile = profile;
                this.updateBoardParams();
            }
            this.oldProfile = profile;
        }
    }

    private void tabbedPaneMainStateChanged(ChangeEvent evt) {
    }

    public boolean isPanelVisible(ITabbedPanel panel) {
        return this.tabbedPaneMain.getSelectedComponent() == panel || panel.getParentContainer() != null;
    }

    public void debugMessage(String msg) {
        this.panelDebug.debugMessage(msg);
    }

    public void debugMessageSynced(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleBGC_GUIApp.mainView.debugMessage(msg);
            }
        });
    }

    private void changeLocaleMenuSelection() {
        Component[] menuElements;
        Locale locale = Settings.getLocale();
        for (Component menuItem : menuElements = this.languageMenu.getMenuComponents()) {
            JRadioButtonMenuItem item;
            if (!(menuItem instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)menuItem).getName().equalsIgnoreCase(GroupView.MENU_NAME_PREFIX + locale.getCountry())) continue;
            item.setSelected(true);
        }
    }

    private void changeViewMenuSelection() {
        Component[] menuElements;
        for (Component menuItem : menuElements = this.viewMenu.getMenuComponents()) {
            JRadioButtonMenuItem item;
            if (!(menuItem instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)menuItem).getName().equalsIgnoreCase(GroupView.MENU_NAME_PREFIX + SimpleBGC_GUIApp.getTheme())) continue;
            item.setSelected(true);
        }
    }

    private void changeViewLevelMenuSelection() {
        String curViewName = GroupView.getCurViewLevel().name();
        for (Component menuItem : this.menuViewLevel.getMenuComponents()) {
            JRadioButtonMenuItem item;
            if (!(menuItem instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)menuItem).getName().equalsIgnoreCase("menuViewLevel" + curViewName)) continue;
            item.setSelected(true);
        }
    }

    public void setToolTipListener(Component c) {
        Utils.setToolTipListener(c, this.toolTipMouseListener);
    }

    public static String getProfileName(int id) {
        String name = null;
        BoardParams params = BoardParams.getCurParams();
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null && boardInfo.profileNames != null && boardInfo.profileNames[id] != null) {
            name = boardInfo.profileNames[id];
        }
        if (name == null || name.isEmpty()) {
            name = "Profile" + (id + 1);
        }
        return name;
    }

    public void updateProfileNames() {
        ItemListener ls = this.jComboBoxProfile.getItemListeners()[0];
        this.jComboBoxProfile.removeItemListener(ls);
        int selected = this.jComboBoxProfile.getSelectedIndex();
        this.jComboBoxProfile.removeAllItems();
        for (int i = 0; i < BoardInfo.getNumProfiles(); ++i) {
            String name = SimpleBGC_GUIView.getProfileName(i);
            this.jComboBoxProfile.addItem(name);
        }
        this.jComboBoxProfile.setSelectedIndex(Math.max(0, selected));
        this.jComboBoxProfile.addItemListener(ls);
    }

    public static void setProjectLink(JLabel jLabel, String path) {
        StringBuilder uri = new StringBuilder(SimpleBGC_GUIApp.PROJECT_URI);
        if (path != null) {
            uri.append(path);
        }
        SimpleBGC_GUIView.setLabelLink(jLabel, SimpleBGC_GUIApp.PROJECT_URI_TITLE, uri.toString());
    }

    public static void setLabelLink(JLabel jLabel, String title, final String url) {
        if (title == null) {
            title = jLabel.getText();
        }
        if (title.indexOf("html") == -1) {
            title = "<html><u>" + title + "</u></html>";
        }
        jLabel.setText(title);
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    SimpleBGC_GUIView.browseURI(url);
                }
            }
        });
    }

    public static void browseURI(String link) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                URI uri = new URI(link);
                desktop.browse(uri);
            }
            catch (IOException ex) {
                logger.error(ex.toString());
            }
            catch (URISyntaxException ex) {
                logger.error(ex.toString());
            }
        }
    }

    private void setPortList() {
        ArrayList<Sprav> portList;
        if (!this.isPortConnected && (portList = SerialPortService.getPortList(SerialPortService.getTunnelNames(Settings.getInt("tunnel.type", 0)))) != null) {
            this.jCBPortList.setModel(new SpravComboBoxModel(portList, this.jCBPortList.getModel()));
            String lastUsedPortName = Settings.get("last.used.port");
            if (lastUsedPortName != null) {
                this.jCBPortList.setSelectedItem(lastUsedPortName);
            }
        }
    }

    @Action
    public void connect(String port, boolean findBoard) {
        this.connect(port, findBoard, "error.serial_connect");
    }

    public void connect(String port, boolean findBoard, String errorLabel) {
        if (port == null) {
            port = latestPortName;
        } else {
            latestPortName = port;
        }
        try {
            SerialPortService.connect(port, this.jCheckBoxConnectBLE.isSelected(), Settings.getInt("tunnel.type", 0));
            this.jButtonConnect.setText(this.resourceMap.getString("jButtonConnect.disconnect.text", new Object[0]));
            this.panelDebug.setPortConnectedState(true);
            this.setPortConnected(true);
            SerialCommandProcessor.applyProtocolVerSettings();
            if (findBoard) {
                this.jLabelConnState.setText(this.resourceMap.getString("jLabelConnState.connecting", port));
                ConnectThread.initConnection();
            } else {
                this.jLabelConnState.setText(this.resourceMap.getString("jLabelConnState.connected", port));
            }
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            JOptionPane.showMessageDialog(null, this.resourceMap.getString(errorLabel, ex.getMessage()), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        }
    }

    public synchronized void stopSerialCommunication() {
        ConnectThread.stopConnection();
        if (this.serialCommunicationActive) {
            RealtimeDataThread.stop();
            SerialCommandProcessor.stopSerialCommunication();
            this.serialCommunicationActive = false;
        }
    }

    public synchronized void disconnect() {
        try {
            this.stopSerialCommunication();
            SerialPortService.disconnect();
            SimpleBGC_GUIView.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIView.this.jButtonConnect.setText(SimpleBGC_GUIView.this.resourceMap.getString("jButtonConnect.connect.text", new Object[0]));
                    SimpleBGC_GUIView.this.panelDebug.setPortConnectedState(false);
                    SimpleBGC_GUIView.this.setPortConnected(false);
                    SimpleBGC_GUIView.this.setConnected(false);
                }
            });
        }
        catch (Exception ex) {
            logger.stackTrace(ex);
        }
    }

    public static void invokeAndWait(Runnable r) {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(r);
            } else {
                r.run();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Action
    public void connectDisconnect() {
        logger.debug("Connect/disconnect action fired!");
        if (!this.isPortConnected) {
            String port = this.getSelectedPort(true);
            if (port != null) {
                this.connect(port, true);
            }
        } else {
            this.disconnect();
        }
    }

    private File createProfilesDirectory() {
        File workingDirectory = null;
        try {
            File lastUsedProfilesDirectory;
            workingDirectory = new File(Settings.getUserDir());
            if (Settings.get("last_used_profiles_directory") != null && (lastUsedProfilesDirectory = new File(Settings.get("last_used_profiles_directory"))).exists() && lastUsedProfilesDirectory.isDirectory()) {
                return lastUsedProfilesDirectory;
            }
            File profilesDirectory = new File(workingDirectory.getPath() + File.separatorChar + "profiles");
            if (!profilesDirectory.exists()) {
                logger.debug("Creating \"profiles\" directory...");
                profilesDirectory.mkdirs();
            }
            return profilesDirectory;
        }
        catch (Exception e) {
            logger.error("Error creating \"profiles\" directory: " + e.toString());
            return workingDirectory;
        }
    }

    @Action
    public void loadProfile() {
        int profileId = this.jComboBoxProfile.getSelectedIndex();
        if (5 < profileId + 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Current board params implementation does not support more than 5 profiles!", this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            return;
        }
        File f = this.showProfileLoadDialog("Profile file", "profile");
        if (this.isSaved() && f != null) {
            logger.debug("Loading profile from file " + f.getAbsolutePath() + " ...");
            try {
                BoardParams curParams = BoardParams.getCurParams();
                BoardParamsSavedData data = XmlUtils.loadProfileXML(f, curParams, curParams.profiles[profileId]);
                BoardParams copy = BoardParams.getCurParams().clone();
                BoardParams loaded = data.join(copy, profileId);
                if (loaded.loadedFrom == BoardParams.LoadedFrom.NO) {
                    loaded.loadedFrom = BoardParams.LoadedFrom.FILE;
                }
                BoardParams.setCurParams(loaded);
                if (!this.isConnected() && data.boardVer > 0 && data.firmwareVer > 0) {
                    BoardInfo info = new BoardInfo();
                    info.boardFeatures = data.boardFeatures;
                    info.boardVer = data.boardVer;
                    info.setFrwVer(data.firmwareVer);
                    info.setBuildNumber(data.buildNumber);
                    BoardInfo.setBoardInfo(info);
                    this.updateBoardInfo();
                }
                this.updateBoardParams();
                this.updateStatus(this.resourceMap.getString("status.profile_loaded_from_file", new Object[0]));
            }
            catch (Exception e) {
                logger.stackTrace(e);
                JOptionPane.showMessageDialog(this.getFrame(), this.resourceMap.getString("error.parsing_profile", e.toString()), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            }
        }
    }

    @Action
    public void saveProfile() {
        int profileId = this.jComboBoxProfile.getSelectedIndex();
        if (5 < profileId + 1) {
            JOptionPane.showMessageDialog(this.getFrame(), "Current board params implementatiuon does not support more than 5 profiles!", this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
            return;
        }
        this._saveProfile(profileId, (String)this.jComboBoxProfile.getSelectedItem(), null);
    }

    @Action
    public void saveAllProfiles() {
        this._saveProfile(-1, "all_profiles", null);
    }

    public void _saveProfile(int profileId, String profileName, HashSet<String> allowedElements) {
        BoardParams copy;
        BoardParams params = BoardParams.getCurParams();
        try {
            copy = params.clone();
            if (!this.applyBoardParams(copy)) {
                return;
            }
            copy.onBeforeSaveFile();
        }
        catch (Exception e) {
            logger.error("Error applying params: " + e.toString());
            return;
        }
        File f = this.showProfileSaveDialog("Profile file", "profile", profileName + ".profile");
        if (f != null) {
            XStream xstream = XmlUtils.configureXStream(allowedElements);
            logger.trace("Converting board params into xml...");
            String xml = null;
            try {
                xml = xstream.toXML((Object)new BoardParamsSavedData(copy, profileId, BoardInfo.getBoardInfo()));
                logger.debug("Board params are converted into xml.");
            }
            catch (Exception e) {
                logger.error("Error converting board params into xml: " + e.toString());
            }
            if (xml != null) {
                logger.trace("Saving xml into file...");
                try {
                    FileUtil.save(f.getAbsolutePath(), xml);
                    this.updateStatus(this.resourceMap.getString("status.params_saved", new Object[0]));
                    logger.debug("Xml was saved.");
                }
                catch (Exception e) {
                    logger.error("Error saving xml into profile: " + e.toString());
                    JOptionPane.showMessageDialog(this.getFrame(), this.resourceMap.getString("error.saving_profile", e.toString()), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
                }
            }
        }
    }

    @Action(enabledProperty="connected")
    public void buttonReadParams() {
        if (this.isSaved()) {
            SerialCommandProcessor.readAllParams(-1);
        }
    }

    public final void setPortConnected(boolean newState) {
        boolean old = this.isPortConnected;
        this.isPortConnected = newState;
        this.firePropertyChange("portConnected", old, newState);
        for (ITabbedPanel p : this.tabPanels) {
            ((JPanel)((Object)p)).firePropertyChange("portConnected", old, newState);
        }
    }

    public final void setConnected(final boolean state) {
        VersionImpl frwVer;
        logger.debug("Set connected state " + state);
        boolean old = this.isConnected();
        this.isConnected = state;
        this.serialCommunicationActive = state;
        this.firePropertyChange("connected", old, this.isConnected());
        this.firePropertyChange("connectedDebugMode", old, this.isConnected());
        for (ITabbedPanel p : this.tabPanels) {
            ((JPanel)((Object)p)).firePropertyChange("connected", old, this.isConnected());
            ((JPanel)((Object)p)).firePropertyChange("connectedDebugMode", old, this.isConnected());
            p.onConnected(state);
        }
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                if (state) {
                    String port = SimpleBGC_GUIView.this.jCBPortList.getSelectedItem() != null ? SimpleBGC_GUIView.this.jCBPortList.getSelectedItem().toString() : "unknown";
                    logger.trace("Saving successully connected port \"" + port + "\"...");
                    Settings.set("last.used.port", port);
                    Settings.save();
                    SimpleBGC_GUIView.this.panelMonitoring.curIMUset = -1;
                    SimpleBGC_GUIView.this.jLabelConnState.setText(SimpleBGC_GUIView.this.resourceMap.getString("jLabelConnState.connected", port));
                } else {
                    SimpleBGC_GUIView.this.jLabelConnState.setText(SimpleBGC_GUIView.this.resourceMap.getString("jLabelConnState.not_connected", new Object[0]));
                    SimpleBGC_GUIView.this.labelFirmwareVersionValue.setText("-");
                    SimpleBGC_GUIView.this.panelFirmwareUpdate.setFirmwareVersion(null);
                    BoardInfo.setBoardInfo(null);
                    BoardParams.setCurParams(new BoardParams());
                    SimpleBGC_GUIView.this.updateBoardParams();
                }
                SimpleBGC_GUIView.this.updateBoardInfo();
            }
        };
        SwingUtilities.invokeLater(updater);
        ErrorInfo.clearAllErrors();
        this.is_write_from_old_GUI_confirmed = false;
        if (this.isConnected && (frwVer = new VersionImpl(BoardInfo.getBoardInfo().getFrwVer())).getFullVer() != 0) {
            SerialCommandProcessor.readAllParams(-1);
            RealtimeDataThread.start();
            if (SimpleBGC_GUIApp.version.getFullVer() / 100 != BoardInfo.getBoardInfo().getCompatibleVer() / 100) {
                JOptionPane.showMessageDialog(null, SimpleBGC_GUIApp.mainView.getResourceMap().getString("error.version_mismatch", frwVer.toString(), SimpleBGC_GUIApp.version.toString()), SimpleBGC_GUIApp.mainView.getResourceMap().getString("messageDialog.error.title", new Object[0]), 2);
            }
        }
    }

    public final void updateBoardVerUI() {
        try {
            BoardInfo info = BoardInfo.getBoardInfo();
            this.jPanelBat.setVisible(BoardInfo.hasBatterryMonitoring());
            this.jLabelCurrentSens.setVisible(BoardInfo.hasBoardFeature(32L));
            this.menuExecuteAction.removeAll();
            JMenu subMenu = this.menuExecuteAction;
            ArrayList<Sprav> cmdList = ParamsUIFactory.getCmdList();
            for (int i = 0; i < cmdList.size(); ++i) {
                ITabbedPanel[] cmd = cmdList.get(i);
                if (cmd.getId() == 0) continue;
                JMenuItem menuItem = new JMenuItem(new AbstractAction(){
                    private Sprav action;

                    public AbstractAction initialize(Sprav action) {
                        this.action = action;
                        this.putValue("Name", action.getName());
                        return this;
                    }

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        logger.debug("Executing action '" + this.action.getName() + "'");
                        SerialCommandProcessor.sendCmdExecuteMenu(this.action.getId());
                    }
                }.initialize((Sprav)cmd));
                subMenu.add(menuItem);
                if (subMenu.getItemCount() <= 27 || i >= cmdList.size() - 1) continue;
                JMenu m = new JMenu(this.resourceMap.getString("menu.more", new Object[0]));
                subMenu.add(m);
                subMenu = m;
            }
            this.updateProfileNames();
            Component selected = this.tabbedPaneMain.getSelectedComponent();
            this.tabbedPaneMain.removeAll();
            for (ITabbedPanel p : this.tabPanels) {
                boolean isTabbed;
                Component c = (Component)((Object)p);
                boolean bl = isTabbed = p.showGroups() && p.getParentContainer() == null;
                if (isTabbed) {
                    this.tabbedPaneMain.addTab(p.getTitle(), c);
                    if (p.equals(selected)) {
                        this.tabbedPaneMain.setSelectedComponent(c);
                    }
                }
                p.updateBoardVerUI();
            }
            for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
                this.updateMenuTree(this.menuBar.getMenu(i));
            }
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
    }

    public void updateMenuTree(JMenu menu) {
        menu.setEnabled((menu.getAction() == null || menu.getAction().isEnabled()) && GroupView.canShowGroup(menu));
        for (Component c : menu.getMenuComponents()) {
            if (c instanceof JMenuItem) {
                JMenuItem i;
                i.setEnabled(((i = (JMenuItem)c).getAction() == null || i.getAction().isEnabled()) && GroupView.canShowGroup(i));
                continue;
            }
            if (!(c instanceof JMenu)) continue;
            this.updateMenuTree((JMenu)c);
        }
    }

    public void updateBoardInfo() {
        BoardInfo info = BoardInfo.getBoardInfo();
        if (info != null) {
            logger.debug("Updating board info in main view..");
            this.jLabelConnState.setText(this.resourceMap.getString("jLabelConnState.boardVersion", BoardInfo.getBoardVerName(info.boardVer)));
            VersionImpl version = new VersionImpl(info.getFrwVerShow(), info.getBuildNumber());
            this.labelFirmwareVersionValue.setText(this.resourceMap.getString("jLabelConnState.firmwareVersion", version.toString(), SerialCommandProcessor.getCurProtocolVer().ordinal()));
            this.panelFirmwareUpdate.setFirmwareVersion(version);
        } else {
            this.panelFirmwareUpdate.setFirmwareVersion(null);
        }
        this.panelFirmwareUpdate.setDeviceSN();
        this.updateBoardVerUI();
    }

    public void setSelectedProfile(int profile) {
        this.oldProfile = profile;
        logger.info("Current profile: " + profile);
        this.jComboBoxProfile.setSelectedIndex(Math.max(0, Math.min(profile, this.jComboBoxProfile.getItemCount() - 1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoardParams() {
        try {
            BoardParams params = BoardParams.getCurParams();
            if (params == null) {
                return;
            }
            this.setSelectedProfile(params.curProfile);
            this.paramsUpdated = true;
            for (ITabbedPanel panel : this.tabPanels) {
                panel.updateBoardParams(params);
            }
        }
        catch (Exception e) {
            this.showErrorMessage("Error updating UI values: " + e.toString() + Log.formatStackTrace(e));
        }
        finally {
            this.paramsUpdated = false;
        }
    }

    public final void updateStatus(String text) {
        if (text != null) {
            this.curStatusInfo = text.isEmpty() ? null : text;
        }
        StringBuilder str = new StringBuilder();
        if (this.curStatusInfo != null) {
            str.append(this.curStatusInfo);
        }
        if (this.calibModeInfo != null) {
            if (str.length() != 0) {
                str.append(" | ");
            }
            str.append(this.calibModeInfo).append("...");
        }
        this.jLabelStatus.setText(str.toString());
    }

    public final void updateError() {
        errorTitle = "<html>" + ErrorInfo.getCurErrors() + "</html>";
        errorDescr = "<html>" + ErrorInfo.getCurErrorsDescr() + "</html>";
        this.jLabelErrorTitle.setText(errorTitle);
        this.jLabelErrorDescr.setText(errorDescr);
    }

    public void updateRealtimeData() {
        RealtimeData d = RealtimeData.getRealtimeData();
        BoardParams params = BoardParams.getCurParams();
        this.jLabelI2CErrors.setText(Integer.toString(d.i2cErrorCount));
        if (d.i2cErrorCount > 100) {
            this.jLabelI2CErrors.setForeground(Color.red);
        }
        this.jLabelCycleTime.setText(Integer.toString(d.cycleTime));
        this.anglePanels[2].setPaused(RealtimeDataThread.isPaused());
        DebugVar[] vars = DebugVars.getVars();
        if (vars != null) {
            for (DebugVar v : vars) {
                if (v == null || !v.testFlag(64) || v.axis < 0) continue;
                this.anglePanels[v.axis].setDebugVar(v);
            }
        }
        for (int i = 0; i < 3; ++i) {
            float angle = d.curIMU == 1 ? d.stab_angle[i] : d.frameIMUAngle[i];
            this.anglePanels[i].setRotationAngle(angle, d.target_angle[i], BoardInfo.hasMaxErrorData() ? Float.valueOf(d.angle_err_max_avg[i]) : null);
            this.anglePanels[i].setPower(d.power[i]);
            if (BoardInfo.hasBoardFeature(4L)) {
                this.anglePanels[i].setBalanceError(d.balanceError[i]);
            }
            this.anglePanels[i].setFrameAngle(d.frameCamAngle[i]);
            this.anglePanels[i].repaint();
        }
        this.panelMonitoring.updateRealtimeData(d);
        this.panelRCSettings.updateRealtimeData(d);
        this.panelDebug.updateRealtimeData(d);
        long curTime = System.currentTimeMillis();
        if (curTime > this.lastRTUpdateTime) {
            if (BoardInfo.hasBatterryMonitoring()) {
                this.panelService.setBatLevel(d.bat_val);
                this.batPanel.setMax((float)Math.abs(params.bat_comp_ref) / 100.0f);
                this.batPanel.setMin((float)Math.abs(params.bat_threshold_motors) / 100.0f);
                this.batPanel.setAlert(Float.valueOf((float)Math.abs(params.bat_threshold_alarm) / 100.0f));
                this.batPanel.setData(Float.valueOf((float)d.bat_val / 100.0f));
            }
            String currentStr = d.current < 1000 ? d.current + " mA" : String.format("%.2f A", Float.valueOf((float)d.current / 1000.0f));
            this.jLabelCurrentSens.setText(currentStr);
            this.panelService.setCurrentVal(currentStr);
            this.jToggleButtonMotors.setSelected(d.isPowered);
            this.panelStabilizationSettings.updateRealtimeDataLowRate(d);
            this.panelService.updateRealtimeDataLowRate(d);
            params.curIMU = d.curIMU;
            this.lastRTUpdateTime = curTime + 500L;
        }
        if (d.curProfile != this.activeProfile && d.curProfile >= 0 && d.curProfile < this.buttonProfiles.length) {
            this.buttonProfiles[d.curProfile].setSelected(true);
            this.activeProfile = d.curProfile;
        }
        if (this.calibMode != d.calibMode) {
            this.calibMode = d.calibMode;
            this.calibModeInfo = this.calibMode != 0 ? this.resourceMap.getString("calibMode." + this.calibMode, new Object[0]) : null;
            this.updateStatus(null);
        }
    }

    public boolean applyBoardParams(BoardParams params) {
        params.beforeApply();
        for (ITabbedPanel panel : this.tabPanels) {
            if (!panel.hasVisibleGroups()) continue;
            try {
                panel.applyBoardParams(params);
            }
            catch (Exception e) {
                this.showErrorMessage("Error applying UI values: " + e.getMessage());
                logger.stackTrace(e);
                this.tabbedPaneMain.setSelectedComponent(panel.getComponent());
                return false;
            }
        }
        return true;
    }

    public boolean confirmDiscardChanges() {
        Object[] options = new Object[]{this.resourceMap.getString("option.discard_changes", new Object[0]), this.resourceMap.getString("option.cancel", new Object[0])};
        int res = JOptionPane.showOptionDialog(null, this.resourceMap.getString("confirm.changes_not_saved", new Object[0]), this.resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0, 3, null, options, options[1]);
        return res == 0;
    }

    public String showPasswordRequiredDialog(String descr, Object[] extraFields) {
        char[] password;
        int option;
        JPasswordField passwordField = new JPasswordField();
        ArrayList<Object> fields = new ArrayList<Object>();
        if (descr != null) {
            fields.add(descr);
        }
        fields.add("Enter Password:");
        fields.add(passwordField);
        if (extraFields != null) {
            Collections.addAll(fields, extraFields);
        }
        if ((option = JOptionPane.showConfirmDialog(null, fields.toArray(), "Password Required", 2, 2)) == 0 && (password = passwordField.getPassword()).length > 0) {
            return new String(password);
        }
        return null;
    }

    public boolean isSaved() {
        try {
            BoardParams params = BoardParams.getCurParams();
            BoardParams copy = params.clone();
            if (!this.applyBoardParams(copy)) {
                return false;
            }
            if (!copy.compare(params, params.curProfile)) {
                return this.confirmDiscardChanges();
            }
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
        return true;
    }

    @Action(enabledProperty="connected")
    public void buttonWriteParams() {
        this.writeParams(false);
    }

    @Action(enabledProperty="connected")
    public void buttonWriteAllProfiles() {
        this.writeParams(true);
    }

    public void writeParams(boolean allProfiles) {
        final BoardParams params = BoardParams.getCurParams();
        if (params != null) {
            final int oldSerialSpeed = params.profiles[params.curProfile].serialSpeed;
            if (!this.applyBoardParams(params)) {
                return;
            }
            BoardInfo boardInfo = BoardInfo.getBoardInfo();
            if (boardInfo != null && SimpleBGC_GUIApp.version.compareToIgnoringIssue(new VersionImpl(boardInfo.getCompatibleVer())) < 0 && !this.is_write_from_old_GUI_confirmed) {
                String[] options = new String[]{this.resourceMap.getString("buttonWrite.text", new Object[0]), this.resourceMap.getString("info.go_to_upgrade", new Object[0]), this.resourceMap.getString("info.cancel", new Object[0])};
                int choice = this.showOptionDialog(this.resourceMap.getString("confirm.gui_version_less_than_firmware", new VersionImpl(boardInfo.getFrwVer()).toStringOmitIssueNum()), options, true);
                if (choice == 0) {
                    this.is_write_from_old_GUI_confirmed = true;
                } else {
                    if (choice == 1) {
                        StringBuilder uri = new StringBuilder(SimpleBGC_GUIApp.GUI_DOWNLOAD_URI);
                        uri.append("frw_ver=" + boardInfo.getFrwVer() + "&board_ver=" + boardInfo.getBoardVersion());
                        SimpleBGC_GUIView.browseURI(uri.toString());
                        return;
                    }
                    return;
                }
            }
            SerialCommandProcessor.writeAllParams(params, allProfiles ? -1 : params.curProfile, new IProgressListener(){

                @Override
                public boolean onProgressChange(int percent) {
                    return SimpleBGC_GUIView.this.onProgressChange(percent);
                }

                @Override
                public void onProgressFinish(boolean isSuccess) {
                    int newSerialSpeed;
                    SimpleBGC_GUIView.this.onProgressFinish(isSuccess);
                    if (isSuccess && oldSerialSpeed != (newSerialSpeed = params.profiles[params.curProfile].serialSpeed)) {
                        logger.debug("Changing serial speed to " + newSerialSpeed);
                        SerialPortService.setBaudIndex(newSerialSpeed);
                    }
                }

                @Override
                public void onProgressStart(String action, boolean modal) {
                    SimpleBGC_GUIView.this.onProgressStart(action, modal);
                }
            });
        }
    }

    @Action(enabledProperty="connected")
    public void buttonCalibACCAction() {
        SerialCommandProcessor.sendCommand(new SerialCommand(65));
    }

    @Action
    public void actionBugReport() {
        SimpleBGC_GUIView.browseURI(SimpleBGC_GUIApp.BUG_REPORT_URI);
    }

    @Action(enabledProperty="connected")
    public void buttonCalibGyroAction() {
        SerialCommandProcessor.sendCommand(new SerialCommand(103));
    }

    @Action
    public void fullScreen() {
        logger.debug("Changing full screen mode");
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode displayMode = device.getDisplayMode();
        this.inFullScreen = !this.inFullScreen;
        JFrame frame = this.getFrame();
        if (!this.inFullScreen) {
            frame.setVisible(false);
            frame.dispose();
            frame.setUndecorated(false);
            frame.setExtendedState(0);
            frame.setSize(this.initSize);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        } else {
            this.initSize = frame.getSize();
            frame.setVisible(false);
            frame.dispose();
            frame.setExtendedState(6);
            frame.setUndecorated(true);
            frame.setVisible(true);
        }
    }

    public static void setEnabledTree(Container obj, boolean enabled) {
        obj.setEnabled(enabled);
        for (Component c : obj.getComponents()) {
            if (c instanceof Container) {
                SimpleBGC_GUIView.setEnabledTree((Container)c, enabled);
                continue;
            }
            c.setEnabled(enabled);
        }
    }

    @Action(enabledProperty="connected")
    public void buttonMotorsOn() {
        try {
            SerialCommand cmd = new SerialCommand(this.jToggleButtonMotors.isSelected() ? 77 : 109, 0);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception e) {
            logger.stackTrace(e);
        }
    }

    @Action(enabledProperty="connected")
    public void eraseEEPROM() {
        if (this.showConfirmDialog(this.resourceMap.getString("confirm.erase_EEPROM", new Object[0]))) {
            SerialCommandProcessor.useDefaults(253);
        }
    }

    public boolean showConfirmDialog(String message) {
        return this.showConfirmDialog(message, false);
    }

    public boolean showConfirmDialog(String message, boolean warning) {
        return JOptionPane.showConfirmDialog(this.getFrame(), message, this.resourceMap.getString("messageDialog.confirm.title", new Object[0]), 0, warning ? 2 : 3) == 0;
    }

    public int showOptionDialog(String message, String[] options, boolean warning) {
        return JOptionPane.showOptionDialog(this.getFrame(), message, this.resourceMap.getString("messageDialog.confirm.title", new Object[0]), -1, warning ? 2 : 3, null, options, options[0]);
    }

    @Override
    public void onProgressStart(final String statusMsg, final boolean modal) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (SimpleBGC_GUIView.this.progressDialog != null) {
                    SimpleBGC_GUIView.this.progressDialog.dispose();
                    SimpleBGC_GUIView.this.progressDialog = null;
                }
                if (modal) {
                    SimpleBGC_GUIView.this.progressDialog = new DialogProgress((Frame)SimpleBGC_GUIApp.mainView.getFrame(), statusMsg);
                    SimpleBGC_GUIView.this.progressDialog.showDialog();
                } else {
                    SimpleBGC_GUIView.this.updateStatus(statusMsg);
                    SimpleBGC_GUIView.this.jProgressBarMain.setVisible(true);
                    SimpleBGC_GUIView.this.jProgressBarMain.setValue(0);
                }
                SimpleBGC_GUIView.this.inProgress = true;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (Exception e) {
                logger.warn("onProgressStart() failed: " + e.toString());
            }
        }
    }

    @Override
    public boolean onProgressChange(final int val) {
        if (this.progressDialog != null) {
            return this.progressDialog.onProgressChange(val);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleBGC_GUIView.this.jProgressBarMain.setValue(val);
            }
        });
        return true;
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
        if (this.progressDialog != null) {
            this.progressDialog.onProgressFinish(isSuccess);
            this.progressDialog = null;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimpleBGC_GUIView.this.jProgressBarMain.setVisible(false);
                }
            });
        }
        this.inProgress = false;
    }

    public void showErrorMessage(SerialCommand cmdErr) {
        try {
            cmdErr.startReading();
            cmdErr.skipBytes(1);
            int errCode = cmdErr.readByte();
            StringBuilder str = new StringBuilder("CMD_ERROR received with code " + errCode);
            if (cmdErr.getBytesAvailable() >= 2) {
                int[] data = cmdErr.readWordArrUnsigned(cmdErr.getBytesAvailable() / 2);
                str.append(" (0x" + HexUtil.toHex(data) + ")");
            }
            this.showErrorMessage(str.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showErrorMessage(String msg) {
        this.showErrorMessage(msg, null);
    }

    public void showErrorMessage(String msg, String statusMsg) {
        logger.error(msg);
        JOptionPane.showMessageDialog(this.getFrame(), SimpleBGC_GUIView.constrainForDialog(msg), this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
        if (statusMsg != null) {
            this.updateStatus(statusMsg);
        }
    }

    public void showErrorMessageThreadSafe(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleBGC_GUIView.this.showErrorMessage(msg);
            }
        });
    }

    public void showWarningMessage(String msg) {
        JOptionPane.showMessageDialog(this.getFrame(), SimpleBGC_GUIView.constrainForDialog(msg), this.resourceMap.getString("messageDialog.warning.title", new Object[0]), 2);
    }

    public static String constrainForDialog(String msg) {
        return "<html><body><p style='width: 500px;'>" + SimpleBGC_GUIView.trimToLength(msg, 1000).replace("\n", "<br>") + "</p></body></html>";
    }

    public static String trimToLength(String msg, int maxLength) {
        return msg.length() > maxLength ? msg.substring(0, maxLength) + "... " + (msg.length() - maxLength) + " chars more" : msg;
    }

    public void showStatusMessage(String msg) {
        this.updateStatus(msg);
        this.showInfoMessage(msg);
    }

    public static String stripHtml(String str) {
        if (str != null) {
            Matcher matcher = Pattern.compile("<html>(.*?)</html>", 34).matcher(str);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return str.replace("\n", "<br>");
        }
        return null;
    }

    public void showInfoMessage(String msg) {
        JOptionPane.showMessageDialog(this.getFrame(), "<html><p style='width: 500px;'>" + SimpleBGC_GUIView.stripHtml(msg) + "</p></html>", this.resourceMap.getString("messageDialog.info.title", new Object[0]), 1);
    }

    public File showProfileSaveDialog(String fileTypeName, String fileExt, String fileName) {
        File profilesDirectory = this.createProfilesDirectory();
        String path = new BGCJFileSaver(this.getFrame(), new String[]{fileExt}, fileTypeName, "last_used_profiles_directory").getFilePath(profilesDirectory.getPath() + File.separatorChar + fileName, true);
        return path != null ? new File(path) : null;
    }

    public File showProfileLoadDialog(String fileTypeName, String fileExt) {
        JFileChooser fileChooser = new JFileChooser();
        File profilesDirectory = this.createProfilesDirectory();
        fileChooser.setCurrentDirectory(profilesDirectory);
        fileChooser.setFileFilter(new FileNameExtensionFilter(fileTypeName, fileExt));
        if (this.isSaved() && fileChooser.showOpenDialog(this.getFrame()) == 0) {
            Settings.set("last_used_profiles_directory", fileChooser.getCurrentDirectory().getPath());
            Settings.save();
            File f = fileChooser.getSelectedFile();
            if (f.exists()) {
                return f;
            }
        }
        return null;
    }

    @Action(enabledProperty="connected")
    public void buttonCalibGyroTemp() {
        try {
            SerialCommandProcessor.sendCalibExtended(103, 0, 3, null, false, null);
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    @Action(enabledProperty="connected")
    public void menuCalibAccTemp() {
        try {
            SerialCommandProcessor.sendCalibExtended(65, 0, 3, null, false, null);
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    @Action
    public void menuSettings() {
        DialogSettings d = new DialogSettings(this.getFrame());
        d.showDialogNewThread();
    }

    public void applySettings() {
        SerialCommandProcessor.applyProtocolVerSettings();
    }

    @Action(enabledProperty="connected")
    public void menuConfigureBluetooth() {
        try {
            DialogBluetooth d = new DialogBluetooth(this.getFrame());
            d.showDialogNewThread();
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    @Action(enabledProperty="connected")
    public void actionBackupMainIMUCalib() {
        BackupIMUCalibThread.backupIMUCalib(false, this);
    }

    @Action(enabledProperty="connected")
    public void actionBackupFrameIMUCalib() {
        BackupIMUCalibThread.backupIMUCalib(true, this);
    }

    @Action(enabledProperty="connected")
    public void actionRestoreMainIMUCalib() {
        RestoreIMUCalibThread.restoreIMUCalib(false, this);
    }

    @Action(enabledProperty="connected")
    public void actionRestoreFrameIMUCalib() {
        RestoreIMUCalibThread.restoreIMUCalib(true, this);
    }

    @Action(enabledProperty="connected")
    public void menuBackupManager() {
        try {
            DialogBackupManager d = new DialogBackupManager(this.getFrame());
            d.showDialogNewThread();
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    @Action
    public void menuSetViewLevel() {
        for (Component menuItem : this.menuViewLevel.getMenuComponents()) {
            JRadioButtonMenuItem item;
            if (!(menuItem instanceof JRadioButtonMenuItem) || !(item = (JRadioButtonMenuItem)menuItem).isSelected() || !item.getName().startsWith("menuViewLevel")) continue;
            try {
                GroupView.VIEW v = GroupView.VIEW.valueOf(item.getName().substring(13));
                GroupView.setCurViewLevel(v);
                Settings.set("view.level", v.name());
                Settings.save();
                this.updateBoardVerUI();
            }
            catch (Exception e) {
                this.showErrorMessage(e.toString());
            }
        }
        this.applyTheme();
    }

    public void applyTheme() {
        SwingUtilities.updateComponentTreeUI(this.getFrame());
        this.getFrame().pack();
        this.updateCustomColors();
    }

    @Action(enabledProperty="connected")
    public void buttonCalibHelper() {
        this.panelHardwareSettings.buttonCalibHelper();
    }

    public void updateCustomColors() {
        Color bg = UIManager.getColor("Panel.background");
        if (bg != null) {
            Component[] darkComponents;
            float[] f = bg.getRGBColorComponents(null);
            float mult = 0.85f;
            bg = new Color(f[0] * 0.85f, f[1] * 0.85f, f[2] * 0.85f);
            for (Component c : darkComponents = new Component[]{this.mainPanel, this.jPanelMain, this.jPanelConnection, this.jPanelProfile, this.menuBar, this.statusPanel, this.jPanelAngles, this.jPanelRollAngle, this.jPanelPitchAngle, this.jPanelYawAngle, this.anglePanels[0], this.anglePanels[1], this.anglePanels[2]}) {
                c.setBackground(bg);
            }
        }
    }

    @Override
    public void onProfileTemplatesChange(HashSet<IProfileTemplate> items) {
        this.rebuildProfileTemplatesMenu();
    }

    private void rebuildProfileTemplatesMenu() {
        this.menuSaveProfileUsingTemplate.removeAll();
        this.menuSaveAllProfilesUsingTemplate.removeAll();
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() instanceof MenuItemProfileTemplate) {
                    IProfileTemplate profileTemplate = ((MenuItemProfileTemplate)ae.getSource()).profileTemplate;
                    boolean allProfiles = ((MenuItemProfileTemplate)ae.getSource()).allProfiles;
                    File p = new File(profileTemplate.getPath());
                    if (!p.exists()) {
                        JOptionPane.showMessageDialog(null, SimpleBGC_GUIView.this.resourceMap.getString("error.file_not_found", profileTemplate.getPath()), SimpleBGC_GUIView.this.resourceMap.getString("messageDialog.error.title", new Object[0]), 0);
                        return;
                    }
                    HashSet<String> allowedElements = null;
                    try {
                        allowedElements = XmlUtils.parseAllowedTagsFromProfileTemplate(profileTemplate.getPath());
                    }
                    catch (Exception e) {
                        SimpleBGC_GUIView.this.showErrorMessage("Error parsing allowed elements from profile template \"" + profileTemplate.getPath() + "\": " + e.toString());
                        return;
                    }
                    int profileId = allProfiles ? -1 : SimpleBGC_GUIView.this.jComboBoxProfile.getSelectedIndex();
                    String filename = (String)SimpleBGC_GUIView.this.jComboBoxProfile.getSelectedItem();
                    SimpleBGC_GUIView.this._saveProfile(profileId, allProfiles ? "all_" + filename : filename, allowedElements);
                }
            }
        };
        LinkedHashSet<IProfileTemplate> profileTemplates = SimpleBGC_GUIApp.getProfileTemplates();
        for (IProfileTemplate item : profileTemplates) {
            File f = new File(item.getPath());
            if (!f.exists()) continue;
            String menuTitle = f.getName();
            if (f.getName().contains(".")) {
                menuTitle = menuTitle.substring(0, menuTitle.lastIndexOf("."));
            }
            MenuItemProfileTemplate m1 = new MenuItemProfileTemplate(item, false, a);
            m1.setText(menuTitle);
            this.menuSaveProfileUsingTemplate.add(m1);
            MenuItemProfileTemplate m2 = new MenuItemProfileTemplate(item, true, a);
            m2.setText(menuTitle);
            this.menuSaveAllProfilesUsingTemplate.add(m2);
        }
        if (profileTemplates.size() > 0) {
            this.menuSaveProfileUsingTemplate.add(new JPopupMenu.Separator());
        }
        this.menuSaveProfileUsingTemplate.add(this.menuManageProfileTemplates);
    }

    @Action
    public void copyProfile() {
        if (this.applyBoardParams(BoardParams.getCurParams())) {
            new DialogCopyProfile((Frame)this.getFrame(), this.jComboBoxProfile.getSelectedIndex()).showDialogNewThread();
        }
    }

    @Action(enabledProperty="connected")
    public void buttonActivateProfile() {
        for (int i = 0; i < this.buttonProfiles.length; ++i) {
            if (!this.buttonProfiles[i].isSelected()) continue;
            logger.debug("Activating profile: " + i);
            SerialCommandProcessor.activateProfile(i);
            this.jComboBoxProfile.setSelectedIndex(i);
            this.activeProfile = i;
            break;
        }
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    @Action(enabledProperty="connected")
    public void buttonReset() {
        logger.info("Reset button pressed, sending reset command to the board..");
        SerialCommandProcessor.sendCmdReset();
    }

    public boolean confirmMainUARTChangeFunction(int oldPort, int newPort) {
        return newPort != 1 || oldPort == newPort || !this.isConnected() || this.showConfirmDialog(this.resourceMap.getString("confirm.use_main_uart_for_other_func", new Object[0]), true);
    }

    public boolean isParamsUpdated() {
        return this.paramsUpdated;
    }

    public void showParamsChart() {
        for (ITabbedPanel tab : this.tabPanels) {
            for (Component group : tab.getGroups()) {
                Border border;
                String groupName = group.getName();
                if (JPanel.class.isInstance(group) && TitledBorder.class.isInstance(border = ((JPanel)group).getBorder())) {
                    groupName = ((TitledBorder)border).getTitle();
                }
                String parentName = tab.getTitle() + " - " + groupName;
                this._paramsChartAddComponents(group, parentName);
            }
        }
    }

    private void _paramsChartAddComponents(Component parent, String parentName) {
        boolean include = false;
        for (Class c : paramsChartClasses) {
            if (!c.isInstance(parent) || parent.getName() == null) continue;
            include = true;
            break;
        }
        if (include) {
            String value = "?";
            if (JSpinner.class.isInstance(parent)) {
                value = ((Number)((JSpinner)parent).getValue()).toString();
            } else if (JComboBox.class.isInstance(parent)) {
                Object o = ((JComboBox)parent).getSelectedItem();
                value = o != null ? o.toString() : "";
            } else if (JCheckBox.class.isInstance(parent)) {
                value = ((JCheckBox)parent).isSelected() ? "1" : "0";
            } else if (JTextField.class.isInstance(parent)) {
                value = ((JTextField)parent).getText();
            } else if (JRadioButton.class.isInstance(parent)) {
                value = ((JRadioButton)parent).isSelected() ? "1" : "0";
            }
            String name = parent.getAccessibleContext().getAccessibleName();
            if (name == null) {
                name = parent.getName();
            }
            logger.debug(parentName + " - " + name + "=" + value);
        } else if (parent instanceof Container) {
            Container container = (Container)parent;
            for (Component c : container.getComponents()) {
                this._paramsChartAddComponents(c, parentName);
            }
        }
    }

    public static GroupView.VIEW getMaxViewLevel() {
        return maxViewLevel;
    }

    @Action(enabledProperty="connected")
    public void menuConfigureMultiLink() {
        try {
            DialogMultilink d = new DialogMultilink(this.getFrame());
            d.showDialogNewThread();
        }
        catch (Exception e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    private class CloseWindowAdapter
    extends WindowAdapter {
        private CloseWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            for (ITabbedPanel p : SimpleBGC_GUIView.this.tabPanels) {
                p.onBeforeClose();
            }
            Settings.save();
        }
    }
}

