/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui.listener;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import sbgc.script_parser.manager.CommandException;
import sbgc.script_parser.manager.ParserException;
import sbgc.script_parser.manager.ScriptParser;
import simplebgc_gui.listener.OnScriptLoadedListener;

public class ScriptValidateListener
implements ActionListener {
    private String content;
    private OnScriptLoadedListener onScriptLoadedListener;
    private ScriptParser scriptParser;

    public ScriptValidateListener(String content, OnScriptLoadedListener onScriptLoadedListener) {
        this.content = content;
        this.onScriptLoadedListener = onScriptLoadedListener;
        this.scriptParser = new ScriptParser();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.onScriptLoadedListener.onScriptLoaded(this.scriptParser.parseScriptFromString(this.content));
        }
        catch (ParserException ex) {
            this.onScriptLoadedListener.onErrorCaught(ex);
        }
    }

    public static void highlightError(JTextPane textPane, ParserException parserException) {
        String[] cmd = textPane.getText().toString().replace("\r", "").split("\n");
        DefaultStyledDocument document = new DefaultStyledDocument();
        textPane.setDocument(document);
        StyleContext context = new StyleContext();
        List<CommandException> excList = null;
        int excNum = -1;
        if (parserException != null) {
            excList = parserException.getErrors();
            excNum = excList.size() - 1;
        }
        for (int i = cmd.length - 1; i >= 0; --i) {
            Color color = null;
            if (excNum >= 0 && i + 1 == excList.get(excNum).getLineNum()) {
                color = Color.RED;
                --excNum;
            } else {
                color = Color.BLACK;
            }
            Style style = context.addStyle("", null);
            StyleConstants.setForeground(style, color);
            try {
                document.insertString(0, cmd[i] + "\n", style);
                continue;
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ScriptValidateListener.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

