/*
 * Decompiled with CFR 0.152.
 */
package simplebgc_gui.model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class LinePainter
implements Highlighter.HighlightPainter {
    private Color color;
    private int pos;

    public LinePainter(JTextComponent component, int pos) {
        this(component, null);
        this.setLighter(component.getSelectionColor());
        this.pos = pos;
    }

    public LinePainter(JTextComponent component, Color color) {
        this.setColor(color);
        try {
            component.getHighlighter().addHighlight(0, 0, this);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void setColor(Color color) {
        this.color = color;
    }

    private void setLighter(Color color) {
        int red = Math.min(255, (int)((double)color.getRed() * 1.2));
        int green = Math.min(255, (int)((double)color.getGreen() * 1.2));
        int blue = Math.min(255, (int)((double)color.getBlue() * 1.2));
        this.setColor(new Color(red, green, blue));
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        try {
            Rectangle r = c.modelToView(this.pos);
            g.setColor(this.color);
            g.fillRect(0, r.y, c.getWidth(), r.height);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }
}

